/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.memory.mmio.MMIO;
import jpcsp.nec78k0.Nec78k0BackendMemory;
import jpcsp.nec78k0.Nec78k0MMIOHandlerReadWrite;
import jpcsp.nec78k0.Nec78k0MMIORegisterBanks;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0Memory
extends MMIO {
    public static final int SIZE_RAM0 = 65248;
    public static final int BASE_RAM0 = 0;
    public static final int END_RAM0 = 65247;
    private final Nec78k0BackendMemory backendMemory = (Nec78k0BackendMemory)this.getBackendMemory();
    private final int[] ram0;
    private final Nec78k0MMIOHandlerReadWrite ram0Handler;
    private final Nec78k0MMIORegisterBanks registerBanksHandler;
    private final Nec78k0Sfr sfr;

    public Nec78k0Memory(Logger log, Nec78k0Sfr sfr, int baseRam0, int sizeRam0) {
        super(new Nec78k0BackendMemory());
        this.ram0 = new int[sizeRam0 >> 2];
        this.ram0Handler = new Nec78k0MMIOHandlerReadWrite(baseRam0, sizeRam0, this.ram0);
        this.ram0Handler.setLogger(log);
        this.registerBanksHandler = new Nec78k0MMIORegisterBanks();
        this.registerBanksHandler.setLogger(log);
        this.sfr = sfr;
        sfr.setLogger(log);
    }

    public void setProcessor(Nec78k0Processor processor) {
        this.backendMemory.setProcessor(processor);
        this.ram0Handler.setProcessor(processor);
        this.registerBanksHandler.setProcessor(processor);
        this.sfr.setProcessor(processor);
    }

    public Nec78k0Sfr getSfr() {
        return this.sfr;
    }

    @Override
    protected IMMIOHandler getHandler(int address) {
        if (address >= 0 && address <= 65247) {
            return this.ram0Handler;
        }
        if (address >= 65248 && address < 65280) {
            return this.registerBanksHandler;
        }
        if (this.isSfrHandler(address)) {
            return this.sfr;
        }
        return super.getHandler(address);
    }

    private boolean isSfrHandler(int address) {
        return address >= 65280 && address <= 65535;
    }

    public static boolean isAddressGood(int address) {
        if (address >= 0 && address <= 65247) {
            return true;
        }
        if (address >= 65248 && address < 65280) {
            return true;
        }
        return address >= 65280 && address <= 65535;
    }

    public boolean read1(int address, int bit) {
        boolean value = this.isSfrHandler(address) ? this.sfr.read1(address, bit) : Utilities.hasBit(this.read8(address), bit);
        return value;
    }

    public void write1(int address, int bit, boolean value) {
        if (this.isSfrHandler(address)) {
            this.sfr.write1(address, bit, value);
        } else {
            int value8 = this.read8(address);
            value8 = value ? Utilities.setBit(value8, bit) : Utilities.clearBit(value8, bit);
            this.write8(address, (byte)value8);
        }
    }

    public void set1(int address, int bit) {
        if (this.isSfrHandler(address)) {
            this.sfr.set1(address, bit);
        } else {
            this.write1(address, bit, true);
        }
    }

    public void clear1(int address, int bit) {
        if (this.isSfrHandler(address)) {
            this.sfr.clear1(address, bit);
        } else {
            this.write1(address, bit, false);
        }
    }

    @Override
    public int normalize(int address) {
        return address;
    }
}

