/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.Nec78k0Debug;
import jpcsp.nec78k0.Nec78k0Decoder;
import jpcsp.nec78k0.Nec78k0Disassembler;
import jpcsp.nec78k0.Nec78k0Instruction;
import jpcsp.nec78k0.Nec78k0Interpreter;
import jpcsp.nec78k0.Nec78k0Memory;
import jpcsp.nec78k0.sfr.Nec78k0InterruptRequestInfo;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Nec78k0Processor {
    public static boolean disassembleFunctions = false;
    public static final int RESET = 0;
    public static final int BRK = 62;
    public static final int REGISTER_ADDRESS_BANK0 = 65272;
    public static final int REGISTER_ADDRESS_BANK1 = 65264;
    public static final int REGISTER_ADDRESS_BANK2 = 65256;
    public static final int REGISTER_ADDRESS_BANK3 = 65248;
    public static final int SFR_ADDRESS = 65280;
    public static final int SHORT_DIRECT_ADDRESS = 65056;
    public static final int SP_ADDRESS = 65308;
    public static final int PSW_ADDRESS = 65310;
    public static final int PSW_BIT_CY = 0;
    public static final int PSW_BIT_ISP = 1;
    public static final int PSW_BIT_RBS0 = 3;
    public static final int PSW_BIT_AC = 4;
    public static final int PSW_BIT_RBS1 = 5;
    public static final int PSW_BIT_Z = 6;
    public static final int PSW_BIT_IE = 7;
    public static final int PSW_ACZ_FLAGS = Utilities.getFlagFromBit(4) | Utilities.getFlagFromBit(6);
    public static final int PSW_CYACZ_FLAGS = Utilities.getFlagFromBit(0) | PSW_ACZ_FLAGS;
    public static final int PSW_RB_FLAGS = Utilities.getFlagFromBit(3) | Utilities.getFlagFromBit(5);
    public static final int REG_X = 0;
    public static final int REG_A = 1;
    public static final int REG_C = 2;
    public static final int REG_B = 3;
    public static final int REG_E = 4;
    public static final int REG_D = 5;
    public static final int REG_L = 6;
    public static final int REG_H = 7;
    public static final int REG_PAIR_AX = 0;
    public static final int REG_PAIR_BC = 1;
    public static final int REG_PAIR_DE = 2;
    public static final int REG_PAIR_HL = 3;
    public final Nec78k0Memory mem;
    public Logger log;
    public Nec78k0Interpreter interpreter;
    private Nec78k0Disassembler disassembler;
    private int pc;
    private int currentInstructionPc;
    private int currentInstructionOpcode;
    private final byte[][] registerBanks = new byte[4][8];
    private int registerBank;
    private int sp;
    private int psw;
    private final Nec78k0InterruptRequestInfo interruptRequestInfo = new Nec78k0InterruptRequestInfo();
    private Nec78k0Debug debug;

    public Nec78k0Processor(Nec78k0Memory mem) {
        this.mem = mem;
        this.log = mem.getSfr().log;
        mem.setProcessor(this);
        if (RuntimeContext.debugCodeBlockCalls) {
            this.debug = new Nec78k0Debug(this.log);
        }
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void setInterpreter(Nec78k0Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public int startNewInstruction(int addr) {
        this.currentInstructionPc = this.pc = addr;
        this.currentInstructionOpcode = 0;
        this.getNextInstructionOpcode();
        return this.currentInstructionOpcode;
    }

    public void interpret() {
        this.currentInstructionPc = this.pc;
        this.currentInstructionOpcode = 0;
        this.getNextInstructionOpcode();
        Nec78k0Instruction instruction = Nec78k0Decoder.instruction(this, this.currentInstructionOpcode);
        if (this.log.isTraceEnabled()) {
            String opcode;
            switch (instruction.getInstructionSize()) {
                case 1: {
                    opcode = String.format("0x%02X", this.currentInstructionOpcode);
                    break;
                }
                case 2: {
                    opcode = String.format("0x%04X", this.currentInstructionOpcode);
                    break;
                }
                case 3: {
                    opcode = String.format("0x%06X", this.currentInstructionOpcode);
                    break;
                }
                case 4: {
                    opcode = String.format("0x%08X", this.currentInstructionOpcode);
                    break;
                }
                default: {
                    opcode = String.format("0x%X", this.currentInstructionOpcode);
                }
            }
            this.log.trace((Object)String.format("0x%04X: [%s] - %s", this.currentInstructionPc, opcode, instruction.disasm(this.currentInstructionPc, this.currentInstructionOpcode)));
        }
        instruction.interpret(this, this.currentInstructionOpcode);
    }

    public int getNextInstructionOpcode() {
        int opcode = this.mem.internalRead8(this.pc);
        ++this.pc;
        this.currentInstructionOpcode = this.currentInstructionOpcode << 8 | opcode;
        return this.currentInstructionOpcode;
    }

    public int getCurrentInstructionPc() {
        return this.currentInstructionPc;
    }

    public int getCurrentInstructionOpcode() {
        return this.currentInstructionOpcode;
    }

    public int getNextInstructionPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc;
    }

    public int getPc() {
        return this.pc;
    }

    public boolean isNextInstructionPc(int addr) {
        return this.pc == addr;
    }

    public int getPsw() {
        return this.psw;
    }

    public void setPsw(int psw) {
        int oldPsw = this.psw;
        this.psw = psw & 0xFF;
        this.registerBank = (Utilities.hasBit(psw, 3) ? 1 : 0) | (Utilities.hasBit(psw, 5) ? 2 : 0);
        if (Utilities.isRaisingBit(oldPsw, this.psw, 7)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("Enabling interrupts", new Object[0]));
            }
            this.checkPendingInterrupt();
        }
    }

    public boolean isInterruptEnabled() {
        return Utilities.hasBit(this.psw, 7);
    }

    public boolean isInServicePriority() {
        return Utilities.hasBit(this.psw, 1);
    }

    public boolean isZeroFlag() {
        return Utilities.hasBit(this.psw, 6);
    }

    public void setRegisterBank(int rbn) {
        this.psw = Utilities.clearFlag(this.psw, PSW_RB_FLAGS);
        if (Utilities.hasBit(rbn, 0)) {
            this.psw = Utilities.setBit(this.psw, 3);
        }
        if (Utilities.hasBit(rbn, 1)) {
            this.psw = Utilities.setBit(this.psw, 5);
        }
        this.registerBank = rbn;
    }

    public boolean isAuxiliaryCarryFlag() {
        return Utilities.hasBit(this.psw, 4);
    }

    public boolean isCarryFlag() {
        return Utilities.hasBit(this.psw, 0);
    }

    public boolean isPriorityFlag() {
        return Utilities.hasBit(this.psw, 1);
    }

    public int getSp() {
        return this.sp;
    }

    public void setSp(int sp) {
        this.sp = sp & 0xFFFF;
    }

    public void reset() {
        this.pc = 0;
        this.pc = this.mem.read16(0);
        this.psw = Utilities.setBit(0, 1);
        if (disassembleFunctions) {
            this.disassemble(this.pc);
        }
    }

    public static int getValue8(int value) {
        return value & 0xFF;
    }

    public static int getValue16(int value) {
        return value & 0xFFFF;
    }

    public static boolean isZero8(int value) {
        return Nec78k0Processor.getValue8(value) == 0;
    }

    public static boolean isZero16(int value) {
        return Nec78k0Processor.getValue16(value) == 0;
    }

    public int getRegister(int r) {
        return this.getRegister(r, this.registerBank);
    }

    public int getRegister(int r, int rb) {
        return Utilities.u8(this.registerBanks[rb][r & 7]);
    }

    public int getRegisterPair(int rp) {
        return this.getRegisterPair(rp, this.registerBank);
    }

    public int getRegisterPair(int rp, int rb) {
        int r = rp << 1;
        return this.getRegister(r, rb) | this.getRegister(r + 1, rb) << 8;
    }

    public void setRegister(int r, int value) {
        this.setRegister(r, this.registerBank, value);
    }

    public void setRegister(int r, int rb, int value) {
        this.registerBanks[rb][r & 7] = (byte)value;
    }

    public void setRegisterPair(int rp, int value) {
        this.setRegisterPair(rp, this.registerBank, value);
    }

    public void setRegisterPair(int rp, int rb, int value) {
        int r = rp << 1;
        this.setRegister(r, rb, value);
        this.setRegister(r + 1, rb, value >> 8);
    }

    public void setPswResult(int result) {
        this.psw = Nec78k0Processor.isZero8(result) ? Utilities.setBit(this.psw, 6) : Utilities.clearBit(this.psw, 6);
    }

    public void setPswResult(int result, boolean cy, boolean ac) {
        this.psw = Utilities.clearFlag(this.psw, PSW_CYACZ_FLAGS);
        if (Nec78k0Processor.isZero8(result)) {
            this.psw = Utilities.setBit(this.psw, 6);
        }
        if (cy) {
            this.psw = Utilities.setBit(this.psw, 0);
        }
        if (ac) {
            this.psw = Utilities.setBit(this.psw, 4);
        }
    }

    public void setPswResult16(int result, boolean cy, boolean ac) {
        this.psw = Utilities.clearFlag(this.psw, PSW_CYACZ_FLAGS);
        if (Nec78k0Processor.isZero16(result)) {
            this.psw = Utilities.setBit(this.psw, 6);
        }
        if (cy) {
            this.psw = Utilities.setBit(this.psw, 0);
        }
        if (ac) {
            this.psw = Utilities.setBit(this.psw, 4);
        }
    }

    public void setPswResult(int result, boolean ac) {
        this.psw = Utilities.clearFlag(this.psw, PSW_ACZ_FLAGS);
        if (Nec78k0Processor.isZero8(result)) {
            this.psw = Utilities.setBit(this.psw, 6);
        }
        if (ac) {
            this.psw = Utilities.setBit(this.psw, 4);
        }
    }

    public void setCarryFlag(boolean cy) {
        this.psw = cy ? Utilities.setBit(this.psw, 0) : Utilities.clearBit(this.psw, 0);
    }

    public static int getSaddr(int saddr) {
        if ((saddr &= 0xFF) >= 32) {
            return 65056 + saddr - 32;
        }
        return 65280 + saddr;
    }

    public static int getSfr(int sfr) {
        return 65280 + (sfr &= 0xFF);
    }

    public void push8(int value) {
        --this.sp;
        this.mem.write8(this.sp, (byte)value);
    }

    public void push16(int value) {
        if (RuntimeContext.debugCodeBlockCalls && (this.getCurrentInstructionPc() == 2548 || this.getCurrentInstructionPc() == 2591)) {
            this.debug.call(this, value);
        }
        this.sp -= 2;
        Utilities.writeUnaligned16(this.mem, this.sp, value);
    }

    public int pop8() {
        int value = this.mem.read8(this.sp);
        ++this.sp;
        return value;
    }

    public int pop16() {
        int value = Utilities.readUnaligned16(this.mem, this.sp);
        this.sp += 2;
        return value;
    }

    public void disassemble(int addr) {
        this.getDisassembler().disasm(addr);
    }

    public Nec78k0Disassembler getDisassembler() {
        if (this.disassembler == null) {
            this.disassembler = new Nec78k0Disassembler(this.log, Level.DEBUG, this);
        }
        return this.disassembler;
    }

    public void call(int addr) {
        if ((addr &= 0xFFFF) == 0) {
            this.log.error((Object)String.format("Calling address 0x%04X, something is wrong", addr));
            Emulator.PauseEmuWithStatus(32);
        } else if (disassembleFunctions) {
            this.disassemble(addr);
        }
        if (RuntimeContext.debugCodeBlockCalls) {
            this.debug.call(this, addr);
        }
        this.push16(this.pc);
        this.setPc(addr);
        this.checkPendingInterrupt();
    }

    public void ret() {
        if (RuntimeContext.debugCodeBlockCalls) {
            this.debug.ret();
        }
        this.setPc(this.pop16());
        this.checkPendingInterrupt();
    }

    public void reti() {
        if (RuntimeContext.debugCodeBlockCalls) {
            this.debug.ret();
        }
        this.setPc(this.pop16());
        this.setPsw(this.pop8());
    }

    public boolean checkPendingInterrupt() {
        boolean interruptTriggered = false;
        if (this.isInterruptEnabled()) {
            this.interruptRequestInfo.vectorTableAddress = -1;
            this.interruptRequestInfo.highPriority = false;
            this.mem.getSfr().checkInterrupts(this.interruptRequestInfo);
            if (this.interruptRequestInfo.vectorTableAddress >= 0) {
                this.mem.getSfr().clearInterruptRequest(this.interruptRequestInfo.interruptRequestBit);
                this.interrupt(this.interruptRequestInfo.vectorTableAddress, this.interruptRequestInfo.highPriority);
                interruptTriggered = true;
            }
        }
        return interruptTriggered;
    }

    private void interrupt(int vectorTableAddress, boolean highPriority) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Triggering interrupt 0x%02X(%s), highPriority=%b", vectorTableAddress, MMIOHandlerSysconFirmwareSfr.getInterruptName(vectorTableAddress), highPriority));
        }
        int addr = this.mem.read16(vectorTableAddress);
        if (RuntimeContext.debugCodeBlockCalls) {
            this.debug.callInterrupt(this, addr, vectorTableAddress);
        }
        this.push8(this.psw);
        this.push16(this.pc);
        this.psw = highPriority ? Utilities.clearBit(this.psw, 1) : Utilities.setBit(this.psw, 1);
        this.psw = Utilities.clearBit(this.psw, 7);
        this.pc = addr;
        if (disassembleFunctions) {
            this.disassemble(this.pc);
        }
    }

    public void branch(int disp) {
        this.setPc(this.pc + disp);
        this.checkPendingInterrupt();
    }

    public void jump(int addr, boolean dynamicAddr) {
        if ((addr &= 0xFFFF) == 0) {
            this.log.error((Object)String.format("Jumping to address 0x%04X, something is wrong", addr));
            Emulator.PauseEmuWithStatus(32);
        }
        if (RuntimeContext.debugCodeBlockCalls && dynamicAddr && this.mem.internalRead8(this.currentInstructionPc - 1) == 179) {
            this.debug.call(this, addr);
        }
        this.setPc(addr);
        this.checkPendingInterrupt();
        if (disassembleFunctions && dynamicAddr) {
            this.disassemble(this.pc);
        }
    }

    public void halt() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("halt at 0x%04X", this.getCurrentInstructionPc()));
            if (RuntimeContext.debugCodeBlockCalls) {
                this.debug.dump();
            }
        }
        if (!this.checkPendingInterrupt()) {
            this.interpreter.setHalted(true);
            this.interpreter.exitInterpreter();
        }
    }
}

