/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0AdConverter
implements IState {
    private static final int STATE_VERSION = 0;
    private final Nec78k0Sfr sfr;
    private final Nec78k0Scheduler scheduler;
    private final AdConverterAction adConverterAction;
    protected Logger log;
    private int mode;
    private int result;
    private int clockStep;
    private int analogInputChannelSpecification;
    private int portConfiguration;

    public Nec78k0AdConverter(Nec78k0Sfr sfr, Nec78k0Scheduler scheduler) {
        this.sfr = sfr;
        this.scheduler = scheduler;
        this.log = sfr.log;
        this.adConverterAction = new AdConverterAction();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.mode = stream.readInt();
        this.analogInputChannelSpecification = stream.readInt();
        this.portConfiguration = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.mode);
        stream.writeInt(this.analogInputChannelSpecification);
        stream.writeInt(this.portConfiguration);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.mode = 0;
        this.result = 0;
        this.analogInputChannelSpecification = 0;
        this.portConfiguration = 0;
        this.updateScheduler();
    }

    private void updateScheduler() {
        this.scheduler.removeAction(this.adConverterAction);
        if (Utilities.notHasBit(this.mode, 7)) {
            return;
        }
        long schedule = Nec78k0Sfr.now() + (long)this.clockStep;
        this.scheduler.addAction(schedule, this.adConverterAction);
    }

    protected int updateResult(int inputChannel) {
        return 0;
    }

    private void onConverterAction() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("AD Converter onConverterAction triggering interrupt %s", Nec78k0Sfr.getInterruptName(36)));
        }
        this.result = this.updateResult(this.analogInputChannelSpecification & 7);
        this.result &= 0xFFC0;
        this.sfr.setInterruptRequest(Nec78k0Sfr.ADIF);
        this.updateScheduler();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int value) {
        if (Utilities.hasBit(value, 0)) {
            this.log.error((Object)String.format("AD Converter setMode unimplemented comparator operation 0x%02X", value));
        }
        this.mode = value;
        switch (this.mode >> 1 & 0x1F) {
            case 1: {
                this.clockStep = 24;
                break;
            }
            case 17: {
                this.clockStep = 24;
                break;
            }
            case 2: {
                this.clockStep = 24;
                break;
            }
            case 13: {
                this.clockStep = 32;
                break;
            }
            default: {
                this.clockStep = 1000;
                this.log.error((Object)String.format("AD Converter setMode unimplemented 0x%02X", value));
            }
        }
        this.updateScheduler();
    }

    public int getResult() {
        return this.result;
    }

    public void setAnalogInputChannelSpecification(int value) {
        this.analogInputChannelSpecification = value;
    }

    public void setPortConfiguration(int value) {
        if (value != 0 && value != 2 && value != 3 && value != 4 && value != 5) {
            this.log.error((Object)String.format("AD Converter setPortConfiguration unimplemented 0x%02X", value));
        }
        this.portConfiguration = value;
    }

    private class AdConverterAction
    implements IAction {
        private AdConverterAction() {
        }

        @Override
        public void execute() {
            Nec78k0AdConverter.this.onConverterAction();
        }
    }
}

