/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0SecureFlash
implements IState {
    private static final int STATE_VERSION = 0;
    private static final int READ_DATA_ADDRESS = 63730;
    private static final int[] secureFlashKey790 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 17, 18, 19, 20, 21, 22, 23, 24};
    private static final int[] secureFlashKey7C0 = new int[]{33, 34, 35, 36, 37, 38, 39, 40, 49, 50, 51, 52, 53, 54, 55, 56};
    private static final int SECURE_FLASH_SIZE = 16384;
    private final int[] secureFlashMemory = new int[4096];
    private final Nec78k0Sfr sfr;
    private Logger log;
    private int programmingModeControl;
    private int address;
    private int unknown1;
    private int unknown4;
    private int unknown5;
    private int unknown6;
    private int unknown7;
    private int unknownB;
    private int writeData32;

    public Nec78k0SecureFlash(Nec78k0Sfr sfr) {
        int i;
        this.sfr = sfr;
        this.log = sfr.log;
        this.write8(9, 30);
        this.write8(129, 15);
        this.write8(1153, 15);
        this.write16(516, 0);
        this.write16(518, 0);
        for (i = 0; i < secureFlashKey790.length; ++i) {
            this.write8(1936 + i, secureFlashKey790[i]);
        }
        for (i = 0; i < secureFlashKey7C0.length; ++i) {
            this.write8(1984 + i, secureFlashKey7C0[i]);
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.programmingModeControl = stream.readInt();
        this.address = stream.readInt();
        this.unknown1 = stream.readInt();
        this.unknown4 = stream.readInt();
        this.unknown5 = stream.readInt();
        this.unknown6 = stream.readInt();
        this.unknown7 = stream.readInt();
        this.unknownB = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.programmingModeControl);
        stream.writeInt(this.address);
        stream.writeInt(this.unknown1);
        stream.writeInt(this.unknown4);
        stream.writeInt(this.unknown5);
        stream.writeInt(this.unknown6);
        stream.writeInt(this.unknown7);
        stream.writeInt(this.unknownB);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.programmingModeControl = 0;
        this.address = 0;
        this.unknown1 = 0;
        this.unknown4 = 0;
        this.unknown5 = 0;
        this.unknown6 = 0;
        this.unknown7 = 0;
        this.unknownB = 0;
    }

    public void setAddress(int address) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("SecureFlash.setAddress 0x%04X", address));
        }
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    public void setFlashProtectCommandRegister(int value) {
        if (value != 165) {
            this.log.error((Object)String.format("SecureFlash.setFlashProtectCommandRegister unknown value 0x%02X", value));
        }
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public void setUnknown1(int value) {
        this.unknown1 = value;
    }

    public int getUnknown4() {
        this.unknown4 |= 4;
        return this.unknown4;
    }

    public void setUnknown4(int value) {
        this.unknown4 = value;
    }

    public int getUnknown5() {
        return this.unknown5;
    }

    public void setUnknown5(int value) {
        if (value != 0 && value != 2 && value != 8 && value != 9 && value != 10 && value != 12) {
            this.log.error((Object)String.format("SecureFlash.setUnknown5 unknown value 0x%02X", value));
        }
        int oldValue = this.unknown5;
        this.unknown5 = value;
        if (Utilities.isRaisingBit(oldValue, this.unknown5, 1) && Utilities.hasBit(this.unknown1, 7)) {
            boolean success = true;
            int operation = this.unknown1 & 0xF;
            if (operation == 0) {
                int value32 = this.read32(this.address);
                Utilities.writeUnaligned32(this.sfr.getMemory(), 63730, value32);
                if (Utilities.hasBit(this.unknown7, 3) && value32 != this.writeData32) {
                    success = false;
                }
            } else if (operation == 2) {
                Utilities.writeUnaligned32(this.sfr.getMemory(), 63730, this.read32(this.address));
                this.sfr.getMemory().write8(63729, (byte)63);
            } else if (operation == 1) {
                int verifyData32 = this.read32(this.address);
                if (this.writeData32 != verifyData32) {
                    this.log.error((Object)String.format("SecureFlash verify operation failed at address 0x%04X: 0x%08X != 0x%08X", this.address, this.writeData32, verifyData32));
                    success = false;
                }
            } else if (operation == 4) {
                this.write32(this.address, this.writeData32);
            } else if (operation == 5) {
                int verifyData32 = this.read32(this.address);
                if (this.writeData32 != verifyData32) {
                    this.log.error((Object)String.format("SecureFlash verify extended operation failed at address 0x%04X: 0x%08X != 0x%08X", this.address, this.writeData32, verifyData32));
                    success = false;
                } else if (this.unknownB != 63) {
                    this.log.error((Object)String.format("SecureFlash verify extended operation failed at address 0x%04X: 0x%02X", this.address, this.unknownB));
                    success = false;
                }
            } else if (operation != 8) {
                this.log.error((Object)String.format("SecureFlash.setUnknown5 unknown operation 0x%X for address 0x%04X", operation, this.address));
            }
            this.unknown7 = success ? Utilities.setBit(this.unknown7, 7) : Utilities.clearBit(this.unknown7, 7);
        }
    }

    public int getUnknown6() {
        return this.unknown6;
    }

    public void setUnknown6(int value) {
        if (value != 0 && value != 2) {
            this.log.error((Object)String.format("SecureFlash.setUnknown6 unknown value 0x%02X", value));
        }
        int oldValue = this.unknown6;
        this.unknown6 = value;
        if (Utilities.isRaisingBit(oldValue, this.unknown6, 1) && Utilities.hasBit(this.unknown1, 7)) {
            int operation = this.unknown1 & 0xF;
            if (operation == 8) {
                this.write32(this.address, this.writeData32);
            } else {
                this.log.error((Object)String.format("SecureFlash.setUnknown6 unknown operation 0x%X for address 0x%04X", operation, this.address));
            }
        }
    }

    public int getUnknown7() {
        return this.unknown7;
    }

    public void setUnknown7(int value) {
        if ((value & 0x72) != 0) {
            this.log.error((Object)String.format("SecureFlash.setUnknown7 unknown value 0x%02X", value));
        }
        this.unknown7 = value;
    }

    public int getUnknown8() {
        return 0;
    }

    public void setFlashProgrammingModeControlRegister(int value) {
        if (value != 0 && value != 1 && value != 128 && value != 129 && value != 126 && value != 127 && value != 254 && value != 255) {
            this.log.error((Object)String.format("SecureFlash.setFlashProgrammingModeControlRegister unknown value 0x%02X", value));
        }
        this.programmingModeControl = value;
    }

    public int getFlashProgrammingModeControl() {
        return this.programmingModeControl;
    }

    public void setUnknownB(int value) {
        if (value != 63) {
            this.log.error((Object)String.format("SecureFlash.setUnknownB unknown value 0x%02X", value));
        }
        this.unknownB = value;
    }

    public void setWriteData0(int value) {
        this.writeData32 = Utilities.setByte0(this.writeData32, value);
    }

    public void setWriteData1(int value) {
        this.writeData32 = Utilities.setByte1(this.writeData32, value);
    }

    public void setWriteData2(int value) {
        this.writeData32 = Utilities.setByte2(this.writeData32, value);
    }

    public void setWriteData3(int value) {
        this.writeData32 = Utilities.setByte3(this.writeData32, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("SecureFlash.setWriteData 0x%08X", this.writeData32));
        }
    }

    private int internalRead32(int addr) {
        return this.secureFlashMemory[addr >> 2];
    }

    private void internalWrite32(int addr, int value) {
        this.secureFlashMemory[addr >> 2] = value;
    }

    private boolean isAddressValid(int addr, int alignment) {
        return addr >= 0 && addr < 16384 && (addr & alignment) == 0;
    }

    public int read32(int addr) {
        int value;
        if (this.isAddressValid(addr, 3)) {
            value = this.internalRead32(addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("SecureFlash.read32(0x%04X) returning 0x%08X", addr, value));
            }
        } else {
            this.log.error((Object)String.format("SecureFlash.read32 unknown address 0x%04X", addr));
            value = 0;
        }
        return value;
    }

    public int read8(int addr) {
        int value8 = 0;
        if (this.isAddressValid(addr, 0)) {
            int value32 = this.internalRead32(addr);
            switch (addr & 3) {
                case 0: {
                    value8 = Utilities.getByte2(value32);
                    break;
                }
                case 1: {
                    value8 = Utilities.getByte3(value32);
                    break;
                }
                case 2: {
                    value8 = Utilities.getByte0(value32);
                    break;
                }
                case 3: {
                    value8 = Utilities.getByte1(value32);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("SecureFlash.read8(0x%04X) returning 0x%02X", addr, value8));
            }
        } else {
            this.log.error((Object)String.format("SecureFlash.read8 unknown address 0x%04X", addr));
        }
        return value8;
    }

    public void write32(int addr, int value) {
        if (this.isAddressValid(addr, 3)) {
            this.internalWrite32(addr, value);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("SecureFlash.write32(0x%04X, 0x%08X)", addr, value));
            }
        } else {
            this.log.error((Object)String.format("SecureFlash.write32 unknown address 0x%04X", addr));
        }
    }

    public void write8(int addr, int value8) {
        if (this.isAddressValid(addr, 0)) {
            int value32 = this.internalRead32(addr);
            switch (addr & 3) {
                case 0: {
                    value32 = Utilities.setByte2(value32, value8);
                    break;
                }
                case 1: {
                    value32 = Utilities.setByte3(value32, value8);
                    break;
                }
                case 2: {
                    value32 = Utilities.setByte0(value32, value8);
                    break;
                }
                case 3: {
                    value32 = Utilities.setByte1(value32, value8);
                }
            }
            this.internalWrite32(addr, value32);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("SecureFlash.write8(0x%04X, 0x%02X)", addr, value8));
            }
        } else {
            this.log.error((Object)String.format("SecureFlash.write8 unknown address 0x%04X", addr));
        }
    }

    public void write16(int addr, int value16) {
        if (this.isAddressValid(addr, 1)) {
            int value32 = this.internalRead32(addr);
            switch (addr & 2) {
                case 0: {
                    value32 = Utilities.setByte2(value32, Utilities.getByte0(value16));
                    value32 = Utilities.setByte3(value32, Utilities.getByte1(value16));
                    break;
                }
                case 2: {
                    value32 = Utilities.setByte0(value32, Utilities.getByte0(value16));
                    value32 = Utilities.setByte1(value32, Utilities.getByte1(value16));
                }
            }
            this.internalWrite32(addr, value32);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("SecureFlash.write16(0x%04X, 0x%04X)", addr, value16));
            }
        } else {
            this.log.error((Object)String.format("SecureFlash.write16 unknown address 0x%04X", addr));
        }
    }
}

