/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterface;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0SerialInterfaceUART6
implements IState {
    private static final int STATE_VERSION = 0;
    private final Nec78k0Sfr sfr;
    private Logger log;
    private Nec78k0SerialInterface serialInterfaceEmulator;
    private int operationMode;
    private int controlRegister;
    private int clockSelection;
    private int baudRateGeneratorControl;
    private int receptionErrorStatus;

    public Nec78k0SerialInterfaceUART6(Nec78k0Sfr sfr) {
        this.sfr = sfr;
        this.log = sfr.log;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.operationMode = stream.readInt();
        this.controlRegister = stream.readInt();
        this.clockSelection = stream.readInt();
        this.baudRateGeneratorControl = stream.readInt();
        this.receptionErrorStatus = stream.readInt();
        if (this.serialInterfaceEmulator != null) {
            this.serialInterfaceEmulator.read(stream);
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.operationMode);
        stream.writeInt(this.controlRegister);
        stream.writeInt(this.clockSelection);
        stream.writeInt(this.baudRateGeneratorControl);
        stream.writeInt(this.receptionErrorStatus);
        if (this.serialInterfaceEmulator != null) {
            this.serialInterfaceEmulator.write(stream);
        }
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.operationMode = 1;
        this.controlRegister = 22;
        this.clockSelection = 0;
        this.baudRateGeneratorControl = 255;
        this.receptionErrorStatus = 0;
        if (this.serialInterfaceEmulator != null) {
            this.serialInterfaceEmulator.reset();
        }
    }

    public void setSerialInterface(Nec78k0SerialInterface serialInterfaceEmulator) {
        this.serialInterfaceEmulator = serialInterfaceEmulator;
    }

    public Nec78k0SerialInterface getConnectedSerialInterface() {
        return this.serialInterfaceEmulator;
    }

    private boolean isTransmissionEnabled() {
        return Utilities.hasBit(this.operationMode, 7) && Utilities.hasBit(this.operationMode, 6);
    }

    public boolean isReceptionEnabled() {
        return Utilities.hasBit(this.operationMode, 7) && Utilities.hasBit(this.operationMode, 5);
    }

    public void setOperationMode(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 setOperationMode 0x%02X", value));
        }
        int oldOperationMode = this.operationMode;
        this.operationMode = value;
        if (Utilities.isRaisingBit(oldOperationMode, this.operationMode, 6)) {
            this.serialInterfaceEmulator.startTransmission();
        } else if (Utilities.isFallingBit(oldOperationMode, this.operationMode, 6)) {
            this.serialInterfaceEmulator.endTransmission();
        }
        if (Utilities.isRaisingBit(oldOperationMode, this.operationMode, 5)) {
            this.serialInterfaceEmulator.startReception();
        } else if (Utilities.isFallingBit(oldOperationMode, this.operationMode, 5)) {
            this.serialInterfaceEmulator.endReception();
        }
    }

    public int getOperationMode() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 getOperationMode returning 0x%02X", this.operationMode));
        }
        return this.operationMode;
    }

    public int getControlRegister() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 getControlRegister returning 0x%02X", this.controlRegister));
        }
        return this.controlRegister;
    }

    public void setControlRegister(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 setControlRegister 0x%02X", value));
        }
        this.controlRegister = value = Utilities.clearBit(value, 7);
    }

    public int getClockSelection() {
        return this.clockSelection;
    }

    public void setClockSelection(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 setClockSelection 0x%02X", value));
        }
        this.clockSelection = value;
    }

    public int getBaudRateGeneratorControl() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 getBaudRateGeneratorControl returning 0x%02X", this.baudRateGeneratorControl));
        }
        return this.baudRateGeneratorControl;
    }

    public void setBaudRateGeneratorControl(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 setBaudRateGeneratorControl 0x%02X", value));
        }
        this.baudRateGeneratorControl = value;
    }

    public int getReceptionErrorStatus() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UART6 getReceptionErrorStatus returning 0x%02X", this.receptionErrorStatus));
        }
        return this.receptionErrorStatus;
    }

    public void setTransmitRegister(int value) {
        if (this.isTransmissionEnabled()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("UART6 setTransmitRegister 0x%02X", value));
            }
            this.serialInterfaceEmulator.transmit(value);
            this.sfr.setInterruptRequest(MMIOHandlerSysconFirmwareSfr.STIF6);
        } else {
            this.log.error((Object)String.format("UART6 setTransmitRegister 0x%02X but transmission not enabled", value));
        }
    }

    public int getReceiveRegister() {
        int value = 0;
        if (this.isReceptionEnabled()) {
            value = this.serialInterfaceEmulator.receive();
            if (this.serialInterfaceEmulator.hasReceived()) {
                this.sfr.setInterruptRequest(MMIOHandlerSysconFirmwareSfr.SRIF6);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("UART6 getReceiveRegister returning 0x%02X", value));
            }
        } else {
            this.log.error((Object)String.format("UART6 getReceiveRegister reception not enabled", new Object[0]));
        }
        return value;
    }

    public int getTransmissionStatus() {
        return 0;
    }

    public void asyncReceive() {
        this.sfr.setInterruptRequest(MMIOHandlerSysconFirmwareSfr.SRIF6);
    }
}

