/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.AbstractSysconTimerEventCounter;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class Nec78k0TimerH
extends AbstractSysconTimerEventCounter {
    private static final int STATE_VERSION = 0;
    private final int interruptFlagCompare;
    private final int[] countClockSelection;
    private int timerMode;
    private int timerCarrierControl;
    private int compare0;
    private int compare1;
    public static final int[] countClockSelectionH0 = new int[]{200, 400, 800, 12800, 204920, 0, 0, 0};
    public static final int[] countClockSelectionH1 = new int[]{200, 800, 3200, 12800, 819670, 531915, 2127660, 4167};

    public Nec78k0TimerH(Nec78k0Sfr sfr, Nec78k0Scheduler scheduler, String name, int interruptFlagCompare, int[] countClockSelection) {
        super(sfr, scheduler, name, 255);
        this.interruptFlagCompare = interruptFlagCompare;
        this.countClockSelection = countClockSelection;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.timerMode = stream.readInt();
        this.timerCarrierControl = stream.readInt();
        this.compare0 = stream.readInt();
        this.compare1 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.timerMode);
        stream.writeInt(this.timerCarrierControl);
        stream.writeInt(this.compare0);
        stream.writeInt(this.compare1);
        super.write(stream);
    }

    @Override
    public void reset() {
        this.timerMode = 0;
        this.timerCarrierControl = 0;
        this.compare0 = 0;
        this.compare1 = 0;
        super.reset();
        this.updateCompare();
    }

    @Override
    protected void onTimerCounterOverflow() {
    }

    @Override
    protected void onTimerCounterCompare0() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s onTimerCounterCompare0 triggering interrupt %s", this.name, MMIOHandlerSysconFirmwareSfr.getInterruptName(MMIOHandlerSysconFirmwareSfr.IFtoINT(this.interruptFlagCompare))));
        }
        this.sfr.setInterruptRequest(this.interruptFlagCompare);
        this.timerCounter = 0;
    }

    private int getTimerOperationMode() {
        return this.timerMode >> 2 & 3;
    }

    private boolean isIntervalTimerMode() {
        return this.getTimerOperationMode() == 0;
    }

    private boolean isPWMTimerMode() {
        return this.getTimerOperationMode() == 2;
    }

    @Override
    protected void onTimerCounterCompare1() {
        if (this.isPWMTimerMode()) {
            // empty if block
        }
    }

    public void setTimerMode(int value) {
        if (Utilities.hasBit(value, 0)) {
            this.log.error((Object)String.format("%s setTimerMode unimplemented output enabled 0x%02X", this.name, value));
        }
        if (Utilities.hasBit(value, 1)) {
            this.log.error((Object)String.format("%s setTimerMode unimplemented output level control 0x%02X", this.name, value));
        }
        if (!this.isIntervalTimerMode()) {
            this.log.error((Object)String.format("%s setTimerMode unimplemented timer operation mode 0x%02X", this.name, value));
        }
        int clockStep = this.countClockSelection[value >> 4 & 7];
        this.setClockStep(clockStep);
        if (clockStep == 0) {
            this.log.error((Object)String.format("%s setTimerMode unimplemented count clock selection 0x%02X", this.name, value));
        }
        if (Utilities.hasBit(value, 7)) {
            this.setMode(false, true);
        }
        this.timerMode = value;
    }

    public int getTimerMode() {
        return this.timerMode;
    }

    public void setTimeCarrierControl(int value) {
        this.log.error((Object)String.format("%s setTimeCarrierControl unimplemented 0x%02X", this.name, value));
    }

    private void updateCompare() {
        this.setCompareValue0(this.compare0);
        if (this.isIntervalTimerMode()) {
            this.setCompareValue1(-1);
        } else {
            this.setCompareValue1(this.compare1);
        }
    }

    public void setCompare0(int value) {
        this.compare0 = value;
        this.updateCompare();
    }

    public void setCompare1(int value) {
        this.compare1 = value;
        this.updateCompare();
    }
}

