/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0WatchTimer
implements IState {
    private static final int STATE_VERSION = 0;
    private final Nec78k0Sfr sfr;
    private final Nec78k0Scheduler scheduler;
    private Logger log;
    private final TimerAction watchTimer;
    private final TimerAction intervalTimer;
    private int operationMode;

    public Nec78k0WatchTimer(Nec78k0Sfr sfr, Nec78k0Scheduler scheduler) {
        this.sfr = sfr;
        this.scheduler = scheduler;
        this.log = sfr.log;
        this.watchTimer = new TimerAction("Watch Timer", MMIOHandlerSysconFirmwareSfr.WTIF);
        this.intervalTimer = new TimerAction("Interval Timer", MMIOHandlerSysconFirmwareSfr.WTIIF);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.operationMode = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.operationMode);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.operationMode = 0;
        this.watchTimer.reset();
        this.intervalTimer.reset();
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(int value) {
        if (this.operationMode != value) {
            this.operationMode = value;
            if (Utilities.hasBit(this.operationMode, 7)) {
                switch (this.operationMode >> 2 & 3) {
                    case 0: {
                        this.watchTimer.setStep(500000);
                        break;
                    }
                    case 1: {
                        this.watchTimer.setStep(250000);
                        break;
                    }
                    case 2: {
                        this.watchTimer.setStep(977);
                        break;
                    }
                    case 3: {
                        this.watchTimer.setStep(488);
                    }
                }
                switch (this.operationMode >> 4 & 7) {
                    case 0: {
                        this.intervalTimer.setStep(488);
                        break;
                    }
                    case 1: {
                        this.intervalTimer.setStep(977);
                        break;
                    }
                    case 2: {
                        this.intervalTimer.setStep(1950);
                        break;
                    }
                    case 3: {
                        this.intervalTimer.setStep(3910);
                        break;
                    }
                    case 4: {
                        this.intervalTimer.setStep(7810);
                        break;
                    }
                    case 5: {
                        this.intervalTimer.setStep(15600);
                        break;
                    }
                    case 6: {
                        this.intervalTimer.setStep(31300);
                        break;
                    }
                    case 7: {
                        this.intervalTimer.setStep(62500);
                    }
                }
            } else {
                switch (this.operationMode >> 2 & 3) {
                    case 0: {
                        this.watchTimer.setStep(419000);
                        break;
                    }
                    case 1: {
                        this.watchTimer.setStep(210000);
                        break;
                    }
                    case 2: {
                        this.watchTimer.setStep(819);
                        break;
                    }
                    case 3: {
                        this.watchTimer.setStep(410);
                    }
                }
                switch (this.operationMode >> 4 & 7) {
                    case 0: {
                        this.intervalTimer.setStep(410);
                        break;
                    }
                    case 1: {
                        this.intervalTimer.setStep(820);
                        break;
                    }
                    case 2: {
                        this.intervalTimer.setStep(1640);
                        break;
                    }
                    case 3: {
                        this.intervalTimer.setStep(3280);
                        break;
                    }
                    case 4: {
                        this.intervalTimer.setStep(6550);
                        break;
                    }
                    case 5: {
                        this.intervalTimer.setStep(13100);
                        break;
                    }
                    case 6: {
                        this.intervalTimer.setStep(26200);
                        break;
                    }
                    case 7: {
                        this.intervalTimer.setStep(52400);
                    }
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("WatchTimer.setOperationMode WTM=0x%02X, %s, %s", this.operationMode, this.watchTimer, this.intervalTimer));
            }
        }
    }

    private class TimerAction
    implements IAction {
        private final int interruptBit;
        private final String name;
        private long nextTimer;
        private int step;
        private boolean booting;

        public TimerAction(String name, int interruptBit) {
            this.name = name;
            this.interruptBit = interruptBit;
            this.booting = true;
        }

        @Override
        public void execute() {
            if (Utilities.hasBit(Nec78k0WatchTimer.this.operationMode, 0)) {
                long now = MMIOHandlerSysconFirmwareSfr.now();
                if (this.booting) {
                    if (Nec78k0WatchTimer.this.sfr.getMemory().internalRead8(65073) == 3) {
                        this.booting = false;
                    } else {
                        this.nextTimer = now + 1000L;
                    }
                }
                if (now >= this.nextTimer) {
                    Nec78k0WatchTimer.this.sfr.setInterruptRequest(this.interruptBit);
                    this.nextTimer = this.getNextTimer(this.nextTimer);
                }
                Nec78k0WatchTimer.this.scheduler.addAction(this.nextTimer, this);
            }
        }

        public void reset() {
            this.nextTimer = 0L;
            this.step = 0;
            this.booting = true;
            Nec78k0WatchTimer.this.scheduler.removeAction(this);
        }

        private long getNextTimer(long now) {
            return now + (long)this.step;
        }

        public void setStep(int step) {
            this.step = step;
            Nec78k0WatchTimer.this.scheduler.removeAction(this);
            this.nextTimer = this.getNextTimer(MMIOHandlerSysconFirmwareSfr.now());
            Nec78k0WatchTimer.this.scheduler.addAction(this.nextTimer, this);
        }

        public String toString() {
            return String.format("%s next=0x%X, step=0x%X", this.name, this.nextTimer, this.step);
        }
    }
}

