/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.modules.sceSasCore;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoftwareSynthesizer;
import jpcsp.sound.SoundMixer;
import jpcsp.sound.SoundVoice;
import org.apache.log4j.Logger;

public class SampleSourceWithADSR
implements ISampleSource {
    private static Logger log = SoftwareSynthesizer.log;
    private ISampleSource sampleSource;
    private SoundVoice voice;
    private EnvelopeState envelopeState;
    private final boolean tracing;

    public SampleSourceWithADSR(ISampleSource sampleSource, SoundVoice voice, SoundVoice.VoiceADSREnvelope envelope) {
        this.sampleSource = sampleSource;
        this.voice = voice;
        this.envelopeState = new EnvelopeState(envelope);
        this.tracing = sceSasCore.log.isTraceEnabled();
    }

    @Override
    public int getNextSample() {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("SampleSourceWithADSR.getNextSample height=0x%X, curveState=%d", this.envelopeState.envelopeHeight, this.envelopeState.getCurveState()));
        }
        if (!this.voice.isOn()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("SampleSourceWithADSR.getNextSample voice no longer on", new Object[0]));
            }
            this.envelopeState.setKeyOff();
        }
        if (this.envelopeState.isEnded()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("SampleSourceWithADSR.getNextSample envelopeState reached end", new Object[0]));
            }
            this.voice.setPlaying(false);
            return 0;
        }
        int envelopeHeight = this.envelopeState.getNextEnvelopeHeight();
        int sample = this.sampleSource.getNextSample();
        int envelopeHeight16 = (envelopeHeight >> 14) + 1 >> 1;
        short modulatedSampleLeft = this.modulate(SoundMixer.getSampleLeft(sample), envelopeHeight16);
        short modulatedSampleRight = this.modulate(SoundMixer.getSampleRight(sample), envelopeHeight16);
        int modulatedSample = SoundMixer.getSampleStereo(modulatedSampleLeft, modulatedSampleRight);
        if (this.tracing) {
            sceSasCore.log.trace((Object)String.format("getNextSample voice=0x%X, sample=0x%08X, envelopeHeight=0x%08X, modulatedSample=0x%08X", this.voice.getIndex(), sample, envelopeHeight, modulatedSample));
        }
        this.voice.getEnvelope().height = envelopeHeight;
        this.voice.getEnvelope().curveState = this.envelopeState.getCurveState();
        return modulatedSample;
    }

    private short modulate(short sample, int envelopeHeight16) {
        return (short)(sample * envelopeHeight16 + 16384 >> 15);
    }

    @Override
    public void resetToStart() {
        this.sampleSource.resetToStart();
        this.envelopeState.resetToStart();
    }

    @Override
    public boolean isEnded() {
        return this.sampleSource.isEnded();
    }

    private static class EnvelopeState {
        private SoundVoice.VoiceADSREnvelope envelope;
        private long envelopeHeight;
        private int curveState;
        private int indexExp;
        private final boolean tracing;
        private static final short[] expCurve = new short[]{0, 896, 1764, 2605, 3419, 4210, 4975, 5715, 6433, 7129, 7803, 8454, 9087, 9700, 10293, 10867, 11424, 11963, 12486, 12992, 13483, 13958, 14418, 14864, 15296, 15715, 16119, 16513, 16892, 17262, 17619, 17963, 18299, 18623, 18938, 19243, 19537, 19824, 20100, 20368, 20629, 20881, 21124, 21360, 21589, 21812, 22025, 22233, 22435, 22631, 22820, 23003, 23180, 23353, 23520, 23681, 23836, 23989, 24136, 24277, 24416, 24549, 24678, 24802, 24925, 25042, 25156, 25266, 25373, 25476, 25576, 25674, 25768, 25859, 25947, 26033, 26117, 26195, 26274, 26349, 26423, 26493, 26561, 26628, 26692, 26754, 26815, 26873, 26930, 26985, 27037, 27090, 27139, 27188, 27235, 27279, 27324, 27366, 27406, 27447, 27485, 27524, 27559, 27595, 27629, 27662, 27693, 27725, 27755, 27784, 27812, 27839, 27865, 27891, 27916, 27940, 27963, 27986, 28008, 28029, 28049, 28070, 28089, 28106, 28126, 28143, 28159, 28176, 28192, 28208, 28222, 28236, 28250, 28264, 28278, 28290, 28302, 28315, 28325, 28337, 28348, 28358, 28369, 28379, 28388, 28397, 28406, 28414, 28423, 28432, 28439, 28448, 28455, 28462, 28469, 28476, 28483, 28488, 28495, 28500, 28507, 28512, 28518, 28523, 28528, 28532, 28537, 28542, 28546, 28551, 28554, 28560, 28563, 28567, 28570, 28574, 28577, 28581, 28584, 28588, 28589, 28593, 28596, 28598, 28602, 28603, 28607, 28609, 28612, 28614, 28616, 28617, 28621, 28623, 28624, 28626, 28628, 28630, 28631, 28633, 28635, 28637, 28638, 28638, 28640, 28642, 28644, 28645, 28645, 28647, 28649, 28649, 28651, 28652, 28652, 28654, 28654, 28656, 28656, 28658, 28658, 28659, 28659, 28661, 28661, 28663, 28663, 28663, 28665, 28665, 28665, 28666, 28666, 28666, 28668, 28668, 28668, 28670, 28670, 28670, 28672};
        private static final short expCurveReference = 28672;

        public EnvelopeState(SoundVoice.VoiceADSREnvelope envelope) {
            this.envelope = envelope;
            this.tracing = sceSasCore.log.isTraceEnabled();
        }

        public void resetToStart() {
            this.indexExp = 0;
            this.envelopeHeight = 0L;
            this.curveState = 0;
        }

        private static short extrapolateSample(short[] curve, int index, int duration) {
            float curveIndex = (float)(index * curve.length) / (float)duration;
            int curveIndex1 = (int)curveIndex;
            int curveIndex2 = curveIndex1 + 1;
            float curveIndexFraction = curveIndex - (float)curveIndex1;
            if (curveIndex1 < 0) {
                return curve[0];
            }
            if (curveIndex2 >= curve.length || curveIndex2 < 0) {
                return curve[curve.length - 1];
            }
            float sample = (float)curve[curveIndex1] * (1.0f - curveIndexFraction) + (float)curve[curveIndex2] * curveIndexFraction;
            return (short)Math.round(sample);
        }

        private long stepCurveExp(int rate) {
            int duration = rate == 0 ? Integer.MAX_VALUE : Integer.MAX_VALUE / rate * 16;
            short expFactor = EnvelopeState.extrapolateSample(expCurve, this.indexExp, duration);
            ++this.indexExp;
            return (long)expFactor * 0x40000000L / 28672L;
        }

        private void setCurveState(int curveState) {
            if (this.curveState != curveState) {
                this.curveState = curveState;
                this.indexExp = 0;
            }
        }

        private int getIntEnvelopeHeight(long envelopeHeight) {
            if (envelopeHeight <= 0L) {
                return 0;
            }
            if (envelopeHeight >= 0x40000000L) {
                return 0x40000000;
            }
            return (int)envelopeHeight;
        }

        private void stepCurve(int type, int rate) {
            switch (type) {
                case 0: {
                    this.envelopeHeight += (long)rate;
                    break;
                }
                case 1: {
                    this.envelopeHeight -= (long)rate;
                    break;
                }
                case 2: {
                    if (this.envelopeHeight <= 0x30000000L) {
                        this.envelopeHeight += (long)rate;
                        break;
                    }
                    this.envelopeHeight += (long)(rate >> 2);
                    break;
                }
                case 3: {
                    this.envelopeHeight = 0x40000000L - this.stepCurveExp(rate);
                    break;
                }
                case 4: {
                    this.envelopeHeight = this.stepCurveExp(rate);
                    break;
                }
                case 5: {
                    this.envelopeHeight = rate;
                }
            }
        }

        public int getNextEnvelopeHeight() {
            long currentEnvelopeHeight = this.envelopeHeight;
            switch (this.curveState) {
                case 0: {
                    this.stepCurve(this.envelope.AttackCurveType, this.envelope.AttackRate);
                    if (this.envelopeHeight < 0x40000000L && this.envelopeHeight >= 0L) break;
                    if (this.envelopeHeight >= 0x40000000L) {
                        this.envelopeHeight = 0x40000000L;
                    }
                    this.setCurveState(1);
                    break;
                }
                case 1: {
                    this.stepCurve(this.envelope.DecayCurveType, this.envelope.DecayRate);
                    if (this.envelopeHeight >= (long)this.envelope.SustainLevel) break;
                    this.setCurveState(2);
                    break;
                }
                case 2: {
                    this.stepCurve(this.envelope.SustainCurveType, this.envelope.SustainRate);
                    break;
                }
                case 3: {
                    this.stepCurve(this.envelope.ReleaseCurveType, this.envelope.ReleaseRate);
                }
            }
            if (this.tracing) {
                sceSasCore.log.trace((Object)String.format("getNextEnvelopeHeight curve=%d, current=0x%08X, next=0x%08X", this.curveState, currentEnvelopeHeight, this.envelopeHeight));
            }
            return this.getIntEnvelopeHeight(currentEnvelopeHeight);
        }

        public void setKeyOff() {
            this.setCurveState(3);
        }

        public boolean isEnded() {
            return this.curveState >= 2 && this.envelopeHeight <= 0L;
        }

        public int getCurveState() {
            return this.curveState;
        }
    }
}

