/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.Emulator;
import jpcsp.HLE.modules.sceAudio;
import jpcsp.sound.SoundBufferManager;
import org.apache.log4j.Logger;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.EXTThreadLocalContext;

public class SoundChannel {
    private static Logger log = sceAudio.log;
    private static final boolean doCheckError = false;
    private static volatile boolean isExit = false;
    private static volatile boolean isInit = false;
    private static long initDevice;
    private static long initContext;
    public static final int FORMAT_MONO = 16;
    public static final int FORMAT_STEREO = 0;
    private static final int BUFFER_SIZE_IN_MILLIS = 100;
    public static final int MAX_VOLUME = 32768;
    private static final int DEFAULT_VOLUME = 32768;
    private static final int DEFAULT_SAMPLE_RATE = 44100;
    private SoundBufferManager soundBufferManager = SoundBufferManager.getInstance();
    private int index;
    private boolean reserved;
    private int leftVolume;
    private int rightVolume;
    private int alSource;
    private int sampleRate;
    private int sampleLength;
    private int format;
    private int numberBlockingBuffers;
    private int minimumNumberBuffers;
    private boolean busy;

    public static void init() {
        if (!isInit) {
            initDevice = ALC10.alcOpenDevice((CharSequence)null);
            ALCCapabilities deviceCapabilities = ALC.createCapabilities((long)initDevice);
            initContext = ALC10.alcCreateContext((long)initDevice, (IntBuffer)null);
            SoundChannel.setThreadInitContext();
            AL.createCapabilities((ALCCapabilities)deviceCapabilities);
            String extensionName = "ALC_EXT_thread_local_context";
            if (!ALC10.alcIsExtensionPresent((long)initDevice, (CharSequence)"ALC_EXT_thread_local_context")) {
                log.error((Object)String.format("Required extension %s is not available", "ALC_EXT_thread_local_context"));
            }
            isInit = true;
        } else {
            SoundChannel.setThreadInitContext();
        }
        isExit = false;
    }

    public static void exit() {
        if (isInit) {
            SoundChannel.clearThreadInitContext();
            ALC10.alcDestroyContext((long)initContext);
            initContext = 0L;
            ALC10.alcCloseDevice((long)initDevice);
            initDevice = 0L;
            isInit = false;
        }
        isExit = true;
    }

    public static void setThreadInitContext() {
        if (!EXTThreadLocalContext.alcSetThreadContext((long)initContext)) {
            if (!Emulator.exitCalled()) {
                log.error((Object)String.format("setThreadInitContext alcMakeContextCurrent failed with error 0x%X", ALC10.alcGetError((long)initDevice)));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setThreadInitContext initContext=0x%X, thread=0x%X", initContext, Thread.currentThread().getId()));
        }
    }

    public static void clearThreadInitContext() {
        if (!EXTThreadLocalContext.alcSetThreadContext((long)0L)) {
            log.error((Object)String.format("clearThreadInitContext alcMakeContextCurrent failed with error 0x%X", ALC10.alcGetError((long)initDevice)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("clearThreadInitContext thread=0x%X", Thread.currentThread().getId()));
        }
    }

    public SoundChannel(int index) {
        this.index = index;
        this.reserved = false;
        this.leftVolume = 32768;
        this.rightVolume = 32768;
        this.alSource = AL10.alGenSources();
        this.sampleRate = 44100;
        this.updateNumberBlockingBuffers();
        AL10.alSourcei((int)this.alSource, (int)4103, (int)0);
        SoundChannel.alCheckError("alSourcei AL_LOOPING");
    }

    public static void alCheckError(String comment) {
    }

    private void updateNumberBlockingBuffers() {
        if (this.getSampleLength() > 0) {
            float bufferSizeInSamples = (float)(this.getSampleRate() * 100) / 1000.0f;
            this.numberBlockingBuffers = Math.round(bufferSizeInSamples / (float)this.getSampleLength());
        }
        this.numberBlockingBuffers = Math.max(this.numberBlockingBuffers, 1);
        this.minimumNumberBuffers = this.getSampleLength() <= 64 ? 10 : 0;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    public int getLeftVolume() {
        return this.leftVolume;
    }

    public void setLeftVolume(int leftVolume) {
        this.leftVolume = leftVolume;
    }

    public int getRightVolume() {
        return this.rightVolume;
    }

    public void setRightVolume(int rightVolume) {
        this.rightVolume = rightVolume;
    }

    public void setVolume(int volume) {
        this.setLeftVolume(volume);
        this.setRightVolume(volume);
    }

    public int getSampleLength() {
        return this.sampleLength;
    }

    public void setSampleLength(int sampleLength) {
        if (this.sampleLength != sampleLength) {
            this.sampleLength = sampleLength;
            this.updateNumberBlockingBuffers();
        }
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public boolean isFormatStereo() {
        return (this.format & 0x10) == 0;
    }

    public boolean isFormatMono() {
        return (this.format & 0x10) == 16;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        if (this.sampleRate != sampleRate) {
            this.sampleRate = sampleRate;
            this.updateNumberBlockingBuffers();
        }
    }

    private void alSourcePlay() {
        int state = AL10.alGetSourcei((int)this.alSource, (int)4112);
        if (state != 4114 && (this.minimumNumberBuffers <= 0 || this.getWaitingBuffers() >= this.minimumNumberBuffers)) {
            AL10.alSourcePlay((int)this.alSource);
            SoundChannel.alCheckError("alSourcePlay");
        }
    }

    private void alSourceQueueBuffer(byte[] buffer) {
        int alBuffer = this.soundBufferManager.getBuffer();
        ByteBuffer directBuffer = this.soundBufferManager.getDirectBuffer(buffer.length);
        directBuffer.clear();
        directBuffer.limit(buffer.length);
        directBuffer.put(buffer);
        directBuffer.rewind();
        int alFormat = this.isFormatStereo() ? 4355 : 4353;
        AL10.alBufferData((int)alBuffer, (int)alFormat, (ByteBuffer)directBuffer, (int)this.getSampleRate());
        SoundChannel.alCheckError("alBufferData");
        AL10.alSourceQueueBuffers((int)this.alSource, (int)alBuffer);
        SoundChannel.alCheckError("alSourceQueueBuffers");
        this.soundBufferManager.releaseDirectBuffer(directBuffer);
        this.alSourcePlay();
        this.checkFreeBuffers();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("alSourceQueueBuffer buffer=%d, %s", alBuffer, this.toString()));
        }
    }

    public void checkFreeBuffers() {
        this.soundBufferManager.checkFreeBuffers(this.alSource);
    }

    public void release() {
        AL10.alSourceStop((int)this.alSource);
        SoundChannel.alCheckError("alSourceStop");
        this.checkFreeBuffers();
    }

    public void play(byte[] buffer) {
        this.alSourceQueueBuffer(buffer);
    }

    private int getWaitingBuffers() {
        this.checkFreeBuffers();
        return AL10.alGetSourcei((int)this.alSource, (int)4117);
    }

    private int getSourceSampleOffset() {
        int sampleOffset = AL10.alGetSourcei((int)this.alSource, (int)4133);
        SoundChannel.alCheckError("alGetSourcei AL_SAMPLE_OFFSET");
        if (this.isFormatStereo()) {
            sampleOffset /= 2;
        }
        return sampleOffset;
    }

    public boolean isOutputBlocking() {
        if (isExit) {
            return true;
        }
        return this.getWaitingBuffers() >= this.numberBlockingBuffers;
    }

    public boolean isDrained() {
        if (this.isEnded()) {
            return true;
        }
        return this.getWaitingBuffers() <= 1;
    }

    public int getUnblockOutputDelayMicros(boolean waitForCompleteDrain) {
        if (isExit || this.isEnded()) {
            return 0;
        }
        int samples = waitForCompleteDrain ? this.getDrainLength() : this.getSampleLength() - this.getSourceSampleOffset();
        float delaySecs = (float)samples / (float)this.getSampleRate();
        int delayMicros = (int)(delaySecs * 1000000.0f);
        return delayMicros;
    }

    public int getDrainLength() {
        int waitingBuffers = this.getWaitingBuffers();
        if (waitingBuffers > 0) {
            --waitingBuffers;
        }
        int restLength = waitingBuffers * this.getSampleLength();
        return restLength;
    }

    public int getRestLength() {
        int restLength = this.getDrainLength();
        if (!this.isEnded()) {
            restLength += this.getSampleLength() - this.getSourceSampleOffset();
        }
        return restLength;
    }

    public boolean isEnded() {
        this.checkFreeBuffers();
        int state = AL10.alGetSourcei((int)this.alSource, (int)4112);
        SoundChannel.alCheckError("alGetSourcei AL_SOURCE_STATE");
        return state != 4114;
    }

    public static short adjustSample(short sample, int volume) {
        return (short)(sample * volume >> 15);
    }

    public static void storeSample(short sample, byte[] data, int index) {
        data[index] = (byte)sample;
        data[index + 1] = (byte)(sample >> 8);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("SoundChannel[%d](", this.index));
        if (!isExit) {
            s.append(String.format("sourceSampleOffset=%d", this.getSourceSampleOffset()));
            s.append(String.format(", restLength=%d", this.getRestLength()));
            s.append(String.format(", buffers queued=%d", this.getWaitingBuffers()));
            s.append(String.format(", isOutputBlock=%b", this.isOutputBlocking()));
            s.append(String.format(", %s", this.isFormatStereo() ? "Stereo" : "Mono"));
            s.append(String.format(", reserved=%b", this.reserved));
            s.append(String.format(", sampleLength=%d", this.getSampleLength()));
            s.append(String.format(", sampleRate=%d", this.getSampleRate()));
            s.append(String.format(", busy=%b", this.busy));
        }
        s.append(")");
        return s.toString();
    }
}

