/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.modules.sceSyscon;
import jpcsp.autotests.AutoTestsRunner;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Model;
import jpcsp.hardware.Wlan;
import jpcsp.memory.mmio.battery.BatteryEmulator;
import jpcsp.memory.mmio.syscon.MMIOHandlerSyscon;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.memory.mmio.syscon.SysconBootloaderEmulator;
import jpcsp.memory.mmio.syscon.SysconEmulator;
import jpcsp.memory.mmio.syscon.SysconMemory;
import jpcsp.nec78k0.Nec78k0Instructions;
import jpcsp.nec78k0.Nec78k0Interpreter;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.util.LWJGLFixer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Syscon78k0Test {
    public static Logger log;
    private static final int[] bootloaderTestCommands;

    public static void main(String[] args) {
        LWJGLFixer.fixOnce();
        DOMConfigurator.configure((String)"LogSettings.xml");
        log = SysconEmulator.log;
        RuntimeContext.setLog4jMDC();
        Wlan.initialize();
        Battery.initialize();
        new Emulator(new AutoTestsRunner.DummyGUI());
        Emulator.getClock().resume();
        RuntimeContext.debugCodeBlockCalls = true;
        Emulator.run = true;
        new Syscon78k0Test().testFirmware();
    }

    public void testFirmware() {
        int addr;
        int i;
        int baseAddress;
        int model = 1;
        model = 7;
        model = 3;
        Model.setModel(model);
        SysconEmulator.firmwareBootloader = false;
        SysconMemory mem = new SysconMemory(log);
        Nec78k0Processor processor = new Nec78k0Processor(mem);
        Nec78k0Interpreter interpreter = new Nec78k0Interpreter(processor);
        SysconEmulator.load(mem);
        if (model == 7) {
            Nec78k0Instructions.registerFunctionName(19680, "do_encrypt");
            Nec78k0Instructions.registerFunctionName(19714, "aes_key_expand");
            Nec78k0Instructions.registerFunctionName(20497, "memcpy");
            Nec78k0Instructions.registerFunctionName(20537, "memcmp");
            Nec78k0Instructions.registerFunctionName(20598, "xorloop_0x10");
            Nec78k0Instructions.registerFunctionName(20647, "memset");
            Nec78k0Instructions.registerFunctionName(20676, "generate_challenge");
            Nec78k0Instructions.registerFunctionName(20739, "final_key_encryption_cbc");
            Nec78k0Instructions.registerFunctionName(21967, "read_secure_flash");
        } else if (model == 3) {
            Nec78k0Instructions.registerFunctionName(1827, "mainLoop");
            Nec78k0Instructions.registerFunctionName(21066, "do_encrypt");
            Nec78k0Instructions.registerFunctionName(21100, "aes_key_expand");
            Nec78k0Instructions.registerFunctionName(21883, "memcpy");
            Nec78k0Instructions.registerFunctionName(21923, "memcmp");
            Nec78k0Instructions.registerFunctionName(21984, "xorloop_0x10");
            Nec78k0Instructions.registerFunctionName(22033, "memset");
            Nec78k0Instructions.registerFunctionName(22125, "final_key_encryption_cbc");
            Nec78k0Instructions.registerFunctionName(23168, "check_if_service_or_autoboot_battery");
            Nec78k0Instructions.registerFunctionName(23362, "read_secure_flash");
            Nec78k0Instructions.registerFunctionName(19629, "aes128_encrypt_key_0xFD3C_data_0xF5D0");
            Nec78k0Instructions.registerFunctionName(18710, "aes128_encrypt_key_0xFCFA_data_0xFE20");
        }
        if (mem.internalRead32(33024) != -1 || SysconEmulator.firmwareBootloader) {
            baseAddress = SysconEmulator.firmwareBootloader ? 0 : 32768;
            Nec78k0Instructions.registerFunctionName(baseAddress + 3757, "send_response_packet_02_and_03");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3748, "send_response_packet_02_and_17");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3766, "send_response_packet_02");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3530, "send_byte");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3553, "wait_for_byte_reception");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3560, "receive_packet_01");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3878, "receive_packet_01_70_and_send_response_packets_02_and_03");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4073, "prepare_one_byte_for_response_packet_02");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2095, "get_status_from_FFC4");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3949, "check_status_success_for_response_packet_02");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3656, "receive_packet_02");
            Nec78k0Instructions.registerFunctionName(baseAddress + 3987, "prepare_byte_STATUS_BUSY_for_response_packet_02");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4007, "prepare_byte_STATUS_PARAM_ERROR_for_response_packet_02");
            Nec78k0Instructions.registerFunctionName(baseAddress + 6687, "store_0F_bytes_of_received_packet_to_FE26");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4284, "multiply_32bits_by_8bits");
            Nec78k0Instructions.registerFunctionName(baseAddress + 7782, "read32_secure_flash");
            Nec78k0Instructions.registerFunctionName(baseAddress + 7719, "write32_secure_flash");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1499, "set_secure_flash_operation_read_with_delay_FE2E");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1511, "set_secure_flash_operation_read_with_delay_FE2F");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1534, "set_secure_flash_operation_read_with_delay_variable");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1523, "set_secure_flash_operation_read_with_delay_3");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1592, "set_secure_flash_operation_erase_with_delay_FE2C");
            Nec78k0Instructions.registerFunctionName(baseAddress + 6332, "set_secure_flash_operation_write_with_delay_FE28");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1559, "set_secure_flash_operation_verify_with_delay_FE2C");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1571, "set_secure_flash_operation_extended_read_with_delay_FE2C");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1583, "set_secure_flash_operation_extended_read_with_delay_FE2D");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1604, "set_secure_flash_operation_05_or_06_with_delay_FE2C");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1624, "set_secure_flash_operation_05_or_06_with_delay_FE2D");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1655, "clr1_FFC5_1");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1664, "set1_FFC5_1");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1673, "clr1_set1_FFC5_1");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1680, "set1_clr1_FFC5_1");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1687, "clr1_set1_clr1_FFC5_1");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1697, "set1_clr1_set1_FFC5_1");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1783, "set_FFCA_to_01");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1800, "set_FFCA_to_81");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1817, "set_FFCA_to_00");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1834, "set_FFCA_to_80");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2286, "enable_interrupts");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2294, "disable_interrupts");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4805, "is_using_internal_8MHz_clock");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1641, "small_delay");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1933, "read32_secure_flash_0204_to_FE3A");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4495, "set_secure_flash_address_range_0400_to_07FF");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4536, "increase_address_range");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1868, "set_secure_flash_address");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2233, "set_secure_flash_writeData32_to_FFFFFFFF");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2270, "set_secure_flash_writeData32");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4058, "set_packet_error_code_STATUS_MRG11_ERROR");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4043, "set_packet_error_code_STATUS_MRG10_ERROR");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4013, "set_packet_error_code_STATUS_PROTECT_ERROR");
            Nec78k0Instructions.registerFunctionName(baseAddress + 5685, "secure_flash_erase_or_verify_address_range");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4455, "set_secure_flash_address_range_0000_to_max");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2249, "copy_secure_flash_readData32_to_writeData32");
            Nec78k0Instructions.registerFunctionName(baseAddress + 6423, "secure_flash_verify_address_range");
            Nec78k0Instructions.registerFunctionName(baseAddress + 6426, "secure_flash_verify_address_range");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4374, "multiply_by_0400");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4577, "receive_packet_02_and_process_secure_flash_write");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2182, "extract_address_range_from_request_packet");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2100, "validate_end_address_range");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2128, "validate_start_address_range_before_end");
            Nec78k0Instructions.registerFunctionName(baseAddress + 2154, "validate_start_and_end_address_range_aligned_on_0400");
            Nec78k0Instructions.registerFunctionName(baseAddress + 1881, "read16_secure_flash_0008_to_FE3F_and_FE41");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4674, "read16_secure_flash_0008_to_FE3F_and_FE41");
            Nec78k0Instructions.registerFunctionName(baseAddress + 5249, "secure_flash_erase_address_range");
            Nec78k0Instructions.registerFunctionName(baseAddress + 4647, "read32_secure_flash_to_DE");
            Nec78k0Instructions.registerFunctionName(baseAddress + 7648, "erase_secure_flash_address_range_0400_to_7FFF");
        }
        for (i = 0; i < 64; i += 2) {
            addr = mem.internalRead16(i);
            if (addr == 0 || addr == 65535) continue;
            log.info((Object)String.format("Disassembling Vector Table entry 0x%02X(%s): 0x%04X", i, MMIOHandlerSysconFirmwareSfr.getInterruptName(i), addr));
            processor.disassemble(addr);
        }
        if (mem.internalRead32(33024) != -1 || SysconEmulator.firmwareBootloader) {
            int addr2;
            int value;
            int addr3;
            int i2;
            int n = baseAddress = SysconEmulator.firmwareBootloader ? 0 : 32768;
            if (!SysconEmulator.firmwareBootloader) {
                for (i2 = 0; i2 < 60; i2 += 2) {
                    addr3 = mem.internalRead16(baseAddress + i2) | baseAddress;
                    if (addr3 == 0 || addr3 == 65535) continue;
                    log.info((Object)String.format("Disassembling Vector Table 0x%04X entry 0x%02X(%s): 0x%04X", baseAddress, i2, MMIOHandlerSysconFirmwareSfr.getInterruptName(i2), addr3));
                    processor.disassemble(addr3);
                }
            }
            for (i2 = 0; i2 < 16; ++i2) {
                addr3 = Nec78k0Instructions.getBranchAddress(mem.internalRead16(baseAddress + 1282 + i2 * 2), baseAddress);
                log.info((Object)String.format("Disassembling switch table from 0x%04X: case 0x%02X at 0x%04X", baseAddress + 2394, i2, addr3));
                processor.disassemble(addr3);
            }
            processor.disassemble(baseAddress + 256);
            for (i2 = 0; i2 < 10; ++i2) {
                value = mem.internalRead8(baseAddress + 8146 - i2);
                addr2 = Nec78k0Instructions.getBranchAddress(Utilities.internalReadUnaligned16(mem, baseAddress + 8147 + (9 - i2) * 2), baseAddress);
                log.info((Object)String.format("Disassembling switch table from 0x%04X: case 0x%02X at 0x%04X", baseAddress + 365, value, addr2));
                processor.disassemble(addr2);
            }
            for (i2 = 0; i2 < 14; ++i2) {
                value = mem.internalRead8(baseAddress + 1327 - i2);
                addr2 = Utilities.internalReadUnaligned16(mem, baseAddress + 1328 + (13 - i2) * 2);
                log.info((Object)String.format("Disassembling switch table from 0x%04X: case 0x%02X at 0x%04X", baseAddress + 2591, value, addr2));
                processor.disassemble(addr2);
            }
        }
        if (!SysconEmulator.firmwareBootloader) {
            if (model == 1) {
                for (i = 136; i < 174; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling sysconCmdGetOps table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 136) / 2), addr));
                    processor.disassemble(addr);
                }
                for (i = 174; i < 220; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling mainOperations table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 174) / 2 + 32), addr));
                    processor.disassemble(addr);
                }
                for (i = 220; i < 266; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling peripheralOperations table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 220) / 2 + 64), addr));
                    processor.disassemble(addr);
                }
                for (i = 2; i <= 13; ++i) {
                    addr = mem.internalRead16(19880 + (i - 2) * 2);
                    log.info((Object)String.format("Disassembling switch table from 0x4DA6: case 0x%02X at 0x%04X", i, addr));
                    processor.disassemble(addr);
                }
                for (i = 1; i <= 20; ++i) {
                    addr = mem.internalRead16(12900 + (i - 1) * 2);
                    log.info((Object)String.format("Disassembling switch table from 0x3262: case 0x%02X at 0x%04X", i, addr));
                    processor.disassemble(addr);
                }
            } else if (model == 0) {
                for (i = 136; i < 174; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling sysconCmdGetOps table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 136) / 2), addr));
                    processor.disassemble(addr);
                }
                for (i = 172; i < 218; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling mainOperations table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 174) / 2 + 32), addr));
                    processor.disassemble(addr);
                }
                for (i = 218; i < 264; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling peripheralOperations table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 220) / 2 + 64), addr));
                    processor.disassemble(addr);
                }
                for (i = 1; i <= 12; ++i) {
                    addr = mem.internalRead16(9666 + (i - 1) * 2);
                    log.info((Object)String.format("Disassembling switch table from 0x25C0: case 0x%02X at 0x%04X", i, addr));
                    processor.disassemble(addr);
                }
            } else if (model == 2) {
                for (i = 2; i <= 13; ++i) {
                    addr = Utilities.internalReadUnaligned16(mem, 19921 + (i - 2) * 2);
                    log.info((Object)String.format("Disassembling switch table from 0x4DCF: case 0x%02X at 0x%04X", i, addr));
                    processor.disassemble(addr);
                }
            } else if (model == 7) {
                for (i = 138; i < 176; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling sysconCmdGetOps table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 138) / 2), addr));
                    processor.disassemble(addr);
                }
                for (i = 176; i < 222; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling mainOperations table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 176) / 2 + 32), addr));
                    processor.disassemble(addr);
                }
                for (i = 224; i < 270; i += 2) {
                    addr = mem.internalRead16(i);
                    if (addr == 0 || addr == 65535) continue;
                    log.info((Object)String.format("Disassembling peripheralOperations table 0x%02X(%s): 0x%04X", i, sceSyscon.getSysconCmdName((i - 224) / 2 + 64), addr));
                    processor.disassemble(addr);
                }
                for (i = 1; i <= 21; ++i) {
                    addr = mem.internalRead16(10106 + (i - 1) * 2);
                    log.info((Object)String.format("Disassembling switch table from 0x2778: case 0x%02X at 0x%04X", i, addr));
                    processor.disassemble(addr);
                }
                for (i = 2; i <= 13; ++i) {
                    addr = Utilities.internalReadUnaligned16(mem, 20922 + (i - 2) * 2);
                    log.info((Object)String.format("Disassembling switch table from 0x51B8: case 0x%02X at 0x%04X", i, addr));
                    processor.disassemble(addr);
                }
            }
        }
        SysconEmulator.disable();
        MMIOHandlerSyscon.getInstance().init(mem.getSfr());
        MMIOHandlerSysconFirmwareSfr.dummyTesting = true;
        Nec78k0Processor.disassembleFunctions = true;
        if (BatteryEmulator.isEnabled()) {
            Utilities.sleep(1000, 0);
        }
        if (SysconEmulator.firmwareBootloader) {
            SerialInterfaceSimulatorThread serialInterfaceSimulatorThread = new SerialInterfaceSimulatorThread(processor);
            serialInterfaceSimulatorThread.setName("Serial Interface Simulator Thread");
            serialInterfaceSimulatorThread.setDaemon(true);
            serialInterfaceSimulatorThread.start();
        }
        processor.reset();
        interpreter.run();
        long minimumDuration = 4000L;
        long start = Syscon78k0Test.now();
        while (Syscon78k0Test.now() - start < minimumDuration && !Emulator.pause) {
            interpreter.run();
        }
    }

    public static long now() {
        return Emulator.getClock().currentTimeMillis();
    }

    static {
        bootloaderTestCommands = new int[]{0, 112, 197, 192, 164, -1, 160, 158, 144, 176, 19, 64, 50, 34, 32, -1};
    }

    private static class SerialInterfaceSimulatorThread
    extends Thread {
        private final Nec78k0Processor processor;
        private final Nec78k0SerialInterfaceUART6 serialInterface;
        private final SysconBootloaderEmulator bootloaderEmulator;

        public SerialInterfaceSimulatorThread(Nec78k0Processor processor) {
            this.processor = processor;
            this.serialInterface = processor.mem.getSfr().getSerialInterfaceUART6();
            this.bootloaderEmulator = (SysconBootloaderEmulator)this.serialInterface.getConnectedSerialInterface();
        }

        private int[] getAddressRangeParameters(int start, int end) {
            int[] data = new int[]{start >> 16 & 0xFF, start >> 8 & 0xFF, start >> 0 & 0xFF, end >> 16 & 0xFF, end >> 8 & 0xFF, end >> 0 & 0xFF};
            return data;
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            Utilities.sleep(100, 0);
            int bootloaderTestCommandIndex = 0;
            while (bootloaderTestCommandIndex < bootloaderTestCommands.length) {
                if (this.bootloaderEmulator.isEmpty()) {
                    int bootloaderTestCommand = bootloaderTestCommands[bootloaderTestCommandIndex++];
                    if (bootloaderTestCommand < 0) break;
                    int startSecureFlashStartAddress = 2048;
                    int endSecureFlashStartAddress = startSecureFlashStartAddress + 1023;
                    switch (bootloaderTestCommand) {
                        case 0: {
                            this.bootloaderEmulator.setCommand(0);
                            break;
                        }
                        case 112: {
                            this.bootloaderEmulator.setCommand(112);
                            break;
                        }
                        case 164: {
                            int[] data = new int[]{0, 0};
                            this.bootloaderEmulator.setCommand(164, data);
                            break;
                        }
                        case 176: {
                            this.bootloaderEmulator.setCommand(176, this.getAddressRangeParameters(startSecureFlashStartAddress, endSecureFlashStartAddress));
                            break;
                        }
                        case 197: {
                            this.bootloaderEmulator.setCommand(197);
                            break;
                        }
                        case 192: {
                            this.bootloaderEmulator.setCommand(192);
                            break;
                        }
                        case 158: {
                            this.bootloaderEmulator.setCommand(158);
                            break;
                        }
                        case 144: {
                            int unknownValue = 4;
                            int timeoutValue = 200;
                            int[] data = new int[]{timeoutValue / 100 % 10, timeoutValue / 10 % 10, timeoutValue % 10, unknownValue};
                            this.bootloaderEmulator.setCommand(144, data);
                            break;
                        }
                        case 160: {
                            int[] data = new int[]{0, 0};
                            this.bootloaderEmulator.setCommand(160, data);
                            data = new int[]{23, 3};
                            this.bootloaderEmulator.setData(data, true);
                            break;
                        }
                        case 64: {
                            int i;
                            int length;
                            int n;
                            int[] data;
                            this.bootloaderEmulator.setCommand(64, this.getAddressRangeParameters(startSecureFlashStartAddress, endSecureFlashStartAddress));
                            for (n = startSecureFlashStartAddress; n <= endSecureFlashStartAddress; n += 256) {
                                length = Math.min(endSecureFlashStartAddress - n + 1, 256);
                                data = new int[length];
                                for (i = 0; i < data.length; ++i) {
                                    data[i] = i + 1 & 0xFF;
                                }
                                this.bootloaderEmulator.setData(data, n + length > endSecureFlashStartAddress);
                            }
                            break;
                        }
                        case 50: {
                            this.bootloaderEmulator.setCommand(50, this.getAddressRangeParameters(startSecureFlashStartAddress, endSecureFlashStartAddress));
                            break;
                        }
                        case 19: {
                            int i;
                            int length;
                            int n;
                            int[] data;
                            this.bootloaderEmulator.setCommand(19, this.getAddressRangeParameters(startSecureFlashStartAddress, endSecureFlashStartAddress));
                            for (n = startSecureFlashStartAddress; n <= endSecureFlashStartAddress; n += 256) {
                                length = Math.min(endSecureFlashStartAddress - n + 1, 256);
                                data = new int[length];
                                for (i = 0; i < data.length; ++i) {
                                    data[i] = i + 1 & 0xFF;
                                }
                                this.bootloaderEmulator.setData(data, n + length > endSecureFlashStartAddress);
                            }
                            break;
                        }
                        case 34: {
                            this.bootloaderEmulator.setCommand(34, this.getAddressRangeParameters(startSecureFlashStartAddress, endSecureFlashStartAddress));
                            break;
                        }
                        case 32: {
                            this.bootloaderEmulator.setCommand(32);
                            break;
                        }
                        default: {
                            log.error((Object)String.format("Unknown bootloader command 0x%02X", bootloaderTestCommand));
                        }
                    }
                }
                if (this.serialInterface.isReceptionEnabled() && this.processor.getCurrentInstructionPc() == 3553) {
                    this.serialInterface.asyncReceive();
                }
                Utilities.sleep(1, 0);
            }
        }
    }
}

