/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassSpecializer {
    private static Logger log = Logger.getLogger((String)"classSpecializer");
    private static SpecializedClassLoader classLoader = new SpecializedClassLoader();
    private static HashSet<Class<?>> tracedClasses = new HashSet();

    public Class<?> specialize(String name, Class<?> c, HashMap<String, Object> variables) {
        ClassWriter cw;
        ClassWriter cv = cw = new ClassWriter(3);
        StringWriter debugOutput = null;
        if (log.isTraceEnabled()) {
            if (!tracedClasses.contains(c)) {
                StringWriter classTrace = new StringWriter();
                Object[] classTraceCv = new TraceClassVisitor(new PrintWriter(classTrace));
                try {
                    ClassReader cr = new ClassReader(c.getName().replace('.', '/'));
                    cr.accept((ClassVisitor)classTraceCv, 0);
                    log.trace((Object)String.format("Dump of class to be specialized: %s", c.getName()));
                    log.trace((Object)classTrace);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                tracedClasses.add(c);
            }
            log.trace((Object)String.format("Specializing class %s", name));
            Object[] variableNames = variables.keySet().toArray(new String[variables.size()]);
            Arrays.sort(variableNames);
            for (Object variableName : variableNames) {
                log.trace((Object)String.format("Variable %s=%s", variableName, variables.get(variableName)));
            }
            debugOutput = new StringWriter();
            PrintWriter debugPrintWriter = new PrintWriter(debugOutput);
            cv = new TraceClassVisitor((ClassVisitor)cv, debugPrintWriter);
        }
        try {
            ClassReader cr = new ClassReader(c.getName().replace('.', '/'));
            SpecializedClassVisitor cn = new SpecializedClassVisitor(name, variables);
            cr.accept((ClassVisitor)cn, 0);
            cn.accept((ClassVisitor)cv);
        }
        catch (IOException e) {
            log.error((Object)"Cannot read class", (Throwable)e);
        }
        if (debugOutput != null) {
            log.trace((Object)debugOutput.toString());
        }
        Class<?> specializedClass = null;
        try {
            specializedClass = classLoader.defineClass(name, cw.toByteArray());
        }
        catch (ClassFormatError e) {
            log.error((Object)"Error while defining specialized class", (Throwable)e);
        }
        return specializedClass;
    }

    private static class SpecializedClassLoader
    extends ClassLoader {
        private SpecializedClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }

    private static class SpecializedClassVisitor
    extends ClassNode {
        private final String specializedClassName;
        private final HashMap<String, Object> variables;
        private Object value;
        private AbstractInsnNode deleteUpToInsn;
        private String className;
        private String superClassName;

        public SpecializedClassVisitor(String specializedClassName, HashMap<String, Object> variables) {
            super(589824);
            this.specializedClassName = specializedClassName;
            this.variables = variables;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.superClassName = superName;
            super.visit(version, access, this.specializedClassName, signature, name, interfaces);
        }

        public void visitEnd() {
            for (MethodNode method : this.methods) {
                this.visitMethod(method);
            }
            ListIterator lit = this.fields.listIterator();
            while (lit.hasNext()) {
                FieldNode field = (FieldNode)lit.next();
                if ((field.access & 8) == 0 || !this.variables.containsKey(field.name)) continue;
                lit.remove();
            }
            super.visitEnd();
        }

        private void visitMethod(MethodNode method) {
            boolean isConstructor = "<init>".equals(method.name);
            this.deleteUpToInsn = null;
            ListIterator lit = method.instructions.iterator();
            while (lit.hasNext()) {
                FieldInsnNode fieldInsn;
                AbstractInsnNode insn = (AbstractInsnNode)lit.next();
                if (this.deleteUpToInsn != null) {
                    if (insn == this.deleteUpToInsn) {
                        this.deleteUpToInsn = null;
                    } else {
                        if (insn.getType() == 8 || insn.getType() == 15) continue;
                        lit.remove();
                        continue;
                    }
                }
                if (insn.getType() == 14) {
                    lit.remove();
                    continue;
                }
                if (insn.getOpcode() == 178) {
                    fieldInsn = (FieldInsnNode)insn;
                    if (this.variables.containsKey(fieldInsn.name)) {
                        AbstractInsnNode constantInsn;
                        int i;
                        boolean processed = false;
                        this.value = this.variables.get(fieldInsn.name);
                        AbstractInsnNode nextInsn = insn.getNext();
                        if (this.analyseIfTestInt(method, insn)) {
                            processed = true;
                        } else if (nextInsn != null && nextInsn.getType() == 11) {
                            int n;
                            TableSwitchInsnNode switchInsn = (TableSwitchInsnNode)nextInsn;
                            LabelNode label = null;
                            if (this.isIntValue(this.value) && (n = this.getIntValue(this.value)) >= switchInsn.min && n <= switchInsn.max && (i = n - switchInsn.min) < switchInsn.labels.size()) {
                                label = (LabelNode)switchInsn.labels.get(i);
                            }
                            if (label == null) {
                                label = switchInsn.dflt;
                            }
                            if (label != null) {
                                method.instructions.set(insn, (AbstractInsnNode)new JumpInsnNode(167, label));
                                processed = true;
                            }
                        } else if (nextInsn != null && nextInsn.getType() == 12) {
                            LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)nextInsn;
                            LabelNode label = null;
                            if (this.isIntValue(this.value)) {
                                int n = this.getIntValue(this.value);
                                i = 0;
                                for (Object value : switchInsn.keys) {
                                    if (value instanceof Integer && (Integer)value == n) {
                                        label = (LabelNode)switchInsn.labels.get(i);
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (label == null) {
                                label = switchInsn.dflt;
                            }
                            if (label != null) {
                                method.instructions.set(insn, (AbstractInsnNode)new JumpInsnNode(167, label));
                                processed = true;
                            }
                        } else if (nextInsn != null && nextInsn.getType() == 0) {
                            int opcode = nextInsn.getOpcode();
                            int n = 0;
                            float f = 0.0f;
                            boolean isIntConstant = false;
                            boolean isFloatConstant = false;
                            switch (opcode) {
                                case 2: {
                                    n = -1;
                                    isIntConstant = true;
                                    break;
                                }
                                case 3: {
                                    n = 0;
                                    isIntConstant = true;
                                    break;
                                }
                                case 4: {
                                    n = 1;
                                    isIntConstant = true;
                                    break;
                                }
                                case 5: {
                                    n = 2;
                                    isIntConstant = true;
                                    break;
                                }
                                case 6: {
                                    n = 3;
                                    isIntConstant = true;
                                    break;
                                }
                                case 7: {
                                    n = 4;
                                    isIntConstant = true;
                                    break;
                                }
                                case 8: {
                                    n = 5;
                                    isIntConstant = true;
                                    break;
                                }
                                case 11: {
                                    f = 0.0f;
                                    isFloatConstant = true;
                                    break;
                                }
                                case 12: {
                                    f = 1.0f;
                                    isFloatConstant = true;
                                    break;
                                }
                                case 13: {
                                    f = 2.0f;
                                    isFloatConstant = true;
                                }
                            }
                            if (isIntConstant) {
                                if (this.analyseIfTestInt(method, insn, nextInsn, n)) {
                                    processed = true;
                                }
                            } else if (isFloatConstant && this.analyseIfTestFloat(method, insn, nextInsn, f)) {
                                processed = true;
                            }
                        } else if (nextInsn != null && nextInsn.getType() == 1) {
                            IntInsnNode intInsn = (IntInsnNode)nextInsn;
                            if (this.analyseIfTestInt(method, insn, nextInsn, intInsn.operand)) {
                                processed = true;
                            }
                        } else if (nextInsn != null && nextInsn.getType() == 9) {
                            LdcInsnNode ldcInsn = (LdcInsnNode)nextInsn;
                            if (this.isIntValue(ldcInsn.cst)) {
                                if (this.analyseIfTestInt(method, insn, nextInsn, this.getIntValue(ldcInsn.cst))) {
                                    processed = true;
                                }
                            } else if (this.isFloatValue(ldcInsn.cst) && this.analyseIfTestFloat(method, insn, nextInsn, this.getFloatValue(ldcInsn.cst))) {
                                processed = true;
                            }
                        }
                        if (processed || (constantInsn = this.getConstantInsn(this.value)) == null) continue;
                        method.instructions.set(insn, constantInsn);
                        continue;
                    }
                    if (!fieldInsn.owner.equals(this.className)) continue;
                    fieldInsn.owner = this.specializedClassName;
                    continue;
                }
                if (insn.getOpcode() == 179) {
                    fieldInsn = (FieldInsnNode)insn;
                    if (this.variables.containsKey(fieldInsn.name) || !fieldInsn.owner.equals(this.className)) continue;
                    fieldInsn.owner = this.specializedClassName;
                    continue;
                }
                if (insn.getType() != 5) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (methodInsn.owner.equals(this.className)) {
                    methodInsn.owner = this.specializedClassName;
                    continue;
                }
                if (!isConstructor || !methodInsn.owner.equals(this.superClassName)) continue;
                methodInsn.owner = this.className;
            }
            method.localVariables.clear();
            this.optimizeJumps(method);
            this.removeDeadCode(method);
            this.optimizeJumps(method);
            this.removeUnusedLabels(method);
            this.removeUselessLineNumbers(method);
        }

        private void optimizeJumps(MethodNode method) {
            ListIterator lit = method.instructions.iterator();
            while (lit.hasNext()) {
                LabelNode target;
                AbstractInsnNode insn = (AbstractInsnNode)lit.next();
                if (insn.getType() != 7) continue;
                JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                LabelNode label = jumpInsn.label;
                while (true) {
                    for (target = label; target != null && target.getOpcode() < 0; target = target.getNext()) {
                    }
                    if (target == null || target.getOpcode() != 167) break;
                    label = ((JumpInsnNode)target).label;
                }
                jumpInsn.label = label;
                boolean removeJump = false;
                if (jumpInsn.getOpcode() == 167) {
                    for (AbstractInsnNode next = jumpInsn.getNext(); next != null; next = next.getNext()) {
                        if (next == label) {
                            removeJump = true;
                            break;
                        }
                        if (next.getOpcode() >= 0) break;
                    }
                }
                if (removeJump) {
                    lit.remove();
                    continue;
                }
                if (jumpInsn.getOpcode() != 167 || target == null) continue;
                switch (target.getOpcode()) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 191: {
                        method.instructions.set(insn, target.clone(null));
                    }
                }
            }
        }

        private void removeDeadCode(MethodNode method) {
            try {
                Analyzer analyzer = new Analyzer((Interpreter)new BasicInterpreter());
                analyzer.analyze(this.specializedClassName, method);
                Frame[] frames = analyzer.getFrames();
                AbstractInsnNode[] insns = method.instructions.toArray();
                for (int i = 0; i < frames.length; ++i) {
                    AbstractInsnNode insn = insns[i];
                    if (frames[i] != null || insn.getType() == 8) continue;
                    method.instructions.remove(insn);
                    insns[i] = null;
                }
            }
            catch (AnalyzerException analyzerException) {
                // empty catch block
            }
        }

        private void removeUnusedLabels(MethodNode method) {
            HashSet<LabelNode> usedLabels = new HashSet<LabelNode>();
            for (AbstractInsnNode insn : method.instructions) {
                if (insn.getType() == 7) {
                    JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                    usedLabels.add(jumpInsn.label);
                    continue;
                }
                if (insn.getType() == 11) {
                    TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insn;
                    for (LabelNode labelNode : tableSwitchInsn.labels) {
                        if (labelNode == null) continue;
                        usedLabels.add(labelNode);
                    }
                    continue;
                }
                if (insn.getType() != 12) continue;
                LookupSwitchInsnNode loopupSwitchInsn = (LookupSwitchInsnNode)insn;
                for (LabelNode labelNode : loopupSwitchInsn.labels) {
                    if (labelNode == null) continue;
                    usedLabels.add(labelNode);
                }
            }
            ListIterator lit = method.instructions.iterator();
            while (lit.hasNext()) {
                AbstractInsnNode insn;
                insn = (AbstractInsnNode)lit.next();
                if (insn.getType() != 8 || usedLabels.contains(insn)) continue;
                lit.remove();
            }
        }

        private void removeUselessLineNumbers(MethodNode method) {
            ListIterator lit = method.instructions.iterator();
            while (lit.hasNext()) {
                AbstractInsnNode nextInsn;
                AbstractInsnNode insn = (AbstractInsnNode)lit.next();
                if (insn.getType() != 15 || (nextInsn = insn.getNext()) == null || nextInsn.getType() != 15) continue;
                lit.remove();
            }
        }

        private boolean analyseIfTestInt(MethodNode method, AbstractInsnNode insn) {
            return this.analyseIfTestInt(method, insn, insn, null);
        }

        private boolean analyseIfTestInt(MethodNode method, AbstractInsnNode insn, AbstractInsnNode valueInsn, Integer testValue) {
            boolean eliminateJump = false;
            AbstractInsnNode nextInsn = valueInsn.getNext();
            if (nextInsn != null && nextInsn.getType() == 7) {
                JumpInsnNode jumpInsn = (JumpInsnNode)nextInsn;
                boolean doJump = false;
                switch (jumpInsn.getOpcode()) {
                    case 153: {
                        if (testValue != null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) == 0;
                        eliminateJump = true;
                        break;
                    }
                    case 154: {
                        if (testValue != null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) != 0;
                        eliminateJump = true;
                        break;
                    }
                    case 155: {
                        if (testValue != null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) < 0;
                        eliminateJump = true;
                        break;
                    }
                    case 156: {
                        if (testValue != null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) >= 0;
                        eliminateJump = true;
                        break;
                    }
                    case 157: {
                        if (testValue != null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) > 0;
                        eliminateJump = true;
                        break;
                    }
                    case 158: {
                        if (testValue != null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) <= 0;
                        eliminateJump = true;
                        break;
                    }
                    case 159: {
                        if (testValue == null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) == testValue.intValue();
                        eliminateJump = true;
                        break;
                    }
                    case 160: {
                        if (testValue == null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) != testValue.intValue();
                        eliminateJump = true;
                        break;
                    }
                    case 161: {
                        if (testValue == null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) < testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 162: {
                        if (testValue == null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) >= testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 163: {
                        if (testValue == null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) > testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 164: {
                        if (testValue == null || !this.isIntValue(this.value)) break;
                        doJump = this.getIntValue(this.value) <= testValue;
                        eliminateJump = true;
                    }
                }
                if (eliminateJump) {
                    if (doJump) {
                        method.instructions.set(insn, (AbstractInsnNode)new JumpInsnNode(167, jumpInsn.label));
                    } else {
                        method.instructions.remove(insn);
                    }
                    this.deleteUpToInsn = jumpInsn.getNext();
                }
            }
            return eliminateJump;
        }

        private boolean analyseIfTestFloat(MethodNode method, AbstractInsnNode insn, AbstractInsnNode valueInsn, float testValue) {
            AbstractInsnNode nextNextInsn;
            boolean eliminateJump = false;
            AbstractInsnNode nextInsn = valueInsn.getNext();
            if (nextInsn != null && (nextInsn.getOpcode() == 149 || nextInsn.getOpcode() == 150) && (nextNextInsn = nextInsn.getNext()) != null && nextNextInsn.getType() == 7) {
                JumpInsnNode jumpInsn = (JumpInsnNode)nextNextInsn;
                boolean doJump = false;
                switch (jumpInsn.getOpcode()) {
                    case 153: {
                        if (!this.isFloatValue(this.value)) break;
                        doJump = this.getFloatValue(this.value) == testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 154: {
                        if (!this.isFloatValue(this.value)) break;
                        doJump = this.getFloatValue(this.value) != testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 155: {
                        if (!this.isFloatValue(this.value)) break;
                        doJump = this.getFloatValue(this.value) < testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 156: {
                        if (!this.isFloatValue(this.value)) break;
                        doJump = this.getFloatValue(this.value) >= testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 157: {
                        if (!this.isFloatValue(this.value)) break;
                        doJump = this.getFloatValue(this.value) > testValue;
                        eliminateJump = true;
                        break;
                    }
                    case 158: {
                        if (!this.isFloatValue(this.value)) break;
                        doJump = this.getFloatValue(this.value) <= testValue;
                        eliminateJump = true;
                    }
                }
                if (eliminateJump) {
                    if (doJump) {
                        method.instructions.set(insn, (AbstractInsnNode)new JumpInsnNode(167, jumpInsn.label));
                    } else {
                        method.instructions.remove(insn);
                    }
                    this.deleteUpToInsn = jumpInsn.getNext();
                }
            }
            return eliminateJump;
        }

        private boolean isIntValue(Object value) {
            return value instanceof Integer || value instanceof Boolean;
        }

        private int getIntValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Boolean) {
                return value == Boolean.FALSE ? 0 : 1;
            }
            return 0;
        }

        private boolean isFloatValue(Object value) {
            return value instanceof Float;
        }

        private float getFloatValue(Object value) {
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            return 0.0f;
        }

        private AbstractInsnNode getConstantInsn(Object value) {
            Object constantInsn = null;
            if (this.isIntValue(value)) {
                int n = this.getIntValue(value);
                switch (n) {
                    case -1: {
                        constantInsn = new InsnNode(2);
                        break;
                    }
                    case 0: {
                        constantInsn = new InsnNode(3);
                        break;
                    }
                    case 1: {
                        constantInsn = new InsnNode(4);
                        break;
                    }
                    case 2: {
                        constantInsn = new InsnNode(5);
                        break;
                    }
                    case 3: {
                        constantInsn = new InsnNode(6);
                        break;
                    }
                    case 4: {
                        constantInsn = new InsnNode(7);
                        break;
                    }
                    case 5: {
                        constantInsn = new InsnNode(8);
                        break;
                    }
                    default: {
                        constantInsn = -128 <= n && n < 127 ? new IntInsnNode(16, n) : (Short.MIN_VALUE <= n && n < Short.MAX_VALUE ? new IntInsnNode(17, n) : new LdcInsnNode((Object)n));
                    }
                }
            }
            return constantInsn;
        }
    }
}

