/*
 * Decompiled with CFR 0.152.
 */
package libchdr.codec;

import jpcsp.util.Utilities;
import libchdr.Chd;
import libchdr.ChdHeader;
import libchdr.codec.BaseCodec;
import libchdr.codec.Zlib;

public abstract class BaseCdCodec
extends BaseCodec {
    @Override
    public ChdHeader.ChdError init(Chd.CodecData codec, int hunkbytes) {
        codec.buffer = new byte[hunkbytes];
        return super.init(codec, hunkbytes);
    }

    @Override
    public ChdHeader.ChdError decompress(Chd.CodecData codec, byte[] src, int srcOffset, int complen, byte[] dest, int destOffset, int destlen) {
        byte[] buffer;
        ChdHeader.ChdError err;
        int frames = destlen / 2448;
        int complenBytes = destlen < 65536 ? 2 : 3;
        int eccBytes = (frames + 7) / 8;
        int headerBytes = eccBytes + complenBytes;
        int complenBase = Utilities.read8(src, srcOffset + eccBytes) << 8;
        complenBase |= Utilities.read8(src, srcOffset + eccBytes + 1);
        if (complenBytes > 2) {
            complenBase = complenBase << 8 | Utilities.read8(src, srcOffset + eccBytes + 2);
        }
        if ((err = this.decompress(src, srcOffset + headerBytes, complenBase, buffer = codec.buffer, 0, frames * 2352)) != ChdHeader.ChdError.CHDERR_NONE) {
            return err;
        }
        err = Zlib.zlibDecompress(src, srcOffset + headerBytes + complenBase, complen - complenBase - headerBytes, buffer, frames * 2352, frames * 96);
        if (err != ChdHeader.ChdError.CHDERR_NONE) {
            return err;
        }
        BaseCdCodec.cdCopyFramesToDest(buffer, frames, dest, destOffset);
        return ChdHeader.ChdError.CHDERR_NONE;
    }

    public static void cdCopyFramesToDest(byte[] buffer, int frames, byte[] dest, int destOffset) {
        for (int frame = 0; frame < frames; ++frame) {
            System.arraycopy(buffer, frame * 2352, dest, destOffset + frame * 2448, 2352);
            System.arraycopy(buffer, frame * 96 + frames * 2352, dest, destOffset + frame * 2448 + 2352, 96);
        }
    }
}

