/*
 * Decompiled with CFR 0.152.
 */
package libchdr.codec;

import java.io.IOException;
import libchdr.Chd;
import libchdr.ChdHeader;
import libchdr.codec.BaseCdCodec;
import libchdr.codec.Flac;
import libchdr.codec.Zlib;

public class CdFlac
extends Flac {
    @Override
    public ChdHeader.ChdError init(Chd.CodecData codec, int hunkbytes) {
        Chd.CdflCodecData cdfl = (Chd.CdflCodecData)codec;
        cdfl.buffer = new byte[hunkbytes];
        return super.init(codec, hunkbytes);
    }

    @Override
    public ChdHeader.ChdError decompress(Chd.CodecData codec, byte[] src, int srcOffset, int complen, byte[] dest, int destOffset, int destlen) {
        Chd.CdflCodecData cdfl = (Chd.CdflCodecData)codec;
        int frames = destlen / 2448;
        try {
            this.decompressDummyMetadata(this.getBlocksize(frames * 2352));
            this.flacInput.setData(src, srcOffset, complen);
            int sampleOffset = 0;
            for (int i = 0; i < frames; i += 4) {
                int sampleCount = this.flacDecoder.readAudioBlock(this.samples, sampleOffset);
                sampleOffset += sampleCount;
            }
            byte[] buffer = cdfl.buffer;
            this.storeSamples(this.samples, sampleOffset, buffer, 0, destlen, cdfl.swapEndian);
            int subcodeOffset = (int)this.flacInput.getPosition();
            int subcodeLength = complen - subcodeOffset;
            ChdHeader.ChdError err = Zlib.zlibDecompress(src, srcOffset + subcodeOffset, subcodeLength, buffer, frames * 2352, frames * 96);
            if (err != ChdHeader.ChdError.CHDERR_NONE) {
                return err;
            }
            BaseCdCodec.cdCopyFramesToDest(buffer, frames, dest, destOffset);
        }
        catch (IOException e) {
            return ChdHeader.ChdError.CHDERR_DECOMPRESSION_ERROR;
        }
        return ChdHeader.ChdError.CHDERR_NONE;
    }

    private int getBlocksize(int bytes) {
        return this.getBlockSize(bytes, 2352);
    }
}

