/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.Processor;
import jpcsp.util.Utilities;

public class CachedInterpreter
extends AbstractNativeCodeSequence {
    private static Common.Instruction[] instructions;
    private static int[] opcodes;

    public static void call(int numberInstructions, int codeBlockContextSize) {
        if (instructions == null) {
            int startAddress = CachedInterpreter.getPc();
            opcodes = Utilities.readInt32(startAddress, numberInstructions << 2);
            instructions = new Common.Instruction[numberInstructions];
            for (int i = 0; i < numberInstructions; ++i) {
                CachedInterpreter.instructions[i] = Decoder.instruction(opcodes[i]);
            }
            CodeBlock codeBlock = null;
            for (int i = 0; i < codeBlockContextSize && codeBlock == null; ++i) {
                codeBlock = RuntimeContext.getCodeBlock(startAddress - (i << 2));
            }
            if (codeBlock != null) {
                codeBlock.setUpdateOpcodesAction(new UpdateOpcodesAction(startAddress, numberInstructions << 2, opcodes, 0));
            } else {
                log.error((Object)String.format("CachedInterpreter: could not find the CodeBlock 0x%08X", startAddress));
            }
        }
        Processor processor = CachedInterpreter.getProcessor();
        for (int i = 0; i < numberInstructions; ++i) {
            instructions[i].interpret(processor, opcodes[i]);
        }
    }

    private static class UpdateOpcodesAction
    implements IAction {
        private int address;
        private int length;
        private int[] opcodes;
        private int offset;

        public UpdateOpcodesAction(int address, int length, int[] opcodes, int offset) {
            this.address = address;
            this.length = length;
            this.opcodes = opcodes;
            this.offset = offset;
        }

        @Override
        public void execute() {
            Utilities.readInt32(this.address, this.length, this.opcodes, this.offset);
        }
    }
}

