/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jpcsp.util.Utilities;

public class ConsoleWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private transient PrintStream m_stdoutPS = new PrintStream(new JTextAreaOutStream(new ByteArrayOutputStream()));
    private int m_maxChars = -1;
    private JButton ClearMessageButton;
    private JButton SaveMessageToFileButton;
    private JScrollPane jScrollPane1;
    private JTextArea talogging;

    public ConsoleWindow() {
        this.initComponents();
        System.setOut(this.m_stdoutPS);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.talogging = new JTextArea();
        this.ClearMessageButton = new JButton();
        this.SaveMessageToFileButton = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("ConsoleWindow.title"));
        this.setResizable(false);
        this.talogging.setColumns(20);
        this.talogging.setFont(new Font("Courier New", 0, 12));
        this.talogging.setRows(5);
        this.jScrollPane1.setViewportView(this.talogging);
        this.ClearMessageButton.setText(bundle.getString("ConsoleWindow.ClearMessageButton.text"));
        this.ClearMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConsoleWindow.this.ClearMessageButtonActionPerformed(evt);
            }
        });
        this.SaveMessageToFileButton.setText(bundle.getString("ConsoleWindow.SaveMessageToFileButton.text"));
        this.SaveMessageToFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConsoleWindow.this.SaveMessageToFileButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(334, Short.MAX_VALUE).addComponent(this.SaveMessageToFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ClearMessageButton)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 583, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ClearMessageButton).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.SaveMessageToFileButton).addContainerGap()))));
        this.pack();
    }

    private void ClearMessageButtonActionPerformed(ActionEvent evt) {
        this.clearScreenMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveMessageToFileButtonActionPerformed(ActionEvent evt) {
        BufferedWriter out;
        File f;
        block6: {
            int res;
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            JFileChooser m_fileChooser = new JFileChooser();
            m_fileChooser.setSelectedFile(new File("logoutput.txt"));
            m_fileChooser.setDialogTitle(bundle.getString("ConsoleWindow.strSaveLogging.text"));
            m_fileChooser.setCurrentDirectory(new File("."));
            int returnVal = m_fileChooser.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            f = m_fileChooser.getSelectedFile();
            out = null;
            if (!f.exists() || (res = JOptionPane.showConfirmDialog(this, bundle.getString("ConsoleWindow.strFileExists.text"), bundle.getString("ConsoleWindow.strFileExistsTitle.text"), 0, 3)) == 0) break block6;
            Utilities.close(out);
            return;
        }
        try {
            out = new BufferedWriter(new FileWriter(f));
            out.write(this.talogging.getText());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Utilities.close(out);
                throw throwable;
            }
            Utilities.close(out);
        }
        Utilities.close(out);
    }

    public synchronized void clearScreenMessages() {
        this.talogging.setText("");
    }

    private final class JTextAreaOutStream
    extends FilterOutputStream {
        public JTextAreaOutStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            String s = new String(b);
            this.appendMessage(s);
            this.flushTextArea();
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            String s = new String(b, off, len);
            this.appendMessage(s);
            this.flushTextArea();
        }

        private synchronized void appendMessage(String s) {
            ConsoleWindow.this.talogging.append(s);
        }

        private synchronized void flushTextArea() {
            int len = ConsoleWindow.this.talogging.getText().length();
            ConsoleWindow.this.talogging.setCaretPosition(len);
            if (ConsoleWindow.this.m_maxChars > 0 && len > ConsoleWindow.this.m_maxChars) {
                ConsoleWindow.this.clearScreenMessages();
            }
        }
    }
}

