/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.Emulator;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.kernel.types.IAction;

public class AfterCallbackAction
implements IAction {
    private final TPointerFunction callback;
    private boolean called;
    private int returnValue;

    public AfterCallbackAction() {
        this.callback = null;
    }

    public AfterCallbackAction(TPointerFunction callback) {
        this.callback = callback;
    }

    @Override
    public void execute() {
        this.called = true;
        this.returnValue = Emulator.getProcessor().cpu._v0;
    }

    public boolean isCalled() {
        return this.called;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Callback");
        if (this.callback != null && this.callback.isNotNull()) {
            s.append(String.format(" %s", this.callback));
        }
        if (this.isCalled()) {
            s.append(String.format(" returned 0x%08X", this.getReturnValue()));
        } else {
            s.append(" not called");
        }
        return s.toString();
    }
}

