/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import java.io.IOException;
import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.HLE.HLEModuleFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.mediaengine.MEEmulator;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.Settings;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public abstract class HLEModule {
    private static final int STATE_VERSION = 0;
    private SysMemUserForUser.SysMemInfo memory;
    private String name;
    private boolean started = false;
    private int moduleVersion;
    private int moduleElfVersion;
    private int moduleMemoryPartition = 2;
    private int moduleMemoryType = 0;
    public HashMap<String, HLEModuleFunction> installedHLEModuleFunctions = new HashMap();

    public final String getName() {
        if (this.name == null) {
            this.name = this.getClass().getSimpleName();
        }
        return this.name;
    }

    public HLEModuleFunction getHleFunctionByName(String functionName) throws RuntimeException {
        if (!this.installedHLEModuleFunctions.containsKey(functionName)) {
            Modules.log.error((Object)String.format("Can't find HLE function '%s' in module '%s'", functionName, this));
            return null;
        }
        return this.installedHLEModuleFunctions.get(functionName);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        Settings.getInstance().removeSettingsListener(this.getName());
        this.started = false;
    }

    protected void setSettingsListener(String option, ISettingsListener settingsListener) {
        Settings.getInstance().registerSettingsListener(this.getName(), option, settingsListener);
    }

    protected static String getCallingFunctionName(int index) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[index + 1].getMethodName();
    }

    public int getMemoryUsage() {
        return 0;
    }

    public void load() {
        int memoryUsage = this.getMemoryUsage();
        if (memoryUsage > 0) {
            if (Modules.log.isDebugEnabled()) {
                Modules.log.debug((Object)String.format("Allocating 0x%X bytes for HLE module %s", memoryUsage, this.getName()));
            }
            this.memory = Modules.SysMemUserForUserModule.malloc(this.moduleMemoryPartition, String.format("Module-%s", this.getName()), this.moduleMemoryType, memoryUsage, 0);
        } else {
            this.memory = null;
        }
    }

    public void unload() {
        if (this.memory != null) {
            if (Modules.log.isDebugEnabled()) {
                Modules.log.debug((Object)String.format("Freeing 0x%X bytes for HLE module %s", this.memory.size, this.getName()));
            }
            Modules.SysMemUserForUserModule.free(this.memory);
            this.memory = null;
        }
    }

    protected int getModuleMemory() {
        if (this.memory == null) {
            return 0;
        }
        return this.memory.addr;
    }

    protected int getModuleMemory(String moduleName) {
        if (this.memory != null) {
            return this.getModuleMemory();
        }
        SysMemUserForUser.SysMemInfo allocatedModuleMemory = Modules.ModuleMgrForKernelModule.getMemoryAllocatedForModule(moduleName);
        if (allocatedModuleMemory == null) {
            return 0;
        }
        return allocatedModuleMemory.addr;
    }

    protected Memory getMemory() {
        return Memory.getInstance();
    }

    protected Processor getProcessor() {
        return Emulator.getProcessor();
    }

    protected Memory getMEMemory() {
        return MEEmulator.getInstance().getMEMemory();
    }

    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.name = stream.readString();
        this.started = stream.readBoolean();
        this.moduleVersion = stream.readInt();
    }

    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeString(this.name);
        stream.writeBoolean(this.started);
        stream.writeInt(this.moduleVersion);
    }

    public int getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(int moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public int getModuleElfVersion() {
        return this.moduleElfVersion;
    }

    public void setModuleElfVersion(int moduleElfVersion) {
        this.moduleElfVersion = moduleElfVersion;
    }

    public int getModuleMemoryPartition() {
        return this.moduleMemoryPartition;
    }

    public void setModuleMemoryPartition(int moduleMemoryPartition) {
        this.moduleMemoryPartition = moduleMemoryPartition;
    }

    public int getModuleMemoryType() {
        return this.moduleMemoryType;
    }

    public void setModuleMemoryType(int moduleMemoryType) {
        this.moduleMemoryType = moduleMemoryType;
    }

    public String toString() {
        return this.getName();
    }
}

