/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class BaseCacheVirtualFile
extends AbstractProxyVirtualFile
implements IState {
    private static final int STATE_VERSION = 0;
    protected final Logger log;
    protected final SortedSet<Block> blocks = new TreeSet<Block>();

    public BaseCacheVirtualFile(Logger log, IVirtualFile vFile) {
        super(vFile);
        this.log = log;
    }

    @Override
    public void setProxyVirtualFile(IVirtualFile vFile) {
        super.setProxyVirtualFile(vFile);
    }

    protected Block mergeBlocks(Block block1, Block block2) {
        long mergedStart = Math.min(block1.start, block2.start);
        long mergedEnd = Math.max(block1.end, block2.end);
        byte[] mergedData = new byte[(int)(mergedEnd - mergedStart)];
        System.arraycopy(block1.data, 0, mergedData, (int)(block1.start - mergedStart), block1.getLength());
        System.arraycopy(block2.data, 0, mergedData, (int)(block2.start - mergedStart), block2.getLength());
        Block mergedBlock = new Block(mergedStart, mergedEnd, mergedData);
        this.blocks.remove(block1);
        this.blocks.remove(block2);
        this.blocks.add(mergedBlock);
        return mergedBlock;
    }

    protected void addBlock(Block blockToBeAdded) {
        if (blockToBeAdded.getLength() <= 0) {
            return;
        }
        Iterator it = this.blocks.iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (block.isFollowing(blockToBeAdded)) {
                this.mergeBlocks(block, blockToBeAdded);
                return;
            }
            if (blockToBeAdded.isFollowing(block)) {
                if (it.hasNext()) {
                    Block mergedBlock;
                    Block nextBlock = (Block)it.next();
                    if (nextBlock.isFollowing(mergedBlock = this.mergeBlocks(block, blockToBeAdded))) {
                        this.mergeBlocks(nextBlock, mergedBlock);
                    }
                } else {
                    this.mergeBlocks(block, blockToBeAdded);
                }
                return;
            }
            if (block.isAfter(blockToBeAdded)) break;
            if (!block.isOverlapping(blockToBeAdded)) continue;
            this.mergeBlocks(block, blockToBeAdded);
            return;
        }
        this.blocks.add(blockToBeAdded);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        int numberBlocks = stream.readInt();
        this.blocks.clear();
        for (int i = 0; i < numberBlocks; ++i) {
            Block block = new Block();
            block.read(stream);
            this.blocks.add(block);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        int numberBlocks = this.blocks.size();
        stream.writeInt(numberBlocks);
        for (Block block : this.blocks) {
            block.write(stream);
        }
        super.write(stream);
    }

    @Override
    public String toString() {
        return String.format("BaseCacheVirtualFile %s", this.vFile);
    }

    protected static class Block
    implements Comparable<Block>,
    IState {
        private static final int STATE_VERSION = 0;
        protected long start;
        protected long end;
        protected byte[] data;

        public Block() {
        }

        public Block(long start, long end, byte[] data) {
            this.start = start;
            this.end = end;
            this.data = data;
        }

        public boolean isContaining(long position) {
            return this.start <= position && position < this.end;
        }

        public boolean isBefore(long position) {
            return this.end <= position;
        }

        public boolean isAfter(long position) {
            return position < this.start;
        }

        public boolean isBefore(Block block) {
            return this.isBefore(block.start);
        }

        public boolean isAfter(Block block) {
            return this.isAfter(block.end);
        }

        public boolean isOverlapping(Block block) {
            return !this.isBefore(block) && !this.isAfter(block);
        }

        public boolean isFollowing(Block block) {
            return this.start == block.end;
        }

        public int getLength() {
            return (int)(this.end - this.start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int ioWrite(IVirtualFile vFile) {
            IVirtualFile iVirtualFile = vFile;
            synchronized (iVirtualFile) {
                vFile.ioLseek(this.start);
                return vFile.ioWrite(this.data, 0, this.getLength());
            }
        }

        @Override
        public int compareTo(Block block) {
            return Long.compare(this.start, block.start);
        }

        @Override
        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.start = stream.readLong();
            this.end = stream.readLong();
            this.data = stream.readBytesWithLength();
        }

        @Override
        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeLong(this.start);
            stream.writeLong(this.end);
            stream.writeBytesWithLength(this.data);
        }

        public String toString() {
            return String.format("Block 0x%X-0x%X(length=0x%X)", this.start, this.end, this.getLength());
        }
    }
}

