/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.BaseCacheVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class ReadCacheVirtualFile
extends BaseCacheVirtualFile
implements IState {
    private static final int STATE_VERSION = 0;

    public ReadCacheVirtualFile(Logger log, IVirtualFile vFile) {
        super(log, vFile);
    }

    private void addToCache(TPointer ptr, int offset, int length, long position) {
        BaseCacheVirtualFile.Block block = new BaseCacheVirtualFile.Block(position, position + (long)length, ptr.getArray8(offset, length));
        this.addBlock(block);
    }

    private void addToCache(byte[] buffer, int offset, int length, long position) {
        byte[] data = new byte[length];
        System.arraycopy(buffer, offset, data, 0, length);
        BaseCacheVirtualFile.Block block = new BaseCacheVirtualFile.Block(position, position + (long)length, data);
        this.addBlock(block);
    }

    @Override
    public synchronized int ioRead(TPointer outputPointer, int outputLength) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ioRead position=0x%X, length=0x%X", this.vFile.getPosition(), outputLength));
        }
        long position = this.vFile.getPosition();
        int outputOffset = 0;
        int totalReadLength = 0;
        for (BaseCacheVirtualFile.Block block : this.blocks) {
            if (block.isAfter(position)) {
                int length = Math.min(outputLength, (int)(block.start - position));
                int readLength = this.vFile.ioRead(new TPointer(outputPointer, outputOffset), length);
                if (readLength < 0) {
                    return readLength;
                }
                this.addToCache(outputPointer, outputOffset, readLength, position);
                outputOffset += readLength;
                outputLength -= readLength;
                totalReadLength += readLength;
                position = this.vFile.getPosition();
            }
            if (block.isContaining(position)) {
                int before = (int)(position - block.start);
                int length = Math.min(outputLength, block.getLength() - before);
                outputPointer.setArray(outputOffset, block.data, before, length);
                outputOffset += length;
                outputLength -= length;
                totalReadLength += length;
                position = this.vFile.ioLseek(position + (long)length);
            } else if (block.isAfter(position)) break;
            if (outputLength != 0) continue;
            break;
        }
        if (outputLength > 0) {
            int readLength = this.vFile.ioRead(new TPointer(outputPointer, outputOffset), outputLength);
            if (readLength < 0) {
                return readLength;
            }
            this.addToCache(outputPointer, outputOffset, readLength, position);
            totalReadLength += readLength;
        }
        return totalReadLength;
    }

    @Override
    public synchronized int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ioRead position=0x%X, length=0x%X", this.vFile.getPosition(), outputLength));
        }
        long position = this.vFile.getPosition();
        int totalReadLength = 0;
        for (BaseCacheVirtualFile.Block block : this.blocks) {
            if (block.isAfter(position)) {
                int length = Math.min(outputLength, (int)(block.start - position));
                int readLength = this.vFile.ioRead(outputBuffer, outputOffset, length);
                if (readLength < 0) {
                    return readLength;
                }
                this.addToCache(outputBuffer, outputOffset, readLength, position);
                outputOffset += readLength;
                outputLength -= readLength;
                totalReadLength += readLength;
                position = this.vFile.getPosition();
            }
            if (block.isContaining(position)) {
                int before = (int)(position - block.start);
                int length = Math.min(outputLength, block.getLength() - before);
                System.arraycopy(block.data, before, outputBuffer, outputOffset, length);
                outputOffset += length;
                outputLength -= length;
                totalReadLength += length;
                position = this.vFile.ioLseek(position + (long)length);
            } else if (block.isAfter(position)) break;
            if (outputLength != 0) continue;
            break;
        }
        if (outputLength > 0) {
            int readLength = this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
            if (readLength < 0) {
                return readLength;
            }
            this.addToCache(outputBuffer, outputOffset, readLength, position);
            totalReadLength += readLength;
        }
        return totalReadLength;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        super.write(stream);
    }

    @Override
    public String toString() {
        return String.format("ReadCacheVirtualFile %s", this.vFile);
    }
}

