/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.SeekableDataInputVirtualFile;
import jpcsp.HLE.VFS.crypto.PGDVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.util.Utilities;

public class LocalVirtualFile
extends AbstractVirtualFile {
    protected SeekableRandomFile file;
    protected boolean truncateAtNextWrite;
    protected IVirtualFile proxyFile;
    protected int proxyFileOffset;

    public LocalVirtualFile(SeekableRandomFile file) {
        super(file);
        this.file = file;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        try {
            Utilities.write(this.file, inputPointer, inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        try {
            if (this.isTruncateAtNextWrite()) {
                long position = this.getPosition();
                if (position < this.file.length()) {
                    this.file.setLength(this.getPosition());
                }
                this.setTruncateAtNextWrite(false);
            }
            this.file.write(inputBuffer, inputOffset, inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        switch (command) {
            case 20481: {
                if (inputLength != 0 || outputLength != 0) {
                    result = -1;
                    break;
                }
                result = 0;
                break;
            }
            case 2129939: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Checking if LoadExec is allowed on '%s'", this));
                }
                result = 0;
                break;
            }
            case 2129923: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Checking if LoadModule is allowed on '%s'", this));
                }
                result = 0;
                break;
            }
            case 2130049: 
            case 0x208082: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Checking if PRX type is allowed on '%s'", this));
                }
                result = 0;
                break;
            }
            case 0x4100001: {
                if (inputLength != 16 || outputLength != 0) {
                    result = -2142174719;
                    break;
                }
                byte[] key = inputPointer.getArray8(16);
                key = null;
                PGDVirtualFile pgdVirtualFile = new PGDVirtualFile(key, new SeekableDataInputVirtualFile(this.file), this.proxyFileOffset);
                if (pgdVirtualFile.isValid()) {
                    this.proxyFile = pgdVirtualFile;
                    result = 0;
                    break;
                }
                result = -2142174719;
                break;
            }
            case 68157442: {
                if (inputLength != 4 || outputLength != 0) {
                    result = -2142174719;
                    break;
                }
                this.proxyFileOffset = inputPointer.getValue32(0);
                result = 0;
                break;
            }
            case 68157445: {
                if (inputLength != 8) {
                    result = -2142174719;
                    break;
                }
                int seekPosition = inputPointer.getValue32(0);
                int readLength = inputPointer.getValue32(4);
                result = (int)this.ioLseek(seekPosition);
                result = this.ioRead(outputPointer, readLength);
                break;
            }
            case 68157446: {
                result = 1;
                break;
            }
            case 0x4100010: {
                result = (int)this.length();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("Returning the size of the DRM file '%s': 0x%X", this, result));
                break;
            }
            default: {
                result = super.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }

    public boolean isTruncateAtNextWrite() {
        return this.truncateAtNextWrite;
    }

    public void setTruncateAtNextWrite(boolean truncateAtNextWrite) {
        this.truncateAtNextWrite = truncateAtNextWrite;
    }

    @Override
    public IVirtualFile duplicate() {
        try {
            return new LocalVirtualFile(new SeekableRandomFile(this.file.getFileName(), this.file.getMode()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return super.duplicate();
        }
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.noDelayTimings;
    }

    @Override
    public String toString() {
        return String.format("LocalVirtualFile %s", this.file);
    }

    @Override
    public long getPosition() {
        if (this.proxyFile != null) {
            return this.proxyFile.getPosition();
        }
        return super.getPosition();
    }

    @Override
    public int ioClose() {
        if (this.proxyFile != null) {
            IVirtualFile vFile = this.proxyFile;
            this.proxyFile = null;
            this.proxyFileOffset = 0;
            return vFile.ioClose();
        }
        return super.ioClose();
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        if (this.proxyFile != null) {
            return this.proxyFile.ioRead(outputPointer, outputLength);
        }
        return super.ioRead(outputPointer, outputLength);
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        if (this.proxyFile != null) {
            return this.proxyFile.ioRead(outputBuffer, outputOffset, outputLength);
        }
        return super.ioRead(outputBuffer, outputOffset, outputLength);
    }

    @Override
    public long ioLseek(long offset) {
        if (this.proxyFile != null) {
            return this.proxyFile.ioLseek(offset);
        }
        return super.ioLseek(offset);
    }

    @Override
    public long length() {
        if (this.proxyFile != null) {
            return this.proxyFile.length();
        }
        return super.length();
    }

    @Override
    public boolean isSectorBlockMode() {
        if (this.proxyFile != null) {
            return this.proxyFile.isSectorBlockMode();
        }
        return super.isSectorBlockMode();
    }
}

