/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelMbxInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import org.apache.log4j.Logger;

public class MbxManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelMbxInfo> mbxMap;
    private MbxWaitStateChecker mbxWaitStateChecker;
    public static final int PSP_MBX_ATTR_FIFO = 0;
    public static final int PSP_MBX_ATTR_PRIORITY = 256;
    private static final int PSP_MBX_ATTR_MSG_FIFO = 0;
    private static final int PSP_MBX_ATTR_MSG_PRIORITY = 1024;
    public static final MbxManager singleton = new MbxManager();

    public void reset() {
        this.mbxMap = new HashMap();
        this.mbxWaitStateChecker = new MbxWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelMbxInfo info = this.mbxMap.get(thread.wait.Mbx_id);
        if (info == null) {
            return false;
        }
        info.threadWaitingList.removeWaitingThread(thread);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"Mbx deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(5)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onMbxDeletedCancelled(int mbxid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(5, mbxid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMbxDeleted(int mbxid) {
        this.onMbxDeletedCancelled(mbxid, -2147352139);
    }

    private void onMbxCancelled(int mbxid) {
        this.onMbxDeletedCancelled(mbxid, -2147352151);
    }

    public int checkMbxID(int uid) {
        if (!this.mbxMap.containsKey(uid)) {
            log.warn((Object)String.format("checkMbxID unknown uid=0x%X", uid));
            throw new SceKernelErrorException(-2147352165);
        }
        return uid;
    }

    public int sceKernelCreateMbx(String name, int attr, TPointer option) {
        if (option.isNotNull()) {
            int optionSize = option.getValue32();
            log.warn((Object)String.format("sceKernelCreateMbx option at %s: size=%d", option, optionSize));
        }
        SceKernelMbxInfo info = new SceKernelMbxInfo(name, attr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateMbx returning %s", info));
        }
        this.mbxMap.put(info.uid, info);
        return info.uid;
    }

    public int sceKernelDeleteMbx(int uid) {
        this.mbxMap.remove(uid);
        this.onMbxDeleted(uid);
        return 0;
    }

    public int sceKernelSendMbx(int uid, TPointer msgAddr) {
        SceKernelThreadInfo thread;
        SceKernelMbxInfo info = this.mbxMap.get(uid);
        boolean msgConsumed = false;
        if (!info.hasMessage() && (thread = info.threadWaitingList.getFirstWaitingThread()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelSendMbx waking thread %s", thread));
            }
            thread.wait.Mbx_resultAddr.setValue(msgAddr.getAddress());
            info.threadWaitingList.removeWaitingThread(thread);
            thread.cpuContext._v0 = 0;
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            threadMan.hleChangeThreadState(thread, 2);
            threadMan.hleRescheduleCurrentThread();
            msgConsumed = true;
        }
        if (!msgConsumed) {
            if ((info.attr & 0x400) == 0) {
                info.addMsg(msgAddr.getMemory(), msgAddr.getAddress());
            } else if ((info.attr & 0x400) == 1024) {
                info.addMsgByPriority(msgAddr.getMemory(), msgAddr.getAddress());
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelReceiveMbx(int uid, TPointer32 addrMsgAddr, TPointer32 timeoutAddr, boolean doCallbacks, boolean poll) {
        SceKernelMbxInfo info = this.mbxMap.get(uid);
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!info.hasMessage()) {
            if (poll) {
                if (!log.isDebugEnabled()) return -2147352142;
                log.debug((Object)"hleKernelReceiveMbx has no messages.");
                return -2147352142;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelReceiveMbx - %s (waiting)", info));
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            info.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.Mbx_id = uid;
            currentThread.wait.Mbx_resultAddr = addrMsgAddr;
            threadMan.hleKernelThreadEnterWaitState(5, uid, this.mbxWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelReceiveMbx - %s fast check succeeded", info));
        }
        int msgAddr = info.removeMsg(Memory.getInstance());
        addrMsgAddr.setValue(msgAddr);
        return 0;
    }

    public int sceKernelReceiveMbx(int uid, TPointer32 addrMsgAddr, TPointer32 timeoutAddr) {
        return this.hleKernelReceiveMbx(uid, addrMsgAddr, timeoutAddr, false, false);
    }

    public int sceKernelReceiveMbxCB(int uid, TPointer32 addrMsgAddr, TPointer32 timeoutAddr) {
        return this.hleKernelReceiveMbx(uid, addrMsgAddr, timeoutAddr, true, false);
    }

    public int sceKernelPollMbx(int uid, TPointer32 addrMsgAddr) {
        return this.hleKernelReceiveMbx(uid, addrMsgAddr, TPointer32.NULL, false, true);
    }

    public int sceKernelCancelReceiveMbx(int uid, TPointer32 pnumAddr) {
        SceKernelMbxInfo info = this.mbxMap.get(uid);
        pnumAddr.setValue(info.getNumWaitThreads());
        info.threadWaitingList.removeAllWaitingThreads();
        this.onMbxCancelled(uid);
        return 0;
    }

    public int sceKernelReferMbxStatus(int uid, TPointer infoAddr) {
        SceKernelMbxInfo info = this.mbxMap.get(uid);
        info.write(infoAddr);
        return 0;
    }

    private MbxManager() {
    }

    private class MbxWaitStateChecker
    implements IWaitStateChecker {
        private MbxWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMbxInfo info = (SceKernelMbxInfo)MbxManager.this.mbxMap.get(wait.Mbx_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352165;
                return false;
            }
            if (info.hasMessage()) {
                Memory mem = Memory.getInstance();
                int msgAddr = info.removeMsg(mem);
                wait.Mbx_resultAddr.setValue(msgAddr);
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

