/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MemoryChunkList {
    protected static Logger log = SysMemUserForUser.log;
    private MemoryChunk low;
    private MemoryChunk high;
    private final int addr;
    private final int size;

    public MemoryChunkList(MemoryChunk initialMemoryChunk) {
        this.addr = initialMemoryChunk.addr;
        this.size = initialMemoryChunk.size;
        this.low = initialMemoryChunk;
        this.high = initialMemoryChunk;
    }

    public void remove(MemoryChunk memoryChunk) {
        if (memoryChunk.previous != null) {
            memoryChunk.previous.next = memoryChunk.next;
        }
        if (memoryChunk.next != null) {
            memoryChunk.next.previous = memoryChunk.previous;
        }
        if (this.low == memoryChunk) {
            this.low = memoryChunk.next;
        }
        if (this.high == memoryChunk) {
            this.high = memoryChunk.previous;
        }
    }

    public MemoryChunk allocLow(int size, int addrAlignment) {
        size = Utilities.alignUp(size, addrAlignment);
        MemoryChunk memoryChunk = this.low;
        while (memoryChunk != null) {
            if (memoryChunk.isAvailable(size, addrAlignment)) {
                return this.allocLow(memoryChunk, size, addrAlignment);
            }
            memoryChunk = memoryChunk.next;
        }
        return null;
    }

    public MemoryChunk allocHigh(int size, int addrAlignment) {
        size = Utilities.alignUp(size, addrAlignment);
        MemoryChunk memoryChunk = this.high;
        while (memoryChunk != null) {
            if (memoryChunk.isAvailable(size, addrAlignment)) {
                return this.allocHigh(memoryChunk, size, addrAlignment);
            }
            memoryChunk = memoryChunk.previous;
        }
        return null;
    }

    public MemoryChunk alloc(int addr, int size) {
        MemoryChunk memoryChunk = this.low;
        while (memoryChunk != null) {
            if (memoryChunk.addr <= addr && addr < memoryChunk.addr + memoryChunk.size) {
                return this.alloc(memoryChunk, addr, size);
            }
            memoryChunk = memoryChunk.next;
        }
        return null;
    }

    private MemoryChunk allocLow(MemoryChunk memoryChunk, int size, int addrAlignment) {
        int addr = Utilities.alignUp(memoryChunk.addr, addrAlignment);
        return this.alloc(memoryChunk, addr, size);
    }

    private MemoryChunk allocHigh(MemoryChunk memoryChunk, int size, int addrAlignment) {
        int addr = Utilities.alignDown(memoryChunk.addr + memoryChunk.size - size, addrAlignment);
        return this.alloc(memoryChunk, addr, size);
    }

    private MemoryChunk alloc(MemoryChunk memoryChunk, int addr, int size) {
        if (addr < memoryChunk.addr || memoryChunk.addr + memoryChunk.size < addr + size) {
            return null;
        }
        if (memoryChunk.size == size) {
            this.remove(memoryChunk);
        } else if (memoryChunk.addr == addr) {
            memoryChunk.size -= size;
            memoryChunk.addr += size;
        } else if (memoryChunk.addr + memoryChunk.size == addr + size) {
            memoryChunk.size -= size;
        } else {
            int lowSize = addr - memoryChunk.addr;
            int highSize = memoryChunk.size - lowSize - size;
            MemoryChunk highMemoryChunk = new MemoryChunk(addr + size, highSize);
            memoryChunk.size = lowSize;
            this.addAfter(highMemoryChunk, memoryChunk);
        }
        this.sanityChecks();
        return new MemoryChunk(addr, size);
    }

    private void addAfter(MemoryChunk memoryChunk, MemoryChunk reference) {
        memoryChunk.previous = reference;
        memoryChunk.next = reference.next;
        reference.next = memoryChunk;
        if (memoryChunk.next != null) {
            memoryChunk.next.previous = memoryChunk;
        }
        if (this.high == reference) {
            this.high = memoryChunk;
        }
    }

    private void addBefore(MemoryChunk memoryChunk, MemoryChunk reference) {
        memoryChunk.previous = reference.previous;
        memoryChunk.next = reference;
        reference.previous = memoryChunk;
        if (memoryChunk.previous != null) {
            memoryChunk.previous.next = memoryChunk;
        }
        if (this.low == reference) {
            this.low = memoryChunk;
        }
    }

    public void add(MemoryChunk memoryChunk) {
        MemoryChunk scanChunk = this.low;
        while (scanChunk != null) {
            if (scanChunk.addr + scanChunk.size == memoryChunk.addr) {
                scanChunk.size += memoryChunk.size;
                MemoryChunk nextChunk = scanChunk.next;
                if (nextChunk != null && scanChunk.addr + scanChunk.size == nextChunk.addr) {
                    scanChunk.size += nextChunk.size;
                    this.remove(nextChunk);
                }
                return;
            }
            if (memoryChunk.addr + memoryChunk.size == scanChunk.addr) {
                scanChunk.addr = memoryChunk.addr;
                scanChunk.size += memoryChunk.size;
                MemoryChunk previousChunk = scanChunk.previous;
                if (previousChunk != null && previousChunk.addr + previousChunk.size == scanChunk.addr) {
                    previousChunk.size += scanChunk.size;
                    this.remove(scanChunk);
                }
                return;
            }
            if (scanChunk.addr > memoryChunk.addr) {
                this.addBefore(memoryChunk, scanChunk);
                this.sanityChecks();
                return;
            }
            scanChunk = scanChunk.next;
        }
        if (this.high == null && this.low == null) {
            this.high = memoryChunk;
            this.low = memoryChunk;
        } else {
            this.addAfter(memoryChunk, this.high);
        }
        this.sanityChecks();
    }

    public MemoryChunk getLowMemoryChunk() {
        return this.low;
    }

    public MemoryChunk getHighMemoryChunk() {
        return this.high;
    }

    public boolean isCompletelyFree() {
        if (this.low == null || this.high == null || this.low != this.high) {
            return false;
        }
        return this.low.addr == this.addr && this.low.size == this.size;
    }

    private void sanityChecks() {
        MemoryChunk memoryChunk;
        if (!log.isDebugEnabled()) {
            return;
        }
        if (this.low != null) {
            int addr = this.low.addr;
            memoryChunk = this.low;
            while (memoryChunk != null) {
                if (memoryChunk.addr < addr) {
                    log.error((Object)String.format("MemoryChunkList has overlapping memory chunks at 0x%08X: %s", addr, memoryChunk));
                }
                addr = memoryChunk.addr + memoryChunk.size;
                memoryChunk = memoryChunk.next;
            }
        }
        int sizeLow = 0;
        memoryChunk = this.low;
        while (memoryChunk != null) {
            sizeLow += memoryChunk.size;
            memoryChunk = memoryChunk.next;
        }
        int sizeHigh = 0;
        MemoryChunk memoryChunk2 = this.high;
        while (memoryChunk2 != null) {
            sizeHigh += memoryChunk2.size;
            memoryChunk2 = memoryChunk2.previous;
        }
        if (sizeLow != sizeHigh) {
            log.error((Object)String.format("Size of low and high MemoryChunk differs: 0x%X != 0x%X", sizeLow, sizeHigh));
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        MemoryChunk memoryChunk = this.low;
        while (memoryChunk != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(memoryChunk.toString());
            memoryChunk = memoryChunk.next;
        }
        return result.toString();
    }
}

