/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.pspGeListOptParam;
import jpcsp.HLE.modules.sceGe_user;
import jpcsp.Memory;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.scheduler.Scheduler;

public class PspGeList {
    private VideoEngine videoEngine;
    private static final int pcAddressMask = 0x1FFFFFFC;
    public int list_addr;
    private int stall_addr;
    public int cbid;
    public pspGeListOptParam optParams;
    private int stackAddr;
    private int pc;
    private int[] stack = new int[64];
    private int stackIndex;
    public int status;
    public int id;
    public List<Integer> blockedThreadIds;
    private boolean finished;
    private boolean paused;
    private boolean ended;
    private boolean reset;
    private boolean restarted;
    private Semaphore sync;
    private IMemoryReader memoryReader;
    private int saveContextAddr;
    private IMemoryReader baseMemoryReader;
    private int baseMemoryReaderStartAddress;
    private int baseMemoryReaderEndAddress;
    private long startTimestamp;
    private long minimumDuration;
    private long pauseTimestamp;
    private long pauseDuration;

    public PspGeList(int id) {
        this.videoEngine = VideoEngine.getInstance();
        this.id = id;
        this.blockedThreadIds = new LinkedList<Integer>();
        this.reset();
    }

    private void init() {
        this.stackIndex = 0;
        this.blockedThreadIds.clear();
        this.finished = true;
        this.paused = false;
        this.reset = true;
        this.ended = true;
        this.restarted = false;
        this.memoryReader = null;
        this.baseMemoryReader = null;
        this.baseMemoryReaderStartAddress = 0;
        this.baseMemoryReaderEndAddress = 0;
        this.pc = 0;
        this.saveContextAddr = 0;
    }

    public void init(int list_addr, int stall_addr, int cbid, pspGeListOptParam optParams) {
        this.init();
        this.list_addr = list_addr &= 0x1FFFFFFC;
        this.stall_addr = stall_addr &= 0x1FFFFFFC;
        this.cbid = cbid;
        this.optParams = optParams;
        this.stackAddr = optParams != null ? optParams.stackAddr : 0;
        this.setPc(list_addr);
        this.status = this.pc == stall_addr ? 3 : 1;
        this.finished = false;
        this.reset = false;
        this.ended = false;
        this.pauseDuration = 0L;
        this.minimumDuration = 0L;
        this.sync = new Semaphore(0);
    }

    public void reset() {
        this.status = 0;
        this.init();
    }

    public void pushSignalCallback(int behavior, int signal) {
        int listPc = this.getPc();
        if (!ExternalGE.isActive()) {
            listPc += 4;
        }
        Modules.sceGe_userModule.triggerSignalCallback(this, listPc, behavior, signal);
    }

    public void pushFinishCallback(int arg) {
        int listPc = this.getPc();
        if (!ExternalGE.isActive()) {
            listPc += 4;
        }
        Modules.sceGe_userModule.triggerFinishCallback(this, listPc, arg);
    }

    private void pushStack(int value) {
        this.stack[this.stackIndex++] = value;
    }

    private int popStack() {
        return this.stack[--this.stackIndex];
    }

    public int getAddressRel(int argument) {
        return Memory.normalizeAddress(this.videoEngine.getBase() | argument);
    }

    public int getAddressRelOffset(int argument) {
        return Memory.normalizeAddress((this.videoEngine.getBase() | argument) + this.videoEngine.getBaseOffset());
    }

    public boolean isStackEmpty() {
        return this.stackIndex <= 0;
    }

    public void setPc(int pc) {
        if (this.pc != (pc &= 0x1FFFFFFC)) {
            int oldPc = this.pc;
            this.pc = pc;
            this.resetMemoryReader(oldPc);
        }
    }

    public int getPc() {
        return this.pc;
    }

    public void setListAddr(int addr) {
        this.list_addr = addr & 0x1FFFFFFC;
        this.setPc(this.list_addr);
    }

    public void jumpAbsolute(int argument) {
        this.setPc(Memory.normalizeAddress(argument));
    }

    public void jumpRelativeOffset(int argument) {
        this.setPc(this.getAddressRelOffset(argument));
    }

    public void callAbsolute(int argument) {
        this.pushStack(this.pc);
        this.pushStack(this.videoEngine.getBaseOffset());
        this.jumpAbsolute(argument);
    }

    public void callRelativeOffset(int argument) {
        this.pushStack(this.pc);
        this.pushStack(this.videoEngine.getBaseOffset());
        this.jumpRelativeOffset(argument);
    }

    public void ret() {
        if (!this.isStackEmpty()) {
            this.videoEngine.setBaseOffset(this.popStack());
            this.setPc(this.popStack());
        }
    }

    public void sync() {
        if (this.sync != null) {
            this.sync.release();
        }
    }

    public boolean waitForSync(int millis) {
        while (true) {
            try {
                int availablePermits = this.sync.drainPermits();
                if (availablePermits <= 0 && !this.sync.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                sceGe_user.log.debug((Object)String.format("PspGeList waitForSync %s", e));
                continue;
            }
            break;
        }
        return true;
    }

    public void setStallAddr(int stall_addr) {
        if (this.stall_addr != (stall_addr &= 0x1FFFFFFC)) {
            int oldStallAddr = this.stall_addr;
            this.stall_addr = stall_addr;
            ExternalGE.onStallAddrUpdated(this);
            VideoEngine.getInstance().onStallAddrUpdated(this, oldStallAddr);
            this.sync();
        }
    }

    public synchronized void setStallAddr(int stall_addr, IMemoryReader baseMemoryReader, int startAddress, int endAddress) {
        this.setStallAddr(stall_addr);
        this.baseMemoryReader = baseMemoryReader;
        this.baseMemoryReaderStartAddress = startAddress;
        this.baseMemoryReaderEndAddress = endAddress;
        this.resetMemoryReader(this.pc);
    }

    public int getStallAddr() {
        return this.stall_addr;
    }

    public boolean isStallReached() {
        return this.pc == this.stall_addr && this.stall_addr != 0;
    }

    public boolean hasStallAddr() {
        return this.stall_addr != 0;
    }

    public boolean isStalledAtStart() {
        return this.isStallReached() && this.pc == this.list_addr;
    }

    public void startList() {
        this.startTimestamp = Scheduler.getNow();
        this.finished = false;
        this.ended = false;
        this.paused = false;
        this.sync = new Semaphore(0);
        ExternalGE.onGeStartList(this);
        if (ExternalGE.isActive()) {
            ExternalGE.startList(this);
        } else {
            this.videoEngine.pushDrawList(this);
        }
        this.sync();
    }

    public void startListHead() {
        this.startTimestamp = Scheduler.getNow();
        this.paused = false;
        ExternalGE.onGeStartList(this);
        if (ExternalGE.isActive()) {
            ExternalGE.startListHead(this);
        } else {
            this.videoEngine.pushDrawListHead(this);
        }
    }

    public void pauseList() {
        this.paused = true;
        this.pauseTimestamp = Scheduler.getNow();
    }

    private void updatePauseDuration() {
        if (this.pauseTimestamp != 0L) {
            this.pauseDuration += Scheduler.getNow() - this.pauseTimestamp;
            this.pauseTimestamp = 0L;
        }
    }

    public void restartList() {
        this.updatePauseDuration();
        this.paused = false;
        this.restarted = true;
        this.sync();
        ExternalGE.onRestartList(this);
    }

    public void clearRestart() {
        this.restarted = false;
    }

    public void clearPaused() {
        this.updatePauseDuration();
        this.paused = false;
    }

    public boolean isRestarted() {
        return this.restarted;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void finishList() {
        this.finished = true;
        ExternalGE.onGeFinishList(this);
    }

    public void endList() {
        this.ended = this.isFinished();
    }

    public boolean isDone() {
        return this.status == 0 || this.status == 5;
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isDrawing() {
        return this.status == 2;
    }

    private void resetMemoryReader(int oldPc) {
        if (this.pc == 0) {
            this.memoryReader = null;
        } else if (this.pc >= this.baseMemoryReaderStartAddress && this.pc < this.baseMemoryReaderEndAddress && this.baseMemoryReader != null) {
            this.memoryReader = this.baseMemoryReader;
            this.memoryReader.skip(this.pc - this.baseMemoryReader.getCurrentAddress() >> 2);
        } else if (this.memoryReader == null || this.memoryReader == this.baseMemoryReader || this.pc < oldPc) {
            this.memoryReader = MemoryReader.getMemoryReader(this.pc, 4);
        } else if (oldPc < 0x8000000 && this.pc >= 0x8000000) {
            this.memoryReader = MemoryReader.getMemoryReader(this.pc, 4);
        } else {
            this.memoryReader.skip(this.pc - oldPc >> 2);
        }
    }

    public synchronized void setMemoryReader(IMemoryReader memoryReader) {
        this.memoryReader = memoryReader;
    }

    public boolean hasBaseMemoryReader() {
        return this.baseMemoryReader != null;
    }

    public synchronized int readNextInstruction() {
        if (this.memoryReader == this.baseMemoryReader && (this.pc < this.baseMemoryReaderStartAddress || this.pc >= this.baseMemoryReaderEndAddress)) {
            this.resetMemoryReader(this.pc - 4);
        }
        this.pc += 4;
        return this.memoryReader.readNext();
    }

    public synchronized int readPreviousInstruction() {
        this.memoryReader.skip(-2);
        int previousInstruction = this.memoryReader.readNext();
        this.memoryReader.skip(1);
        return previousInstruction;
    }

    public synchronized void undoRead() {
        this.undoRead(1);
    }

    public synchronized void undoRead(int n) {
        this.memoryReader.skip(-n);
    }

    public int getSaveContextAddr() {
        return this.saveContextAddr;
    }

    public void setSaveContextAddr(int saveContextAddr) {
        this.saveContextAddr = saveContextAddr;
    }

    public boolean hasSaveContextAddr() {
        return this.saveContextAddr != 0;
    }

    public boolean isInUse(int listAddr, int stackAddr) {
        if (this.list_addr == listAddr) {
            return true;
        }
        return stackAddr != 0 && this.stackAddr == stackAddr;
    }

    public int getSyncStatus() {
        if (this.status == 3 && !this.isStallReached()) {
            return 2;
        }
        return this.status;
    }

    public void onGeListSyncDone() {
        if (this.minimumDuration != 0L && Scheduler.getNow() < this.startTimestamp + this.pauseDuration + this.minimumDuration) {
            long schedule = this.startTimestamp + this.pauseDuration + this.minimumDuration;
            this.minimumDuration = 0L;
            this.pauseDuration = 0L;
            Scheduler.getInstance().addAction(schedule, new OnGeListSyncDone(this));
        } else {
            Modules.sceGe_userModule.hleGeListSyncDone(this);
        }
    }

    private void addMinimumDuration(int duration) {
        this.minimumDuration += (long)duration;
    }

    public void onRenderSprite(int textureAddress, int renderedTextureWidth, int renderedTextureHeight, int textureFormat) {
        if (Memory.isVRAM(textureAddress) || renderedTextureWidth < 128 || renderedTextureHeight <= 64 || textureFormat > 3) {
            return;
        }
        int duration = 0;
        if (renderedTextureWidth == 128 && renderedTextureHeight == 272) {
            duration = 4166;
        } else if (renderedTextureWidth >= 512 && renderedTextureHeight >= 256) {
            duration = 66666;
        } else if (renderedTextureWidth >= 256 && renderedTextureHeight >= 256) {
            duration = 33333;
        } else if (renderedTextureWidth >= 512 && renderedTextureHeight >= 128) {
            duration = 33333;
        }
        if (sceGe_user.log.isDebugEnabled()) {
            sceGe_user.log.debug((Object)String.format("onRenderSprite textureAddress=0x%08X, renderedTextureWidth=%d, renderedTextureHeight=%d, textureFormat=%d, duration=%dus", textureAddress, renderedTextureWidth, renderedTextureHeight, textureFormat, duration));
        }
        this.addMinimumDuration(duration);
    }

    public String toString() {
        return String.format("PspGeList[id=0x%X, status=%s, list=0x%08X, pc=0x%08X, stall=0x%08X, cbid=0x%X, ended=%b, finished=%b, paused=%b, restarted=%b, reset=%b]", this.id, sceGe_user.PSP_GE_LIST_STRINGS[this.status], this.list_addr, this.pc, this.stall_addr, this.cbid, this.ended, this.finished, this.paused, this.restarted, this.reset);
    }

    private static class OnGeListSyncDone
    implements IAction {
        private PspGeList list;

        public OnGeListSyncDone(PspGeList list) {
            this.list = list;
        }

        @Override
        public void execute() {
            Modules.sceGe_userModule.hleGeListSyncDone(this.list);
        }
    }
}

