/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.Map;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.modules.SysMemUserForUser;
import org.apache.log4j.Logger;

public class ThreadManForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("ThreadManForKernel");
    private final KTLSEntry[] ktlsEntries = new KTLSEntry[16];
    private final Map<Integer, SysMemUserForUser.SysMemInfo[]> threadKTLSEntries = new HashMap<Integer, SysMemUserForUser.SysMemInfo[]>();

    @Override
    public void start() {
        for (int i = 0; i < this.ktlsEntries.length; ++i) {
            this.ktlsEntries[i] = null;
        }
        this.threadKTLSEntries.clear();
        super.start();
    }

    public void freeKTLSEntries(int thid) {
        SysMemUserForUser.SysMemInfo[] threadKTLS;
        if (thid == 0) {
            thid = Modules.ThreadManForUserModule.getCurrentThreadID();
        }
        if ((threadKTLS = this.threadKTLSEntries.remove(thid)) != null) {
            for (int i = 0; i < this.ktlsEntries.length; ++i) {
                SysMemUserForUser.SysMemInfo sysMemInfo = threadKTLS[i];
                if (sysMemInfo == null) continue;
                if (this.ktlsEntries[i] != null) {
                    this.ktlsEntries[i].call(sysMemInfo.addr);
                }
                Modules.SysMemUserForUserModule.free(sysMemInfo);
            }
        }
    }

    @HLEFunction(nid=82256481, version=150)
    public int sceKernelAllocateKTLS(int size, TPointerFunction callback, int callbackArg) {
        int result = -2147352127;
        for (int i = 0; i < this.ktlsEntries.length; ++i) {
            if (this.ktlsEntries[i] != null) continue;
            this.ktlsEntries[i] = new KTLSEntry(size, callback, callbackArg);
            result = i;
            break;
        }
        return result;
    }

    @HLEFunction(nid=1340362078, version=150)
    public int sceKernelCheckThreadKernelStack() {
        return 4096;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2052938305, version=150)
    public int sceKernelIsUserModeThread() {
        return 1;
    }

    @HLEFunction(nid=-1572214098, version=150)
    public int sceKernelGetKTLS(int id) {
        return this.sceKernelGetThreadKTLS(id, 0, 1);
    }

    @HLEFunction(nid=-1, version=150)
    public int hleKernelGetSystemTimeLow() {
        return Managers.systime.sceKernelGetSystemTimeLow();
    }

    @HLEUnimplemented
    @HLEFunction(nid=987264451, version=150)
    public int sceKernelGetThreadKTLS(int id, int thid, int mode) {
        KTLSEntry ktlsEntry;
        SysMemUserForUser.SysMemInfo info;
        if (thid == 0) {
            thid = Modules.ThreadManForUserModule.getCurrentThreadID();
        }
        if ((info = Modules.SysMemUserForUserModule.malloc(2, "KTLS", 0, (ktlsEntry = this.ktlsEntries[id]).size, 0)) == null) {
            return 0;
        }
        this.getMemory().memset(info.addr, (byte)0, ktlsEntry.size);
        SysMemUserForUser.SysMemInfo[] threadKTLS = this.threadKTLSEntries.get(thid);
        if (threadKTLS == null) {
            threadKTLS = new SysMemUserForUser.SysMemInfo[this.ktlsEntries.length];
            this.threadKTLSEntries.put(thid, threadKTLS);
        }
        threadKTLS[id] = info;
        return info.addr;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-778520559, version=150)
    public int sceKernelFreeKTLS(int id) {
        this.ktlsEntries[id] = null;
        return 0;
    }

    private static class KTLSEntry {
        private int size;
        private TPointerFunction callback;
        private int callbackArg;
        private int gp;

        public KTLSEntry(int size, TPointerFunction callback, int callbackArg) {
            this.size = size;
            this.callback = callback;
            this.callbackArg = callbackArg;
            this.gp = Emulator.getProcessor().cpu._gp;
        }

        public void call(int addr) {
            if (this.callback == null || this.callback.isNull()) {
                return;
            }
            Modules.ThreadManForUserModule.executeCallback(this.callback.getAddress(), this.gp, null, addr, this.callbackArg);
        }
    }
}

