/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Interpreter;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelLoadExecVSHParam;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceLoadCoreBootInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.SceSysmemUidCB;
import jpcsp.HLE.modules.SysMemForKernel;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Loader;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.Processor;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.PRX;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.hardware.Model;
import jpcsp.memory.ByteArrayMemory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.IntArrayMemory;
import jpcsp.memory.MemoryWriter;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerGpio;
import jpcsp.memory.mmio.MMIOHandlerKirk;
import jpcsp.memory.mmio.memorystick.MMIOHandlerMemoryStick;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class reboot
extends HLEModule {
    public static Logger log = Modules.getLogger("reboot");
    public static boolean enableReboot = false;
    public static boolean loadCoreInitialized = false;
    private static final String rebootFileName = "flash0:/reboot.bin";
    private static final int rebootBaseAddress = -2006974464;
    private static final int BOOT_PREIPL = 0;
    private static final int BOOT_IPL = 1;
    private static final int BOOT_LOADEXEC_PRX = 2;
    private static final int BOOT_REBOOT_BIN = 3;
    private final int preIplAddress = -1077936128;
    private final int preIplSize = 4096;
    private static final int IPL_KEY_MODEL_GENERATION_1 = 1494326223;
    private static final int IPL_KEY_MODEL_GENERATION_2 = -1134218516;
    private final TPointer preIplCopy = new TPointer(Memory.getInstance(), -2147418112);
    private int iplEntry;
    private int iplBase;
    private int iplSize;
    private boolean usingKbooti;

    private boolean isFilePresent(String fileName) {
        StringBuilder localFileName = new StringBuilder();
        IVirtualFileSystem vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(fileName, localFileName);
        if (vfs == null) {
            return false;
        }
        IVirtualFile vFile = vfs.ioOpen(localFileName.toString(), 1, 0);
        if (vFile == null) {
            return false;
        }
        int length = (int)vFile.length();
        vFile.ioClose();
        return length > 0;
    }

    public boolean isAvailable() {
        String[] fileNames;
        Model.init();
        String generationSuffix = "";
        if (RuntimeContextLLE.getFirmwareVersion() >= 500) {
            generationSuffix = String.format("_%02dg", Model.getGeneration());
        }
        for (String fileName : fileNames = new String[]{"flash0:/kd/loadexec%s.prx", "flash0:/kd/sysmem.prx"}) {
            String completeFileName = String.format(fileName, generationSuffix);
            if (this.isFilePresent(completeFileName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("reboot is not available because the file '%s' is missing", completeFileName));
            }
            return false;
        }
        return true;
    }

    public boolean isUsingKbooti() {
        return this.usingKbooti;
    }

    public boolean loadAndRun() {
        boolean result;
        if (!enableReboot) {
            return false;
        }
        Model.init();
        Modules.SysMemUserForUserModule.setMemory64MB(Model.getModel() > 0);
        RuntimeContextLLE.reset();
        RuntimeContextLLE.start();
        RuntimeContext.updateMemory();
        boolean fromSyscall = false;
        Emulator.getInstance().initNewPsp(false);
        Emulator.getProcessor().triggerReset();
        Emulator.getInstance().setModuleLoaded(true);
        HLEModuleManager.getInstance().startModules(false);
        int bootMethod = this.getBestBootMethod();
        switch (bootMethod) {
            case 1: {
                result = this.bootIpl();
                break;
            }
            case 2: {
                result = this.bootLoadexecPrx();
                break;
            }
            case 3: {
                result = this.bootRebootBin();
                break;
            }
            case 0: {
                result = this.bootPreIpl();
                break;
            }
            default: {
                result = false;
            }
        }
        Emulator.getScheduler().addAction(new SetLog4jMDC());
        if (result) {
            loadCoreInitialized = true;
        }
        return result;
    }

    private String getPreIplFileName() {
        return String.format("preIpl_%02dg.bin", Model.getGeneration());
    }

    private int getBestBootMethod() {
        int bootMethod;
        File preIplFile = new File(this.getPreIplFileName());
        if (preIplFile.canRead() && preIplFile.length() == 4096L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Best boot method is BOOT_PREIPL for PSP Model '%s'", Model.getModelName()));
            }
            bootMethod = 0;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Best boot method is BOOT_IPL for PSP Model '%s'", Model.getModelName()));
            }
            bootMethod = 1;
        }
        return bootMethod;
    }

    private TPointer getKl4eDecompress(TPointer baseAddress) {
        int opcode;
        int i;
        SceModule module;
        String fileName = "flash0:/kd/np9660.prx";
        byte[] buffer = Utilities.readCompleteFile(fileName);
        if (buffer == null) {
            return null;
        }
        try {
            module = Loader.getInstance().LoadModule(fileName, ByteBuffer.wrap(buffer), baseAddress, 1, 1, false, false, true, true, null);
        }
        catch (IOException e) {
            return null;
        }
        TPointer entryAddress = null;
        int functionSize = 0;
        TPointer moduleTextAddr = new TPointer(baseAddress.getMemory(), module.text_addr);
        for (i = 0; i < module.text_size; i += 4) {
            opcode = moduleTextAddr.getValue32(i);
            if (opcode == 666760432) {
                entryAddress = new TPointer(moduleTextAddr, i);
                entryAddress.setValue32(12, entryAddress.getValue32(12) & 0xFFFF0000);
                entryAddress.setValue32(144, entryAddress.getValue32(144) + 14);
                continue;
            }
            if (entryAddress == null) continue;
            if ((opcode & Short.MIN_VALUE) == 666730496) {
                functionSize = i;
                break;
            }
            if ((opcode & 0xFFE007FF) == 192) {
                moduleTextAddr.setValue32(i, opcode & 0xFFFFF83F | 0x100);
                continue;
            }
            if ((opcode & 0xFFFF07FF) == 852162) {
                moduleTextAddr.setValue32(i, opcode & 0xFFFFF83F | 0x100);
                continue;
            }
            if (opcode == 610467871) {
                moduleTextAddr.setValue32(i, opcode - 16);
                continue;
            }
            if (opcode != 605159776) continue;
            moduleTextAddr.setValue32(i, opcode - 96);
        }
        if (entryAddress == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("KL4E decompress at %s", entryAddress));
            if (log.isTraceEnabled()) {
                for (i = 0; i < functionSize; i += 4) {
                    opcode = entryAddress.getValue32(i);
                    int addr = entryAddress.getAddress() + i;
                    log.trace((Object)String.format("0x%08X: 0x%08X %s", addr, opcode, Decoder.instruction(opcode).disasm(addr, opcode)));
                }
            }
        }
        return entryAddress;
    }

    private TPointer getKl3eDecompress(TPointer baseAddress, TPointer kl4eDecompress, TPointer tempBuffer, int tempBufferSize) {
        int opcode;
        int i;
        SceModule module;
        String fileName = String.format("flash0:/kd/loadexec_%02dg.prx", Model.getGeneration());
        byte[] buffer = Utilities.readCompleteFile(fileName);
        if (buffer == null) {
            return null;
        }
        PRX prxEngine = new CryptoEngine().getPRXEngine();
        buffer = prxEngine.DecryptAndUncompressPRX(buffer, buffer.length, true, null, kl4eDecompress, tempBuffer, tempBufferSize);
        if (buffer == null) {
            return null;
        }
        try {
            module = Loader.getInstance().LoadModule(fileName, ByteBuffer.wrap(buffer), baseAddress, 1, 1, false, false, true, true, null);
        }
        catch (IOException e) {
            return null;
        }
        TPointer entryAddress = null;
        int functionSize = 0;
        TPointer moduleTextAddr = new TPointer(baseAddress.getMemory(), module.text_addr);
        for (i = 0; i < module.text_size; i += 4) {
            opcode = moduleTextAddr.getValue32(i);
            if (opcode == 666760584) {
                entryAddress = new TPointer(moduleTextAddr, i);
                continue;
            }
            if (entryAddress == null || (opcode & Short.MIN_VALUE) != 666730496) continue;
            functionSize = i;
            break;
        }
        if (entryAddress == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("KL3E decompress at %s", entryAddress));
            if (log.isTraceEnabled()) {
                for (i = 0; i < functionSize; i += 4) {
                    opcode = entryAddress.getValue32(i);
                    int addr = entryAddress.getAddress() + i;
                    log.trace((Object)String.format("0x%08X: 0x%08X %s", addr, opcode, Decoder.instruction(opcode).disasm(addr, opcode)));
                }
            }
        }
        return entryAddress;
    }

    private void initRebootParameters(Memory mem, SceModule rebootModule) {
        int rebootParamPartitionId;
        int rebootParamAddressOffset;
        this.addFunctionNames(rebootModule);
        if (Model.getModel() == 0) {
            rebootParamAddressOffset = 0x400000;
            rebootParamPartitionId = 5;
        } else {
            rebootParamAddressOffset = 0x3800000;
            rebootParamPartitionId = 2;
        }
        int rebootParamAddress = -2013265920 + rebootParamAddressOffset + 64;
        SysMemUserForUser.SysMemInfo rebootParamInfo = Modules.SysMemUserForUserModule.malloc(rebootParamPartitionId, "reboot-parameters", 2, 65536, rebootParamAddress);
        TPointer sceLoadCoreBootInfoAddr = new TPointer(mem, rebootParamInfo.addr);
        SceLoadCoreBootInfo sceLoadCoreBootInfo = new SceLoadCoreBootInfo();
        sceLoadCoreBootInfoAddr.clear(119680);
        TPointer startAddr = new TPointer(sceLoadCoreBootInfoAddr, 4096);
        TPointer sceKernelLoadExecVSHParamAddr = new TPointer(startAddr, 114688);
        TPointer loadModeStringAddr = new TPointer(sceKernelLoadExecVSHParamAddr, 48);
        loadModeStringAddr.setStringZ("vsh");
        SceKernelLoadExecVSHParam sceKernelLoadExecVSHParam = new SceKernelLoadExecVSHParam();
        sceKernelLoadExecVSHParamAddr.setValue32(48);
        sceKernelLoadExecVSHParam.flags = 65536;
        sceKernelLoadExecVSHParam.keyAddr = loadModeStringAddr;
        sceKernelLoadExecVSHParam.write(sceKernelLoadExecVSHParamAddr);
        sceLoadCoreBootInfo.memBase = -2013265920;
        sceLoadCoreBootInfo.memSize = MemoryMap.SIZE_RAM;
        sceLoadCoreBootInfo.startAddr = startAddr;
        sceLoadCoreBootInfo.endAddr = new TPointer(sceKernelLoadExecVSHParamAddr, 896);
        sceLoadCoreBootInfo.modProtId = -1;
        sceLoadCoreBootInfo.modArgProtId = -1;
        sceLoadCoreBootInfo.model = Model.getGeneration() - 1;
        sceLoadCoreBootInfo.dipswLo = Modules.KDebugForKernelModule.sceKernelDipswLow32();
        sceLoadCoreBootInfo.dipswHi = Modules.KDebugForKernelModule.sceKernelDipswHigh32();
        if (Modules.KDebugForKernelModule.sceKernelDipsw(30) != 1) {
            sceLoadCoreBootInfo.dipswHi = Utilities.clearBit(sceLoadCoreBootInfo.dipswHi, 24);
            sceLoadCoreBootInfo.dipswHi = Utilities.clearBit(sceLoadCoreBootInfo.dipswHi, 26);
        }
        sceLoadCoreBootInfo.unknown76 = sceLoadCoreBootInfo.unknown72 = ((MemoryMap.END_USERSPACE | Integer.MIN_VALUE) & 0xFFFFFF00) - 1024;
        sceLoadCoreBootInfo.cpTime = Modules.KDebugForKernelModule.sceKernelDipswCpTime();
        sceLoadCoreBootInfo.write(sceLoadCoreBootInfoAddr);
        SceKernelThreadInfo rootThread = Modules.ThreadManForUserModule.getRootThread(null);
        if (rootThread != null) {
            rootThread.cpuContext._a0 = sceLoadCoreBootInfoAddr.getAddress() | 0x88000000;
            rootThread.cpuContext._a1 = sceKernelLoadExecVSHParamAddr.getAddress() | 0x88000000;
            rootThread.cpuContext._a2 = 768;
            rootThread.cpuContext._a3 = Modules.SysMemForKernelModule.sceKernelGetInitialRandomValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceReboot arg0=%s, arg1=%s", sceLoadCoreBootInfoAddr, sceKernelLoadExecVSHParamAddr));
        }
    }

    private SceModule createRebootModule() {
        SceModule rebootModule = new SceModule(true);
        rebootModule.modname = this.getName();
        rebootModule.baseAddress = -2006974464;
        rebootModule.text_addr = -2006974464;
        rebootModule.text_size = 0;
        rebootModule.data_size = 0;
        rebootModule.bss_size = 158592;
        Modules.ThreadManForUserModule.Initialise(rebootModule, rebootModule.baseAddress, 0, rebootModule.pspfilename, -1, 0, false);
        return rebootModule;
    }

    private boolean bootLoadexecPrx() {
        String loadexecFileName = String.format("flash0:/kd/loadexec_%02dg.prx", Model.getGeneration());
        byte[] loadexecBuffer = Utilities.readCompleteFile(loadexecFileName);
        if (loadexecBuffer == null) {
            return false;
        }
        SceModule rebootModule = this.createRebootModule();
        IntArrayMemory intArrayMemory = new IntArrayMemory(new int[65536], 0, 0x8000000);
        TPointer tempMemory = intArrayMemory.getPointer();
        int offset = 0;
        TPointer kl4eBaseAddress = new TPointer(tempMemory, offset);
        TPointer kl3eBaseAddress = new TPointer(tempMemory, offset += 65536);
        TPointer tempBuffer = new TPointer(tempMemory, offset += 65536);
        int tempBufferSize = 131072;
        TPointer kl4eDecompress = this.getKl4eDecompress(kl4eBaseAddress);
        TPointer kl3eDecompress = this.getKl3eDecompress(kl3eBaseAddress, kl4eDecompress, tempBuffer, tempBufferSize);
        PRX prxEngine = new CryptoEngine().getPRXEngine();
        loadexecBuffer = prxEngine.DecryptAndUncompressPRX(loadexecBuffer, loadexecBuffer.length, true, null, kl4eDecompress, tempBuffer, tempBufferSize);
        if (loadexecBuffer == null) {
            return false;
        }
        int rebootOffset = -1;
        for (int i = 0; i < loadexecBuffer.length; i += 4) {
            if (Utilities.readUnaligned32(loadexecBuffer, i) != 1347637374) continue;
            rebootOffset = i;
            break;
        }
        if (rebootOffset < 0) {
            return false;
        }
        int rebootLength = Utilities.readUnaligned32(loadexecBuffer, rebootOffset + 44);
        byte[] rebootBuffer = new byte[rebootLength];
        System.arraycopy(loadexecBuffer, rebootOffset, rebootBuffer, 0, rebootLength);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Found reboot.prx at offset 0x%X: %s", rebootOffset, Utilities.getMemoryDump(rebootBuffer)));
        }
        rebootBuffer = prxEngine.DecryptAndUncompressPRX(rebootBuffer, rebootLength, false, null);
        try {
            offset = 0;
            tempBuffer.alignUp(15);
            TPointer inputBufferAddr = new TPointer(tempBuffer, offset);
            int stackSize = Utilities.alignUp(3000, 15);
            TPointer stackBufferAddr = new TPointer(tempBuffer, offset += Utilities.alignUp(rebootBuffer.length, 15));
            offset += stackSize;
            offset = Utilities.alignUp(offset, 63);
            TPointer outputBufferAddr = new TPointer(tempBuffer, offset);
            inputBufferAddr.setArray(0, rebootBuffer, 4, rebootBuffer.length - 4);
            int outputSize = 131072;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Calling KL3E decompress at %s: input %s(size=0x%X), output %s(size=0x%X)", kl3eDecompress, inputBufferAddr, rebootBuffer.length, outputBufferAddr, outputSize));
            }
            Processor processor = new Processor();
            processor.cpu.setMemory(kl3eDecompress.getMemory());
            processor.cpu._a0 = outputBufferAddr.getAddress();
            processor.cpu._a1 = outputSize;
            processor.cpu._a2 = inputBufferAddr.getAddress();
            processor.cpu._a3 = 0;
            processor.cpu._sp = stackBufferAddr.getAddress() + stackSize | Integer.MIN_VALUE;
            Interpreter interpreter = new Interpreter(processor);
            interpreter.run(kl3eDecompress.getAddress());
            int result = processor.cpu._v0;
            if (result < 0) {
                return false;
            }
            rebootBuffer = outputBufferAddr.getArray8(0, result);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("KL3E decompress returned size=0x%X", result));
            }
        }
        catch (Exception e) {
            log.error((Object)"KL3E decompress", (Throwable)e);
        }
        RuntimeContextLLE.getMMIO().remapMemoryAtProcessorReset();
        this.addMMIORange(-1077932288, 256);
        MMIOHandlerKirk.getInstance().setInitDone();
        int rebootMemSize = rebootModule.text_size + rebootModule.data_size + rebootModule.bss_size;
        SysMemUserForUser.SysMemInfo rebootMemInfo = Modules.SysMemUserForUserModule.malloc(5, "reboot", 2, rebootMemSize, rebootModule.text_addr);
        if (rebootMemInfo == null) {
            return false;
        }
        Memory mem = Memory.getInstance();
        TPointer rebootBinAddr = new TPointer(mem, -2006974464);
        rebootBinAddr.setArray(rebootBuffer);
        rebootModule.text_size = rebootBuffer.length;
        this.initRebootParameters(mem, rebootModule);
        return true;
    }

    private boolean bootRebootBin() {
        StringBuilder localFileName = new StringBuilder();
        IVirtualFileSystem vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(rebootFileName, localFileName);
        if (vfs == null) {
            return false;
        }
        IVirtualFile vFile = vfs.ioOpen(localFileName.toString(), 1, 0);
        if (vFile == null) {
            return false;
        }
        int rebootFileLength = (int)vFile.length();
        if (rebootFileLength <= 0) {
            return false;
        }
        SceModule rebootModule = this.createRebootModule();
        rebootModule.text_size = rebootFileLength;
        MMIO mmio = (MMIO)RuntimeContextLLE.getMMIO();
        mmio.remapMemoryAtProcessorReset();
        int rebootMemSize = rebootModule.text_size + rebootModule.data_size + rebootModule.bss_size;
        SysMemUserForUser.SysMemInfo rebootMemInfo = Modules.SysMemUserForUserModule.malloc(5, "reboot", 2, rebootMemSize, rebootModule.text_addr);
        if (rebootMemInfo == null) {
            return false;
        }
        Memory mem = Memory.getInstance();
        TPointer rebootBinAddr = new TPointer(mem, -2006974464);
        int readLength = vFile.ioRead(rebootBinAddr, rebootFileLength);
        vFile.ioClose();
        if (readLength != rebootFileLength) {
            return false;
        }
        this.initRebootParameters(mem, rebootModule);
        return true;
    }

    private void addMMIORangeIPL() {
        this.addMMIORange(68075520, 122880);
        this.addMMIORange(0x4000000, 917504);
        this.addMMIORange(69074944, 16384);
        this.addMMIORange(0x40E0000, 20480);
        this.addMMIORange(-1076887552, 4096);
    }

    private boolean bootIpl() {
        if (this.loadKbooti()) {
            this.usingKbooti = true;
        } else {
            boolean bootFromNand;
            boolean bl = bootFromNand = !MMIOHandlerGpio.getInstance().readPort(4);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Loading IPL from %s", bootFromNand ? "Nand" : "MemoryStick"));
            }
            if (!this.loadIpl(bootFromNand)) {
                return false;
            }
        }
        this.addMMIORange(-1077936128, 4096);
        this.addMMIORange(this.preIplCopy, 4096);
        this.addMMIORangeIPL();
        if (Model.getModel() <= 1) {
            HLEUtilities.getInstance().installHLESyscallWithJump(new TPointer(this.preIplCopy, 0), this, "hlePreIplStart");
            HLEUtilities.getInstance().installHLESyscall(new TPointer(this.preIplCopy, 672), (HLEModule)this, "hlePreIplIcacheInvalidateAll");
            HLEUtilities.getInstance().installHLESyscall(new TPointer(this.preIplCopy, 728), (HLEModule)this, "hlePreIplDcacheWritebackInvalidateAll");
            HLEUtilities.getInstance().installHLESyscall(new TPointer(this.preIplCopy, 820), (HLEModule)this, "hlePreIplNandReadPage");
            HLEUtilities.getInstance().installHLESyscall(new TPointer(this.preIplCopy, 1048), (HLEModule)this, "hlePreIplMemoryStickReadSector");
        }
        SceModule iplModule = new SceModule(true);
        iplModule.modname = this.getName();
        iplModule.baseAddress = this.iplBase;
        iplModule.text_addr = this.iplBase;
        iplModule.text_size = this.iplSize;
        iplModule.data_size = 0;
        iplModule.bss_size = 0;
        Modules.ThreadManForUserModule.Initialise(iplModule, this.iplEntry, 0, iplModule.pspfilename, -1, 0, false);
        SceModule rebootModule = new SceModule(true);
        rebootModule.baseAddress = -2006974464;
        rebootModule.text_addr = -2006974464;
        this.addFunctionNames(rebootModule);
        return true;
    }

    private boolean bootPreIpl() {
        TPointer preIpl = new TPointer(RuntimeContextLLE.getMMIO(), -1077936128);
        File preIplFile = new File(this.getPreIplFileName());
        try {
            LocalVirtualFile vFile = new LocalVirtualFile(new SeekableRandomFile(preIplFile, "r"));
            int result = vFile.ioRead(preIpl, 4096);
            vFile.ioClose();
            if (result != 4096) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        this.addMMIORange(preIpl, 4096);
        this.addMMIORange(this.preIplCopy, 4096);
        this.addMMIORangeIPL();
        SceModule iplModule = new SceModule(true);
        iplModule.modname = this.getName();
        iplModule.baseAddress = -1077936128;
        iplModule.text_addr = -1077936128;
        iplModule.text_size = 4096;
        iplModule.data_size = 0;
        iplModule.bss_size = 0;
        Modules.ThreadManForUserModule.Initialise(iplModule, -1077936128, 0, iplModule.pspfilename, -1, 0, false);
        SceModule rebootModule = new SceModule(true);
        rebootModule.baseAddress = -2006974464;
        rebootModule.text_addr = -2006974464;
        this.addFunctionNames(rebootModule);
        switch (RuntimeContextLLE.getFirmwareVersion()) {
            case 639: {
                this.addFunctionNid(67144328, "sceIdStorageReadLeaf");
                this.addFunctionNid(67146512, "sceIdStorageLookup");
                this.addFunctionNid(67143200, "sceIdStorageInit");
                this.addFunctionNid(67159120, "sceSysregGetFuseId");
                this.addFunctionNid(67110524, "sceKernelUtilsSha1Digest");
                this.addFunctionNid(67159056, "sceSysregGetTachyonVersion");
                this.addFunctionNid(67123744, "sceKernelUtilsSha1Digest");
                break;
            }
            case 660: 
            case 661: {
                this.addFunctionNid(67144740, "sceIdStorageReadLeaf");
                this.addFunctionNid(67146924, "sceIdStorageLookup");
                this.addFunctionNid(67143612, "sceIdStorageInit");
                this.addFunctionNid(67159540, "sceSysregGetFuseId");
                this.addFunctionNid(67110524, "sceKernelUtilsSha1Digest");
                this.addFunctionNid(67159476, "sceSysregGetTachyonVersion");
                this.addFunctionNid(67123952, "sceKernelUtilsSha1Digest");
            }
        }
        return true;
    }

    private void addFunctionNid(int address, String name) {
        int nid = HLEModuleManager.getInstance().getNIDFromFunctionName(name);
        if (nid != 0) {
            Modules.LoadCoreForKernelModule.addFunctionNid(address, nid);
        }
    }

    private void addFunctionNid(int moduleAddress, SceModule module, String name) {
        this.addFunctionNid(module.text_addr + moduleAddress, name);
    }

    private void addFunctionNames(SceModule rebootModule) {
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 128, "sceInit.patchGames");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 536, "sceInit.InitCBInit");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 736, "sceInit.ExitInit");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 1012, "sceInit.ExitCheck");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 1080, "sceInit.PowerUnlock");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 1164, "sceInit.invoke_init_callback");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 1520, "sceInit.sub_05F0");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 1704, "sceInit.CleanupPhase1");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 1936, "sceInit.CleanupPhase2");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 2296, "sceInit.ProtectHandling");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 3324, "sceInit.sub_0CFC_IsModuleInUserPartition");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 3404, "sceInit.ClearFreeBlock");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 3536, "sceInit.sub_0DD0_IsApplicationTypeGame");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 4152, "sceInit.LoadModuleBufferAnchorInBtcnf");
        Modules.LoadCoreForKernelModule.addFunctionName("sceInit", 4672, "sceInit.InitThreadEntry");
        Modules.LoadCoreForKernelModule.addFunctionName("sceLoaderCore", 22200, "sceLoaderCore.PspUncompress");
        Modules.LoadCoreForKernelModule.addFunctionName("sceGE_Manager", 600, "sceGE_Manager.sceGeInit");
        Modules.LoadCoreForKernelModule.addFunctionName("sceMeCodecWrapper", 7172, "sceMeCodecWrapper.decrypt");
        Modules.LoadCoreForKernelModule.addFunctionName("sceAudio_Driver", 0, "sceAudio_Driver.updateAudioBuf");
        Modules.LoadCoreForKernelModule.addFunctionName("sceAudio_Driver", 4988, "sceAudio_Driver.audioOutput");
        Modules.LoadCoreForKernelModule.addFunctionName("sceAudio_Driver", 1328, "sceAudio_Driver.audioOutputDmaCb");
        Modules.LoadCoreForKernelModule.addFunctionName("sceAudio_Driver", 492, "sceAudio_Driver.dmaUpdate");
        Modules.LoadCoreForKernelModule.addFunctionName("sceAudio_Driver", 6512, "sceAudio_Driver.audioIntrHandler");
        Modules.LoadCoreForKernelModule.addFunctionName("sceAudio_Driver", 696, "sceAudio_Driver.audioMixerThread");
        Modules.LoadCoreForKernelModule.addFunctionName("sceSYSCON_Driver", 2576, "sceSYSCON_Driver._sceSysconGpioIntr");
        Modules.LoadCoreForKernelModule.addFunctionName("sceSYSCON_Driver", 9268, "sceSYSCON_Driver._sceSysconPacketEnd");
        Modules.LoadCoreForKernelModule.addFunctionName("sceDisplay_Service", 1260, "sceDisplay_Service.sceDisplayInit");
        Modules.LoadCoreForKernelModule.addFunctionName("scePower_Service", 0, "scePower_Service.scePowerInit");
        Modules.LoadCoreForKernelModule.addFunctionName("sceHP_Remote_Driver", 1796, "sceHP_Remote_Driver.sceHpRemoteThreadEntry");
        Modules.LoadCoreForKernelModule.addFunctionName("sceLowIO_Driver", 40060, "sceNandTransferDataToNandBuf");
        int offset = -1;
        switch (Model.getGeneration()) {
            case 1: {
                offset = 648;
                break;
            }
            case 2: {
                offset = 840;
            }
        }
        if (offset != -1) {
            this.addFunctionNid(offset + 61388, rebootModule, "sceNandInit2");
            this.addFunctionNid(offset + 61636, rebootModule, "sceNandIsReady");
            this.addFunctionNid(offset + 61652, rebootModule, "sceNandSetWriteProtect");
            this.addFunctionNid(offset + 61764, rebootModule, "sceNandLock");
            this.addFunctionNid(offset + 61848, rebootModule, "sceNandReset");
            this.addFunctionNid(offset + 62004, rebootModule, "sceNandReadId");
            this.addFunctionNid(offset + 62092, rebootModule, "sceNandReadAccess");
            this.addFunctionNid(offset + 62552, rebootModule, "sceNandWriteAccess");
            this.addFunctionNid(offset + 63040, rebootModule, "sceNandEraseBlock");
            this.addFunctionNid(offset + 63276, rebootModule, "sceNandReadExtraOnly");
            this.addFunctionNid(offset + 63656, rebootModule, "sceNandReadStatus");
            this.addFunctionNid(offset + 63708, rebootModule, "sceNandSetScramble");
            this.addFunctionNid(offset + 63724, rebootModule, "sceNandReadPages");
            this.addFunctionNid(offset + 63792, rebootModule, "sceNandWritePages");
            this.addFunctionNid(offset + 63832, rebootModule, "sceNandReadPagesRawExtra");
            this.addFunctionNid(offset + 63860, rebootModule, "sceNandWritePagesRawExtra");
            this.addFunctionNid(offset + 63896, rebootModule, "sceNandReadPagesRawAll");
            this.addFunctionNid(offset + 63952, rebootModule, "sceNandTransferDataToNandBuf");
            this.addFunctionNid(offset + 64576, rebootModule, "sceNandIntrHandler");
            this.addFunctionNid(offset + 65376, rebootModule, "sceNandTransferDataFromNandBuf");
            this.addFunctionNid(offset + 66504, rebootModule, "sceNandWriteBlockWithVerify");
            this.addFunctionNid(offset + 66684, rebootModule, "sceNandReadBlockWithRetry");
            this.addFunctionNid(offset + 66816, rebootModule, "sceNandVerifyBlockWithRetry");
            this.addFunctionNid(offset + 67152, rebootModule, "sceNandEraseBlockWithRetry");
            this.addFunctionNid(offset + 67268, rebootModule, "sceNandIsBadBlock");
            this.addFunctionNid(offset + 67408, rebootModule, "sceNandDoMarkAsBadBlock");
            this.addFunctionNid(offset + 68060, rebootModule, "sceNandDetectChipMakersBBM");
            this.addFunctionNid(offset + 68892, rebootModule, "sceNandGetPageSize");
            this.addFunctionNid(offset + 68904, rebootModule, "sceNandGetPagesPerBlock");
            this.addFunctionNid(offset + 68916, rebootModule, "sceNandGetTotalBlocks");
        }
    }

    public static void dumpAllModulesAndLibraries() {
        if (!enableReboot || !log.isTraceEnabled()) {
            return;
        }
        Memory mem = Memory.getInstance();
        int g_loadCore = -2013130468;
        int registeredMods = mem.read32(g_loadCore + 524);
        int registeredLibs = g_loadCore + 0;
        reboot.dumpAllModules(mem, registeredMods);
        for (int i = 0; i < 512; i += 4) {
            reboot.dumpAllLibraries(mem, mem.read32(registeredLibs + i));
        }
    }

    private static void dumpAllModules(Memory mem, int address) {
        while (address != 0) {
            String moduleName = Utilities.readStringNZ(address + 8, 27);
            int textAddr = mem.read32(address + 108);
            int textSize = mem.read32(address + 112);
            log.trace((Object)String.format("Module '%s': text 0x%08X-0x%08X", moduleName, textAddr, textAddr + textSize));
            address = mem.read32(address);
        }
    }

    private static void dumpAllLibraries(Memory mem, int address) {
        while (address != 0) {
            String libName = Utilities.readStringZ(mem.read32(address + 68));
            int numExports = mem.read32(address + 16);
            int entryTable = mem.read32(address + 32);
            log.trace((Object)String.format("Library '%s':", libName));
            for (int i = 0; i < numExports; ++i) {
                int nid = mem.read32(entryTable + i * 4);
                int entryAddress = mem.read32(entryTable + (i + numExports) * 4);
                log.trace((Object)String.format("   0x%08X: 0x%08X", nid, entryAddress));
            }
            address = mem.read32(address);
        }
    }

    public static void setLog4jMDC(Processor processor) {
        boolean isInterruptContext;
        if (!enableReboot) {
            return;
        }
        if (processor.cp0.isMediaEngineCpu()) {
            return;
        }
        boolean bl = isInterruptContext = processor.cp0.getControlRegister(13) != 0;
        if (isInterruptContext && RuntimeContextLLE.getFirmwareVersion() > 200) {
            RuntimeContext.setLog4jMDC("Interrupt");
        } else {
            Memory mem = Memory.getInstance();
            int threadManInfo = Modules.LoadCoreForKernelModule.getThreadManInfo();
            if (threadManInfo != 0) {
                int currentThread = mem.internalRead32(threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoCurrentThreadOffset);
                if (Memory.isAddressGood(currentThread)) {
                    int uid = mem.internalRead32(currentThread + 8);
                    int cb = SysMemForKernel.getCBFromUid(uid);
                    int nameAddr = mem.internalRead32(cb + 16);
                    String name = Utilities.readInternalStringZ(mem, nameAddr);
                    RuntimeContext.setLog4jMDC(name, uid);
                } else {
                    RuntimeContext.setLog4jMDC("root");
                }
            } else {
                RuntimeContext.setLog4jMDC("root");
            }
        }
    }

    public static void resetThreadManInfo(Processor processor) {
        if (!enableReboot) {
            return;
        }
        if (processor.cp0.isMediaEngineCpu()) {
            return;
        }
        Memory mem = Memory.getInstance();
        int threadManInfo = Modules.LoadCoreForKernelModule.getThreadManInfo();
        if (threadManInfo != 0) {
            mem.write32(threadManInfo + 0, 0);
        }
        reboot.setLog4jMDC(processor);
    }

    public static void dumpAllThreads() {
        if (!enableReboot || !log.isTraceEnabled()) {
            return;
        }
        Memory mem = Memory.getInstance();
        int threadManInfo = Modules.LoadCoreForKernelModule.getThreadManInfo();
        if (threadManInfo == 0) {
            return;
        }
        int currentThread = mem.read32(threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoCurrentThreadOffset);
        int nextThread = mem.read32(threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoNextThreadOffset);
        if (Modules.LoadCoreForKernelModule.threadManInfoThreadTypeOffset != -1) {
            reboot.dumpThreadTypeList(mem, mem.read32(threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoThreadTypeOffset));
        }
        reboot.dumpThread(mem, currentThread, "Current thread");
        if (nextThread != 0 && nextThread != currentThread) {
            reboot.dumpThread(mem, nextThread, "Next thread");
        }
        reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoSleepingThreadsOffset, "Sleeping thread");
        reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoDelayedThreadsOffset, "Delayed thread");
        reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoStoppedThreadsOffset, "Stopped thread");
        reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoSuspendedThreadsOffset, "Suspended thread");
        reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoDeadThreadsOffset, "Dead thread");
        if (Modules.LoadCoreForKernelModule.threadManInfoUnknownThreadsOffset != -1) {
            reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoUnknownThreadsOffset, "??? thread");
        }
        for (int priority = 0; priority < 128; ++priority) {
            reboot.dumpThreadList(mem, threadManInfo + Modules.LoadCoreForKernelModule.threadManInfoReadyThreadsOffset + priority * 8, String.format("Ready thread[prio=0x%X]", priority));
        }
    }

    private static void dumpThreadTypeList(Memory mem, int list) {
        if (list == 0) {
            return;
        }
        int cb = mem.read32(list);
        while (cb != list) {
            SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
            sceSysmemUidCB.read(mem, cb);
            reboot.dumpThread(mem, cb + sceSysmemUidCB.size * 4, "Thread");
            cb = mem.read32(cb);
        }
    }

    private static void dumpThread(Memory mem, int address, String comment) {
        if (address == 0) {
            return;
        }
        int uid = mem.read32(address + 8);
        int status = mem.read32(address + 12);
        int currentPriority = mem.read32(address + 16);
        StringBuilder waitInfo = new StringBuilder();
        if (SceKernelThreadInfo.isWaitingStatus(status)) {
            int waitTypeCBaddr;
            int waitType = mem.read32(address + 88);
            if (waitType != 0) {
                waitInfo.append(String.format(", waitType=0x%X(%s)", waitType, SceKernelThreadInfo.getWaitName(waitType)));
            }
            if ((waitTypeCBaddr = mem.read32(address + 92)) != 0) {
                SceSysmemUidCB waitTypeCB = new SceSysmemUidCB();
                waitTypeCB.read(mem, waitTypeCBaddr);
                waitInfo.append(String.format(", waitUid=0x%X(%s)", waitTypeCB.uid, waitTypeCB.name));
            }
            if (waitType == 2) {
                int waitDelay = mem.read32(address + 96);
                waitInfo.append(String.format(", waitDelay=0x%X", waitDelay));
            } else if (waitType == 4) {
                int bits = mem.read32(address + 96);
                waitInfo.append(String.format(", waitEventFlagBits=0x%X", bits));
            }
        }
        int cb = SysMemForKernel.getCBFromUid(uid);
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.read(mem, cb);
        log.trace((Object)String.format("%s: uid=0x%X, name='%s', status=0x%X(%s), currentPriority=0x%X%s", comment, uid, sceSysmemUidCB.name, status, SceKernelThreadInfo.getStatusName(status), currentPriority, waitInfo));
    }

    private static void dumpThreadList(Memory mem, int list, String comment) {
        if (list == 0) {
            return;
        }
        int address = mem.read32(list);
        while (address != 0 && address != list) {
            reboot.dumpThread(mem, address, comment);
            address = mem.read32(address);
        }
    }

    private void addMMIORange(int startAddress, int length) {
        Compiler.getInstance().addMMIORange(startAddress, length);
    }

    private void addMMIORange(TPointer startAddress, int length) {
        this.addMMIORange(startAddress.getAddress(), length);
    }

    private boolean loadKbooti() {
        int offset;
        File kbootiFile = new File("kbooti.bin");
        if (!kbootiFile.canRead() || kbootiFile.length() <= 4096L) {
            return false;
        }
        byte[] kbooti = new byte[(int)kbootiFile.length()];
        try {
            FileInputStream is = new FileInputStream(kbootiFile);
            ((InputStream)is).read(kbooti);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            log.error((Object)"loadKbooti", (Throwable)e);
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Loading IPL from %s", kbootiFile));
        }
        if (Utilities.readUnaligned32(kbooti, (offset = 0) + 96) != 1) {
            offset += 4096;
        }
        Memory mem = RuntimeContextLLE.getMMIO();
        TPointer decryptBuffer = new TPointer(mem, -1076887552);
        int decryptBufferPages = 8;
        int decryptBufferSize = 4096;
        int nextAddr = 0;
        this.iplBase = 0;
        this.iplEntry = 0;
        for (int i = 0; i < 512 && this.iplEntry == 0; i += 2) {
            for (int j = 0; j < 32 && this.iplEntry == 0; j += 8) {
                decryptBuffer.setArray(0, kbooti, offset, 4096);
                offset += 4096;
                int dataSize = decryptBuffer.getValue32(112);
                int dataOffset = decryptBuffer.getValue32(116);
                int inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(decryptBuffer, 4096, decryptBuffer, inSize, 1);
                if (result != 0) {
                    log.error((Object)String.format("hleUtilsBufferCopyWithRange returned 0x%08X", result));
                }
                int addr = decryptBuffer.getValue32(0);
                int length = decryptBuffer.getValue32(4);
                this.iplEntry = decryptBuffer.getValue32(8);
                int checksum = decryptBuffer.getValue32(12);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("IPL block 0x%X: addr=0x%08X, length=0x%X, entry=0x%08X, checkSum=0x%08X", i, addr, length, this.iplEntry, checksum));
                }
                if (this.iplBase == 0) {
                    this.iplBase = addr;
                } else if (addr != nextAddr) {
                    log.error((Object)String.format("Error at IPL offset 0x%X: 0x%08X != 0x%08X", i, addr, nextAddr));
                }
                if (length > 0) {
                    mem.memcpy(addr, decryptBuffer.getAddress() + 16, length);
                }
                nextAddr = addr + length;
            }
        }
        this.iplSize = nextAddr - this.iplBase;
        if (this.iplBase == 0) {
            this.iplBase = decryptBuffer.getAddress();
            this.iplSize = 4096;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("IPL size=0x%X: %s", this.iplSize, Utilities.getMemoryDump(mem, this.iplBase, Math.min(this.iplSize, 1024))));
        }
        this.patchIpl(mem);
        this.addMMIORange(this.iplBase, this.iplSize);
        return true;
    }

    private int iplKirkCommand(TPointer outAddr, int outSize, TPointer inAddr, int inSize, int cmd) {
        if (MMIOHandlerKirk.getInstance().preDecrypt(outAddr, outSize, inAddr, inSize, cmd)) {
            return 0;
        }
        return Modules.semaphoreModule.hleUtilsBufferCopyWithRange(outAddr, outSize, inAddr, inSize, cmd);
    }

    private boolean loadIpl(boolean loadFromNand) {
        int result;
        Memory mem = RuntimeContextLLE.getMMIO();
        boolean isPsp3000 = Model.getModel() >= 2;
        TPointer nandSpareBuffer = new TPointer(this.preIplCopy, 2064);
        TPointer iplFatSectorBuffer = new TPointer(this.preIplCopy, 2076);
        if (loadFromNand) {
            int iplFatPpn = 128;
            while (true) {
                if ((result = this.preIplCopy.getValue32(340) == HLEUtilities.MOVE(2, 0) ? 0 : Modules.sceNandModule.hleNandReadPages(iplFatPpn, iplFatSectorBuffer, nandSpareBuffer, 1, true, false, true)) != 0) {
                    return false;
                }
                if (nandSpareBuffer.getValue32(4) == 1841711672) break;
                iplFatPpn += 32;
            }
        }
        TPointer decryptBuffer = new TPointer(mem, -1076887552);
        TPointer hashDecryptBuffer = new TPointer(decryptBuffer, 4044);
        TPointer hashBuffer = new TPointer(decryptBuffer, 4);
        TPointer checkHashBuffer = new TPointer(decryptBuffer, 3968);
        TPointer ecdsaSignatureBuffer = new TPointer(decryptBuffer, 4000);
        TPointer ecdsaMessageHash = new ByteArrayMemory(new byte[20]).getPointer();
        TPointer ecdsaSignature = new ByteArrayMemory(new byte[40]).getPointer();
        int hashSize = 20;
        int decryptBufferPages = 8;
        int decryptBufferSize = 4096;
        int nextAddr = 0;
        this.iplBase = 0;
        this.iplEntry = 0;
        int previousChecksum = 0;
        boolean ecdsaHash = false;
        for (int i = 0; i < 512 && this.iplEntry == 0; i += 2) {
            for (int j = 0; j < 32 && this.iplEntry == 0; j += 8) {
                int k;
                int length;
                int addr;
                for (int page = 0; page < 8; ++page) {
                    if (loadFromNand) {
                        int ppn = iplFatSectorBuffer.getUnsignedValue16(i) * 32;
                        if (ppn == 0) break;
                        result = Modules.sceNandModule.hleNandReadPages(ppn + j + page, new TPointer(decryptBuffer, page * 512), nandSpareBuffer, 1, true, false, true);
                        if (result != 0) {
                            return false;
                        }
                        if (nandSpareBuffer.getValue32(4) == 1841711672) continue;
                        return false;
                    }
                    MMIOHandlerMemoryStick.getInstance().readSector(j + page + 16, new TPointer(decryptBuffer, page * 512));
                }
                int dataSize = decryptBuffer.getValue32(112);
                int dataOffset = decryptBuffer.getValue32(116);
                int inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                int cmd = 1;
                if (isPsp3000) {
                    cmd = decryptBuffer.getValue32(96) & 3;
                    decryptBuffer.setUnsignedValue16(98, 0);
                    ecdsaHash = Utilities.hasBit(decryptBuffer.getValue32(100), 0);
                }
                if ((result = this.iplKirkCommand(decryptBuffer, 4096, decryptBuffer, inSize, cmd)) != 0) {
                    log.error((Object)String.format("hleUtilsBufferCopyWithRange cmd=0x%X returned 0x%08X", cmd, result));
                    return false;
                }
                if (isPsp3000) {
                    hashDecryptBuffer.setValue32(0, 5);
                    hashDecryptBuffer.setValue32(4, 0);
                    hashDecryptBuffer.setValue32(8, 0);
                    hashDecryptBuffer.setValue32(12, 108);
                    hashDecryptBuffer.setValue32(16, 20);
                    result = this.iplKirkCommand(hashDecryptBuffer, 20, hashDecryptBuffer, Utilities.alignUp(20, 15) + 20, 7);
                    if (result != 0) {
                        log.error((Object)String.format("hleUtilsBufferCopyWithRange KIRK_CMD_DECRYPT_IV_0 returned 0x%08X", result));
                        return false;
                    }
                    addr = decryptBuffer.getValue32(0);
                    length = decryptBuffer.getValue32(4);
                    TPointer ptr = new TPointer(decryptBuffer, length);
                    ptr.setValue32(16, addr);
                    ptr.setValue32(20, length);
                    hashBuffer.setValue32(0, length + 16);
                    result = this.iplKirkCommand(checkHashBuffer, 20, hashBuffer, length + 20, 11);
                    if (result != 0) {
                        log.error((Object)String.format("hleUtilsBufferCopyWithRange KIRK_CMD_SHA1_HASH returned 0x%08X", result));
                        return false;
                    }
                    decryptBuffer.setValue32(4, length);
                    for (k = 0; k < 20; k += 4) {
                        if (checkHashBuffer.getValue32(k) != hashDecryptBuffer.getValue32(k)) {
                            log.error((Object)String.format("IPL invalid hash at offset 0x%X: 0x%08X != 0x%08X", k, checkHashBuffer.getValue32(k), hashDecryptBuffer.getValue32(k)));
                            return false;
                        }
                        ecdsaMessageHash.setValue32(k, ecdsaMessageHash.getValue32(k) ^ checkHashBuffer.getValue32(k));
                    }
                    ecdsaSignature.memcpy(ecdsaSignatureBuffer, 40);
                    for (k = dataSize; k < 4096; k += 4) {
                        decryptBuffer.setValue32(k, 13);
                    }
                }
                addr = decryptBuffer.getValue32(0);
                length = decryptBuffer.getValue32(4);
                this.iplEntry = decryptBuffer.getValue32(8);
                int checksum = decryptBuffer.getValue32(12);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("IPL block 0x%X: addr=0x%08X, length=0x%X, entry=0x%08X, checkSum=0x%08X", i, addr, length, this.iplEntry, checksum));
                }
                if (previousChecksum != checksum) {
                    log.error((Object)String.format("IPL checksum=0x%08X not matching previousChecksum=0x%08X", checksum, previousChecksum));
                    return false;
                }
                if (this.iplBase == 0) {
                    this.iplBase = addr;
                } else if (addr != nextAddr) {
                    log.error((Object)String.format("Error at IPL offset 0x%X: 0x%08X != 0x%08X", i, addr, nextAddr));
                }
                if (length > 0 && addr != 0) {
                    previousChecksum = 0;
                    for (k = 0; k < length; k += 4) {
                        int value = decryptBuffer.getValue32(16 + k);
                        mem.write32(addr + k, value);
                        previousChecksum += value;
                    }
                }
                nextAddr = addr + length;
            }
        }
        if (isPsp3000) {
            if (!ecdsaHash) {
                return false;
            }
            byte[] ecdsaPublicKey = new byte[]{-68, 102, 6, 17, -89, 11, -41, -14, -47, 64, -92, -126, 21, -64, -106, -47, 29, 45, 65, 18, -16, -23, 55, -102, -60, -32, -45, -121, -59, 66, -48, -111, 52, -99, -47, 81, 105, -35, 90, -121};
            decryptBuffer.setArray(0, ecdsaPublicKey);
            decryptBuffer.memcpy(40, ecdsaMessageHash, 20);
            ecdsaMessageHash.clear(20);
            decryptBuffer.memcpy(60, ecdsaSignature, 40);
            ecdsaSignatureBuffer.clear(40);
            result = this.iplKirkCommand(TPointer.NULL, 0, decryptBuffer, 100, 17);
            if (result != 0) {
                log.error((Object)String.format("hleUtilsBufferCopyWithRange KIRK_CMD_ECDSA_VERIFY returned 0x%08X", result));
                return false;
            }
            decryptBuffer.clear(100);
            mem.write32(-1077932036, 537331984);
        }
        this.iplSize = nextAddr - this.iplBase;
        if (this.iplBase == 0) {
            this.iplBase = decryptBuffer.getAddress();
            this.iplSize = 4096;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("IPL size=0x%X: %s", this.iplSize, Utilities.getMemoryDump(mem, this.iplBase, this.iplSize)));
        }
        this.patchIpl(mem);
        this.addMMIORange(this.iplBase, this.iplSize);
        return true;
    }

    private void patchIplKey(TPointer keyAddr, int[] keyWithoutPreIpl, int[] keyWithPreIpl) {
        int checksum = 0;
        for (int i = 0; i < keyWithoutPreIpl.length; ++i) {
            keyAddr.setUnsignedValue8(i, keyWithoutPreIpl[i] ^ keyWithPreIpl[i] ^ keyAddr.getUnsignedValue8(i));
            checksum += keyWithoutPreIpl[i];
        }
        keyAddr.setUnsignedValue8(32, checksum);
    }

    private void patchIpl(Memory mem) {
        TPointer keyAddr = null;
        int iplKeyValue = 0;
        if (Memory.isAddressGood(this.iplBase)) {
            keyAddr = new TPointer(mem, this.iplBase + 10368);
            iplKeyValue = keyAddr.getValue32(0);
        }
        switch (iplKeyValue) {
            case 1494326223: {
                int[] keyWithoutPreIpl = new int[]{24, 42, 114, 162, 85, 67, 86, 216, 10, 95, 135, 87, 119, 185, 143, 147, 162, 168, 196, 251, 72, 15, 209, 37, 97, 150, 74, 223, 0, 0, 0, 0};
                int[] keyWithPreIpl = new int[]{16, 124, 213, 9, 106, 181, 137, 118, 73, 246, 234, 84, 11, 48, 62, 43, 71, 23, 109, 11, 4, 112, 62, 176, 60, 1, 68, 137, 0, 0, 0, 0};
                this.patchIplKey(keyAddr, keyWithoutPreIpl, keyWithPreIpl);
                break;
            }
            case -1134218516: {
                int[] keyWithoutPreIpl = new int[]{131, 3, 92, 144, 170, 89, 3, 134, 233, 124, 153, 148, 161, 192, 130, 120, 168, 138, 126, 113, 146, 90, 3, 43, 232, 238, 190, 59, 0, 0, 0, 0};
                int[] keyWithPreIpl = new int[]{135, 157, 12, 22, 66, 193, 153, 253, 119, 194, 67, 47, 69, 189, 96, 37, 180, 167, 90, 66, 23, 81, 241, 21, 218, 31, 218, 2, 0, 0, 0, 0};
                this.patchIplKey(keyAddr, keyWithoutPreIpl, keyWithPreIpl);
                break;
            }
            default: {
                int hashDigestPatchAddr = this.iplBase + 4644;
                if (mem.read32(hashDigestPatchAddr) == HLEUtilities.JAL(this.iplBase + 3588)) {
                    mem.write32(this.iplBase + 4644, HLEUtilities.SYSCALL(this, "hleIplHashDigestPatch"));
                    break;
                }
                log.error((Object)String.format("patchIpl unknown IPL code at 0x%08X for PSP Model %s", this.iplBase, Model.getModelName()));
            }
        }
    }

    @HLEFunction(nid=-1, version=150)
    public int hlePreIplStart() {
        this.loadIpl(true);
        int continueAddress = this.iplEntry;
        int opcode = this.preIplCopy.getValue32(252);
        if ((opcode & 0xFFFF0000) == HLEUtilities.LUI(25, 0)) {
            continueAddress = opcode << 16;
            this.addMMIORange(continueAddress, 12288);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hlePreIplStart continueAddress=0x%08X", continueAddress));
        }
        return continueAddress;
    }

    @HLEFunction(nid=-1, version=150)
    public int hlePreIplNandReadPage(int ppn, TPointer user, TPointer spare) {
        return Modules.sceNandModule.hleNandReadPages(ppn, user, spare, 1, true, false, true);
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePreIplIcacheInvalidateAll() {
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePreIplDcacheWritebackInvalidateAll() {
    }

    @HLEFunction(nid=-1, version=150)
    public int hlePreIplMemoryStickReadSector(int lba, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer address) {
        MMIOHandlerMemoryStick.getInstance().readSector(lba, address);
        this.addMMIORange(address, 512);
        return 0;
    }

    private byte[] getHashDigest() {
        switch (Model.getGeneration()) {
            case 3: {
                return new byte[]{65, 56, -99, -76, 11, -111, 36, -104, 55, -1, 61, 73, 19, 92, 90, 88, -82, -41, 55, 22, 87, 30, 16, 79, -13, 32, -2, -91};
            }
            case 4: {
                return new byte[]{-74, -119, -106, 9, 104, -14, 65, -91, -77, 126, 39, 18, 85, -90, -69, 28, -21, 81, -18, 11, 36, -127, -98, -84, -20, 104, 59, 80};
            }
            case 7: {
                return new byte[]{127, 64, 102, -119, -41, 83, 126, 101, 116, -14, 43, 91, 36, -113, -25, -49, -2, -88, -17, 56, 94, -64, 77, 13, -53, -83, -37, 57};
            }
            case 9: {
                return new byte[]{-42, 24, 18, 14, 62, 43, -23, -33, 30, -64, -115, -44, 51, -27, -123, -124, 74, -58, -73, -17, 49, -1, 22, -25, 3, -7, 126, 63};
            }
            case 11: {
                return new byte[]{-55, -8, -3, -85, -105, -24, 20, 68, -83, 95, -109, 76, 30, 97, 9, 73, 67, 114, -79, 86, -111, 96, 59, 103, -95, 45, -102, 68};
            }
        }
        log.error((Object)String.format("getHashDigest unimplemented for PSP model %s", Model.getModelName()));
        return null;
    }

    @HLEFunction(nid=-1, version=150)
    public void hleIplHashDigestPatch(CpuState cpu) {
        byte[] hashDigest = this.getHashDigest();
        int hashDigestAddr = cpu._t0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleIplHashDigestPatch writing hash digest to 0x%08X", hashDigestAddr));
        }
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(this.getMemory(), hashDigestAddr, hashDigest.length, 1);
        for (int i = 0; i < hashDigest.length; ++i) {
            memoryWriter.writeNext(hashDigest[i]);
        }
        memoryWriter.flush();
    }

    private static class SetLog4jMDC
    implements IAction {
        private SetLog4jMDC() {
        }

        @Override
        public void execute() {
            reboot.setLog4jMDC(Emulator.getProcessor());
        }
    }
}

