/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.MemoryInputStream;
import org.apache.log4j.Logger;

public class sceDeflt
extends HLEModule {
    public static Logger log = Modules.getLogger("sceDeflt");
    protected static final int GZIP_MAGIC = 35615;

    @HLEUnimplemented
    @HLEFunction(nid=786668132, version=150)
    public int sceZlibAdler32() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1141198339, version=150)
    public int sceDeflateDecompress() {
        return 0;
    }

    @HLEFunction(nid=1841100951, version=150)
    public int sceGzipDecompress(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.returnValue, usage=BufferInfo.Usage.out) TPointer outBufferAddr, int outBufferLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer inBufferAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 crc32Addr) {
        int result;
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int decompressedLength;
            int length;
            GZIPInputStream is = new GZIPInputStream(new MemoryInputStream(inBufferAddr.getAddress()));
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outBufferAddr.getAddress(), outBufferLength, 1);
            for (decompressedLength = 0; decompressedLength < outBufferLength && (length = is.read(buffer)) >= 0; decompressedLength += length) {
                if (decompressedLength + length > outBufferLength) {
                    log.warn((Object)String.format("sceGzipDecompress : decompress buffer too small inBuffer=%s, outLength=%d", inBufferAddr, outBufferLength));
                    is.close();
                    return -2147483388;
                }
                crc32.update(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    memoryWriter.writeNext(buffer[i] & 0xFF);
                }
            }
            is.close();
            memoryWriter.flush();
            result = decompressedLength;
        }
        catch (IOException e) {
            log.error((Object)"sceGzipDecompress", (Throwable)e);
            return -2147483384;
        }
        crc32Addr.setValue((int)crc32.getValue());
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1217922656, version=150)
    public int sceGzipGetComment() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=195279308, version=150)
    public int sceGzipGetCompressedData() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1968690030, version=150)
    public int sceGzipGetInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=275395922, version=150)
    public int sceGzipGetName() {
        return 0;
    }

    @HLEFunction(nid=458982076, version=150)
    public boolean sceGzipIsValid(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer gzipData) {
        int magic = gzipData.getUnsignedValue16();
        return magic == 35615;
    }

    @HLEFunction(nid=-1444611288, version=150)
    public int sceZlibDecompress(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.returnValue, usage=BufferInfo.Usage.out) TPointer outBufferAddr, int outBufferLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer inBufferAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 crc32Addr) {
        byte[] inBuffer = new byte[4096];
        byte[] outBuffer = new byte[4096];
        int inBufferPtr = 0;
        IMemoryReader reader = MemoryReader.getMemoryReader(inBufferAddr.getAddress(), 1);
        IMemoryWriter writer = MemoryWriter.getMemoryWriter(outBufferAddr.getAddress(), outBufferLength, 1);
        CRC32 crc32 = new CRC32();
        Inflater inflater = new Inflater();
        while (!inflater.finished()) {
            if (inflater.needsInput()) {
                for (inBufferPtr = 0; inBufferPtr < inBuffer.length; ++inBufferPtr) {
                    inBuffer[inBufferPtr] = (byte)reader.readNext();
                }
                inflater.setInput(inBuffer);
            }
            try {
                int count = inflater.inflate(outBuffer);
                if (inflater.getTotalOut() > outBufferLength) {
                    log.warn((Object)String.format("sceZlibDecompress : zlib decompress buffer too small inBuffer=%s, outLength=%d", inBufferAddr, outBufferLength));
                    return -2147483388;
                }
                crc32.update(outBuffer, 0, count);
                for (int i = 0; i < count; ++i) {
                    writer.writeNext(outBuffer[i] & 0xFF);
                }
            }
            catch (DataFormatException e) {
                log.warn((Object)String.format("sceZlibDecompress : malformed zlib stream inBuffer=%s", inBufferAddr));
                return -2147483384;
            }
        }
        writer.flush();
        crc32Addr.setValue((int)crc32.getValue());
        return inflater.getTotalOut();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1783923831, version=150)
    public int sceZlibGetCompressedData() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1344266285, version=150)
    public int sceZlibGetInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-462505594, version=150)
    public int sceZlibIsValid() {
        return 0;
    }
}

