/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.MainGUI;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.graphics.DisplayScreen;
import jpcsp.graphics.FrameBufferSettings;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.RenderingEngineFactory;
import jpcsp.graphics.RE.RenderingEngineLwjgl;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.TextureSettings;
import jpcsp.graphics.VertexCache;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.VideoEngineThread;
import jpcsp.graphics.VideoEngineUtilities;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.graphics.textures.GETexture;
import jpcsp.graphics.textures.GETextureManager;
import jpcsp.graphics.textures.TextureCache;
import jpcsp.hardware.Screen;
import jpcsp.scheduler.UnblockThreadAction;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.AbstractStringSettingsListener;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.lwjgl.opengl.awt.AWTGLCanvas;
import org.lwjgl.opengl.awt.GLData;
import org.lwjgl.opengl.awt.PlatformLinuxGLCanvas;
import org.lwjgl.opengl.awt.PlatformWin32GLCanvas;

public class sceDisplay
extends HLEModule {
    public static Logger log = Modules.getLogger("sceDisplay");
    private static final boolean multiThreadingLockDisplay = false;
    private static final boolean dumpDepthBuffer = false;
    protected AWTGLCanvas_sceDisplay canvas;
    private boolean saveGEToTexture = false;
    private boolean useSoftwareRenderer = false;
    private boolean saveStencilToMemory = false;
    private static final boolean useDebugGL = false;
    private static final String resizeScaleFactorSettings = "emu.graphics.resizeScaleFactor";
    public static final int PSP_DISPLAY_MODE_LCD = 0;
    public static final int PSP_DISPLAY_MODE_VESA1A = 26;
    public static final int PSP_DISPLAY_MODE_PSEUDO_VGA = 96;
    public static final int PSP_DISPLAY_SETBUF_IMMEDIATE = 0;
    public static final int PSP_DISPLAY_SETBUF_NEXTFRAME = 1;
    private static final float hCountPerVblank = 285.72f;
    private static final float FRAME_PER_SEC = 59.94006f;
    private IRenderingEngine re;
    private IRenderingEngine reDisplay;
    private boolean startModules;
    private boolean isStarted;
    private boolean resetDisplaySettings;
    private boolean resetGeTextures;
    private int mode;
    private boolean resizePending;
    private FrameBufferSettings fb;
    private FrameBufferSettings ge;
    private int sync;
    private boolean setGeBufCalledAtLeastOnce;
    public boolean gotBadGeBufParams;
    public boolean gotBadFbBufParams;
    protected boolean isFbShowing;
    private DisplayScreen displayScreen;
    private boolean detailsDirty;
    private boolean displayDirty;
    private boolean geDirty;
    private long lastUpdate;
    private boolean initGLcalled;
    private String openGLversion;
    private boolean calledFromCommandLine;
    private volatile boolean doneCopyGeToMemory;
    private Buffer temp;
    private ByteBuffer tempByteBuffer;
    private int[] tempIntArray;
    private int tempSize;
    private int canvasWidth;
    private int canvasHeight;
    private boolean createTex;
    private int texFb;
    private int resizedTexFb;
    private float texS;
    private float texT;
    private Robot captureRobot;
    private long prevStatsTime;
    private long frameCount;
    private long paintFrameCount;
    private long prevFrameCount;
    private long prevPaintFrameCount;
    private long reportCount;
    private int vcount;
    private long lastVblankMicroTime;
    private DisplayVblankAction displayVblankAction;
    public DurationStatistics statistics;
    private AsyncDisplayThread asyncDisplayThread;
    private SoftwareRenderingDisplayThread softwareRenderingDisplayThread;
    private volatile boolean insideRendering;
    private List<WaitVblankInfo> waitingOnVblank;
    private int antiAliasSamplesNum;
    private int desiredFps = 0;
    private int maxFramesSkippedInSequence = 3;
    private int framesSkippedInSequence;
    private LinkedList<Long> frameTimestamps = new LinkedList();
    private boolean skipNextFrameBufferSwitch;
    private int framePerSecFactor;
    private List<IAction> displayActions = new LinkedList<IAction>();
    private List<IAction> displayActionsOnce = new LinkedList<IAction>();
    private Semaphore lockDisplay = new Semaphore(1);
    private Map<Integer, TextureSettings> getTextureSettingsDone = new HashMap<Integer, TextureSettings>();
    private Set<Integer> getTextureSettingsPending = new HashSet<Integer>();

    public AWTGLCanvas_sceDisplay getCanvas() {
        return this.canvas;
    }

    public sceDisplay() {
        this.setSettingsListener("emu.graphics.antialias", new AntiAliasSettingsListerner());
        DisplaySettingsListener displaySettingsListener = new DisplaySettingsListener();
        this.setSettingsListener("emu.useVertexCache", displaySettingsListener);
        this.setSettingsListener("emu.useshaders", displaySettingsListener);
        this.setSettingsListener("emu.useGeometryShader", displaySettingsListener);
        this.setSettingsListener("emu.disableubo", displaySettingsListener);
        this.setSettingsListener("emu.enablevao", displaySettingsListener);
        this.setSettingsListener("emu.enablegetexture", displaySettingsListener);
        this.setSettingsListener("emu.enablenativeclut", displaySettingsListener);
        this.setSettingsListener("emu.enabledynamicshaders", displaySettingsListener);
        this.setSettingsListener("emu.enableshaderstenciltest", displaySettingsListener);
        this.setSettingsListener("emu.enableshadercolormask", displaySettingsListener);
        this.displayScreen = new DisplayScreen();
        this.canvas = new AWTGLCanvas_sceDisplay(this.createGLData());
        this.setScreenResolution(this.displayScreen.getWidth(), this.displayScreen.getHeight());
        if (Emulator.getMainGUI() != null && !Emulator.getMainGUI().isFullScreen()) {
            this.setViewportResizeScaleFactor(Settings.getInstance().readFloat(resizeScaleFactorSettings, 1.0f));
        }
        this.texFb = -1;
        this.resizedTexFb = -1;
        this.startModules = false;
        this.isStarted = false;
        this.resizePending = false;
        this.tempSize = 0;
        this.fb = new FrameBufferSettings(0x4000000, 512, 480, 272, 3);
        this.ge = new FrameBufferSettings(this.fb);
    }

    public void lockDisplay() {
    }

    public void unlockDisplay() {
    }

    private GLData createGLData() {
        GLData glData = new GLData();
        glData.redSize = 8;
        glData.blueSize = 8;
        glData.greenSize = 8;
        glData.alphaSize = 8;
        glData.stencilSize = 8;
        glData.samples = this.antiAliasSamplesNum;
        glData.debug = false;
        glData.swapInterval = 0;
        return glData;
    }

    public void setDesiredFPS(int desiredFPS) {
        this.desiredFps = desiredFPS;
    }

    public int getDesiredFPS() {
        return this.desiredFps;
    }

    public final void setScreenResolution(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.canvas.setSize(width, height);
    }

    public void setViewportResizeScaleFactor(int width, int height) {
        float scaleAspectRatio;
        float scaleWidth = (float)width / (float)this.displayScreen.getWidth();
        float scaleHeight = (float)height / (float)this.displayScreen.getHeight();
        if (Emulator.getMainGUI() != null && Emulator.getMainGUI().isFullScreen()) {
            Dimension fullScreenDimension = MainGUI.getFullScreenDimension();
            scaleAspectRatio = fullScreenDimension.width == width && fullScreenDimension.height > height ? scaleWidth : (fullScreenDimension.height == height && fullScreenDimension.width > width ? scaleHeight : Math.min(scaleWidth, scaleHeight));
        } else {
            scaleAspectRatio = (scaleWidth + scaleHeight) / 2.0f;
        }
        this.setViewportResizeScaleFactor(scaleAspectRatio);
        this.resizePending = true;
    }

    public void forceSetViewportResizeScaleFactor(float viewportResizeFilterScaleFactor) {
        if (!Emulator.getMainGUI().isFullScreen()) {
            Settings.getInstance().writeFloat(resizeScaleFactorSettings, viewportResizeFilterScaleFactor);
        }
        this.resetGeTextures = true;
        VideoEngineUtilities.setViewportResizeScaleFactor(viewportResizeFilterScaleFactor);
        Dimension size = new Dimension(VideoEngineUtilities.getResizedWidth(this.displayScreen.getWidth()), VideoEngineUtilities.getResizedHeight(this.displayScreen.getHeight()));
        this.canvas.setSize(size);
        this.canvas.setPreferredSize(size);
        if (Emulator.getMainGUI().isFullScreen()) {
            Emulator.getMainGUI().setFullScreenDisplaySize();
        }
        this.createTex = true;
        if (ExternalGE.isActive()) {
            ExternalGE.setScreenScale(VideoEngineUtilities.getViewportResizeScaleFactorInt());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setViewportResizeScaleFactor resize=%f, size(%dx%d), canvas(%dx%d), location(%d,%d)", Float.valueOf(viewportResizeFilterScaleFactor), size.width, size.height, this.canvasWidth, this.canvasHeight, this.canvas.getLocation().x, this.canvas.getLocation().y));
        }
    }

    public void setViewportResizeScaleFactor(float viewportResizeFilterScaleFactor) {
        if (viewportResizeFilterScaleFactor < 1.0f) {
            return;
        }
        if (viewportResizeFilterScaleFactor != VideoEngineUtilities.getViewportResizeScaleFactor()) {
            this.forceSetViewportResizeScaleFactor(viewportResizeFilterScaleFactor);
        }
    }

    public boolean isDisplaySwappedXY() {
        return this.displayScreen.isSwappedXY();
    }

    private void setAntiAliasSamplesNum(int samples) {
        this.antiAliasSamplesNum = samples;
    }

    public void setFramePerSecFactor(int framePerSecFactor) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("setFramePerSecFactor %d", framePerSecFactor));
        }
        this.framePerSecFactor = framePerSecFactor;
    }

    @Override
    public void start() {
        this.statistics = new DurationStatistics("sceDisplay Statistics");
        VideoEngineUtilities.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("initGL called = %b, OpenGL Version = %s", this.initGLcalled, this.openGLversion));
        }
        if (!this.initGLcalled && !this.calledFromCommandLine) {
            throw new RuntimeException("Jpcsp cannot display.\nThe cause could be that you are using an old graphic card driver (try to update it)\nor your display format is not compatible with Jpcsp (try to change your display format, Jpcsp requires 32 bit color depth)\nor the anti-aliasing settings is not supported by your display (leave the Jpcsp anti-aliasing to its default setting)");
        }
        if (!HLEModuleManager.getInstance().isStartFromSyscall()) {
            this.mode = 0;
            this.fb = new FrameBufferSettings(0x4000000, 512, 480, 272, 3);
            this.ge = new FrameBufferSettings(this.fb);
            this.sync = 0;
            this.texS = (float)this.fb.getWidth() / 512.0f;
            this.texT = (float)this.fb.getHeight() / (float)Utilities.makePow2(this.fb.getHeight());
            this.displayScreen.update(this.texS, this.texT);
            this.createTex = true;
        }
        this.detailsDirty = true;
        this.displayDirty = true;
        this.geDirty = false;
        this.isFbShowing = false;
        this.setGeBufCalledAtLeastOnce = false;
        this.gotBadGeBufParams = false;
        this.gotBadFbBufParams = false;
        this.prevStatsTime = 0L;
        this.frameCount = 0L;
        this.paintFrameCount = 0L;
        this.prevFrameCount = 0L;
        this.prevPaintFrameCount = 0L;
        this.reportCount = 0L;
        this.insideRendering = false;
        this.framePerSecFactor = 1;
        this.vcount = 0;
        if (this.asyncDisplayThread == null) {
            this.asyncDisplayThread = new AsyncDisplayThread();
            this.asyncDisplayThread.setDaemon(true);
            this.asyncDisplayThread.setName("Async Display Thread");
            this.asyncDisplayThread.start();
        }
        if (this.displayVblankAction == null) {
            this.displayVblankAction = new DisplayVblankAction();
            IntrManager.getInstance().addVBlankAction(this.displayVblankAction);
        }
        this.waitingOnVblank = new LinkedList<WaitVblankInfo>();
        this.startModules = true;
        this.re = null;
        this.reDisplay = null;
        this.resetDisplaySettings = false;
        this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
        if (this.saveGEToTexture) {
            log.info((Object)"Saving GE to Textures");
        }
        try {
            this.captureRobot = new Robot();
            this.captureRobot.setAutoDelay(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSettingsListener("emu.useSoftwareRenderer", new SoftwareRendererSettingsListener());
        this.setSettingsListener("emu.saveStencilToMemory", new SaveStencilToMemorySettingsListener());
        super.start();
    }

    @Override
    public void stop() {
        VideoEngine.getInstance().stop();
        if (this.asyncDisplayThread != null) {
            this.asyncDisplayThread.exit();
            this.asyncDisplayThread = null;
        }
        this.re = null;
        this.reDisplay = null;
        this.startModules = false;
        this.isStarted = false;
        VideoEngineUtilities.stop();
        super.stop();
    }

    public void exit() {
        if (this.statistics != null) {
            // empty if block
        }
    }

    public void step(boolean immediately) {
        long now = System.currentTimeMillis();
        if (immediately || now - this.lastUpdate > 16L || this.geDirty) {
            if (this.geDirty || this.detailsDirty || this.displayDirty) {
                this.detailsDirty = false;
                this.displayDirty = false;
                this.geDirty = false;
                this.asyncDisplayThread.display();
            }
            this.lastUpdate = now;
        }
    }

    public void step() {
        this.step(false);
    }

    public void clear() {
        this.getMemory().memset(0x4000000, (byte)0, 0x200000);
        this.setGeDirty(true);
        this.step(true);
    }

    public final void write8(int rawAddress) {
        if (this.fb.isRawAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public final void write16(int rawAddress) {
        if (this.fb.isRawAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public final void write32(int rawAddress) {
        if (this.fb.isRawAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public final void write(int rawAddress) {
        if (this.fb.isAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public IRenderingEngine getRenderingEngine() {
        return this.re;
    }

    public void setRenderingEngine(IRenderingEngine re) {
        this.re = re;
    }

    public void setGeDirty(boolean dirty) {
        this.geDirty = dirty;
        if (dirty) {
            if (this.softwareRenderingDisplayThread != null) {
                this.softwareRenderingDisplayThread.display();
            } else {
                VideoEngine.getInstance().onUpdateDrawList();
            }
        }
    }

    public void hleDisplaySetGeMode(int width, int height) {
        if (width <= 0 || height <= 0) {
            log.warn((Object)String.format("hleDisplaySetGeMode width=%d, height=%d bad params", width, height));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleDisplaySetGeMode width=%d, height=%d", width, height));
            }
            this.ge.setDimension(width, height);
        }
    }

    public void hleDisplaySetGeBuf(int topaddr, int bufferwidth, int pixelformat, boolean copyGEToMemory, boolean forceLoadGEToScreen) {
        this.hleDisplaySetGeBuf(topaddr, bufferwidth, pixelformat, copyGEToMemory, forceLoadGEToScreen, this.ge.getWidth(), this.ge.getHeight());
    }

    public void hleDisplaySetGeBuf(int topaddr, int bufferwidth, int pixelformat, boolean copyGEToMemory, boolean forceLoadGEToScreen, int width, int height) {
        boolean loadGEToScreen;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, copyGE=%b, with=%d, height=%d", topaddr, bufferwidth, pixelformat, copyGEToMemory, width, height));
        }
        if (this.isUsingSoftwareRenderer() || VideoEngine.getInstance().isSkipThisFrame()) {
            copyGEToMemory = false;
            forceLoadGEToScreen = false;
        }
        if ((topaddr = topaddr & 0xFFFFF0 | 0x4000000) == this.ge.getTopAddr() && (bufferwidth &= 0xFFFFFFFC) == this.ge.getBufferWidth() && pixelformat == this.ge.getPixelFormat() && width == this.ge.getWidth() && height == this.ge.getHeight()) {
            if (forceLoadGEToScreen) {
                VideoEngineUtilities.loadGEToScreen(this.re);
            }
            return;
        }
        if (topaddr < 0x4000000 || topaddr >= 0x41FFFFF || bufferwidth <= 0 || pixelformat < 0 || pixelformat > 3 || this.sync != 0 && this.sync != 1) {
            if (this.setGeBufCalledAtLeastOnce && bufferwidth != 0) {
                log.warn((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d bad params", topaddr, bufferwidth, pixelformat));
                this.gotBadGeBufParams = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d bad params", topaddr, bufferwidth, pixelformat));
                }
                this.setGeBufCalledAtLeastOnce = true;
            }
            return;
        }
        if (this.gotBadGeBufParams) {
            this.gotBadGeBufParams = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d OK", topaddr, bufferwidth, pixelformat));
            }
        }
        if (this.re.isVertexArrayAvailable()) {
            this.re.bindVertexArray(0);
        }
        boolean bl = loadGEToScreen = !this.isUsingSoftwareRenderer() && !VideoEngine.getInstance().isSkipThisFrame();
        if (copyGEToMemory && (this.ge.getTopAddr() != topaddr || this.ge.getPixelFormat() != pixelformat)) {
            VideoEngineUtilities.copyGeToMemory(this.re, false, false);
            loadGEToScreen = true;
        }
        this.ge = new FrameBufferSettings(topaddr, bufferwidth, width, height, pixelformat);
        this.checkTemp();
        if (loadGEToScreen) {
            VideoEngineUtilities.loadGEToScreen(this.re);
            if (State.dumpGeNextFrame) {
                this.dumpGeImage();
            }
        }
        this.setGeBufCalledAtLeastOnce = true;
    }

    public boolean isGeAddress(int address) {
        if (ExternalGE.isActive()) {
            return ExternalGE.isGeAddress(address);
        }
        return this.ge.isAddressInside(address);
    }

    public boolean isFbAddress(int address) {
        return this.fb.isAddressInside(address);
    }

    public boolean isSaveStencilToMemory() {
        return this.saveStencilToMemory;
    }

    public void setSaveStencilToMemory(boolean saveStencilToMemory) {
        this.saveStencilToMemory = saveStencilToMemory;
        log.info((Object)String.format("Save Stencil To Memory: %b", saveStencilToMemory));
    }

    public void setUseSoftwareRenderer(boolean useSoftwareRenderer) {
        this.useSoftwareRenderer = useSoftwareRenderer;
        if (useSoftwareRenderer) {
            if (!Screen.hasScreen() && this.softwareRenderingDisplayThread == null) {
                this.softwareRenderingDisplayThread = new SoftwareRenderingDisplayThread();
                this.softwareRenderingDisplayThread.setDaemon(true);
                this.softwareRenderingDisplayThread.setName("GUI");
                this.softwareRenderingDisplayThread.start();
                log.debug((Object)"Starting Software Rendering Display Thread");
            }
        } else if (this.softwareRenderingDisplayThread != null) {
            log.debug((Object)"Stopping Software Rendering Display Thread");
            this.softwareRenderingDisplayThread.exit();
            this.softwareRenderingDisplayThread = null;
        }
        if (this.isStarted) {
            this.resetDisplaySettings = true;
        }
    }

    public boolean isUsingSoftwareRenderer() {
        return this.useSoftwareRenderer;
    }

    public void rotate(int angleId) {
        switch (angleId) {
            case 0: {
                this.displayScreen = new DisplayScreen.DisplayScreenRotation90();
                break;
            }
            case 1: {
                this.displayScreen = new DisplayScreen.DisplayScreenRotation270();
                break;
            }
            case 2: {
                this.displayScreen = new DisplayScreen.DisplayScreenRotation180();
                break;
            }
            case 3: {
                this.displayScreen = new DisplayScreen.DisplayScreenMirrorX(new DisplayScreen());
                break;
            }
            case 4: {
                this.displayScreen = new DisplayScreen();
            }
        }
        VideoEngineUtilities.updateDisplaySize();
    }

    public void saveScreen() {
        String fileName;
        String fileFormat = "png";
        int id = 1;
        while (new File(fileName = String.format("%s-Shot-%d.%s", State.discId, id, fileFormat)).exists()) {
            ++id;
        }
        Rectangle rect = Emulator.getMainGUI().getCaptureRectangle();
        try {
            BufferedImage img = this.captureRobot.createScreenCapture(rect);
            ImageIO.write((RenderedImage)img, fileFormat, new File(fileName));
            img.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error saving screenshot", (Throwable)e);
        }
    }

    public int getTopAddrFb() {
        return this.fb.getTopAddr();
    }

    public int getBufferWidthFb() {
        return this.fb.getBufferWidth();
    }

    public int getPixelFormatFb() {
        return this.fb.getPixelFormat();
    }

    public int getSync() {
        return this.sync;
    }

    public int getWidthFb() {
        return this.fb.getWidth();
    }

    public int getHeightFb() {
        return this.fb.getHeight();
    }

    public int getTopAddrGe() {
        return this.ge.getTopAddr();
    }

    public int getBottomAddrGe() {
        return this.ge.getBottomAddr();
    }

    public int getBufferWidthGe() {
        return this.ge.getBufferWidth();
    }

    public int getWidthGe() {
        return this.ge.getWidth();
    }

    public int getHeightGe() {
        return this.ge.getHeight();
    }

    public int getPixelFormatGe() {
        return this.ge.getPixelFormat();
    }

    public BufferInfo getBufferInfoGe() {
        return new BufferInfo(this.ge.getTopAddr(), this.ge.getBottomAddr(), this.ge.getWidth(), this.ge.getHeight(), this.ge.getBufferWidth(), this.ge.getPixelFormat());
    }

    public BufferInfo getBufferInfoFb() {
        return new BufferInfo(this.fb.getTopAddr(), this.fb.getBottomAddr(), this.fb.getWidth(), this.fb.getHeight(), this.fb.getBufferWidth(), this.fb.getPixelFormat());
    }

    public boolean getSaveGEToTexture() {
        return this.saveGEToTexture;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public Buffer getPixelsGe() {
        return this.ge.getPixels();
    }

    public int getSizeGe() {
        return this.ge.getSize();
    }

    public Buffer getPixelsGe(int topAddr) {
        return this.ge.getPixels(topAddr);
    }

    public DisplayScreen getDisplayScreen() {
        return this.displayScreen;
    }

    public float getTexS() {
        return this.texS;
    }

    public float getTexT() {
        return this.texT;
    }

    public ByteBuffer getTempByteBuffer() {
        return this.tempByteBuffer;
    }

    public Buffer getTempBuffer() {
        return this.temp;
    }

    public void dumpGeImage() {
        if (this.isUsingSoftwareRenderer()) {
            Buffer buffer = Memory.getInstance().getBuffer(this.ge.getTopAddr(), this.ge.getBufferWidth() * this.ge.getHeight() * VideoEngineUtilities.getPixelFormatBytes(this.ge.getPixelFormat()));
            CaptureManager.dumpImage(this.ge.getTopAddr(), 0, buffer, this.ge.getWidth(), this.ge.getHeight(), this.ge.getBufferWidth(), this.ge.getPixelFormat(), false, 0, false, false);
            return;
        }
        int texGe = this.re.genTexture();
        int texturePixelFormat = VideoEngineUtilities.getTexturePixelFormat(this.ge.getPixelFormat());
        this.re.bindTexture(texGe);
        this.re.setTextureFormat(this.ge.getPixelFormat(), false);
        this.re.setTexImage(0, 3, VideoEngineUtilities.getResizedWidthPow2(Utilities.makePow2(this.ge.getBufferWidth())), VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(this.ge.getHeight())), texturePixelFormat, texturePixelFormat, 0, null);
        this.re.setTextureMipmapMinFilter(0);
        this.re.setTextureMipmapMagFilter(0);
        this.re.setTextureMipmapMinLevel(0);
        this.re.setTextureMipmapMaxLevel(0);
        this.re.setTextureWrapMode(1, 1);
        this.re.setPixelStore(VideoEngineUtilities.getResizedWidthPow2(this.ge.getBufferWidth()), VideoEngineUtilities.getPixelFormatBytes(this.ge.getPixelFormat()));
        this.re.copyTexSubImage(0, 0, 0, 0, 0, VideoEngineUtilities.getResizedWidth(Math.min(this.ge.getWidth(), this.ge.getBufferWidth())), VideoEngineUtilities.getResizedHeight(this.ge.getHeight()));
        this.temp.clear();
        this.re.getTexImage(0, texturePixelFormat, texturePixelFormat, this.temp);
        CaptureManager.dumpImage(this.ge.getTopAddr(), 0, this.temp, VideoEngineUtilities.getResizedWidth(this.ge.getWidth()), VideoEngineUtilities.getResizedHeight(this.ge.getHeight()), VideoEngineUtilities.getResizedWidthPow2(this.ge.getBufferWidth()), texturePixelFormat, false, 0, true, false);
        this.re.deleteTexture(texGe);
    }

    private void convertABGRtoARGB(int[] abgr, int imageSize, boolean needAlpha) {
        if (needAlpha) {
            for (int i = 0; i < imageSize; ++i) {
                abgr[i] = Utilities.convertABGRtoARGB(abgr[i]);
            }
        } else {
            for (int i = 0; i < imageSize; ++i) {
                abgr[i] = Utilities.convertABGRtoARGB(abgr[i]) & 0xFFFFFF;
            }
        }
    }

    public BufferedImage getCurrentDisplayAsBufferedImage(boolean needAlpha) {
        BufferedImage image = null;
        int[] abgr = this.tempIntArray;
        int width = this.fb.getWidth();
        int height = this.fb.getHeight();
        int bufferWidth = this.fb.getBufferWidth();
        int pixelFormat = this.fb.getPixelFormat();
        if (this.isUsingSoftwareRenderer()) {
            int imageSize = bufferWidth * height;
            Buffer buffer = Memory.getInstance().getBuffer(this.fb.getTopAddr(), imageSize * VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
            if (buffer instanceof IntBuffer) {
                image = new BufferedImage(width, height, 1);
                ((IntBuffer)buffer).get(abgr, 0, imageSize);
                this.convertABGRtoARGB(abgr, imageSize, needAlpha);
            } else {
                log.warn((Object)"sceDisplay.getCurrentDisplayAsBufferedImage not yet implemented for the software renderer");
            }
        } else {
            int lineWidth = VideoEngineUtilities.getResizedWidth(Math.min(width, bufferWidth));
            width = VideoEngineUtilities.getResizedWidth(width);
            height = VideoEngineUtilities.getResizedHeight(height);
            bufferWidth = VideoEngineUtilities.getResizedWidthPow2(bufferWidth);
            int imageSize = bufferWidth * height;
            image = new BufferedImage(width, height, 1);
            if (ExternalGE.isActive()) {
                ByteBuffer scaledScreen = ExternalGE.getScaledScreen(this.fb.getTopAddr(), this.fb.getBufferWidth(), this.fb.getHeight(), pixelFormat);
                if (scaledScreen == null) {
                    Buffer buffer = Memory.getInstance().getBuffer(this.fb.getTopAddr(), imageSize * VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
                    if (buffer instanceof IntBuffer) {
                        ((IntBuffer)buffer).get(abgr, 0, imageSize);
                        this.convertABGRtoARGB(abgr, imageSize, needAlpha);
                    }
                } else {
                    scaledScreen.asIntBuffer().get(abgr, 0, imageSize);
                    for (int i = 0; i < imageSize; ++i) {
                        abgr[i] = abgr[i] >>> 8;
                    }
                }
            } else {
                int texGe = this.re.genTexture();
                this.re.bindTexture(texGe);
                this.re.setTextureFormat(this.fb.getPixelFormat(), false);
                this.re.setTexImage(0, 3, bufferWidth, VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(this.fb.getHeight())), pixelFormat, pixelFormat, 0, null);
                this.re.setTextureMipmapMinFilter(0);
                this.re.setTextureMipmapMagFilter(0);
                this.re.setTextureMipmapMinLevel(0);
                this.re.setTextureMipmapMaxLevel(0);
                this.re.setTextureWrapMode(1, 1);
                this.re.setPixelStore(bufferWidth, VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
                this.re.copyTexSubImage(0, 0, 0, 0, 0, lineWidth, height);
                this.temp.clear();
                this.re.getTexImage(0, pixelFormat, pixelFormat, this.temp);
                this.re.deleteTexture(texGe);
                IntBuffer intBuffer = this.tempByteBuffer.asIntBuffer();
                for (int y = 0; y < height; ++y) {
                    intBuffer.get(abgr, (height - 1 - y) * bufferWidth, bufferWidth);
                }
                this.convertABGRtoARGB(abgr, imageSize, needAlpha);
            }
        }
        image.setRGB(0, 0, Math.min(bufferWidth, width), height, abgr, 0, bufferWidth);
        return image;
    }

    public void captureCurrentTexture(int address, int width, int height, int bufferWidth, int pixelFormat) {
        this.re.setPixelStore(bufferWidth, VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
        this.temp.clear();
        this.re.getTexImage(0, pixelFormat, pixelFormat, this.temp);
        CaptureManager.dumpImage(address, 0, this.temp, width, height, bufferWidth, pixelFormat, false, 0, true, false);
    }

    public TextureSettings getTextureSettings(int textureId, int width, int height, IAction completedAction) {
        TextureSettings textureSettings = this.getTextureSettingsDone.remove(textureId);
        if (textureSettings != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("getTextureSettings returning %s", textureSettings));
            }
            return textureSettings;
        }
        if (this.getTextureSettingsPending.contains(textureId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("getTextureSettings already in progress", new Object[0]));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("getTextureSettings adding action to retrieve the texture settings within the OpenGL context", new Object[0]));
            }
            this.getTextureSettingsPending.add(textureId);
            this.addDisplayActionOce(new GetTextureSettingsAction(this.reDisplay, textureId, width, height, completedAction));
            this.geDirty = true;
            this.step(true);
        }
        return null;
    }

    private void reportFPSStats() {
        long timeNow = System.currentTimeMillis();
        long realElapsedTime = timeNow - this.prevStatsTime;
        if (realElapsedTime > 1000L) {
            ++this.reportCount;
            if (this.frameCount == this.prevFrameCount) {
                this.frameCount = this.paintFrameCount;
                this.prevFrameCount = this.prevPaintFrameCount;
            }
            int lastFPS = (int)(this.frameCount - this.prevFrameCount);
            double averageFPS = (double)this.frameCount / (double)this.reportCount;
            this.prevFrameCount = this.frameCount;
            this.prevPaintFrameCount = this.paintFrameCount;
            this.prevStatsTime = timeNow;
            Emulator.setFpsTitle(String.format("FPS: %d, averageFPS: %.1f", lastFPS, averageFPS));
        }
    }

    public void copyGeToMemory(int geTopAddress) {
        if (this.isUsingSoftwareRenderer() || ExternalGE.isActive()) {
            return;
        }
        if (!this.saveGEToTexture) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("copyGeToMemory starting with geTopAddress=0x%08X", geTopAddress));
        }
        this.doneCopyGeToMemory = false;
        this.addDisplayActionOce(new CopyGeToMemoryAction(geTopAddress));
        this.geDirty = true;
        this.step(true);
        while (!this.doneCopyGeToMemory) {
            Utilities.sleep(1, 0);
        }
        this.doneCopyGeToMemory = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("copyGeToMemory done with geTopAddress=0x%08X", geTopAddress));
        }
    }

    public int hleDisplayWaitVblankStart(int cycles, boolean doCallbacks) {
        if (cycles <= 0) {
            return -2147483138;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = threadMan.getCurrentThread();
        int threadId = threadMan.getCurrentThreadID();
        int lastWaitVblank = thread.displayLastWaitVcount;
        int unblockVcount = lastWaitVblank + cycles;
        if (unblockVcount <= this.vcount) {
            VblankUnblockThreadAction vblankAction = new VblankUnblockThreadAction(threadId);
            IntrManager.getInstance().addVBlankActionOnce(vblankAction);
            thread.displayLastWaitVcount = this.vcount + 1;
        } else {
            WaitVblankInfo waitVblankInfo = new WaitVblankInfo(threadId, unblockVcount);
            this.waitingOnVblank.add(waitVblankInfo);
        }
        threadMan.hleBlockCurrentThread(261, unblockVcount, doCallbacks, null, new VblankWaitStateChecker(unblockVcount));
        ExternalGE.onDisplayStartWaitVblank();
        return 0;
    }

    private void hleVblankStart() {
        this.lastVblankMicroTime = Emulator.getClock().microTime();
        ++this.vcount;
        ExternalGE.onDisplayVblank();
        if (!this.waitingOnVblank.isEmpty()) {
            ListIterator<WaitVblankInfo> lit = this.waitingOnVblank.listIterator();
            while (lit.hasNext()) {
                WaitVblankInfo waitVblankInfo = lit.next();
                if (waitVblankInfo.unblockVcount > this.vcount) continue;
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                SceKernelThreadInfo thread = threadMan.getThreadById(waitVblankInfo.threadId);
                if (thread != null) {
                    ExternalGE.onDisplayStopWaitVblank();
                    thread.displayLastWaitVcount = this.vcount;
                    threadMan.hleUnblockThread(waitVblankInfo.threadId);
                }
                lit.remove();
            }
        }
    }

    private boolean isVblank() {
        long nowMicroTime = Emulator.getClock().microTime();
        long microTimeSinceLastVblank = nowMicroTime - this.lastVblankMicroTime;
        return microTimeSinceLastVblank <= 731L;
    }

    private int getCurrentHcount() {
        long nowMicroTime = Emulator.getClock().microTime();
        long microTimeSinceLastVblank = nowMicroTime - this.lastVblankMicroTime;
        float vblankStep = (float)microTimeSinceLastVblank / 16666.666f;
        if (vblankStep > 1.0f) {
            vblankStep = 1.0f;
        }
        return (int)(vblankStep * 285.72f);
    }

    public int getVcount() {
        return this.vcount;
    }

    private int createTexture(int textureId, boolean isResized) {
        if (textureId != -1) {
            this.reDisplay.deleteTexture(textureId);
        }
        textureId = this.reDisplay.genTexture();
        this.reDisplay.bindTexture(textureId);
        this.reDisplay.setTextureFormat(this.fb.getPixelFormat(), false);
        this.reDisplay.setTexImage(0, 3, isResized ? VideoEngineUtilities.getResizedWidthPow2(this.fb.getBufferWidth()) : this.fb.getBufferWidth(), isResized ? VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(this.fb.getHeight())) : Utilities.makePow2(this.fb.getHeight()), VideoEngineUtilities.getTexturePixelFormat(this.getPixelFormatFb()), VideoEngineUtilities.getTexturePixelFormat(this.getPixelFormatFb()), 0, null);
        this.reDisplay.setTextureMipmapMinFilter(0);
        this.reDisplay.setTextureMipmapMagFilter(0);
        this.reDisplay.setTextureMipmapMinLevel(0);
        this.reDisplay.setTextureMipmapMaxLevel(0);
        this.reDisplay.setTextureWrapMode(1, 1);
        return textureId;
    }

    private void checkTemp() {
        int bytesPerPixel = VideoEngineUtilities.getPixelFormatBytes(Math.max(this.fb.getPixelFormat(), this.ge.getPixelFormat()));
        int sizeInBytes = VideoEngineUtilities.getResizedWidthPow2(Math.max(this.fb.getBufferWidth(), this.ge.getBufferWidth())) * VideoEngineUtilities.getResizedHeightPow2(Utilities.makePow2(Math.max(this.fb.getHeight(), this.ge.getHeight()))) * bytesPerPixel;
        if (sizeInBytes > this.tempSize) {
            this.tempByteBuffer = ByteBuffer.allocateDirect(sizeInBytes).order(ByteOrder.LITTLE_ENDIAN);
            this.temp = Memory.getInstance().getMainMemoryByteBuffer() instanceof IntBuffer ? this.tempByteBuffer.asIntBuffer() : this.tempByteBuffer;
            this.tempIntArray = new int[sizeInBytes / bytesPerPixel];
            this.tempSize = sizeInBytes;
        }
    }

    public void setCalledFromCommandLine() {
        this.calledFromCommandLine = true;
    }

    public void takeScreenshot() {
        this.addDisplayActionOce(new ScreenshotAction());
    }

    public boolean isInsideRendering() {
        PspGeList currentList;
        if (ExternalGE.isActive()) {
            if (ExternalGE.isInsideRendering()) {
                return true;
            }
        } else if (this.insideRendering && (currentList = VideoEngine.getInstance().getCurrentList()) != null && currentList.isStalledAtStart()) {
            return false;
        }
        return this.insideRendering;
    }

    public void setInsideRendering(boolean insideRendering) {
        this.insideRendering = insideRendering;
    }

    public void waitForRenderingCompletion(int address) {
        int countWaitingOnStall = 0;
        while (this.isInsideRendering() && this.isGeAddress(address)) {
            if (VideoEngine.getInstance().isWaitingOnStall()) {
                if (++countWaitingOnStall > 10) {
                    break;
                }
            } else {
                countWaitingOnStall = 0;
            }
            Utilities.sleep(10);
        }
    }

    public void addDisplayAction(IAction action) {
        this.displayActions.add(action);
    }

    public boolean removeDisplayAction(IAction action) {
        return this.displayActions.remove(action);
    }

    public void addDisplayActionOce(IAction action) {
        this.displayActionsOnce.add(action);
    }

    public boolean removeDisplayActionOce(IAction action) {
        return this.displayActionsOnce.remove(action);
    }

    @HLEFunction(nid=237039991, version=150, checkInsideInterrupt=true)
    public int sceDisplaySetMode(int displayMode, int displayWidth, int displayHeight) {
        if (displayWidth <= 0 || displayHeight <= 0 || (displayWidth & 7) != 0 || displayHeight > 272) {
            return -2147483388;
        }
        if (displayMode != 0) {
            return -2147483385;
        }
        this.mode = displayMode;
        this.fb.setDimension(displayWidth, displayHeight);
        this.detailsDirty = true;
        return 0;
    }

    @HLEFunction(nid=-559835180, version=150)
    public int sceDisplayGetMode(@CanBeNull TPointer32 modeAddr, @CanBeNull TPointer32 widthAddr, @CanBeNull TPointer32 heightAddr) {
        modeAddr.setValue(this.mode);
        widthAddr.setValue(this.fb.getWidth());
        heightAddr.setValue(this.fb.getHeight());
        return 0;
    }

    @HLEFunction(nid=-609827644, version=150)
    public float sceDisplayGetFramePerSec() {
        float framePerSec = 59.94006f / (float)this.framePerSecFactor;
        this.framePerSecFactor = 1;
        return framePerSec;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2127928260, version=150, checkInsideInterrupt=true), @HLEFunction(nid=894610193, version=660, checkInsideInterrupt=true)})
    public int sceDisplaySetHoldMode(int holdMode) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1522219898, version=150, checkInsideInterrupt=true), @HLEFunction(nid=66154452, version=660, checkInsideInterrupt=true)})
    public int sceDisplaySetResumeMode(int resumeMode) {
        return 0;
    }

    @HLEFunction(nid=681411326, version=150)
    public int sceDisplaySetFrameBuf(@CanBeNull TPointer topaddr, int bufferwidth, int pixelformat, int syncType) {
        return this.hleDisplaySetFrameBuf(topaddr.getAddress(), bufferwidth, pixelformat, syncType);
    }

    private int hleDisplaySetFrameBufError(int topaddr, int bufferwidth, int pixelformat, int syncType, int error, String errorString) {
        log.warn((Object)String.format("sceDisplaySetFrameBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d %s: returning 0x%08X", topaddr, bufferwidth, pixelformat, syncType, errorString, error));
        this.gotBadFbBufParams = true;
        return error;
    }

    public int hleDisplaySetFrameBuf(int topaddr, int bufferwidth, int pixelformat, int syncType) {
        if (syncType != 0 && syncType != 1) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483385, "bad syncType");
        }
        if ((topaddr & 0xF) != 0) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483389, "bad topaddr");
        }
        if (topaddr != 0 && !Memory.isRAM(topaddr) && !Memory.isVRAM(topaddr)) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483389, "bad topaddr");
        }
        if ((bufferwidth & 0x3F) != 0) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483388, "bad bufferwidth");
        }
        if (bufferwidth == 0 && topaddr != 0) {
            return -2147483388;
        }
        if (pixelformat < 0 || pixelformat > 3) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483384, "bad pixelformat");
        }
        if (topaddr == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceDisplaySetFrameBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d (blocking display output)", topaddr, bufferwidth, pixelformat, syncType));
            }
            this.isFbShowing = false;
            this.gotBadFbBufParams = true;
            return 0;
        }
        if (this.gotBadFbBufParams) {
            this.gotBadFbBufParams = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceDisplaySetFrameBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d ok", topaddr, bufferwidth, pixelformat, syncType));
            }
        }
        if (topaddr == this.fb.getTopAddr() && bufferwidth == this.fb.getBufferWidth() && pixelformat == this.fb.getPixelFormat() && syncType == this.sync && this.isFbShowing) {
            return 0;
        }
        if (topaddr != this.fb.getTopAddr()) {
            ++this.frameCount;
        }
        this.framesSkippedInSequence = this.skipNextFrameBufferSwitch ? ++this.framesSkippedInSequence : 0;
        boolean skipThisFrame = false;
        if (this.desiredFps > 0) {
            long currentFrameTimestamp = Emulator.getClock().currentTimeMillis();
            this.frameTimestamps.addLast(currentFrameTimestamp);
            while (currentFrameTimestamp - this.frameTimestamps.getFirst() > 1000L) {
                this.frameTimestamps.removeFirst();
            }
            int currentFps = this.frameTimestamps.size();
            if (currentFps < this.desiredFps && this.framesSkippedInSequence < this.maxFramesSkippedInSequence) {
                skipThisFrame = true;
            }
        }
        VideoEngine.getInstance().setSkipThisFrame(skipThisFrame);
        if (this.skipNextFrameBufferSwitch) {
            if (topaddr != this.fb.getTopAddr()) {
                Memory.getInstance().memcpy(topaddr, this.fb.getTopAddr(), this.fb.getBottomAddr() - this.fb.getTopAddr());
            }
            this.skipNextFrameBufferSwitch = false;
        }
        if (pixelformat != this.fb.getPixelFormat() || bufferwidth != this.fb.getBufferWidth() || Utilities.makePow2(this.fb.getHeight()) != Utilities.makePow2(this.fb.getHeight())) {
            this.createTex = true;
        }
        this.fb = new FrameBufferSettings(topaddr, bufferwidth, this.fb.getWidth(), this.fb.getHeight(), pixelformat);
        this.sync = syncType;
        this.texS = (float)this.fb.getWidth() / (float)bufferwidth;
        this.texT = (float)this.fb.getHeight() / (float)Utilities.makePow2(this.fb.getHeight());
        this.displayScreen.update(this.texS, this.texT);
        this.detailsDirty = true;
        this.isFbShowing = true;
        if (State.dumpGeNextFrame && CaptureManager.hasListExecuted()) {
            VideoEngine.getInstance().endDumpFrame();
            State.dumpGeNextFrame = false;
            Emulator.PauseEmu();
        } else if (State.stopRecordGeFrames && State.recordGeFrames && CaptureManager.hasListExecuted()) {
            State.recordGeFrames = false;
            State.stopRecordGeFrames = false;
            CaptureManager.captureFrameBufDetails();
            CaptureManager.endCapture();
            Emulator.getMainGUI().RefreshButtons();
        }
        VideoEngine.getInstance().hleSetFrameBuf(this.fb.getTopAddr(), this.fb.getBufferWidth(), this.fb.getPixelFormat());
        return 0;
    }

    @HLEFunction(nid=-287691180, version=150)
    public int sceDisplayGetFrameBuf(TPointer32 topaddrAddr, @CanBeNull TPointer32 bufferwidthAddr, @CanBeNull TPointer32 pixelformatAddr, int syncType) {
        topaddrAddr.setValue(this.fb.getTopAddr());
        bufferwidthAddr.setValue(this.fb.getBufferWidth());
        pixelformatAddr.setValue(this.fb.getPixelFormat());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetFrameBuf returning topaddr=0x%08X, bufferwidth=0x%X, pixelformat=0x%X", this.fb.getTopAddr(), this.fb.getBufferWidth(), this.fb.getPixelFormat()));
        }
        return 0;
    }

    @HLEFunction(nid=-1259112198, version=150)
    public boolean sceDisplayIsForeground() {
        return this.isFbShowing;
    }

    @HLEFunction(nid=834976424, version=150)
    public int sceDisplayGetBrightness(@CanBeNull TPointer32 levelAddr, @CanBeNull TPointer32 unknownAddr) {
        levelAddr.setValue(Screen.getBrightnessLevel());
        unknownAddr.setValue(0);
        return 0;
    }

    @HLEFunction(nid=-1640206906, version=150)
    public int sceDisplaySetBrightness(int level, int syncType) {
        if (level < 0 || level > 100) {
            return -2147483137;
        }
        if (syncType != 0 && syncType != 1) {
            return -2147483385;
        }
        Screen.setBrightnessLevel(level);
        return 0;
    }

    @HLEFunction(nid=-1670468905, version=150)
    public int sceDisplayGetVcount() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetVcount returning %d", this.vcount));
        }
        return this.vcount;
    }

    @HLEFunction(nid=1296961772, version=150)
    public boolean sceDisplayIsVblank() {
        boolean isVblank = this.isVblank();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayIsVblank returns %b", isVblank));
        }
        return isVblank;
    }

    @HLEFunction(nid=919468766, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblank() {
        if (!this.isVblank()) {
            this.sceDisplayWaitVblankStart();
        }
        return 0;
    }

    @HLEFunction(nid=-1900417975, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankCB() {
        if (!this.isVblank()) {
            this.sceDisplayWaitVblankStartCB();
        }
        return 0;
    }

    @HLEFunction(nid=-1739839513, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStart() {
        return this.hleDisplayWaitVblankStart(1, false);
    }

    @HLEFunctions(value={@HLEFunction(nid=1190233795, version=150, checkInsideInterrupt=true), @HLEFunction(nid=-477321707, version=660, checkInsideInterrupt=true)})
    public int sceDisplayWaitVblankStartCB() {
        return this.hleDisplayWaitVblankStart(1, true);
    }

    @HLEFunction(nid=2000540579, version=150)
    public int sceDisplayGetCurrentHcount() {
        int currentHcount = this.getCurrentHcount();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetCurrentHcount returning %d", currentHcount));
        }
        return currentHcount;
    }

    @HLEFunction(nid=554609466, version=150)
    public int sceDisplayGetAccumulatedHcount() {
        int currentHcount = this.getCurrentHcount();
        int accumulatedHcount = currentHcount + (int)((float)this.vcount * 285.72f);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetAccumulatedHcount returning %d (currentHcount=%d)", accumulatedHcount, currentHcount));
        }
        return accumulatedHcount;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1472270023, version=150)
    public int sceDisplayAdjustAccumulatedHcount() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1082526138, version=200)
    public int sceDisplayGetResumeMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1773483329, version=200)
    public int sceDisplayGetVblankRest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=553879827, version=200)
    public int sceDisplayIsVsync() {
        return 0;
    }

    @HLEFunction(nid=1089554076, version=500, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStartMulti(int cycleNum) {
        return this.hleDisplayWaitVblankStart(cycleNum, false);
    }

    @HLEFunction(nid=2012056378, version=500, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStartMultiCB(int cycleNum) {
        return this.hleDisplayWaitVblankStart(cycleNum, true);
    }

    @HLEFunction(nid=-1721204270, version=660)
    public int sceDisplay_driver_996881D2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1692869155, version=660)
    public int sceDisplay_driver_9B18DDDD(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-195718785, version=660)
    public int sceDisplay_driver_F455917F(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-446755504, version=150)
    public int sceDisplaySetBacklightSel(int unknown0, int unknown1) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-377579752, version=660)
    public int sceDisplaySetPseudoVsync(int unknown) {
        return 0;
    }

    private class GetTextureSettingsAction
    implements IAction {
        private final IRenderingEngine re;
        private final int textureId;
        private int width;
        private int height;
        private final IAction completedAction;

        public GetTextureSettingsAction(IRenderingEngine re, int textureId, int width, int height, IAction completedAction) {
            this.re = re;
            this.textureId = textureId;
            this.width = width;
            this.height = height;
            this.completedAction = completedAction;
        }

        @Override
        public void execute() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("GetTextureImageAction textureId=%d, width=%d, height=%d", this.textureId, this.width, this.height));
            }
            this.re.bindTexture(this.textureId);
            TextureSettings textureSettings = new TextureSettings();
            textureSettings.setWidth(this.re.getTextureLevelParameter(this.textureId, 0, 0));
            textureSettings.setHeight(this.re.getTextureLevelParameter(this.textureId, 0, 1));
            int pixelFormat = this.re.getTextureLevelParameter(this.textureId, 0, 3);
            if (pixelFormat < 3) {
                pixelFormat = 3;
            }
            textureSettings.setPixelFormat(pixelFormat);
            if (textureSettings.hasWidth()) {
                this.width = textureSettings.getWidth();
            } else {
                textureSettings.setWidth(this.width);
            }
            if (textureSettings.hasHeight()) {
                this.height = textureSettings.getHeight();
            } else {
                textureSettings.setHeight(this.height);
            }
            int bytesPerPixel = VideoEngineUtilities.getPixelFormatBytes(pixelFormat);
            int sizeInBytes = this.width * this.height * bytesPerPixel;
            ByteBuffer buffer = ByteBuffer.allocateDirect(sizeInBytes).order(ByteOrder.LITTLE_ENDIAN);
            this.re.setPixelStore(this.width, VideoEngineUtilities.getPixelFormatBytes(pixelFormat));
            this.re.getTexImage(0, pixelFormat, pixelFormat, buffer);
            textureSettings.setBuffer(buffer);
            sceDisplay.this.getTextureSettingsDone.put(this.textureId, textureSettings);
            sceDisplay.this.getTextureSettingsPending.remove(this.textureId);
            if (this.completedAction != null) {
                this.completedAction.execute();
            }
        }
    }

    private class CopyGeToMemoryAction
    implements IAction {
        private int geTopAddress;

        public CopyGeToMemoryAction(int geTopAddress) {
            this.geTopAddress = geTopAddress;
        }

        @Override
        public void execute() {
            VideoEngineUtilities.copyGeToMemory(sceDisplay.this.re, this.geTopAddress, true, true);
            sceDisplay.this.doneCopyGeToMemory = true;
        }
    }

    private class ScreenshotAction
    implements IAction {
        private ScreenshotAction() {
        }

        @Override
        public void execute() {
            sceDisplay.this.saveScreen();
        }
    }

    public static class BufferInfo {
        public int topAddr;
        public int bottomAddr;
        public int width;
        public int height;
        public int bufferWidth;
        public int pixelFormat;

        public BufferInfo(int topAddr, int bottomAddr, int width, int height, int bufferWidth, int pixelFormat) {
            this.topAddr = topAddr;
            this.bottomAddr = bottomAddr;
            this.width = width;
            this.height = height;
            this.bufferWidth = bufferWidth;
            this.pixelFormat = pixelFormat;
        }
    }

    private class DisplaySettingsListener
    implements ISettingsListener {
        private DisplaySettingsListener() {
        }

        @Override
        public void settingsValueChanged(String option, String value) {
            if (sceDisplay.this.isStarted) {
                sceDisplay.this.resetDisplaySettings = true;
            }
        }
    }

    private class AntiAliasSettingsListerner
    extends AbstractStringSettingsListener {
        private Pattern pattern = Pattern.compile("x(\\d+)", 2);

        private AntiAliasSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(String value) {
            Matcher matcher;
            int samples = 0;
            if (value != null && (matcher = this.pattern.matcher(value)).matches()) {
                samples = Integer.parseInt(matcher.group(1));
            }
            sceDisplay.this.setAntiAliasSamplesNum(samples);
        }
    }

    private class VblankUnblockThreadAction
    extends UnblockThreadAction {
        public VblankUnblockThreadAction(int threadId) {
            super(threadId);
        }

        @Override
        public void execute() {
            boolean unblock = true;
            SceKernelThreadInfo threadInfo = this.getThreadInfo();
            if (threadInfo != null && threadInfo.waitType != 261) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("VblankUnblockThreadAction not unblocking %s", threadInfo));
                }
                unblock = false;
            }
            if (unblock) {
                ExternalGE.onDisplayStopWaitVblank();
                super.execute();
            }
        }
    }

    private class VblankWaitStateChecker
    implements IWaitStateChecker {
        private int vcount;

        public VblankWaitStateChecker(int vcount) {
            this.vcount = vcount;
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            boolean continueWait;
            boolean bl = continueWait = sceDisplay.this.vcount < this.vcount;
            if (!continueWait) {
                ExternalGE.onDisplayStopWaitVblank();
            }
            return continueWait;
        }
    }

    private class DisplayVblankAction
    implements IAction {
        private DisplayVblankAction() {
        }

        @Override
        public void execute() {
            sceDisplay.this.hleVblankStart();
        }
    }

    private static class SoftwareRenderingDisplayThread
    extends AbstractDisplayThread {
        private SoftwareRenderingDisplayThread() {
        }

        @Override
        protected void doDisplay() {
            IRenderingEngine re;
            if (VideoEngine.getInstance().hasDrawLists() && (re = Modules.sceDisplayModule.getRenderingEngine()) == null && !Screen.hasScreen()) {
                re = RenderingEngineFactory.createRenderingEngine();
                Modules.sceDisplayModule.setRenderingEngine(re);
                VideoEngine.getInstance().start();
            }
        }
    }

    private static class AsyncDisplayThread
    extends AbstractDisplayThread {
        private AsyncDisplayThread() {
        }

        @Override
        protected void doDisplay() {
            Modules.sceDisplayModule.canvas.repaint();
        }
    }

    private static abstract class AbstractDisplayThread
    extends Thread {
        private Semaphore displaySemaphore = new Semaphore(1);
        protected boolean run = true;

        public AbstractDisplayThread() {
            VideoEngine.getInstance();
        }

        @Override
        public void run() {
            while (this.run) {
                this.waitForDisplay();
                if (!this.run) continue;
                this.doDisplay();
            }
        }

        protected abstract void doDisplay();

        public void display() {
            this.displaySemaphore.release();
        }

        private void waitForDisplay() {
            while (true) {
                try {
                    int availablePermits;
                    while ((availablePermits = this.displaySemaphore.drainPermits()) <= 0 && !this.displaySemaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void exit() {
            this.run = false;
            this.display();
        }
    }

    private static class WaitVblankInfo {
        public int threadId;
        public int unblockVcount;

        public WaitVblankInfo(int threadId, int unblockVcount) {
            this.threadId = threadId;
            this.unblockVcount = unblockVcount;
        }
    }

    private class SaveStencilToMemorySettingsListener
    extends AbstractBoolSettingsListener {
        private SaveStencilToMemorySettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setSaveStencilToMemory(value);
        }
    }

    private class SoftwareRendererSettingsListener
    extends AbstractBoolSettingsListener {
        private SoftwareRendererSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setUseSoftwareRenderer(value);
        }
    }

    public class AWTGLCanvas_sceDisplay
    extends AWTGLCanvas {
        private static final long serialVersionUID = -3808789665048696700L;

        public AWTGLCanvas_sceDisplay(GLData glData) {
            super(glData);
        }

        public long getDisplayWindow() {
            if (this.platformCanvas instanceof PlatformWin32GLCanvas) {
                return ((PlatformWin32GLCanvas)this.platformCanvas).hwnd;
            }
            if (this.platformCanvas instanceof PlatformLinuxGLCanvas) {
                return ((PlatformLinuxGLCanvas)this.platformCanvas).display;
            }
            return 0L;
        }

        public long getDisplayDrawable() {
            if (this.platformCanvas instanceof PlatformLinuxGLCanvas) {
                return ((PlatformLinuxGLCanvas)this.platformCanvas).drawable;
            }
            return 0L;
        }

        public void paint(Graphics g) {
            this.render();
        }

        public void paintGL() {
            GETexture geTexture;
            VideoEngine videoEngine = VideoEngine.getInstance();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("paintGL resize=%f, size(%dx%d), canvas(%dx%d), location(%d,%d), createTex=%b", Float.valueOf(VideoEngineUtilities.getViewportResizeScaleFactor()), sceDisplay.this.canvas.getSize().width, sceDisplay.this.canvas.getSize().height, sceDisplay.this.canvasWidth, sceDisplay.this.canvasHeight, sceDisplay.this.canvas.getLocation().x, sceDisplay.this.canvas.getLocation().y, sceDisplay.this.createTex));
            }
            if (sceDisplay.this.resizePending && Emulator.getMainGUI().isVisible()) {
                Emulator.getMainGUI().pack();
                sceDisplay.this.resizePending = false;
            }
            if (sceDisplay.this.statistics != null) {
                sceDisplay.this.statistics.start();
            }
            if (sceDisplay.this.resetDisplaySettings) {
                if (sceDisplay.this.isStarted) {
                    videoEngine.stop();
                }
                TextureCache.getInstance().reset(sceDisplay.this.re);
                VertexCache.getInstance().reset(sceDisplay.this.re);
                sceDisplay.this.startModules = true;
                sceDisplay.this.re = null;
                sceDisplay.this.reDisplay = null;
                sceDisplay.this.resetDisplaySettings = false;
                sceDisplay.this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
                if (sceDisplay.this.saveGEToTexture) {
                    log.info((Object)"Saving GE to Textures");
                }
            }
            if (sceDisplay.this.re == null) {
                if (sceDisplay.this.startModules) {
                    ExternalGE.init();
                    sceDisplay.this.re = RenderingEngineFactory.createRenderingEngine();
                    if (sceDisplay.this.isUsingSoftwareRenderer()) {
                        sceDisplay.this.reDisplay = RenderingEngineFactory.createRenderingEngineForDisplay();
                        sceDisplay.this.reDisplay.setGeContext(videoEngine.getContext());
                    } else if (ExternalGE.isActive()) {
                        sceDisplay.this.reDisplay = sceDisplay.this.re;
                    } else {
                        sceDisplay.this.reDisplay = RenderingEngineFactory.createRenderingEngineForDisplay();
                        sceDisplay.this.reDisplay.setGeContext(videoEngine.getContext());
                        sceDisplay.this.reDisplay.setBufferManager(sceDisplay.this.re.getBufferManager());
                    }
                } else {
                    sceDisplay.this.re = RenderingEngineFactory.createInitialRenderingEngine();
                    sceDisplay.this.reDisplay = sceDisplay.this.re;
                }
            }
            sceDisplay.this.lockDisplay();
            if (sceDisplay.this.startModules) {
                sceDisplay.this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
                if (sceDisplay.this.saveGEToTexture) {
                    GETextureManager.getInstance().reset(sceDisplay.this.reDisplay);
                }
                videoEngine.start();
                sceDisplay.this.startModules = false;
                if (sceDisplay.this.saveGEToTexture && !sceDisplay.this.re.isFramebufferObjectAvailable()) {
                    sceDisplay.this.saveGEToTexture = false;
                    log.warn((Object)"Saving GE to Textures has been automatically disabled: FBO is not supported by this OpenGL version");
                }
                sceDisplay.this.isStarted = true;
            }
            if (!sceDisplay.this.isStarted) {
                sceDisplay.this.reDisplay.clear(0.0f, 0.0f, 0.0f, 0.0f);
                sceDisplay.this.unlockDisplay();
                return;
            }
            if (sceDisplay.this.createTex) {
                sceDisplay.this.texFb = sceDisplay.this.createTexture(sceDisplay.this.texFb, false);
                sceDisplay.this.resizedTexFb = sceDisplay.this.createTexture(sceDisplay.this.resizedTexFb, true);
                sceDisplay.this.checkTemp();
                sceDisplay.this.createTex = false;
            }
            if (sceDisplay.this.resetGeTextures) {
                if (sceDisplay.this.saveGEToTexture) {
                    GETextureManager.getInstance().reset(sceDisplay.this.reDisplay);
                }
                sceDisplay.this.resetGeTextures = false;
            }
            sceDisplay.this.skipNextFrameBufferSwitch = videoEngine.isSkipThisFrame();
            boolean doSwapBuffers = true;
            FrameBufferSettings currentFb = sceDisplay.this.fb;
            sceDisplay.this.setInsideRendering(true);
            if (ExternalGE.isActive()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - ExternalGE - rendering the FB 0x%08X", currentFb.getTopAddr()));
                }
                sceDisplay.this.reDisplay.startDisplay();
                if (ExternalGE.getScreenScale() <= 1) {
                    VideoEngineUtilities.drawFrameBufferFromMemory(sceDisplay.this.reDisplay, currentFb, sceDisplay.this.texFb);
                } else {
                    ByteBuffer scaledScreen = ExternalGE.getScaledScreen(sceDisplay.this.fb.getTopAddr(), sceDisplay.this.fb.getBufferWidth(), sceDisplay.this.fb.getHeight(), sceDisplay.this.fb.getPixelFormat());
                    if (scaledScreen == null) {
                        VideoEngineUtilities.drawFrameBufferFromMemory(sceDisplay.this.reDisplay, currentFb, sceDisplay.this.texFb);
                    } else {
                        int screenScale = ExternalGE.getScreenScale();
                        sceDisplay.this.fb.getPixels().clear();
                        sceDisplay.this.reDisplay.bindTexture(sceDisplay.this.resizedTexFb);
                        sceDisplay.this.reDisplay.setTextureFormat(sceDisplay.this.fb.getPixelFormat(), false);
                        sceDisplay.this.reDisplay.setPixelStore(sceDisplay.this.fb.getBufferWidth() * screenScale, VideoEngineUtilities.getPixelFormatBytes(sceDisplay.this.fb.getPixelFormat()));
                        sceDisplay.this.reDisplay.setTexSubImage(0, 0, 0, sceDisplay.this.fb.getBufferWidth() * screenScale, sceDisplay.this.fb.getHeight() * screenScale, sceDisplay.this.fb.getPixelFormat(), sceDisplay.this.fb.getPixelFormat(), scaledScreen.remaining(), scaledScreen);
                        VideoEngineUtilities.drawFrameBuffer(sceDisplay.this.reDisplay, false, true, sceDisplay.this.fb.getBufferWidth(), sceDisplay.this.fb.getPixelFormat(), sceDisplay.this.displayScreen.getWidth(sceDisplay.this.fb), sceDisplay.this.displayScreen.getHeight(sceDisplay.this.fb));
                    }
                }
                sceDisplay.this.reDisplay.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - ExternalGE - end display - isFbShowing=%b", sceDisplay.this.isFbShowing));
                }
            } else if (sceDisplay.this.isUsingSoftwareRenderer()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - software - rendering the FB 0x%08X", currentFb.getTopAddr()));
                }
                sceDisplay.this.reDisplay.startDisplay();
                VideoEngineUtilities.drawFrameBufferFromMemory(sceDisplay.this.reDisplay, currentFb, sceDisplay.this.texFb);
                sceDisplay.this.reDisplay.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - software - end display");
                }
            } else if (VideoEngineThread.isActive()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - start display with Video Engine Thread");
                }
                sceDisplay.this.reDisplay.startDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - rendering the FB 0x%08X", currentFb.getTopAddr()));
                }
                if (sceDisplay.this.saveGEToTexture && !videoEngine.isVideoTexture(sceDisplay.this.fb.getTopAddr())) {
                    geTexture = GETextureManager.getInstance().getGETexture(sceDisplay.this.reDisplay, currentFb.getTopAddr(), currentFb.getBufferWidth(), currentFb.getWidth(), currentFb.getHeight(), currentFb.getPixelFormat(), true);
                    geTexture.copyTextureToScreen(sceDisplay.this.reDisplay);
                } else {
                    VideoEngineUtilities.drawFrameBufferFromMemory(sceDisplay.this.reDisplay, currentFb, sceDisplay.this.texFb);
                }
                sceDisplay.this.reDisplay.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - end display");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - start display without Video Engine Thread");
                }
                sceDisplay.this.re.startDisplay();
                videoEngine.update();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - rendering the FB 0x%08X", currentFb.getTopAddr()));
                }
                if (sceDisplay.this.saveGEToTexture && !videoEngine.isVideoTexture(sceDisplay.this.fb.getTopAddr())) {
                    geTexture = GETextureManager.getInstance().getGETexture(sceDisplay.this.re, currentFb.getTopAddr(), currentFb.getBufferWidth(), currentFb.getWidth(), currentFb.getHeight(), currentFb.getPixelFormat(), true);
                    geTexture.copyTextureToScreen(sceDisplay.this.re);
                } else {
                    VideoEngineUtilities.drawFrameBufferFromMemory(sceDisplay.this.re, currentFb, sceDisplay.this.texFb);
                }
                sceDisplay.this.re.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - end display");
                }
            }
            if (!sceDisplay.this.isFbShowing) {
                sceDisplay.this.reDisplay.clear(0.0f, 0.0f, 0.0f, 0.0f);
            }
            sceDisplay.this.setInsideRendering(false);
            if (doSwapBuffers) {
                sceDisplay.this.paintFrameCount++;
                sceDisplay.this.canvas.swapBuffers();
            }
            sceDisplay.this.reportFPSStats();
            if (sceDisplay.this.statistics != null) {
                sceDisplay.this.statistics.end();
            }
            for (IAction action : sceDisplay.this.displayActions) {
                action.execute();
            }
            for (IAction action : sceDisplay.this.displayActionsOnce) {
                action.execute();
            }
            sceDisplay.this.displayActionsOnce.clear();
            sceDisplay.this.unlockDisplay();
        }

        public void initGL() {
            sceDisplay.this.initGLcalled = true;
            sceDisplay.this.openGLversion = RenderingEngineLwjgl.getVersion();
        }

        public void setBounds(int x, int y, int width, int height) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("setBounds width=%d, height=%d", width, height));
            }
            sceDisplay.this.canvasWidth = width;
            sceDisplay.this.canvasHeight = height;
            sceDisplay.this.setViewportResizeScaleFactor(width, height);
            super.setBounds(x, y, width, height);
        }
    }
}

