/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceMp4AvcCscStruct;
import jpcsp.HLE.modules.sceMpegbase;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceDmacplus
extends HLEModule {
    public static Logger log = Modules.getLogger("sceDmacplus");
    public static final int[] pixelFormatFromCode = new int[]{3, 0, 1, 2};
    private int pixelMode;
    private int bufferWidth;

    @HLEUnimplemented
    @HLEFunction(nid=-373864711, version=150)
    public int sceDmacplusLcdcDisable() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-310078880, version=150)
    public int sceDmacplusLcdcEnable() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2001946895, version=150)
    public int sceDmacplusLcdcSetFormat(int displayWidth, int displayFrameBufferWidth, int displayPixelFormatCoded) {
        int pixelFormat = pixelFormatFromCode[displayPixelFormatCoded];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDmacplusLcdcSetFormat pixelFormat=%d", pixelFormat));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1549103872, version=150)
    public int sceDmacplusLcdcSetBaseAddr(int frameBufferAddress) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=760824063, version=150), @HLEFunction(nid=1766191571, version=660)})
    public int sceDmacplusMe2ScLLI(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer32 dmacParameters) {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=876141067, version=150), @HLEFunction(nid=674013399, version=660)})
    public int sceDmacplusSc2MeLLI(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer32 dmacParameters) {
        int next;
        do {
            int src = dmacParameters.getValue(0);
            int dst = dmacParameters.getValue(4);
            next = dmacParameters.getValue(8);
            int attributes = dmacParameters.getValue(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceDmacplusSc2MeLLI src=0x%08X, dst=0x%08X, next=0x%08X, attributes=0x%X", src, dst, next, attributes));
            }
            int srcStep = attributes >> 12 & 7;
            int dstStep = attributes >> 15 & 7;
            int srcLengthShift = attributes >> 18 & 7;
            int dstLengthShift = attributes >> 21 & 7;
            boolean srcIncrement = Utilities.hasFlag(attributes, 0x4000000);
            boolean dstIncrement = Utilities.hasFlag(attributes, 0x8000000);
            int length = attributes & 0xFFF;
            if (Utilities.hasFlag(attributes, 0x2000000)) {
                srcIncrement = true;
                dstIncrement = true;
                srcLengthShift = 0;
                dstLengthShift = 0;
            }
            if (!srcIncrement || !dstIncrement || srcStep != 1 || dstStep != 1) {
                log.error((Object)String.format("sceDmacplusSc2MeLLI unimplemented srcIncrement=%b, dstIncrement=%b, srcStep=%d, dstStep=%d", srcIncrement, dstIncrement, srcStep, dstStep));
                return -1;
            }
            int srcLength = length << srcLengthShift;
            int dstLength = length << dstLengthShift;
            TPointer memcpyDst = new TPointer(this.getMEMemory(), dst);
            TPointer memcpySrc = new TPointer(this.getMemory(), src);
            int memcpyLength = Math.min(srcLength, dstLength);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceDmacplusSc2MeLLI memcpy dst=%s, src=%s, length=0x%X", memcpyDst, memcpySrc, memcpyLength));
            }
            memcpyDst.memcpy(memcpySrc, memcpyLength);
        } while ((dmacParameters = new TPointer32(dmacParameters.getMemory(), next)).isNotNull());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1301681463, version=660)
    public int sceDmacplus_driver_B269EAC9(int internalPixelMode, int bufferWidth, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=22, usage=BufferInfo.Usage.in) TPointer unknown3) {
        this.pixelMode = sceMpegbase.getPixelMode(internalPixelMode);
        this.bufferWidth = bufferWidth;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-786020021, version=660)
    public int sceDmacplus_driver_D126494B(TPointer bufferRGB, @CanBeNull TPointer unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.in) TPointer mp4AvcCscStructAddr) {
        SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
        mp4AvcCscStruct.read(mp4AvcCscStructAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDmacplus_driver_D126494B %s", mp4AvcCscStruct));
        }
        return Modules.sceMpegbaseModule.hleMpegBaseCscAvc(bufferRGB, unknown, this.bufferWidth, this.pixelMode, mp4AvcCscStruct);
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1490962708, version=150), @HLEFunction(nid=1205076171, version=660)})
    public int sceDmacplusSc2MeSync(boolean poll, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer32 result) {
        if (result.isNotNull()) {
            result.setValue(0, 0);
            result.setValue(4, 0);
            result.setValue(8, 0);
            result.setValue(12, 0);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1421225269, version=150), @HLEFunction(nid=1607418813, version=660)})
    public int sceDmacplusMe2ScSync(boolean poll, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer32 result) {
        if (result.isNotNull()) {
            result.setValue(0, 0);
            result.setValue(4, 0);
            result.setValue(8, 0);
            result.setValue(12, 0);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=983100933, version=150), @HLEFunction(nid=-1089620898, version=660)})
    public int sceDmacplusAvcSync(boolean poll, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.out) TPointer32 result) {
        if (result.isNotNull()) {
            result.setValue(0, 0);
            result.setValue(4, 0);
            result.setValue(8, 0);
            result.setValue(12, 0);
            result.setValue(16, 0);
            result.setValue(20, 0);
            result.setValue(24, 0);
            result.setValue(28, 0);
            result.setValue(32, 0);
            result.setValue(36, 0);
            result.setValue(40, 0);
            result.setValue(44, 0);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=605421998, version=150), @HLEFunction(nid=869086941, version=660)})
    public int sceDmacplusLcdcGetFormat() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1672926309, version=660)
    public int sceDmacplus_driver_9C492B9B() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1268254088, version=150), @HLEFunction(nid=-1631617730, version=660)})
    public int sceDmacplusSc2MeNormal16() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-48743473, version=150), @HLEFunction(nid=-1326685939, version=660)})
    public int sceDmacplusSc128LLI() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1489207483, version=150), @HLEFunction(nid=-858824599, version=660)})
    public int sceDmacplusLcdcGetBaseAddr() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1100400600, version=150), @HLEFunction(nid=-606580113, version=660)})
    public int sceDmacplusMe2ScNormal16() {
        return 0;
    }
}

