/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.SeekableDataInputVirtualFile;
import jpcsp.HLE.VFS.crypto.EDATVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.crypto.CryptoEngine;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class scePspNpDrm_user
extends HLEModule {
    public static Logger log = Modules.getLogger("scePspNpDrm_user");
    public static final int PSP_NPDRM_LICENSEE_KEY_LENGTH = 16;
    private byte[] licenseeKey = new byte[16];
    private boolean isLicenseeKeySet = false;
    private boolean isDLCDecryptionDisabled;

    @Override
    public void start() {
        this.setSettingsListener("emu.disableDLC", new DisableDLCSettingsListerner());
        super.start();
    }

    public boolean isLicenseeKeySet() {
        return this.isLicenseeKeySet;
    }

    public void setLicenseeKeySet(boolean isLicenseeKeySet) {
        this.isLicenseeKeySet = isLicenseeKeySet;
    }

    public boolean isDLCDecryptionDisabled() {
        return this.isDLCDecryptionDisabled;
    }

    public boolean isDLCDecryptionEnabled() {
        return !this.isDLCDecryptionDisabled;
    }

    public void setDLCDecryptionDisabled(boolean isDLCDecryptionDisabled) {
        this.isDLCDecryptionDisabled = isDLCDecryptionDisabled;
    }

    public byte[] getLicenseeKey() {
        return this.licenseeKey;
    }

    public static boolean isEncrypted(byte[] header) {
        return Utilities.readUnaligned32(header, 0) == 0x50535000 && Utilities.readUnaligned32(header, 4) == 0x54414445;
    }

    private boolean isEncrypted(IVirtualFile vFile) {
        if (vFile == null) {
            return false;
        }
        long position = vFile.getPosition();
        byte[] header = new byte[8];
        int length = vFile.ioRead(header, 0, header.length);
        vFile.ioLseek(position);
        if (length != header.length) {
            return false;
        }
        return scePspNpDrm_user.isEncrypted(header);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1590468463, version=150, checkInsideInterrupt=true)
    public int sceNpDrmSetLicenseeKey(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer licenseeKeyAddr) {
        licenseeKeyAddr.getArray8(this.licenseeKey);
        this.setLicenseeKeySet(true);
        return 0;
    }

    @HLEFunction(nid=-1686874814, version=150, checkInsideInterrupt=true)
    public int sceNpDrmClearLicenseeKey() {
        Arrays.fill(this.licenseeKey, (byte)0);
        this.setLicenseeKeySet(false);
        return 0;
    }

    @HLEFunction(nid=660178897, version=150, checkInsideInterrupt=true)
    public int sceNpDrmRenameCheck(PspString fileName) {
        CryptoEngine crypto = new CryptoEngine();
        int result = 0;
        if (!this.isLicenseeKeySet()) {
            result = -2141910762;
        } else {
            IVirtualFile vFile = Modules.IoFileMgrForUserModule.getVirtualFile(fileName.getString(), 1, 511);
            if (vFile == null) {
                result = -2141910783;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNpDrmRenameCheck: file '%s' not found", fileName.getString()));
                }
            } else {
                String fName = fileName.getString();
                int lastFileNamePart = fName.lastIndexOf(47);
                if (lastFileNamePart > 0) {
                    fName = fName.substring(lastFileNamePart + 1);
                }
                byte[] inBuf = new byte[128];
                byte[] srcData = new byte[48];
                byte[] srcHash = new byte[16];
                int length = vFile.ioRead(inBuf, 0, inBuf.length);
                vFile.ioClose();
                if (length == inBuf.length && scePspNpDrm_user.isEncrypted(inBuf)) {
                    System.arraycopy(inBuf, 16, srcData, 0, 48);
                    System.arraycopy(inBuf, 64, srcHash, 0, 16);
                    if (!crypto.getPGDEngine().CheckEDATRenameKey(fName.getBytes(), srcHash, srcData) && this.isDLCDecryptionEnabled()) {
                        result = -2141910761;
                        log.warn((Object)"sceNpDrmRenameCheck: the file has been renamed");
                    }
                } else {
                    result = 0;
                }
            }
        }
        return result;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=148474004, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataSetupKey(int edataFd) {
        EDATVirtualFile pgdFile;
        if (!this.isLicenseeKeySet()) {
            return -2141910762;
        }
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        if (info == null) {
            return -1;
        }
        int result = 0;
        IVirtualFile vFile = info.vFile;
        if (vFile == null && info.readOnlyFile != null) {
            vFile = new SeekableDataInputVirtualFile(info.readOnlyFile);
        }
        if (this.isEncrypted(vFile) && (pgdFile = new EDATVirtualFile(vFile)).isValid()) {
            info.vFile = pgdFile;
        }
        return result;
    }

    @HLEFunction(nid=564065740, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataGetDataSize(int edataFd) {
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        int size = 0;
        if (info != null) {
            if (info.vFile != null) {
                size = (int)info.vFile.length();
            } else if (info.readOnlyFile != null) {
                try {
                    size = (int)info.readOnlyFile.length();
                }
                catch (IOException e) {
                    log.error((Object)"sceNpDrmEdataGetDataSize", (Throwable)e);
                }
            }
        }
        return size;
    }

    @HLEUnimplemented
    @HLEFunction(nid=732578452, version=150, checkInsideInterrupt=true)
    public int sceNpDrmOpen(PspString name, int flags, int permissions) {
        if (!this.isLicenseeKeySet()) {
            return -2141910762;
        }
        int fd = Modules.IoFileMgrForUserModule.hleIoOpen(name, flags | 0x40000000, permissions, true);
        return this.sceNpDrmEdataSetupKey(fd);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-340682515, version=150)
    public int sceNpDrmDecActivation(TPointer unknown1, TPointer unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=400815291, version=150)
    public int sceNpDrmVerifyAct(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4152, usage=BufferInfo.Usage.in) TPointer actDatAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=934916365, version=150)
    public int sceNpDrmVerifyRif(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1148764211, version=150)
    public int sceNpDrmVerifyRifById(int id) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1707823969, version=150)
    public int sceNpDrmCheckRifTimeLimit(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-778146264, version=150)
    public int sceNpDrmCheckRifTimeLimitById(int id) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=261441510, version=150)
    public int sceNpDrmGetVersionKey(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer keyAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4152, usage=BufferInfo.Usage.in) TPointer actDatAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr, int type) {
        byte[] ebootKey = Modules.scePopsManModule.getEbootKey();
        if (ebootKey != null) {
            keyAddr.setArray(ebootKey);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1449637817, version=150)
    public int sceNpDrmGetContentKey(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer keyAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4152, usage=BufferInfo.Usage.in) TPointer actDatAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=152, usage=BufferInfo.Usage.in) TPointer rifAddr) {
        return this.sceNpDrmGetVersionKey(keyAddr, actDatAddr, rifAddr, 0);
    }

    @HLEUnimplemented
    @HLEFunction(nid=763922330, version=150)
    public int sceNpDrmSetDebugMode(int debugMode) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=894755624, version=150)
    public int sceNpDrmSetRifDevice(int rifDevice) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-747942291, version=150)
    public int sceNpDrmGetModuleKey(int fileId, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer key) {
        return 0;
    }

    @HLEFunction(nid=11364344, version=150)
    public int sceNpDrmGetFixedKey(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer key, PspString data, int type) {
        if (Utilities.notHasBit(type, 24)) {
            return -2141910783;
        }
        byte[] hash = new byte[16];
        byte[] dataBuffer = new byte[48];
        data.getPointer().getArray8(0, dataBuffer, 0, data.getString().length());
        hash = new CryptoEngine().getDRMEngine().hleNpDrmGetFixedKey(hash, dataBuffer, type & 0xFF);
        key.setArray(hash);
        return 0;
    }

    private class DisableDLCSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableDLCSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            scePspNpDrm_user.this.setDLCDecryptionDisabled(value);
        }
    }
}

