/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.sceAtrac3plus;
import jpcsp.Memory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.sound.SoundMixer;
import jpcsp.sound.SoundVoice;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceSasCore
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSasCore");
    public static final int PSP_SAS_VOICES_MAX = 32;
    public static final int PSP_SAS_GRAIN_SAMPLES = 256;
    public static final int PSP_SAS_VOL_MAX = 4096;
    public static final int PSP_SAS_LOOP_MODE_OFF = 0;
    public static final int PSP_SAS_LOOP_MODE_ON = 1;
    public static final int PSP_SAS_PITCH_MIN = 1;
    public static final int PSP_SAS_PITCH_BASE = 4096;
    public static final int PSP_SAS_PITCH_MAX = 16384;
    public static final int PSP_SAS_NOISE_FREQ_MAX = 63;
    public static final int PSP_SAS_ENVELOPE_HEIGHT_MAX = 0x40000000;
    public static final int PSP_SAS_ENVELOPE_FREQ_MAX = Integer.MAX_VALUE;
    public static final int PSP_SAS_ADSR_CURVE_MODE_LINEAR_INCREASE = 0;
    public static final int PSP_SAS_ADSR_CURVE_MODE_LINEAR_DECREASE = 1;
    public static final int PSP_SAS_ADSR_CURVE_MODE_LINEAR_BENT = 2;
    public static final int PSP_SAS_ADSR_CURVE_MODE_EXPONENT_DECREASE = 3;
    public static final int PSP_SAS_ADSR_CURVE_MODE_EXPONENT_INCREASE = 4;
    public static final int PSP_SAS_ADSR_CURVE_MODE_DIRECT = 5;
    public static final int PSP_SAS_ADSR_ATTACK = 1;
    public static final int PSP_SAS_ADSR_DECAY = 2;
    public static final int PSP_SAS_ADSR_SUSTAIN = 4;
    public static final int PSP_SAS_ADSR_RELEASE = 8;
    public static final int PSP_SAS_OUTPUTMODE_STEREO = 0;
    public static final int PSP_SAS_OUTPUTMODE_MONO = 1;
    public static final int PSP_SAS_EFFECT_TYPE_OFF = -1;
    public static final int PSP_SAS_EFFECT_TYPE_ROOM = 0;
    public static final int PSP_SAS_EFFECT_TYPE_UNK1 = 1;
    public static final int PSP_SAS_EFFECT_TYPE_UNK2 = 2;
    public static final int PSP_SAS_EFFECT_TYPE_UNK3 = 3;
    public static final int PSP_SAS_EFFECT_TYPE_HALL = 4;
    public static final int PSP_SAS_EFFECT_TYPE_SPACE = 5;
    public static final int PSP_SAS_EFFECT_TYPE_ECHO = 6;
    public static final int PSP_SAS_EFFECT_TYPE_DELAY = 7;
    public static final int PSP_SAS_EFFECT_TYPE_PIPE = 8;
    private static final String[] sasADSRCurveTypeNames = new String[]{"LINEAR_INCREASE", "LINEAR_DECREASE", "LINEAR_BENT", "EXPONENT_REV", "EXPONENT", "DIRECT"};
    public static final int CURVE_STATE_OFF = -1;
    public static final int CURVE_STATE_START = -2;
    public static final int CURVE_STATE_ATTACK = 0;
    public static final int CURVE_STATE_DECAY = 1;
    public static final int CURVE_STATE_SUSTAIN = 2;
    public static final int CURVE_STATE_RELEASE = 3;
    public static final int CURVE_STATE_ENDED = 4;
    private static final int SASCORE_ATRAC3_CONTEXT_OFFSET = 20;
    private static final int SASCORE_VOICE_SIZE = 56;
    private static final int SASCORE_ME_OFFSET = 1812;
    private static final int SASCORE_ME_PARAMS_OFFSET = 1792;
    private static final int SASCORE_ME_VOICE_TYPE_NONE = 0;
    private static final int SASCORE_ME_VOICE_TYPE_VAG = 1;
    private static final int SASCORE_ME_VOICE_TYPE_NOISE = 2;
    private static final int SASCORE_ME_VOICE_TYPE_PCM = 5;
    private static final int SASCORE_ME_VOICE_TYPE_ATRAC3 = 6;
    protected int sasCoreUid;
    protected SoundVoice[] voices;
    protected SoundMixer mixer;
    protected int grainSamples;
    protected int outputMode;
    protected static final int waveformBufMaxSize = 1024;
    protected int waveformEffectType;
    protected int waveformEffectLeftVol;
    protected int waveformEffectRightVol;
    protected int waveformEffectDelay;
    protected int waveformEffectFeedback;
    protected boolean waveformEffectIsDryOn;
    protected boolean waveformEffectIsWetOn;
    protected static final int sasCoreDelay = 5000;
    protected static final String sasCodeUidPurpose = "sceSasCore-SasCore";

    @Override
    public void start() {
        this.sasCoreUid = -1;
        this.voices = new SoundVoice[32];
        for (int i = 0; i < this.voices.length; ++i) {
            this.voices[i] = new SoundVoice(i);
        }
        this.mixer = new SoundMixer(this.voices);
        this.grainSamples = 256;
        this.outputMode = 0;
        super.start();
    }

    public static String getSasADSRCurveTypeName(int curveType) {
        if (curveType < 0 || curveType >= sasADSRCurveTypeNames.length) {
            return String.format("UNKNOWN_%d", curveType);
        }
        return sasADSRCurveTypeNames[curveType];
    }

    protected void checkSasAddressGood(int sasCore) {
        if (!Memory.isAddressGood(sasCore)) {
            log.warn((Object)String.format("%s bad sasCore Address 0x%08X", sceSasCore.getCallingFunctionName(3), sasCore));
            throw new SceKernelErrorException(-2143158267);
        }
        if (!Memory.isAddressAlignedTo(sasCore, 64)) {
            log.warn((Object)String.format("%s bad sasCore Address 0x%08X (not aligned to 64)", sceSasCore.getCallingFunctionName(3), sasCore));
            throw new SceKernelErrorException(-2143158267);
        }
    }

    protected void checkSasHandleGood(int sasCore) {
        this.checkSasAddressGood(sasCore);
        int checkValue = this.getMemory().read32(sasCore);
        if (checkValue != this.sasCoreUid && !Modules.sceMeMemoryModule.isAllocated(checkValue - 2432)) {
            log.error((Object)String.format("%s bad sasCoreUid 0x%08X (should be 0x%08X)", sceSasCore.getCallingFunctionName(3), checkValue, this.sasCoreUid));
            throw new SceKernelErrorException(-2143158016);
        }
    }

    protected void checkVoiceNumberGood(int voice) {
        if (voice < 0 || voice >= this.voices.length) {
            log.warn((Object)String.format("%s bad voice number %d", sceSasCore.getCallingFunctionName(3), voice));
            throw new SceKernelErrorException(-2143158256);
        }
    }

    protected void checkSasAndVoiceHandlesGood(int sasCore, int voice) {
        this.checkSasHandleGood(sasCore);
        this.checkVoiceNumberGood(voice);
    }

    protected void checkADSRmode(int curveIndex, int flag, int curveType) {
        int[] validCurveTypes = new int[]{21, 42, 63, 42};
        if ((flag & 1 << curveIndex) != 0 && (validCurveTypes[curveIndex] & 1 << curveType) == 0) {
            throw new SceKernelErrorException(-2143158253);
        }
    }

    protected void checkVoiceNotPaused(int voice, boolean requiredOnState) {
        if (this.voices[voice].isPaused() || this.voices[voice].isOn() != requiredOnState) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkVoiceNotPaused returning 0x%08X(ERROR_SAS_VOICE_PAUSED)", -2143158250));
            }
            throw new SceKernelErrorException(-2143158250);
        }
    }

    public int checkVolume(int volume) {
        if (volume < -4096 || volume > 4096) {
            throw new SceKernelErrorException(-2143158248);
        }
        return volume;
    }

    private void delayThread(long startMicros, int delayMicros, int minimumDelayMicros) {
        long now = Emulator.getClock().microTime();
        int threadDelayMicros = delayMicros - (int)(now - startMicros);
        if ((threadDelayMicros = Math.max(threadDelayMicros, minimumDelayMicros)) > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(threadDelayMicros, false);
        } else {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    private void delayThreadSasCore(long startMicros) {
        int delayMicros = 600;
        this.delayThread(startMicros, delayMicros, delayMicros);
    }

    public int getOutputMode() {
        return this.outputMode;
    }

    protected void setSasCoreAtrac3Context(int sasCore, int voice, int atrac3Context) {
        Memory mem = Memory.getInstance();
        mem.write32(sasCore + 56 * voice + 20, atrac3Context);
    }

    protected int getSasCoreAtrac3Context(int sasCore, int voice) {
        Memory mem = Memory.getInstance();
        return mem.read32(sasCore + 56 * voice + 20);
    }

    public void copySasCoreToME(int sasCore) {
        this.grainSamples = this.getMemory().read8(sasCore + 8) << 5;
        TPointer base = new TPointer(this.getMemory(), sasCore + 1812);
        int revVON = base.getUnsignedValue8(1796);
        this.waveformEffectIsDryOn = Utilities.hasBit(revVON, 0);
        this.waveformEffectIsWetOn = Utilities.hasBit(revVON, 1);
        this.waveformEffectLeftVol = base.getUnsignedValue16(1798);
        this.waveformEffectRightVol = base.getUnsignedValue16(1800);
        for (int i = 0; i < this.voices.length; ++i) {
            int voiceType = base.getUnsignedValue8(8) & 0xF;
            if (voiceType != 0) {
                SoundVoice voice = this.voices[i];
                int voicePaused = base.getUnsignedValue8(8) >> 4 & 3;
                voice.setPaused(voicePaused != 0);
                byte curveState = base.getValue8(51);
                voice.getEnvelope().curveState = curveState;
                if (curveState != -1) {
                    if (curveState == -2) {
                        switch (voiceType) {
                            case 1: {
                                voice.setVAG(base.getValue32(0), base.getValue32(4) - base.getValue32(0));
                                voice.setLoopMode(base.getUnsignedValue8(9));
                                break;
                            }
                            case 2: {
                                voice.setNoise(base.getValue32(4));
                                break;
                            }
                            case 5: {
                                voice.setPCM(base.getValue32(0), base.getUnsignedValue16(4) + 1);
                                voice.setLoopMode(base.getUnsignedValue16(6));
                                break;
                            }
                            case 6: {
                                this.setSasCoreAtrac3Context(sasCore, i, base.getValue32(0));
                                break;
                            }
                            default: {
                                log.error((Object)String.format("copySasCoreToME voice#%d: unknown voice type %d", i, voiceType));
                            }
                        }
                        voice.on();
                    }
                    voice.setPitch(base.getUnsignedValue16(10));
                    voice.setLeftVolume(base.getUnsignedValue16(12) << 3);
                    voice.setEffectLeftVolume(base.getUnsignedValue16(14) << 3);
                    voice.setRightVolume(base.getUnsignedValue16(16) << 3);
                    voice.setEffectRightVolume(base.getUnsignedValue16(18) << 3);
                    SoundVoice.VoiceADSREnvelope envelope = this.voices[i].getEnvelope();
                    envelope.AttackRate = base.getValue32(24);
                    envelope.DecayRate = base.getValue32(28);
                    envelope.SustainRate = base.getValue32(32);
                    envelope.ReleaseRate = base.getValue32(36);
                    envelope.SustainLevel = base.getValue32(40);
                    envelope.AttackCurveType = base.getUnsignedValue8(44);
                    envelope.DecayCurveType = base.getUnsignedValue8(45);
                    envelope.SustainCurveType = base.getUnsignedValue8(46);
                    envelope.ReleaseCurveType = base.getUnsignedValue8(47);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("copySasCoreToME voice#%d: type=%d, paused=%d, curveState=%d: %s", i, voiceType, voicePaused, (int)curveState, Utilities.getMemoryDump(base, 56)));
                    }
                }
            }
            base.add(56);
        }
    }

    public void copyMEToSasCore(int sasCore) {
        TPointer base = new TPointer(this.getMemory(), sasCore + 1812);
        int endFlag = this.__sceSasGetEndFlag(sasCore);
        base.setValue32(1792, endFlag);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("copyMEToSasCore endFlag=0x%08X", endFlag));
        }
        for (int i = 0; i < this.voices.length; ++i) {
            int voiceType = base.getUnsignedValue8(8) & 0xF;
            if (voiceType != 0) {
                SoundVoice voice = this.voices[i];
                int height = voice.getEnvelope().height;
                int curveState = voice.isOn() ? voice.getEnvelope().curveState : -1;
                base.setValue32(52, height);
                base.setUnsignedValue8(51, curveState);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("copyMEToSasCore voice#%d: height=0x%08X, curveState=%d", i, height, curveState));
                }
            }
            base.add(56);
        }
    }

    @HLEFunction(nid=26945003, version=150, checkInsideInterrupt=true)
    public int __sceSasSetADSR(int sasCore, int voice, int flag, int attack, int decay, int sustain, int release) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        SoundVoice.VoiceADSREnvelope envelope = this.voices[voice].getEnvelope();
        if ((flag & 1) != 0) {
            envelope.AttackRate = attack;
        }
        if ((flag & 2) != 0) {
            envelope.DecayRate = decay;
        }
        if ((flag & 4) != 0) {
            envelope.SustainRate = sustain;
        }
        if ((flag & 8) != 0) {
            envelope.ReleaseRate = release;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetADSR voice=0x%X: %s", voice, envelope.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=645557714, version=150, checkInsideInterrupt=true)
    public int __sceSasRevParam(int sasCore, int delay, int feedback) {
        this.checkSasHandleGood(sasCore);
        this.waveformEffectDelay = delay;
        this.waveformEffectFeedback = feedback;
        return 0;
    }

    @HLEFunction(nid=747530931, version=150, checkInsideInterrupt=true)
    public int __sceSasGetPauseFlag(int sasCore) {
        this.checkSasHandleGood(sasCore);
        int pauseFlag = 0;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].isPaused()) continue;
            pauseFlag |= 1 << i;
        }
        return pauseFlag;
    }

    @HLEFunction(nid=869575479, version=150, checkInsideInterrupt=true)
    public int __sceSasRevType(int sasCore, int type) {
        this.checkSasHandleGood(sasCore);
        this.waveformEffectType = type;
        return 0;
    }

    @HLEFunction(nid=1115130527, version=150)
    public int __sceSasInit(@CanBeNull TPointer sasCore, int grain, int maxVoices, int outputMode, int sampleRate) {
        this.checkSasAddressGood(sasCore.getAddress());
        if (grain < 64 || grain > 2048 || (grain & 0x1F) != 0) {
            return -2143158271;
        }
        if (sampleRate != 44100) {
            return -2143158268;
        }
        if (maxVoices <= 0 || maxVoices > 32) {
            return -2143158270;
        }
        if (outputMode != 0 && outputMode != 1) {
            return -2143158269;
        }
        if (this.sasCoreUid != -1) {
            SceUidManager.releaseUid(this.sasCoreUid, sasCodeUidPurpose);
        }
        sasCore.clear(3616);
        this.sasCoreUid = SceUidManager.getNewUid(sasCodeUidPurpose);
        sasCore.setValue32(0, this.sasCoreUid);
        this.grainSamples = grain;
        this.outputMode = outputMode;
        for (int i = 0; i < this.voices.length; ++i) {
            this.voices[i].setSampleRate(sampleRate);
        }
        return 0;
    }

    @HLEFunction(nid=1141680088, version=150, checkInsideInterrupt=true)
    public int __sceSasSetVolume(int sasCore, int voice, @CheckArgument(value="checkVolume") int leftVolume, @CheckArgument(value="checkVolume") int rightVolume, @CheckArgument(value="checkVolume") int effectLeftVolumne, @CheckArgument(value="checkVolume") int effectRightVolume) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setLeftVolume(leftVolume << 3);
        this.voices[voice].setRightVolume(rightVolume << 3);
        this.voices[voice].setEffectLeftVolume(effectLeftVolumne << 3);
        this.voices[voice].setEffectRightVolume(effectRightVolume << 3);
        return 0;
    }

    @HLEFunction(nid=1352748540, version=150, checkInsideInterrupt=true)
    public int __sceSasCoreWithMix(int sasCore, int sasInOut, int leftVolume, int rightVolume) {
        this.checkSasHandleGood(sasCore);
        long startTime = Emulator.getClock().microTime();
        this.mixer.synthesizeWithMix(sasInOut, this.grainSamples, leftVolume << 3, rightVolume << 3);
        this.delayThreadSasCore(startTime);
        return 0;
    }

    @HLEFunction(nid=1603611126, version=150, checkInsideInterrupt=true)
    public int __sceSasSetSL(int sasCore, int voice, int level) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].getEnvelope().SustainLevel = level;
        return 0;
    }

    @HLEFunction(nid=1755605909, version=150)
    public int __sceSasGetEndFlag(int sasCore) {
        this.checkSasHandleGood(sasCore);
        int endFlag = 0;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].isEnded()) continue;
            endFlag |= 1 << i;
        }
        return endFlag;
    }

    @HLEFunction(nid=1957582890, version=150, checkInsideInterrupt=true)
    public int __sceSasGetEnvelopeHeight(int sasCore, int voice) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        return this.voices[voice].getEnvelope().height;
    }

    @HLEFunction(nid=1995446986, version=150, checkInsideInterrupt=true)
    public int __sceSasSetKeyOn(int sasCore, int voice) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.checkVoiceNotPaused(voice, false);
        this.voices[voice].on();
        return 0;
    }

    @HLEFunction(nid=2021459157, version=150, checkInsideInterrupt=true)
    public int __sceSasSetPause(int sasCore, int voice_bit, boolean setPause) {
        this.checkSasHandleGood(sasCore);
        int i = 0;
        while (voice_bit != 0) {
            if ((voice_bit & 1) != 0) {
                this.voices[i].setPaused(setPause);
            }
            ++i;
            voice_bit >>>= 1;
        }
        return 0;
    }

    @HLEFunction(nid=-1718337399, version=150, checkInsideInterrupt=true)
    public int __sceSasSetVoice(int sasCore, int voice, int vagAddr, int size, int loopmode) {
        if (size <= 0 || (size & 0xF) != 0) {
            log.warn((Object)String.format("__sceSasSetVoice invalid size 0x%08X", size));
            return -2143158252;
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setVAG(vagAddr, size);
        this.voices[voice].setLoopMode(loopmode);
        return 0;
    }

    @HLEFunction(nid=-1631361174, version=150, checkInsideInterrupt=true)
    public int __sceSasSetADSRmode(int sasCore, int voice, int flag, int attackType, int decayType, int sustainType, int releaseType) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.checkADSRmode(0, flag, attackType);
        this.checkADSRmode(1, flag, decayType);
        this.checkADSRmode(2, flag, sustainType);
        this.checkADSRmode(3, flag, releaseType);
        SoundVoice.VoiceADSREnvelope envelope = this.voices[voice].getEnvelope();
        if ((flag & 1) != 0) {
            envelope.AttackCurveType = attackType;
        }
        if ((flag & 2) != 0) {
            envelope.DecayCurveType = decayType;
        }
        if ((flag & 4) != 0) {
            envelope.SustainCurveType = sustainType;
        }
        if ((flag & 8) != 0) {
            envelope.ReleaseCurveType = releaseType;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetADSRmode voice=0x%X: %s", voice, envelope.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-1597034588, version=150, checkInsideInterrupt=true)
    public int __sceSasSetKeyOff(int sasCore, int voice) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.checkVoiceNotPaused(voice, true);
        this.voices[voice].off();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1573729306, version=150, checkInsideInterrupt=true)
    public int __sceSasSetTriangularWave(int sasCore, int voice, int unknown) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        return 0;
    }

    @HLEFunction(nid=-1554473599, version=150, checkInsideInterrupt=true)
    public int __sceSasCore(int sasCore, int sasOut) {
        this.checkSasHandleGood(sasCore);
        long startTime = Emulator.getClock().microTime();
        this.mixer.synthesize(sasOut, this.grainSamples);
        this.delayThreadSasCore(startTime);
        return 0;
    }

    @HLEFunction(nid=-1383804033, version=150, checkInsideInterrupt=true)
    public int __sceSasSetPitch(int sasCore, int voice, int pitch) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setPitch(pitch);
        return 0;
    }

    @HLEFunction(nid=-1218049501, version=150, checkInsideInterrupt=true)
    public int __sceSasSetNoise(int sasCore, int voice, int freq) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setNoise(freq);
        return 0;
    }

    @HLEFunction(nid=-1122912318, version=150, checkInsideInterrupt=true)
    public int __sceSasGetGrain(int sasCore) {
        this.checkSasHandleGood(sasCore);
        return this.grainSamples;
    }

    private int getSimpleSustainLevel(int bitfield1) {
        return (bitfield1 & 0xF) + 1 << 26;
    }

    private int getSimpleDecayRate(int bitfield1) {
        int bitShift = bitfield1 >> 4 & 0xF;
        if (bitShift == 0) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE >>> bitShift;
    }

    private int getSimpleRate(int n) {
        if ((n &= 0x7F) == 127) {
            return 0;
        }
        int rate = 7 - (n & 3) << 26 >>> (n >> 2);
        if (rate == 0) {
            return 1;
        }
        return rate;
    }

    private int getSimpleExponentRate(int n) {
        if ((n &= 0x7F) == 127) {
            return 0;
        }
        int rate = 7 - (n & 3) << 24 >>> (n >> 2);
        if (rate == 0) {
            return 1;
        }
        return rate;
    }

    private int getSimpleAttackRate(int bitfield1) {
        return this.getSimpleRate(bitfield1 >> 8);
    }

    private int getSimpleAttackCurveType(int bitfield1) {
        return (bitfield1 & 0x8000) == 0 ? 0 : 2;
    }

    private int getSimpleReleaseRate(int bitfield2) {
        int n = bitfield2 & 0x1F;
        if (n == 31) {
            return 0;
        }
        if (this.getSimpleReleaseCurveType(bitfield2) == 1) {
            if (n == 30) {
                return 0x40000000;
            }
            if (n == 29) {
                return 1;
            }
            return 0x10000000 >> n;
        }
        if (n == 0) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE >>> n;
    }

    private int getSimpleReleaseCurveType(int bitfield2) {
        return (bitfield2 & 0x20) == 0 ? 1 : 3;
    }

    private int getSimpleSustainRate(int bitfield2) {
        if (this.getSimpleSustainCurveType(bitfield2) == 3) {
            return this.getSimpleExponentRate(bitfield2 >> 6);
        }
        return this.getSimpleRate(bitfield2 >> 6);
    }

    private int getSimpleSustainCurveType(int bitfield2) {
        switch (bitfield2 >> 13) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        throw new SceKernelErrorException(-2143158253);
    }

    @HLEFunction(nid=-875737223, version=150, checkInsideInterrupt=true)
    public int __sceSasSetSimpleADSR(int sasCore, int voice, int ADSREnv1, int ADSREnv2) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        int env1Bitfield = ADSREnv1 & 0xFFFF;
        int env2Bitfield = ADSREnv2 & 0xFFFF;
        SoundVoice.VoiceADSREnvelope envelope = this.voices[voice].getEnvelope();
        envelope.SustainLevel = this.getSimpleSustainLevel(env1Bitfield);
        envelope.DecayRate = this.getSimpleDecayRate(env1Bitfield);
        envelope.DecayCurveType = 3;
        envelope.AttackRate = this.getSimpleAttackRate(env1Bitfield);
        envelope.AttackCurveType = this.getSimpleAttackCurveType(env1Bitfield);
        envelope.ReleaseRate = this.getSimpleReleaseRate(env2Bitfield);
        envelope.ReleaseCurveType = this.getSimpleReleaseCurveType(env2Bitfield);
        envelope.SustainRate = this.getSimpleSustainRate(env2Bitfield);
        envelope.SustainCurveType = this.getSimpleSustainCurveType(env2Bitfield);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetSimpleADSR voice=0x%X: %s", voice, envelope.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-773808098, version=150, checkInsideInterrupt=true)
    public int __sceSasSetGrain(int sasCore, int grain) {
        this.checkSasHandleGood(sasCore);
        this.grainSamples = grain;
        return 0;
    }

    @HLEFunction(nid=-710792759, version=150, checkInsideInterrupt=true)
    public int __sceSasRevEVOL(int sasCore, int leftVolume, int rightVolume) {
        this.checkSasHandleGood(sasCore);
        this.waveformEffectLeftVol = leftVolume;
        this.waveformEffectRightVol = rightVolume;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-705971251, version=150, checkInsideInterrupt=true)
    public int __sceSasSetSteepWave(int sasCore, int voice, int unknown) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        return 0;
    }

    @HLEFunction(nid=-512364698, version=150, checkInsideInterrupt=true)
    public int __sceSasGetOutputmode(int sasCore) {
        this.checkSasHandleGood(sasCore);
        return this.getOutputMode();
    }

    @HLEFunction(nid=-397033610, version=150, checkInsideInterrupt=true)
    public int __sceSasSetOutputmode(int sasCore, int outputMode) {
        this.checkSasHandleGood(sasCore);
        this.outputMode = outputMode;
        return 0;
    }

    @HLEFunction(nid=-108809850, version=150, checkInsideInterrupt=true)
    public int __sceSasRevVON(int sasCore, int dry, int wet) {
        this.checkSasHandleGood(sasCore);
        this.waveformEffectIsDryOn = dry > 0;
        this.waveformEffectIsWetOn = wet > 0;
        return 0;
    }

    @HLEFunction(nid=133532708, version=150, checkInsideInterrupt=true)
    public int __sceSasGetAllEnvelopeHeights(int sasCore, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=128, usage=BufferInfo.Usage.out) TPointer32 heightsAddr) {
        this.checkSasHandleGood(sasCore);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(heightsAddr.getAddress(), this.voices.length * 4, 4);
        for (int i = 0; i < this.voices.length; ++i) {
            int voiceHeight = this.voices[i].getEnvelope().height;
            memoryWriter.writeNext(voiceHeight);
            if (!log.isTraceEnabled() || voiceHeight == 0) continue;
            log.trace((Object)String.format("__sceSasGetAllEnvelopeHeights height voice #%d=0x%08X", i, voiceHeight));
        }
        memoryWriter.flush();
        return 0;
    }

    @HLEFunction(nid=-506620575, version=500, checkInsideInterrupt=true)
    public int __sceSasSetVoicePCM(int sasCore, int voice, TPointer pcmAddr, int size, int loopmode) {
        if (size <= 0 || size > 65536) {
            log.warn((Object)String.format("__sceSasSetVoicePCM invalid size 0x%08X", size));
            return -2143158246;
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setPCM(pcmAddr.getAddress(), size);
        this.voices[voice].setLoopMode(loopmode);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1252649686, version=600, checkInsideInterrupt=true)
    public int __sceSasSetVoiceATRAC3(int sasCore, int voice, int atrac3Context) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        sceAtrac3plus.AtracID atracId = Modules.sceAtrac3plusModule.getAtracIdFromContext(atrac3Context);
        if (atracId != null) {
            this.voices[voice].setAtracId(atracId);
            this.setSasCoreAtrac3Context(sasCore, voice, atrac3Context);
        }
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1956113029, version=600, checkInsideInterrupt=true)
    public int __sceSasConcatenateATRAC3(int sasCore, int voice, @CanBeNull TPointer atrac3DataAddr, int atrac3DataLength) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        int atrac3Context = this.getSasCoreAtrac3Context(sasCore, voice);
        sceAtrac3plus.AtracID atracID = Modules.sceAtrac3plusModule.getAtracIdFromContext(atrac3Context);
        if (atracID.getSecondBufferAddr() != -1) {
            return -2143158206;
        }
        atracID.setSecondBuffer(atrac3DataAddr.getAddress(), atrac3DataLength);
        return 0;
    }

    @HLEFunction(nid=-166691072, version=600, checkInsideInterrupt=true)
    public int __sceSasUnsetATRAC3(int sasCore, int voice) {
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setAtracId(null);
        this.setSasCoreAtrac3Context(sasCore, voice, 0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1325794929, version=150, moduleName="sceSasCore_driver")
    public int sceSasCoreInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-515661334, version=150, moduleName="sceSasCore_driver")
    public int sceSasCoreExit() {
        return 0;
    }
}

