/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.AfterCallbackAction;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.pspSysEventHandler;
import org.apache.log4j.Logger;

public class sceSysEventForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSysEventForKernel");
    private TPointer sysEventHandlers;

    @Override
    public void start() {
        this.sysEventHandlers = TPointer.NULL;
        super.start();
    }

    @HLEFunction(nid=-1364000594, version=150)
    public boolean sceKernelIsRegisterSysEventHandler(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=64, usage=BufferInfo.Usage.in) TPointer handler) {
        TPointer current = this.sysEventHandlers;
        while (current.isNotNull() && !current.equals(handler)) {
            current = pspSysEventHandler.getNext(current);
        }
        return current.isNotNull();
    }

    @HLEFunction(nid=-845263947, version=150)
    public int sceKernelRegisterSysEventHandler(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=64, usage=BufferInfo.Usage.in) TPointer handler) {
        pspSysEventHandler sysEventHandler = new pspSysEventHandler();
        sysEventHandler.read(handler);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelRegisterSysEventHandler handler: %s", sysEventHandler));
        }
        if (this.sceKernelIsRegisterSysEventHandler(handler)) {
            return -2147352473;
        }
        sysEventHandler.busy = false;
        sysEventHandler.gp = this.getProcessor().cpu._gp;
        sysEventHandler.next = this.sysEventHandlers;
        sysEventHandler.write(handler);
        if ("SceFatfsSysEvent".equals(sysEventHandler.name)) {
            Modules.sceMSstorModule.installDrivers();
        }
        return 0;
    }

    @HLEFunction(nid=-673972787, version=150)
    public int sceKernelUnregisterSysEventHandler(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=64, usage=BufferInfo.Usage.in) TPointer handler) {
        if (pspSysEventHandler.isBusy(handler)) {
            return -1;
        }
        TPointer current = this.sysEventHandlers;
        TPointer previous = TPointer.NULL;
        while (current.isNotNull()) {
            TPointer next = pspSysEventHandler.getNext(current);
            if (current.equals(handler)) {
                if (previous.isNull()) {
                    this.sysEventHandlers = next;
                    break;
                }
                pspSysEventHandler.setNext(previous, next);
                break;
            }
            previous = current;
            current = next;
        }
        if (current.isNull()) {
            return -2147352472;
        }
        return 0;
    }

    @HLEFunction(nid=909316756, version=150)
    public int sceKernelSysEventDispatch(int eventTypeMask, int eventId, PspString eventName, int param, TPointer32 resultAddr, int breakNonzero, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 breakHandler) {
        pspSysEventHandler sysEventHandler = new pspSysEventHandler();
        TPointer current = this.sysEventHandlers;
        int result = 0;
        while (current.isNotNull()) {
            if (pspSysEventHandler.isMatchingTypeMask(current, eventTypeMask)) {
                pspSysEventHandler.setBusy(current, true);
                sysEventHandler.read(current);
                AfterCallbackAction afterCallbackAction = new AfterCallbackAction(sysEventHandler.handler);
                Modules.ThreadManForUserModule.executeCallback(sysEventHandler.handler.getAddress(), sysEventHandler.gp, (IAction)afterCallbackAction, eventId, eventName.getAddress(), param, resultAddr.getAddress());
                pspSysEventHandler.setBusy(current, false);
                result = afterCallbackAction.getReturnValue();
                if (result < 0 && breakNonzero != 0) {
                    breakHandler.setPointer(current);
                    break;
                }
                result = 0;
            }
            current = pspSysEventHandler.getNext(current);
        }
        return result;
    }

    @HLEFunction(nid=1758811397, version=150)
    public int sceKernelReferSysEventHandler() {
        return this.sysEventHandlers.getAddress();
    }
}

