/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import jpcsp.Clock;

public class VariableSpeedClock
extends Clock {
    private int numerator;
    private int denominator;
    private long baseSystemNanoTime;
    private long baseSystemMilliTime;
    private long baseStartSystemNanoTime;
    private long baseStartSystemMilliTime;

    public VariableSpeedClock(Clock clock, int numerator, int denominator) {
        super(clock);
        this.setSpeed(numerator, denominator);
    }

    public void setSpeed(int numerator, int denominator) {
        if (this.denominator == 0) {
            this.baseStartSystemNanoTime = super.getSystemNanoTime();
            this.baseStartSystemMilliTime = super.getSystemMilliTime();
        } else {
            this.baseStartSystemNanoTime = this.getSystemNanoTime();
            this.baseStartSystemMilliTime = this.getSystemMilliTime();
        }
        this.numerator = numerator;
        this.denominator = denominator;
        this.baseSystemNanoTime = super.getSystemNanoTime();
        this.baseSystemMilliTime = super.getSystemMilliTime();
    }

    private long adaptToSpeed(long value) {
        return value * (long)this.numerator / (long)this.denominator;
    }

    @Override
    protected long getSystemNanoTime() {
        long systemNanoTime = super.getSystemNanoTime();
        long deltaNanoTime = systemNanoTime - this.baseSystemNanoTime;
        return this.baseStartSystemNanoTime + this.adaptToSpeed(deltaNanoTime);
    }

    @Override
    protected long getSystemMilliTime() {
        long systemMilliTime = super.getSystemMilliTime();
        long deltaMilliTime = systemMilliTime - this.baseSystemMilliTime;
        return this.baseStartSystemMilliTime + this.adaptToSpeed(deltaMilliTime);
    }
}

