/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import jpcsp.crypto.AES128;
import jpcsp.crypto.AMCTRL;
import jpcsp.crypto.KeyVault;

public class DRM {
    private static AMCTRL amctrl;
    private byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public DRM() {
        amctrl = new AMCTRL();
    }

    public byte[] hleNpDrmGetFixedKey(byte[] hash, byte[] data, int mode) {
        AMCTRL.BBMac_Ctx bbctx = new AMCTRL.BBMac_Ctx();
        AES128 aes = new AES128("AES/CBC/NoPadding");
        int[] drmEncKey = null;
        switch (mode) {
            case 1: {
                drmEncKey = KeyVault.drmEncKey1;
                break;
            }
            case 2: {
                drmEncKey = KeyVault.drmEncKey2;
                break;
            }
            case 3: {
                drmEncKey = KeyVault.drmEncKey3;
            }
        }
        if (drmEncKey == null) {
            return null;
        }
        byte[] encKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            encKey[i] = (byte)drmEncKey[i];
        }
        byte[] fixedKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            fixedKey[i] = (byte)KeyVault.drmFixedKey[i];
        }
        amctrl.hleDrmBBMacInit(bbctx, 1);
        amctrl.hleDrmBBMacUpdate(bbctx, data, data.length);
        amctrl.hleDrmBBMacFinal(bbctx, hash, fixedKey);
        return aes.encrypt(hash, encKey, this.iv);
    }

    public byte[] GetKeyFromRif(byte[] rifBuf, byte[] actdatBuf, byte[] openPSID) {
        AES128 aes = new AES128("AES/ECB/NoPadding");
        byte[] rifIndex = new byte[16];
        byte[] rifDatKey = new byte[16];
        byte[] encRifIndex = new byte[16];
        byte[] encRifDatKey = new byte[16];
        byte[] rifKey = new byte[KeyVault.drmRifKey.length];
        for (int i = 0; i < KeyVault.drmRifKey.length; ++i) {
            rifKey[i] = (byte)(KeyVault.drmRifKey[i] & 0xFF);
        }
        System.arraycopy(rifBuf, 64, encRifIndex, 0, 16);
        System.arraycopy(rifBuf, 80, encRifDatKey, 0, 16);
        rifIndex = aes.decrypt(encRifIndex, rifKey, this.iv);
        long index = rifIndex[15];
        if (index < 128L) {
            byte[] actDat = this.DecryptActdat(actdatBuf, openPSID);
            byte[] datKey = new byte[16];
            System.arraycopy(actDat, (int)index * 16, datKey, 0, 16);
            rifDatKey = aes.decrypt(encRifDatKey, datKey, this.iv);
        }
        return rifDatKey;
    }

    public byte[] DecryptActdat(byte[] actdatBuf, byte[] openPSID) {
        AES128 aes = new AES128("AES/ECB/NoPadding");
        byte[] actdat = new byte[2048];
        byte[] consoleKey = this.GetConsoleKey(openPSID);
        System.arraycopy(actdatBuf, 16, actdat, 0, actdat.length - 16);
        return aes.decrypt(actdat, consoleKey, this.iv);
    }

    public byte[] GetConsoleKey(byte[] openPSID) {
        AES128 aes = new AES128("AES/ECB/NoPadding");
        byte[] actdatKey = new byte[KeyVault.drmActdatKey.length];
        for (int i = 0; i < KeyVault.drmActdatKey.length; ++i) {
            actdatKey[i] = (byte)(KeyVault.drmActdatKey[i] & 0xFF);
        }
        return aes.encrypt(openPSID, actdatKey, this.iv);
    }
}

