/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import jpcsp.Emulator;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;

public class ECDSA {
    private static Logger log = Emulator.log;
    private KeyPair keyPair;
    private ECCurve curve;
    private ECParameterSpec spec;
    private KeyPairGenerator g;
    private KeyFactory f;

    public void setCurve() {
        try {
            this.curve = new ECCurve.Fp(new BigInteger("FFFFFFFFFFFFFFFF00000001FFFFFFFFFFFFFFFF", 16), new BigInteger("FFFFFFFFFFFFFFFF00000001FFFFFFFFFFFFFFFC", 16), new BigInteger("A68BEDC33418029C1D3CE33B9A321FCCBB9E0F0B", 16), null, null);
            this.spec = new ECParameterSpec(this.curve, this.curve.createPoint(new BigInteger("128EC4256487FD8FDF64E2437BC0A1F6D5AFDE2C", 16), new BigInteger("5958557EB1DB001260425524DBC379D5AC5F4ADF", 16)), new BigInteger("00FFFFFFFFFFFFFFFEFFFFB5AE3C523E63944F2127", 16));
            this.g = KeyPairGenerator.getInstance("ECDSA", "BC");
            this.f = KeyFactory.getInstance("ECDSA", "BC");
            this.g.initialize((AlgorithmParameterSpec)this.spec, new SecureRandom());
            this.keyPair = this.g.generateKeyPair();
        }
        catch (Exception e) {
            log.error((Object)"setCurve", (Throwable)e);
        }
    }

    public void sign(byte[] hash, byte[] priv, byte[] R, byte[] S) {
    }

    public void verify(byte[] hash, byte[] pub, byte[] R, byte[] S) {
    }

    public byte[] getPrivateKey() {
        return ((JCEECPrivateKey)this.keyPair.getPrivate()).getD().toByteArray();
    }

    public byte[] getPublicKey() {
        return this.keyPair.getPublic().getEncoded();
    }

    public byte[] multiplyPublicKey(byte[] pub, byte[] priv) {
        Key multPubKey = null;
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(priv), this.spec);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(this.curve.decodePoint(pub), this.spec);
        ECPublicKeySpec newPublicKeySpec = new ECPublicKeySpec(publicKeySpec.getQ().multiply(privateKeySpec.getD()), this.spec);
        try {
            multPubKey = this.f.generatePublic((KeySpec)newPublicKeySpec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return multPubKey.getEncoded();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

