/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpcsp.HLE.Modules;
import jpcsp.crypto.CryptoEngine;
import jpcsp.util.Constants;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PreDecrypt {
    public static Logger log = CryptoEngine.log;
    private static PreDecryptInfo[] preDecrypts;
    private static int preDecryptIndex;

    public static boolean preDecrypt(byte[] out, int outOffset, int outSize, byte[] in, int inOffset, int inSize, int cmd) {
        for (PreDecryptInfo preDecrypt : preDecrypts) {
            if (!preDecrypt.decrypt(out, outOffset, outSize, in, inOffset, inSize, cmd)) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(PreDecrypt.class.getResourceAsStream("PreDecrypt.xml"));
            Element configuration = document.getDocumentElement();
            PreDecrypt.load(configuration);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
        }
        catch (SAXException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private static String getContent(Node node) {
        if (node.hasChildNodes()) {
            return PreDecrypt.getContent(node.getChildNodes());
        }
        return node.getNodeValue();
    }

    private static String getContent(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            content.append(PreDecrypt.getContent(node));
        }
        return content.toString();
    }

    private static void load(Element configuration) {
        preDecrypts = new PreDecryptInfo[0];
        NodeList infos = configuration.getElementsByTagName("PreDecryptInfo");
        int n = infos.getLength();
        for (int i = 0; i < n; ++i) {
            Element info = (Element)infos.item(i);
            PreDecrypt.loadInfo(info);
        }
    }

    private static int skipWhitespaces(String s, int i) {
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static byte[] parseBytes(String s) {
        byte[] bytes = null;
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.startsWith("0x", i = PreDecrypt.skipWhitespaces(s, i))) {
                int value = Integer.parseInt(s.substring(i += 2, i + 2), 16);
                i += 2;
                bytes = Utilities.add(bytes, (byte)value);
            } else {
                int endJavaName;
                String javaName;
                int fieldNameIndex;
                if (i >= length || !Character.isJavaIdentifierStart(s.charAt(i))) break;
                int startJavaName = i++;
                while (i < length) {
                    char c = s.charAt(i);
                    if (Character.isJavaIdentifierPart(c)) {
                        ++i;
                        continue;
                    }
                    if (c != '.') break;
                    if (++i >= length) continue;
                    c = s.charAt(i);
                    if (!Character.isJavaIdentifierStart(c)) break;
                    ++i;
                }
                if ((fieldNameIndex = (javaName = s.substring(startJavaName, endJavaName = i)).lastIndexOf(46)) > 0) {
                    String className = javaName.substring(0, fieldNameIndex);
                    String fieldName = javaName.substring(fieldNameIndex + 1);
                    try {
                        Class<?> classObject = Modules.class.getClassLoader().loadClass(className);
                        Field fieldObject = classObject.getField(fieldName);
                        Object fieldValue = fieldObject.get(null);
                        byte[] fieldValueBytes = fieldValue instanceof byte[] ? (byte[])fieldValue : fieldValue.toString().getBytes(Constants.charset);
                        bytes = Utilities.add(bytes, fieldValueBytes);
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)e);
                    }
                    catch (NoSuchFieldException e) {
                        log.error((Object)e);
                    }
                    catch (SecurityException e) {
                        log.error((Object)e);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)e);
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)e);
                    }
                }
            }
            if ((i = PreDecrypt.skipWhitespaces(s, i)) >= length || s.charAt(i) != ',') continue;
            ++i;
        }
        return bytes;
    }

    private static void loadInfo(Element info) {
        int cmd = Integer.parseInt(info.getAttribute("cmd"));
        String input = PreDecrypt.getContent(info.getElementsByTagName("Input"));
        String output = PreDecrypt.getContent(info.getElementsByTagName("Output"));
        PreDecrypt.addInfo(PreDecrypt.parseBytes(input), PreDecrypt.parseBytes(output), cmd);
    }

    private static boolean isUseless(byte[] input, byte[] output, int cmd) {
        if (cmd == 2 || cmd == 3) {
            return false;
        }
        ByteBuffer inBuffer = ByteBuffer.wrap(input).order(ByteOrder.LITTLE_ENDIAN);
        byte[] kirkOutput = new byte[output.length];
        ByteBuffer outBuffer = ByteBuffer.wrap(kirkOutput).order(ByteOrder.LITTLE_ENDIAN);
        int inSizeAligned = Utilities.alignUp(input.length, 15);
        CryptoEngine crypto = new CryptoEngine();
        int result = crypto.getKIRKEngine().hleUtilsBufferCopyWithRange(outBuffer, output.length, inBuffer, inSizeAligned, input.length, cmd);
        if (result != 0) {
            return false;
        }
        return Arrays.equals(kirkOutput, output);
    }

    private static void addInfo(byte[] input, byte[] output, int cmd) {
        ++preDecryptIndex;
        PreDecryptInfo info = new PreDecryptInfo(input, output, cmd);
        for (int i = 0; i < preDecrypts.length; ++i) {
            if (!info.equals(preDecrypts[i])) continue;
            log.warn((Object)String.format("PreDecrypt.xml: duplicate entry #%d:\n%s", preDecryptIndex, info));
            return;
        }
        if (PreDecrypt.isUseless(input, output, cmd)) {
            log.warn((Object)String.format("PreDecrypt.xml: useless entry #%d:\n%s", preDecryptIndex, info));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("PreDecrypt.xml: adding entry #%d:\n%s", preDecryptIndex, info));
        }
        PreDecryptInfo[] newPreDecrypts = new PreDecryptInfo[preDecrypts.length + 1];
        System.arraycopy(preDecrypts, 0, newPreDecrypts, 0, preDecrypts.length);
        newPreDecrypts[PreDecrypt.preDecrypts.length] = info;
        preDecrypts = newPreDecrypts;
    }

    private static class PreDecryptInfo {
        private byte[] input;
        private byte[] output;
        private int cmd;

        public PreDecryptInfo(byte[] input, byte[] output, int cmd) {
            this.input = input;
            this.output = output;
            this.cmd = cmd;
        }

        public boolean decrypt(byte[] out, int outOffset, int outSize, byte[] in, int inOffset, int inSize, int cmd) {
            if (this.cmd != cmd) {
                return false;
            }
            if (this.input == null && inSize != 0) {
                return false;
            }
            if (this.output == null && outSize != 0) {
                return false;
            }
            if (this.input != null && this.output != null && (this.input.length != inSize || this.output.length != outSize)) {
                return false;
            }
            for (int i = 0; i < inSize; ++i) {
                if (this.input[i] == in[inOffset + i]) continue;
                return false;
            }
            if (out != null && outSize > 0) {
                System.arraycopy(this.output, 0, out, outOffset, outSize);
            }
            return true;
        }

        private static boolean equals(byte[] a, byte[] b) {
            if (a == null) {
                return b == null;
            }
            if (b == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(PreDecryptInfo info) {
            if (this.cmd != info.cmd) {
                return false;
            }
            if (!PreDecryptInfo.equals(this.input, info.input)) {
                return false;
            }
            return PreDecryptInfo.equals(this.output, info.output);
        }

        private static void toString(StringBuilder s, byte[] bytes, String name) {
            s.append(String.format("\t<%s>", name));
            if (bytes != null) {
                for (int i = 0; i < bytes.length; ++i) {
                    if (i > 0) {
                        s.append(", ");
                    }
                    if (i % 16 == 0) {
                        s.append("\n\t\t");
                    }
                    s.append(String.format("0x%02X", bytes[i]));
                }
            }
            s.append(String.format("\n\t</%s>\n", name));
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(String.format("<PreDecryptInfo cmd=\"%d\">\n", this.cmd));
            PreDecryptInfo.toString(s, this.input, "Input");
            PreDecryptInfo.toString(s, this.output, "Output");
            s.append("</PreDecryptInfo>");
            return s.toString();
        }
    }
}

