/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import jpcsp.crypto.AMCTRL;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.umdiso.AbstractFileSectorDevice;
import jpcsp.filesystems.umdiso.IBrowser;
import jpcsp.util.Tlzrc;
import jpcsp.util.Utilities;

public class PBPFileSectorDevice
extends AbstractFileSectorDevice
implements IBrowser {
    private int lbaSize;
    private int blockSize;
    private int blockLBAs;
    private int numBlocks;
    private int numSectors;
    private byte[] vkey;
    private byte[] hkey = new byte[16];
    private TableInfo[] table;
    private int currentBlock;
    private AMCTRL amctrl;
    private byte[] blockBuffer;
    private byte[] tempBuffer;
    private int offsetParamSFO;
    private int offsetIcon0;
    private int offsetIcon1;
    private int offsetPic0;
    private int offsetPic1;
    private int offsetSnd0;
    private int offsetPspData;
    private int offsetPsarData;

    public PBPFileSectorDevice(RandomAccessFile fileAccess) {
        super(fileAccess);
        try {
            int magic = Utilities.endianSwap32(fileAccess.readInt());
            int version = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetParamSFO = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetIcon0 = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetIcon1 = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetPic0 = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetPic1 = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetSnd0 = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetPspData = Utilities.endianSwap32(fileAccess.readInt());
            this.offsetPsarData = Utilities.endianSwap32(fileAccess.readInt());
            if (magic != 1346523136) {
                throw new IOException(String.format("Invalid PBP header 0x%08X", magic));
            }
            if (version != 65536 && version != 256 && version != 65537) {
                throw new IOException(String.format("Invalid PBP version 0x%08X", version));
            }
            fileAccess.seek(this.offsetPsarData);
            byte[] header = new byte[256];
            int readSize = fileAccess.read(header);
            if (readSize != header.length) {
                int psarDataLength = (int)(fileAccess.length() - (long)this.offsetPsarData);
                if (psarDataLength != 0 && psarDataLength != 16) {
                    throw new IOException(String.format("Invalid PBP header", new Object[0]));
                }
            } else if (header[0] == 78 && header[1] == 80 && header[2] == 85 && header[3] == 77 && header[4] == 68 && header[5] == 73 && header[6] == 77 && header[7] == 71) {
                CryptoEngine cryptoEngine = new CryptoEngine();
                this.amctrl = cryptoEngine.getAMCTRLEngine();
                AMCTRL.BBMac_Ctx macContext = new AMCTRL.BBMac_Ctx();
                AMCTRL.BBCipher_Ctx cipherContext = new AMCTRL.BBCipher_Ctx();
                this.amctrl.hleDrmBBMacInit(macContext, 3);
                this.amctrl.hleDrmBBMacUpdate(macContext, header, 192);
                byte[] macKeyC0 = new byte[16];
                System.arraycopy(header, 192, macKeyC0, 0, macKeyC0.length);
                this.vkey = this.amctrl.GetKeyFromBBMac(macContext, macKeyC0);
                byte[] cipherData = new byte[96];
                System.arraycopy(header, 64, cipherData, 0, cipherData.length);
                System.arraycopy(header, 160, this.hkey, 0, this.hkey.length);
                this.amctrl.hleDrmBBCipherInit(cipherContext, 1, 2, this.hkey, this.vkey, 0);
                this.amctrl.hleDrmBBCipherUpdate(cipherContext, cipherData, cipherData.length);
                this.amctrl.hleDrmBBCipherFinal(cipherContext);
                int lbaStart = Utilities.readUnaligned32(cipherData, 20);
                int lbaEnd = Utilities.readUnaligned32(cipherData, 36);
                this.numSectors = lbaEnd + 1;
                this.lbaSize = this.numSectors - lbaStart;
                this.blockLBAs = Utilities.readUnaligned32(header, 12);
                this.blockSize = this.blockLBAs * 2048;
                this.numBlocks = (this.lbaSize + this.blockLBAs - 1) / this.blockLBAs;
                this.blockBuffer = new byte[this.blockSize];
                this.tempBuffer = new byte[this.blockSize];
                this.table = new TableInfo[this.numBlocks];
                int tableOffset = Utilities.readUnaligned32(cipherData, 44);
                fileAccess.seek(this.offsetPsarData + tableOffset);
                byte[] tableBytes = new byte[this.numBlocks * 32];
                readSize = fileAccess.read(tableBytes);
                if (readSize != tableBytes.length) {
                    log.error((Object)String.format("Could not read table with size %d (readSize=%d)", tableBytes.length, readSize));
                }
                IntBuffer tableInts = ByteBuffer.wrap(tableBytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                for (int i = 0; i < this.numBlocks; ++i) {
                    int p0 = tableInts.get();
                    int p1 = tableInts.get();
                    int p2 = tableInts.get();
                    int p3 = tableInts.get();
                    int p4 = tableInts.get();
                    int p5 = tableInts.get();
                    int p6 = tableInts.get();
                    int p7 = tableInts.get();
                    int k0 = p0 ^ p1;
                    int k1 = p1 ^ p2;
                    int k2 = p0 ^ p3;
                    int k3 = p2 ^ p3;
                    TableInfo tableInfo = new TableInfo();
                    System.arraycopy(tableBytes, i * 32, tableInfo.mac, 0, tableInfo.mac.length);
                    tableInfo.offset = p4 ^ k3;
                    tableInfo.size = p5 ^ k1;
                    tableInfo.flags = p6 ^ k2;
                    tableInfo.unknown = p7 ^ k0;
                    this.table[i] = tableInfo;
                }
                this.currentBlock = -1;
            }
        }
        catch (IOException e) {
            log.error((Object)"Reading PBP", (Throwable)e);
        }
    }

    @Override
    public int getNumSectors() {
        return this.numSectors;
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        int lba = sectorNumber - this.currentBlock;
        if (this.table == null) {
            Arrays.fill(buffer, offset, offset + 2048, (byte)0);
        } else if (this.currentBlock >= 0 && lba >= 0 && lba < this.blockLBAs) {
            System.arraycopy(this.blockBuffer, lba * 2048, buffer, offset, 2048);
        } else {
            int block = sectorNumber / this.blockLBAs;
            lba = sectorNumber % this.blockLBAs;
            this.currentBlock = block * this.blockLBAs;
            if (this.table[block].unknown == 0) {
                this.fileAccess.seek(this.offsetPsarData + this.table[block].offset);
                byte[] readBuffer = this.table[block].size < this.blockSize ? this.tempBuffer : this.blockBuffer;
                int readSize = this.fileAccess.read(readBuffer, 0, this.table[block].size);
                if (readSize == this.table[block].size) {
                    int lzsize;
                    if ((this.table[block].flags & 4) == 0) {
                        AMCTRL.BBCipher_Ctx cipherContext = new AMCTRL.BBCipher_Ctx();
                        this.amctrl.hleDrmBBCipherInit(cipherContext, 1, 2, this.hkey, this.vkey, this.table[block].offset >> 4);
                        this.amctrl.hleDrmBBCipherUpdate(cipherContext, readBuffer, this.table[block].size);
                        this.amctrl.hleDrmBBCipherFinal(cipherContext);
                    }
                    if (this.table[block].size < this.blockSize && (lzsize = Tlzrc.lzrc_decompress(this.blockBuffer, this.blockBuffer.length, readBuffer, this.table[block].size)) != this.blockSize) {
                        log.error((Object)String.format("LZRC decompress error: decompressedSized=%d, should be %d", lzsize, this.blockSize));
                    }
                    System.arraycopy(this.blockBuffer, lba * 2048, buffer, offset, 2048);
                }
            }
        }
    }

    private byte[] read(int offset, int length) throws IOException {
        if (length <= 0) {
            return null;
        }
        byte[] buffer = new byte[length];
        this.fileAccess.seek((long)offset & 0xFFFFFFFFL);
        int read = this.fileAccess.read(buffer);
        if (read < 0) {
            return null;
        }
        if (read < length) {
            byte[] newBuffer = new byte[read];
            System.arraycopy(buffer, 0, newBuffer, 0, read);
            buffer = newBuffer;
        }
        return buffer;
    }

    @Override
    public byte[] readParamSFO() throws IOException {
        return this.read(this.offsetParamSFO, this.offsetIcon0 - this.offsetParamSFO);
    }

    @Override
    public byte[] readIcon0() throws IOException {
        return this.read(this.offsetIcon0, this.offsetIcon1 - this.offsetIcon0);
    }

    @Override
    public byte[] readIcon1() throws IOException {
        return this.read(this.offsetIcon1, this.offsetPic0 - this.offsetIcon1);
    }

    @Override
    public byte[] readPic0() throws IOException {
        return this.read(this.offsetPic0, this.offsetPic1 - this.offsetPic0);
    }

    @Override
    public byte[] readPic1() throws IOException {
        return this.read(this.offsetPic1, this.offsetSnd0 - this.offsetPic1);
    }

    @Override
    public byte[] readSnd0() throws IOException {
        return this.read(this.offsetSnd0, this.offsetPspData - this.offsetSnd0);
    }

    @Override
    public byte[] readPspData() throws IOException {
        return this.read(this.offsetPspData, this.offsetPsarData - this.offsetPspData);
    }

    @Override
    public byte[] readPsarData() throws IOException {
        return this.read(this.offsetPsarData, (int)(this.fileAccess.length() - (long)this.offsetPsarData));
    }

    private static class TableInfo {
        public static final int FLAG_IS_UNCRYPTED = 4;
        public byte[] mac = new byte[16];
        public int offset;
        public int size;
        public int flags;
        public int unknown;

        private TableInfo() {
        }
    }
}

