/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class Elf32EntHeader {
    private String modulenamez = "";
    private int modulename;
    private int version;
    private int attr;
    private int size;
    private int vcount;
    private int fcount;
    private int resident;
    private int vcountNew;
    private int unknown1;
    private int unknown2;

    public static int sizeof() {
        return 16;
    }

    public Elf32EntHeader(ByteBuffer f) throws IOException {
        this.modulename = Utilities.readUWord(f);
        this.version = Utilities.readUHalf(f);
        this.attr = Utilities.readUHalf(f);
        this.size = Utilities.readUByte(f);
        this.vcount = Utilities.readUByte(f);
        this.fcount = Utilities.readUHalf(f);
        this.resident = Utilities.readUWord(f);
        if (this.size >= 5) {
            this.vcountNew = Utilities.readUHalf(f);
            this.unknown1 = Utilities.readUByte(f);
            this.unknown2 = Utilities.readUByte(f);
        }
    }

    public Elf32EntHeader(Memory mem, int address) {
        this.modulename = mem.read32(address);
        this.version = mem.read16(address + 4);
        this.attr = mem.read16(address + 6);
        this.size = mem.read8(address + 8);
        this.vcount = mem.read8(address + 9);
        this.fcount = mem.read16(address + 10);
        this.resident = mem.read32(address + 12);
        if (this.size >= 5) {
            this.vcountNew = mem.read16(address + 16);
            this.unknown1 = mem.read8(address + 18);
            this.unknown2 = mem.read8(address + 19);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.modulenamez != null && this.modulenamez.length() > 0) {
            str.append(this.modulenamez + "\n");
        }
        str.append("modulename\t" + Utilities.formatString("long", Long.toHexString((long)this.modulename & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("version\t\t" + Utilities.formatString("short", Long.toHexString(this.version & 0xFFFF).toUpperCase()) + "\n");
        str.append("attr\t\t" + Utilities.formatString("short", Long.toHexString(this.attr & 0xFFFF).toUpperCase()) + "\n");
        str.append("size\t\t" + Utilities.formatString("byte", Long.toHexString(this.size & 0xFFFF).toUpperCase()) + "\n");
        str.append("vcount\t\t" + Utilities.formatString("byte", Long.toHexString(this.vcount & 0xFFFF).toUpperCase()) + "\n");
        str.append("fcount\t\t" + Utilities.formatString("short", Long.toHexString(this.fcount & 0xFFFF).toUpperCase()) + "\n");
        str.append("resident\t\t" + Utilities.formatString("long", Long.toHexString((long)this.resident & 0xFFFFFFFFL).toUpperCase()) + "\n");
        if (this.size >= 5) {
            str.append(String.format("vcountNew\t\t0x%04X\n", this.vcountNew));
            str.append(String.format("unknown1\t\t0x%02X\n", this.unknown1));
            str.append(String.format("unknown2\t\t0x%02X\n", this.unknown2));
        }
        return str.toString();
    }

    public String getModuleNamez() {
        return this.modulenamez;
    }

    public void setModuleNamez(String moduleName) {
        this.modulenamez = moduleName;
    }

    public int getOffsetModuleName() {
        return this.modulename;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAttr() {
        return this.attr;
    }

    public int getSize() {
        return this.size;
    }

    public int getVariableCount() {
        if (this.size <= 4) {
            return this.vcount;
        }
        return Math.max(this.vcount, this.vcountNew);
    }

    public int getFunctionCount() {
        return this.fcount;
    }

    public int getOffsetResident() {
        return this.resident;
    }

    public boolean requiresSyscall() {
        return this.attr == 16385;
    }
}

