/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.TPointer;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class Elf32SectionHeader {
    public static final int SHF_NONE = 0;
    public static final int SHF_WRITE = 1;
    public static final int SHF_ALLOCATE = 2;
    public static final int SHF_EXECUTE = 4;
    public static final int SHT_NULL = 0;
    public static final int SHT_PROGBITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NOBITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYNSYM = 11;
    public static final int SHT_PRXREL = 0x700000A0;
    private String sh_namez = "";
    private int sh_name;
    private int sh_type;
    private int sh_flags;
    private int sh_addr;
    private int sh_offset;
    private int sh_size;
    private int sh_link;
    private int sh_info;
    private int sh_addralign;
    private int sh_entsize;

    public static int sizeof() {
        return 40;
    }

    public Elf32SectionHeader(ByteBuffer f) throws IOException {
        this.sh_name = Utilities.readUWord(f);
        this.sh_type = Utilities.readWord(f);
        this.sh_flags = Utilities.readWord(f);
        this.sh_addr = Utilities.readUWord(f);
        this.sh_offset = Utilities.readUWord(f);
        this.sh_size = Utilities.readUWord(f);
        this.sh_link = Utilities.readWord(f);
        this.sh_info = Utilities.readWord(f);
        this.sh_addralign = Utilities.readWord(f);
        this.sh_entsize = Utilities.readWord(f);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("sh_name \t ").append(Utilities.formatString("long", Long.toHexString((long)this.getSh_name() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        if (this.sh_namez != null && this.sh_namez.length() > 0) {
            str.append("sh_namez \t '").append(this.sh_namez).append("'\n");
        }
        str.append("sh_type \t ").append(Utilities.formatString("long", Long.toHexString((long)this.getSh_type() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("sh_flags \t ").append(Utilities.integerToHex(this.getSh_flags() & 0xFF)).append("\n");
        str.append("sh_addr \t ").append(Utilities.formatString("long", Long.toHexString((long)this.getSh_addr() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("sh_offset \t ").append(Utilities.formatString("long", Long.toHexString((long)this.getSh_offset() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("sh_size \t ").append(Utilities.formatString("long", Long.toHexString((long)this.getSh_size() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("sh_link \t ").append(Utilities.integerToHex(this.getSh_link() & 0xFF)).append("\n");
        str.append("sh_info \t ").append(Utilities.integerToHex(this.getSh_info() & 0xFF)).append("\n");
        str.append("sh_addralign \t ").append(Utilities.integerToHex(this.getSh_addralign() & 0xFF)).append("\n");
        str.append("sh_entsize \t ").append(Utilities.formatString("long", Long.toHexString((long)this.getSh_entsize() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        return str.toString();
    }

    public String getSh_namez() {
        return this.sh_namez;
    }

    public void setSh_namez(String sh_namez) {
        this.sh_namez = sh_namez;
    }

    public int getSh_name() {
        return this.sh_name;
    }

    public int getSh_type() {
        return this.sh_type;
    }

    public int getSh_flags() {
        return this.sh_flags;
    }

    public int getSh_addr() {
        return this.sh_addr;
    }

    public int getSh_addr(TPointer baseAddress) {
        return this.getSh_addr(baseAddress.getAddress());
    }

    public int getSh_addr(int baseAddress) {
        if (Memory.isAddressGood(this.getSh_addr()) && this.getSh_addr() >= baseAddress) {
            return this.getSh_addr();
        }
        return baseAddress + this.getSh_addr();
    }

    public int getSh_offset() {
        return this.sh_offset;
    }

    public int getSh_size() {
        return this.sh_size;
    }

    public int getSh_link() {
        return this.sh_link;
    }

    public int getSh_info() {
        return this.sh_info;
    }

    public int getSh_addralign() {
        return this.sh_addralign;
    }

    public int getSh_entsize() {
        return this.sh_entsize;
    }
}

