/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class Elf32StubHeader {
    private String s_modulenamez = "";
    private int s_modulename;
    private int s_version;
    private int s_flags;
    private int s_size;
    private int s_vstub_size;
    private int s_imports;
    private int s_nid;
    private int s_text;
    private int s_vstub;

    public static int sizeof() {
        return 20;
    }

    public Elf32StubHeader(ByteBuffer f) throws IOException {
        this.s_modulename = Utilities.readUWord(f);
        this.s_version = Utilities.readUHalf(f);
        this.s_flags = Utilities.readUHalf(f);
        this.s_size = Utilities.readUByte(f);
        this.s_vstub_size = Utilities.readUByte(f);
        this.s_imports = Utilities.readUHalf(f);
        this.s_nid = Utilities.readUWord(f);
        this.s_text = Utilities.readUWord(f);
        if (this.hasVStub()) {
            this.s_vstub = Utilities.readUWord(f);
        }
    }

    public Elf32StubHeader(Memory mem, int address) {
        this.s_modulename = mem.read32(address);
        this.s_version = mem.read16(address + 4);
        this.s_flags = mem.read16(address + 6);
        this.s_size = mem.read8(address + 8);
        this.s_vstub_size = mem.read8(address + 9);
        this.s_imports = mem.read16(address + 10);
        this.s_nid = mem.read32(address + 12);
        this.s_text = mem.read32(address + 16);
        if (this.hasVStub()) {
            this.s_vstub = mem.read32(address + 20);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.s_modulenamez != null && this.s_modulenamez.length() > 0) {
            str.append(this.s_modulenamez + "\n");
        }
        str.append("s_modulename\t" + Utilities.formatString("long", Long.toHexString((long)this.s_modulename & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("s_version\t\t" + Utilities.formatString("short", Long.toHexString(this.s_version & 0xFFFF).toUpperCase()) + "\n");
        str.append("s_flags\t\t\t" + Utilities.formatString("short", Long.toHexString(this.s_flags & 0xFFFF).toUpperCase()) + "\n");
        str.append("s_size\t\t\t" + Utilities.formatString("short", Long.toHexString(this.s_size & 0xFFFF).toUpperCase()) + "\n");
        str.append("s_imports\t\t" + Utilities.formatString("short", Long.toHexString(this.s_imports & 0xFFFF).toUpperCase()) + "\n");
        str.append("s_nid\t\t\t" + Utilities.formatString("long", Long.toHexString((long)this.s_nid & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("s_text\t\t\t" + Utilities.formatString("long", Long.toHexString((long)this.s_text & 0xFFFFFFFFL).toUpperCase()) + "\n");
        if (this.hasVStub()) {
            str.append("s_vstub\t\t\t" + Utilities.formatString("long", Long.toHexString((long)this.s_vstub & 0xFFFFFFFFL).toUpperCase()) + "\n");
        }
        return str.toString();
    }

    public String getModuleNamez() {
        return this.s_modulenamez;
    }

    public void setModuleNamez(String moduleName) {
        this.s_modulenamez = moduleName;
    }

    public int getOffsetModuleName() {
        return this.s_modulename;
    }

    public int getVersion() {
        return this.s_version;
    }

    public int getFlags() {
        return this.s_flags;
    }

    public int getSize() {
        return this.s_size;
    }

    public int getVStubSize() {
        return this.s_vstub_size;
    }

    public int getImports() {
        return this.s_imports;
    }

    public int getOffsetNid() {
        return this.s_nid;
    }

    public int getOffsetText() {
        return this.s_text;
    }

    public int getVStub() {
        return this.s_vstub;
    }

    public boolean hasVStub() {
        return this.s_size >= 6;
    }
}

