/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.format.Elf32;
import jpcsp.format.PSF;
import jpcsp.util.ByteUtil;
import jpcsp.util.FileUtil;
import jpcsp.util.Utilities;

public class PBP {
    public static final int PBP_MAGIC = 1346523136;
    private static final String PBP_UNPACK_PATH_PREFIX = "unpacked-pbp/";
    private static final String[] FILE_NAMES = new String[]{"param.sfo", "icon0.png", "icon1.pmf", "pic0.png", "pic1.png", "snd0.at3", "psp.data", "psar.data"};
    private static final int TOTAL_FILES = 8;
    private static final int PARAM_SFO = 0;
    private static final int ICON0_PNG = 1;
    private static final int ICON1_PMF = 2;
    private static final int PIC0_PNG = 3;
    private static final int PIC1_PNG = 4;
    private static final int SND0_AT3 = 5;
    private static final int PSP_DATA = 6;
    private static final int PSAR_DATA = 7;
    public static final int PBP_HEADER_SIZE = 40;
    public static final int PBP_PSP_DATA_OFFSET = 32;
    public static final int PBP_PSAR_DATA_OFFSET = 36;
    private int size_pbp;
    private int p_magic;
    private int p_version;
    private int[] p_offsets;
    private Elf32 elf32;
    private PSF psf;

    public boolean isValid() {
        return this.size_pbp != 0 && this.p_magic == 1346523136;
    }

    public void setElf32(Elf32 elf) {
        this.elf32 = elf;
    }

    public Elf32 getElf32() {
        return this.elf32;
    }

    public PSF getPSF() {
        return this.psf;
    }

    public PBP(ByteBuffer f) throws IOException {
        this.size_pbp = f.limit();
        if (this.size_pbp == 0) {
            return;
        }
        this.p_magic = Utilities.readUWord(f);
        if (this.isValid()) {
            this.p_version = Utilities.readUWord(f);
            this.p_offsets = new int[]{Utilities.readUWord(f), Utilities.readUWord(f), Utilities.readUWord(f), Utilities.readUWord(f), Utilities.readUWord(f), Utilities.readUWord(f), Utilities.readUWord(f), Utilities.readUWord(f), this.size_pbp};
        }
    }

    private PBP() {
    }

    public PSF readPSF(ByteBuffer f) throws IOException {
        if (this.getOffsetParam() > 0) {
            f.position(this.getOffsetParam());
            this.psf = new PSF(this.getOffsetParam());
            this.psf.read(f);
            return this.psf;
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("-----PBP HEADER---------\n");
        str.append("p_magic \t\t").append(Utilities.formatString("long", Long.toHexString((long)this.p_magic & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_version \t\t").append(Utilities.formatString("long", Long.toHexString((long)this.p_version & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_param_sfo \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetParam() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_icon0_png \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetIcon0() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_icon1_pmf \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetIcon1() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_pic0_png \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetPic0() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_pic1_png \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetPic1() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_snd0_at3 \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetSnd0() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_psp_data \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetPspData() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        str.append("p_offset_psar_data \t").append(Utilities.formatString("long", Long.toHexString((long)this.getOffsetPsarData() & 0xFFFFFFFFL).toUpperCase())).append("\n");
        return str.toString();
    }

    private String getName(int index) {
        return FILE_NAMES[index];
    }

    private int getOffset(int index) {
        return this.p_offsets[index];
    }

    private int getSize(int index) {
        return this.p_offsets[index + 1] - this.p_offsets[index];
    }

    private byte[] getBytes(ByteBuffer f, int index) {
        return ByteUtil.readBytes(f, this.getOffset(index), this.getSize(index));
    }

    public int getMagic() {
        return this.p_magic;
    }

    public int getVersion() {
        return this.p_version;
    }

    public int getOffsetParam() {
        return this.getOffset(0);
    }

    public int getOffsetIcon0() {
        return this.getOffset(1);
    }

    public int getOffsetIcon1() {
        return this.getOffset(2);
    }

    public int getOffsetPic0() {
        return this.getOffset(3);
    }

    public int getOffsetPic1() {
        return this.getOffset(4);
    }

    public int getOffsetSnd0() {
        return this.getOffset(5);
    }

    public int getOffsetPspData() {
        return this.getOffset(6);
    }

    public int getOffsetPsarData() {
        return this.getOffset(7);
    }

    public int getSizeIcon0() {
        return this.getSize(1);
    }

    public int getSizePsarData() {
        return this.getSize(7);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String children1 : children = dir.list()) {
                boolean success = PBP.deleteDir(new File(dir, children1));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void unpackPBP(ByteBuffer f) throws IOException {
        f.position(0);
        PBP pbp = new PBP(f);
        if (!pbp.isValid()) {
            return;
        }
        File dir = new File(PBP_UNPACK_PATH_PREFIX);
        PBP.deleteDir(dir);
        dir.mkdir();
        for (int index = 0; index < 8; ++index) {
            byte[] bytes = pbp.getBytes(f, index);
            if (bytes == null || bytes.length <= 0) continue;
            FileUtil.writeBytes(new File(PBP_UNPACK_PATH_PREFIX + pbp.getName(index)), bytes);
        }
    }

    public static void unpackPBP(IVirtualFile vFile) throws IOException {
        vFile.ioLseek(0L);
        PBP pbp = new PBP();
        pbp.size_pbp = (int)vFile.length();
        pbp.p_magic = Utilities.read32(vFile);
        if (!pbp.isValid()) {
            return;
        }
        pbp.p_version = Utilities.read32(vFile);
        pbp.p_offsets = new int[]{Utilities.read32(vFile), Utilities.read32(vFile), Utilities.read32(vFile), Utilities.read32(vFile), Utilities.read32(vFile), Utilities.read32(vFile), Utilities.read32(vFile), Utilities.read32(vFile), pbp.size_pbp};
        File dir = new File(PBP_UNPACK_PATH_PREFIX);
        PBP.deleteDir(dir);
        dir.mkdir();
        byte[] buffer = new byte[10240];
        block9: for (int index = 0; index < 8; ++index) {
            long offset;
            int size = pbp.getSize(index);
            if (size <= 0 || vFile.ioLseek(offset = (long)pbp.getOffset(index) & 0xFFFFFFFFL) != offset) continue;
            try (FileOutputStream os = new FileOutputStream(new File(PBP_UNPACK_PATH_PREFIX + pbp.getName(index)));){
                while (size > 0) {
                    int length = Math.min(size, buffer.length);
                    int readLength = vFile.ioRead(buffer, 0, length);
                    if (readLength > 0) {
                        ((OutputStream)os).write(buffer, 0, readLength);
                        size -= readLength;
                    }
                    if (readLength == length) continue;
                    continue block9;
                }
                continue;
            }
        }
    }
}

