/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.crypto.CryptoEngine;
import jpcsp.hardware.Model;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class PSAR {
    public static final Logger log = Logger.getLogger((String)"psar");
    public static final int PSAR_MAGIC = 1380012880;
    private boolean decrypted;
    private boolean oldschool;
    private int overhead;
    private int iBase;
    private int psarPosition = 0;
    private int psarVersion;
    private int tableMode;
    private static final int SIZE_A = 272;
    private Map<String, String> tableFileNames = new HashMap<String, String>();
    private CryptoEngine crypto = new CryptoEngine();
    private byte[] buffer;
    private int offset;
    private int size;
    private final byte[] dataOut = new byte[3000000];
    private final byte[] dataOut2 = new byte[3000000];
    private static final int[] key_C = new int[]{7, 15, 23, 31, 39, 47, 55, 63, 6, 14, 22, 30, 38, 46, 54, 62, 5, 13, 21, 29, 37, 45, 53, 61, 4, 12, 20, 28, 1, 9, 17, 25, 33, 41, 49, 57, 2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59, 36, 44, 52, 60};
    private static final int[] key_Z = new int[]{50, 47, 53, 40, 63, 59, 61, 36, 49, 58, 43, 54, 41, 45, 52, 60, 38, 56, 48, 57, 37, 44, 51, 62, 23, 12, 33, 27, 17, 9, 34, 24, 13, 19, 31, 16, 20, 15, 25, 8, 30, 11, 18, 22, 14, 28, 35, 32};
    private static final int[] key_M = new int[]{13, 1, 2, 15, 8, 13, 4, 8, 6, 10, 15, 3, 11, 7, 1, 4, 10, 12, 9, 5, 3, 6, 14, 11, 5, 0, 0, 14, 12, 9, 7, 2, 7, 2, 11, 1, 4, 14, 1, 7, 9, 4, 12, 10, 14, 8, 2, 13, 0, 15, 6, 12, 10, 9, 13, 0, 15, 3, 3, 5, 5, 6, 8, 11, 4, 13, 11, 0, 2, 11, 14, 7, 15, 4, 0, 9, 8, 1, 13, 10, 3, 14, 12, 3, 9, 5, 7, 12, 5, 2, 10, 15, 6, 8, 1, 6, 1, 6, 4, 11, 11, 13, 13, 8, 12, 1, 3, 4, 7, 10, 14, 7, 10, 9, 15, 5, 6, 0, 8, 15, 0, 14, 5, 2, 9, 3, 2, 12, 12, 10, 1, 15, 10, 4, 15, 2, 9, 7, 2, 12, 6, 9, 8, 5, 0, 6, 13, 1, 3, 13, 4, 14, 14, 0, 7, 11, 5, 3, 11, 8, 9, 4, 14, 3, 15, 2, 5, 12, 2, 9, 8, 5, 12, 15, 3, 10, 7, 11, 0, 14, 4, 1, 10, 7, 1, 6, 13, 0, 11, 8, 6, 13, 2, 14, 12, 11, 4, 2, 1, 12, 7, 4, 10, 7, 11, 13, 6, 1, 8, 5, 5, 0, 3, 15, 15, 10, 13, 3, 0, 9, 14, 8, 9, 6, 4, 11, 2, 8, 1, 12, 11, 7, 10, 1, 13, 14, 7, 2, 8, 13, 15, 6, 9, 15, 12, 0, 5, 9, 6, 10, 3, 4, 0, 5, 14, 3, 7, 13, 13, 8, 14, 11, 3, 5, 0, 6, 6, 15, 9, 0, 10, 3, 1, 4, 2, 7, 8, 2, 5, 12, 11, 1, 12, 10, 4, 14, 15, 9, 10, 3, 6, 15, 9, 0, 0, 6, 12, 10, 11, 1, 7, 13, 13, 8, 15, 9, 1, 4, 3, 5, 14, 11, 5, 12, 2, 7, 8, 2, 4, 14, 10, 13, 0, 7, 9, 0, 14, 9, 6, 3, 3, 4, 15, 6, 5, 10, 1, 2, 13, 8, 12, 5, 7, 14, 11, 12, 4, 11, 2, 15, 8, 1, 13, 1, 6, 10, 4, 13, 9, 0, 8, 6, 15, 9, 3, 8, 0, 7, 11, 4, 1, 15, 2, 14, 12, 3, 5, 11, 10, 5, 14, 2, 7, 12, 15, 3, 1, 13, 8, 4, 14, 7, 6, 15, 11, 2, 3, 8, 4, 14, 9, 12, 7, 0, 2, 1, 13, 10, 12, 6, 0, 9, 5, 11, 10, 5, 0, 13, 14, 8, 7, 10, 11, 1, 10, 3, 4, 15, 13, 4, 1, 2, 5, 11, 8, 6, 12, 7, 6, 12, 9, 0, 3, 5, 2, 14, 15, 9, 14, 0, 4, 15, 13, 7, 1, 4, 2, 14, 15, 2, 11, 13, 8, 1, 3, 10, 10, 6, 6, 12, 12, 11, 5, 9, 9, 5, 0, 3, 7, 8, 4, 15, 1, 12, 14, 8, 8, 2, 13, 4, 6, 9, 2, 1, 11, 7, 15, 5, 12, 11, 9, 3, 7, 14, 3, 10, 10, 0, 5, 6, 0, 13};
    private static final int[] key_S = new int[]{158, 164, 51, 129, 134, 12, 82, 133};
    private static final int[] key_S2 = new int[]{178, 254, 217, 121, 138, 2, 177, 135};
    private static final int[] key_S3 = new int[]{129, 8, 193, 242, 53, 152, 105, 176};
    private static final int[] key_S4 = new int[]{109, 82, 27, 163, 194, 54, 249, 43};
    private static final int[] key_S5 = new int[]{219, 78, 121, 65, 245, 151, 48, 173};
    private static final int[] key_S6 = new int[]{166, 131, 12, 47, 99, 11, 150, 41};
    private static final int[] table_40 = new int[]{0, 8, 0, 0, 0, 0, 2, 0, 32, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 2, 0, 4, 0, 0, 0, 0, 16, 0, 1, 0, 0, 0, 0, 32, 0, 0, 0, 0, 32, 0, 8, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 32, 128, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 1, 0, 0, 0, 128, 0, 0, 64, 0, 0, 16, 0, 0, 64, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 64, 0, 0, 0, 0, 0, 64, 16, 0, 0, 0, 0, 0, 8, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 128, 0, 0, 0, 0, 128, 0};
    private static final TableKey[] tableKeys = new TableKey[]{new TableKey(-1221532217, -1788736695, key_S), new TableKey(1170857109, 1518026141, key_S2), new TableKey(1864390746, 1288587611, key_S3), new TableKey(1644949850, 1945391714, key_S4), new TableKey(-40024936, -1503344392, key_S5), new TableKey(1029973735, -675449727, key_S6)};

    public PSAR(byte[] buffer, int offset, int size) {
        this.buffer = buffer;
        this.offset = offset;
        this.size = size;
    }

    public int readHeader() {
        int result = this.pspPSARInit(this.buffer, this.offset, this.dataOut, this.dataOut2);
        if (result < 0) {
            log.error((Object)String.format("pspPSARInit failed with error 0x%08X", result));
            return result;
        }
        String s = Utilities.readStringZ(this.dataOut, 16);
        String version = s.substring(s.lastIndexOf(44) + 1);
        this.tableMode = 0;
        if (version.startsWith("3.8") || version.startsWith("3.9")) {
            this.tableMode = 1;
        } else if (version.startsWith("4.")) {
            this.tableMode = 2;
        } else if (version.startsWith("5.")) {
            this.tableMode = 3;
        } else if (version.startsWith("6.")) {
            this.tableMode = 4;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Version %s, tableMode=%d", version, this.tableMode));
        }
        return 0;
    }

    private static int read32(int[] a, int offset) {
        return a[offset] | a[offset + 1] << 8 | a[offset + 2] << 16 | a[offset + 3] << 24;
    }

    private void demangle(byte[] pIn, int pInOffset, byte[] pOut, int pOutOffset) {
        int headerSize = 20;
        int dataSize = 304;
        int totalSize = 324;
        byte[] buffer = new byte[324];
        System.arraycopy(pIn, pInOffset, buffer, 20, 304);
        Utilities.writeUnaligned32(buffer, 0, 5);
        Utilities.writeUnaligned32(buffer, 4, 0);
        Utilities.writeUnaligned32(buffer, 8, 0);
        Utilities.writeUnaligned32(buffer, 12, 85);
        Utilities.writeUnaligned32(buffer, 16, 304);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buffer, 304, buffer, 324, 7);
        if (result != 0) {
            log.error((Object)String.format("demangle error 0x%X", result));
        }
        System.arraycopy(buffer, 0, pOut, pOutOffset, 304);
    }

    private int decodeBlock(byte[] pIn, int pInOffset, int cbIn, byte[] pOut, int pOutOffset) {
        int tag;
        if (this.decrypted) {
            System.arraycopy(pIn, pInOffset, pOut, pOutOffset, cbIn);
            return cbIn;
        }
        System.arraycopy(pIn, pInOffset, pOut, pOutOffset, cbIn + 16);
        int ret = 0;
        int cbOut = 0;
        if (!this.oldschool) {
            this.demangle(pIn, pInOffset + 32, pOut, pOutOffset + 32);
        }
        if ((tag = Utilities.readUnaligned32(pOut, pOutOffset + 208)) == 0xE000000) {
            TPointer32 cbOutAddr = Utilities.allocatePointer32(4);
            ret = Modules.sceMesgdModule.hleMesgd_driver_102DC8AF(pOut, pOutOffset, cbIn, cbOutAddr);
            cbOut = cbOutAddr.getValue();
        } else if (tag == 0x6000000) {
            TPointer32 cbOutAddr = Utilities.allocatePointer32(4);
            ret = Modules.sceNwmanModule.hleNwman_driver_9555D68D(pOut, pOutOffset, cbIn, cbOutAddr);
            cbOut = cbOutAddr.getValue();
        } else {
            log.error((Object)"Unknown PSAR tag");
            return -4;
        }
        if (ret != 0) {
            return ret;
        }
        return cbOut;
    }

    private int pspPSARInit(byte[] dataPSAR, int dataPSAROffset, byte[] dataOut, byte[] dataOut2) {
        if (Utilities.readUnaligned32(dataPSAR, dataPSAROffset) != 1380012880) {
            return -1;
        }
        this.decrypted = Utilities.readUnaligned32(dataPSAR, dataPSAROffset + 32) == 0x2C333333;
        this.overhead = this.decrypted ? 0 : 336;
        this.psarVersion = Utilities.read8(dataPSAR, dataPSAROffset + 4);
        this.oldschool = this.psarVersion == 1;
        int cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + 16, this.overhead + 272, dataOut, 0);
        if (cbOut <= 0) {
            return cbOut;
        }
        if (cbOut != 272) {
            return -2;
        }
        this.iBase = 16 + this.overhead + 272;
        if (this.decrypted) {
            cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + this.iBase, Utilities.readUnaligned32(dataOut, 144), dataOut2, 0);
            if (cbOut <= 0) {
                return -3;
            }
            this.iBase += this.overhead + cbOut;
            return 0;
        }
        if (!this.oldschool) {
            cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + this.iBase, this.overhead + 100, dataOut2, 0);
            if (cbOut <= 0 && (cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + this.iBase, this.overhead + 144, dataOut2, 0)) <= 0 && (cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + this.iBase, this.overhead + Utilities.readUnaligned16(dataOut, 144), dataOut2, 0)) <= 0) {
                return -4;
            }
            int cbChunk = Utilities.alignUp(cbOut, 15);
            this.iBase += this.overhead + cbChunk;
        }
        this.psarPosition = 0;
        return 0;
    }

    private int pspPSARGetNextFile(byte[] dataPSAR, int dataPSAROffset, int cbFile, byte[] dataOut, byte[] dataOut2, PSARFileInfo fileInfo) {
        if (this.iBase >= cbFile - this.overhead) {
            return 0;
        }
        int cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + this.iBase - this.psarPosition, this.overhead + 272, dataOut, 0);
        if (cbOut <= 0) {
            return -1;
        }
        if (cbOut != 272) {
            return -1;
        }
        fileInfo.shortFileName = Utilities.readStringNZ(dataOut, 4, 252);
        boolean bl = fileInfo.signCheck = Utilities.read8(dataOut, 271) == 2;
        if (Utilities.readUnaligned32(dataOut, 256) != 0) {
            return -1;
        }
        this.iBase += this.overhead + 272;
        int cbDataChunk = Utilities.readUnaligned32(dataOut, 260);
        int cbExpanded = Utilities.readUnaligned32(dataOut, 264);
        if (cbExpanded == 0) {
            fileInfo.size = 0;
        } else {
            cbOut = this.decodeBlock(dataPSAR, dataPSAROffset + this.iBase - this.psarPosition, cbDataChunk, dataOut, 0);
            if (cbOut > 10 && Utilities.read8(dataOut, 0) == 120 && Utilities.read8(dataOut, 1) == 156) {
                Inflater inflater = new Inflater();
                inflater.setInput(dataOut, 0, cbDataChunk);
                try {
                    int result = inflater.inflate(dataOut2, 0, cbExpanded);
                    inflater.end();
                    if (result != cbExpanded) {
                        return -1;
                    }
                    fileInfo.size = result;
                }
                catch (DataFormatException e) {
                    inflater.end();
                    log.error((Object)"pspPSARGetNextFile", (Throwable)e);
                    return -1;
                }
            } else {
                this.iBase -= this.overhead + 272;
                return -1;
            }
        }
        this.iBase += cbDataChunk;
        fileInfo.pos = this.iBase;
        return 1;
    }

    private void generateSeed(byte[] out, int c1, int c2) {
        int bit_insert = Integer.MIN_VALUE;
        int r1 = 0;
        int r2 = 0;
        int base = 0;
        for (int i = 0; i < 56; ++i) {
            int val2;
            int val1 = key_C[i];
            if ((val1 & 0x20) != 0) {
                val2 = 1 << val1;
                val1 = 0;
            } else {
                val1 = 1 << val1;
                val2 = 0;
            }
            if (((val1 &= c1) | (val2 &= c2)) != 0) {
                val1 = base;
                val2 = bit_insert;
            } else {
                val1 = 0;
                val2 = 0;
            }
            r1 |= val1;
            r2 |= val2;
            base >>>= 1;
            base = base & Integer.MAX_VALUE | (bit_insert & 1) << 31;
            bit_insert >>>= 1;
        }
        int wpar1 = r2 >>> 4;
        int wpar2 = r1 >>> 8 & 0xFFFFFF;
        wpar2 = wpar2 & 0xF0FFFFFF | (r2 & 0xF) << 24;
        int outOffset = 0;
        for (int i = 16; i != 0; --i) {
            r1 = 32508;
            int val1 = wpar1 << 4;
            r1 >>= i;
            int val2 = wpar2 << 4;
            int shr = (r1 &= 1) ^ 0x1F;
            wpar1 <<= ++r1;
            wpar2 <<= r1;
            wpar1 |= (val1 >>>= shr);
            wpar2 |= (val2 >>>= shr);
            c2 = (wpar2 &= 0xFFFFFFF) >>> 24;
            c2 = c2 & 0xF | ((wpar1 &= 0xFFFFFFF) & 0xFFFFFFF) << 4;
            c1 = wpar2 << 8;
            r2 = 0;
            r1 = 0;
            base = 0;
            bit_insert = Integer.MIN_VALUE;
            for (int j = 0; j < 48; ++j) {
                val1 = key_Z[j];
                if ((val1 & 0x20) != 0) {
                    val2 = 1 << val1;
                    val1 = 0;
                } else {
                    val1 = 1 << val1;
                    val2 = 0;
                }
                if (((val1 &= c1) | (val2 &= c2)) != 0) {
                    val1 = base;
                    val2 = bit_insert;
                } else {
                    val1 = 0;
                    val2 = 0;
                }
                r1 |= val1;
                r2 |= val2;
                base >>>= 1;
                base = base & Integer.MAX_VALUE | (bit_insert & 1) << 31;
                bit_insert >>>= 1;
            }
            Utilities.writeUnaligned32(out, outOffset, r1);
            Utilities.writeUnaligned32(out, outOffset + 4, r2);
            outOffset += 8;
        }
    }

    private static void sceInsanity1(int x1, int x2, int[] r) {
        int temp = (x2 >> 4 ^ x1) & 0xF0F0F0F;
        x2 ^= temp << 4;
        x1 ^= temp;
        temp = (x2 >> 16 ^ x1) & 0xFFFF;
        x1 ^= temp;
        x2 ^= temp << 16;
        temp = (x1 >> 2 ^ x2) & 0x33333333;
        x1 ^= temp << 2;
        x2 ^= temp;
        temp = (x1 >> 8 ^ x2) & 0xFF00FF;
        x2 ^= temp;
        x1 ^= temp << 8;
        temp = (x2 >> 1 ^ x1) & 0x55555555;
        r[1] = x2 ^ temp << 1;
        r[0] = x1 ^ temp;
    }

    private static void sceInsanity2(int x1, int x2, int[] r) {
        int h1 = x2 & 1;
        int h2 = x2 >> 27 & 0x1F;
        int h3 = x2 >> 23 & 0x3F;
        int h4 = x2 >> 19 & 0x3F;
        r[1] = x2 >> 15 & 0x3F;
        r[1] = r[1] & 0xFF7FFFFF | (h1 & 1) << 23;
        r[1] = r[1] & 0xFF83FFFF | (h2 & 0x1F) << 18;
        r[1] = r[1] & 0xFFFC0FFF | (h3 & 0x3F) << 12;
        r[1] = r[1] & 0xFFFFF03F | (h4 & 0x3F) << 6;
        h1 = x2 >> 11 & 0x3F;
        h2 = x2 >> 7 & 0x3F;
        h3 = x2 >> 3 & 0x3F;
        h4 = x2 & 0x1F;
        r[0] = x2 >> 31 & 1;
        r[0] = r[0] & 0xFF03FFFF | (h1 & 0x3F) << 18;
        r[0] = r[0] & 0xFFFC0FFF | (h2 & 0x3F) << 12;
        r[0] = r[0] & 0xFFFFF03F | (h3 & 0x3F) << 6;
        r[0] = r[0] & 0xFFFFFFC1 | (h4 & 0x1F) << 1;
        r[1] = r[1] << 8 | r[0] >> 16 & 0xFF;
        r[0] = r[0] << 16;
    }

    private static void sceInsanity3(int x1, int x2, int[] r) {
        r[1] = 0;
        int offset = 0;
        int shifter = 0;
        for (int i = 0; i < 8; ++i) {
            int val = key_M[offset + (x1 & 0x3F)];
            offset += 64;
            x1 >>>= 6;
            x1 = x1 & 0x3FFFFFF | (x2 & 0x3F) << 26;
            x2 >>>= 6;
            r[1] = r[1] | val << shifter;
            shifter += 4;
        }
        r[0] = 0;
    }

    private static void sceInsanity4(int x1, int x2, int[] r) {
        r[0] = 0;
        r[1] = 0;
        for (int i = 0; i < 32; ++i) {
            if ((x2 & 1) != 0) {
                r[1] = r[1] | PSAR.read32(table_40, i * 4);
            }
            x2 >>>= 1;
        }
    }

    private static void sceInsanity5(int x1, int x2, int[] r) {
        int temp = (x2 >> 1 ^ x1) & 0x55555555;
        x1 ^= temp;
        x2 ^= temp << 1;
        temp = (x1 >> 8 ^ x2) & 0xFF00FF;
        x1 ^= temp << 8;
        x2 ^= temp;
        temp = (x1 >> 2 ^ x2) & 0x33333333;
        x2 ^= temp;
        x1 ^= temp << 2;
        temp = (x2 >> 16 ^ x1) & 0xFFFF;
        x2 ^= temp << 16;
        x1 ^= temp;
        temp = (x2 >> 4 ^ x1) & 0xF0F0F0F;
        r[0] = x1 ^ temp;
        r[1] = x2 ^ temp << 4;
    }

    private void sceParanoia(byte[] buf, int[] p) {
        int x1 = p[0];
        int x2 = p[1];
        int[] r = new int[2];
        int bufOffset = 120;
        PSAR.sceInsanity1(x1, x2, r);
        int rot1 = 0;
        int rot2 = 0;
        int rot3 = r[0];
        int rot4 = r[1];
        for (int i = 0; i < 16; ++i) {
            PSAR.sceInsanity2(rot1, rot3, r);
            int ro1 = r[0];
            int ro2 = r[1];
            r[0] = Utilities.readUnaligned32(buf, bufOffset);
            r[1] = Utilities.readUnaligned32(buf, bufOffset + 4);
            bufOffset -= 8;
            int base = ro2 ^ r[1];
            x1 = base << 16;
            PSAR.sceInsanity3((ro1 ^ r[0]) >>> 16 | x1, base >>> 16, r);
            PSAR.sceInsanity4(r[0], r[1], r);
            x1 = r[0] ^ rot2;
            x2 = r[1] ^ rot4;
            rot2 = rot1;
            rot4 = rot3;
            rot1 = x1;
            rot3 = x2;
        }
        PSAR.sceInsanity5(x1 | rot4, x2, p);
    }

    private void pspDecryptT(byte[] buf, int size, int mode) {
        byte[] m1 = new byte[1024];
        byte[] m2 = new byte[8];
        this.generateSeed(m1, PSAR.tableKeys[mode].mklow, PSAR.tableKeys[mode].mkhigh);
        System.arraycopy(PSAR.tableKeys[mode].key_S, 0, m1, 128, 8);
        int[] p = new int[2];
        int bufOffset = 0;
        for (int i = 0; i < size; ++i) {
            int j;
            for (j = 0; j < 8; ++j) {
                m2[7 - j] = buf[bufOffset + j];
            }
            p[0] = Utilities.readUnaligned32(m2, 0);
            p[1] = Utilities.readUnaligned32(m2, 4);
            this.sceParanoia(m1, p);
            Utilities.writeUnaligned32(m2, 0, p[0]);
            Utilities.writeUnaligned32(m2, 4, p[1]);
            for (j = 0; j < 8; ++j) {
                m1[144 + j] = (byte)(m2[7 - j] ^ m1[128 + j]);
                m1[128 + j] = buf[bufOffset + j];
            }
            System.arraycopy(m1, 144, buf, bufOffset, 8);
            bufOffset += 8;
        }
    }

    private int pspDecryptTable(byte[] buf, int size, int mode) {
        TPointer32 resultSizeAddr;
        int res;
        this.pspDecryptT(buf, size >> 3, mode);
        int tag = Utilities.readUnaligned32(buf, 208);
        int type = 2;
        switch (tag) {
            case 0xE000000: {
                type = 0;
                break;
            }
            case -668790544: 
            case -668786960: {
                type = 2;
                break;
            }
            default: {
                log.error((Object)String.format("pspDecryptTable tag=0x%08X", tag));
            }
        }
        int retSize = this.crypto.getPRXEngine().DecryptPRX(buf, size, type, null, null);
        if (retSize < 0 && (res = Modules.sceMesgdModule.hleMesgd_driver_102DC8AF(buf, 0, size, resultSizeAddr = Utilities.allocatePointer32(4))) < 0) {
            retSize = -1;
        }
        return retSize;
    }

    private static String getKey(int tableIndex, String shortFileName) {
        return String.format("%d_%s", tableIndex, shortFileName);
    }

    private void decryptTable(byte[] buf, int size, int tableMode, int tableIndex) {
        int tableSize = this.pspDecryptTable(buf, size, tableMode);
        if (tableSize <= 0) {
            log.error((Object)String.format("Cannot decrypt %dg table, error 0x%08X", tableIndex, tableSize));
        } else {
            String[] tableStrings;
            String tableString = new String(buf, 0, tableSize);
            for (String line : tableStrings = tableString.split("\r\n")) {
                String[] elements = line.split(",", 2);
                String shortFileName = elements[0];
                String realFileName = elements[1];
                this.tableFileNames.put(PSAR.getKey(tableIndex, shortFileName), realFileName);
            }
        }
    }

    private void findRealFileName(PSARFileInfo fileInfo) {
        for (int i = 1; i <= 12; ++i) {
            String realFileName = this.tableFileNames.get(PSAR.getKey(i, fileInfo.shortFileName));
            if (realFileName == null) continue;
            fileInfo.realFileNames[i] = realFileName;
        }
    }

    public int extractFile(byte[] outBuffer, int outOffset, String fileName) {
        int resultSize;
        block6: {
            PSARFileInfo fileInfo;
            resultSize = -1;
            int fileVersion = Model.getGeneration();
            while (true) {
                int result;
                if ((result = this.pspPSARGetNextFile(this.buffer, this.offset, this.size, this.dataOut, this.dataOut2, fileInfo = new PSARFileInfo())) < 0) {
                    continue;
                }
                if (result == 0) break block6;
                if (fileInfo.shortFileName.matches("000(0[1-9]|1[1-2])")) {
                    this.decryptTable(this.dataOut2, fileInfo.size, this.tableMode, Integer.parseInt(fileInfo.shortFileName));
                } else {
                    this.findRealFileName(fileInfo);
                }
                String realFileName = fileVersion < 0 ? fileInfo.getFirstRealFileName() : fileInfo.realFileNames[fileVersion];
                if (realFileName == null) {
                    realFileName = fileInfo.shortFileName;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PSAR found file '%s'", realFileName));
                }
                if (fileName.equals(realFileName)) break;
            }
            System.arraycopy(this.dataOut2, 0, outBuffer, outOffset, fileInfo.size);
            resultSize = fileInfo.size;
        }
        return resultSize;
    }

    private static class TableKey {
        public final int mklow;
        public final int mkhigh;
        public final byte[] key_S;

        public TableKey(int mklow, int mkhigh, int[] key_S) {
            this.mklow = mklow;
            this.mkhigh = mkhigh;
            this.key_S = new byte[key_S.length];
            for (int i = 0; i < key_S.length; ++i) {
                this.key_S[i] = (byte)key_S[i];
            }
        }
    }

    private static class PSARFileInfo {
        public String shortFileName;
        public final String[] realFileNames = new String[13];
        public int size;
        public int pos;
        public boolean signCheck;

        private PSARFileInfo() {
        }

        public String getFirstRealFileName() {
            for (int i = 0; i < this.realFileNames.length; ++i) {
                if (this.realFileNames[i] == null) continue;
                return this.realFileNames[i];
            }
            return this.shortFileName;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(String.format("shortName='%s', ", this.shortFileName));
            for (int i = 0; i < this.realFileNames.length; ++i) {
                if (this.realFileNames[i] == null) continue;
                s.append(String.format("name[%d]='%s', ", i, this.realFileNames[i]));
            }
            s.append(String.format("size=0x%X, pos=0x%X, signCheck=%b", this.size, this.pos, this.signCheck));
            return s.toString();
        }
    }
}

