/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco;

import java.util.Arrays;

public class LZR {
    private static int u8(byte b) {
        return b & 0xFF;
    }

    private static long u32(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private static void fillBuffer(IntObject testMask, IntObject mask, IntObject buffer, byte[] in, IntObject nextIn) {
        if (testMask.getValue() >= 0 && testMask.getValue() <= 0xFFFFFF) {
            buffer.setValue((buffer.getValue() << 8) + LZR.u8(in[nextIn.incr()]));
            mask.setValue(testMask.getValue() << 8);
        }
    }

    private static boolean nextBit(byte[] buf, int bufPtr1, IntObject number, IntObject testMask, IntObject mask, IntObject buffer, byte[] in, IntObject nextIn) {
        LZR.fillBuffer(testMask, mask, buffer, in, nextIn);
        int value = (mask.getValue() >>> 8) * LZR.u8(buf[bufPtr1]);
        if (testMask != mask) {
            testMask.setValue(value);
        }
        int n = bufPtr1;
        buf[n] = (byte)(buf[n] - (LZR.u8(buf[bufPtr1]) >> 3));
        number.setValue(number.getValue() << 1);
        if (LZR.u32(buffer.getValue()) < LZR.u32(value)) {
            mask.setValue(value);
            int n2 = bufPtr1;
            buf[n2] = (byte)(buf[n2] + 31);
            number.incr();
            return true;
        }
        buffer.sub(value);
        mask.sub(value);
        return false;
    }

    private static int getNumber(int nBits, byte[] buf, int bufPtr, int inc, BoolObject flag, IntObject mask, IntObject buffer, byte[] in, IntObject nextIn) {
        IntObject number = new IntObject(1);
        if (nBits >= 3) {
            LZR.nextBit(buf, bufPtr + 3 * inc, number, mask, mask, buffer, in, nextIn);
            if (nBits >= 4) {
                LZR.nextBit(buf, bufPtr + 3 * inc, number, mask, mask, buffer, in, nextIn);
                if (nBits >= 5) {
                    LZR.fillBuffer(mask, mask, buffer, in, nextIn);
                    while (nBits >= 5) {
                        number.setValue(number.getValue() << 1);
                        mask.setValue(mask.getValue() >>> 1);
                        if (LZR.u32(buffer.getValue()) < LZR.u32(mask.getValue())) {
                            number.incr();
                        } else {
                            buffer.sub(mask.getValue());
                        }
                        --nBits;
                    }
                }
            }
        }
        flag.setValue(LZR.nextBit(buf, bufPtr, number, mask, mask, buffer, in, nextIn));
        if (nBits >= 1) {
            LZR.nextBit(buf, bufPtr + inc, number, mask, mask, buffer, in, nextIn);
            if (nBits >= 2) {
                LZR.nextBit(buf, bufPtr + 2 * inc, number, mask, mask, buffer, in, nextIn);
            }
        }
        return number.getValue();
    }

    public static int decompress(byte[] out, int outCapacity, byte[] in) {
        byte type = in[0];
        IntObject buffer = new IntObject(LZR.u8(in[1]) << 24 | LZR.u8(in[2]) << 16 | LZR.u8(in[3]) << 8 | LZR.u8(in[4]));
        IntObject nextIn = new IntObject(5);
        int nextOut = 0;
        int outEnd = outCapacity;
        if (type < 0) {
            int seqEnd = nextOut + buffer.getValue();
            if (seqEnd > outEnd) {
                return -1;
            }
            while (nextOut < seqEnd) {
                out[nextOut++] = in[nextIn.incr()];
            }
            return nextOut;
        }
        byte[] buf = new byte[2800];
        Arrays.fill(buf, (byte)-128);
        int bufOff = 0;
        IntObject mask = new IntObject(-1);
        IntObject testMask = new IntObject(0);
        int lastChar = 0;
        while (true) {
            int bufPtr1;
            if (!LZR.nextBit(buf, bufPtr1 = bufOff + 2488, IntObject.Null, mask, mask, buffer, in, nextIn)) {
                if (bufOff > 0) {
                    --bufOff;
                }
                if (nextOut == outEnd) {
                    return -1;
                }
                bufPtr1 = (((nextOut & 7) << 8) + lastChar >> type & 7) * 255 - 1;
                IntObject j = new IntObject(1);
                while (j.getValue() <= 255) {
                    LZR.nextBit(buf, bufPtr1 + j.getValue(), j, mask, mask, buffer, in, nextIn);
                }
                out[nextOut++] = (byte)j.getValue();
            } else {
                int seqOff;
                int seqLen;
                testMask.setValue(mask.getValue());
                int nBits = -1;
                BoolObject flag = new BoolObject();
                do {
                    flag.setValue(LZR.nextBit(buf, bufPtr1 += 8, IntObject.Null, testMask, mask, buffer, in, nextIn));
                    if (!flag.getValue()) continue;
                    ++nBits;
                } while (flag.getValue() && nBits < 6);
                int bufPtr2 = nBits + 2033;
                int j = 64;
                if (flag.getValue() || nBits >= 0) {
                    bufPtr1 = (nBits << 5) + ((nextOut << nBits & 3) << 3) + bufOff + 2552;
                    seqLen = LZR.getNumber(nBits, buf, bufPtr1, 8, flag, mask, buffer, in, nextIn);
                    if (seqLen == 255) {
                        return nextOut;
                    }
                    if (flag.getValue() || nBits > 0) {
                        bufPtr2 += 56;
                        j = 352;
                    }
                } else {
                    seqLen = 1;
                }
                IntObject i = new IntObject(1);
                do {
                    nBits = (i.getValue() << 4) - j;
                    flag.setValue(LZR.nextBit(buf, bufPtr2 + (i.getValue() << 3), i, mask, mask, buffer, in, nextIn));
                } while (nBits < 0);
                if (flag.getValue() || nBits > 0) {
                    if (!flag.getValue()) {
                        nBits -= 8;
                    }
                    seqOff = LZR.getNumber(nBits / 8, buf, nBits + 2344, 1, flag, mask, buffer, in, nextIn);
                } else {
                    seqOff = 1;
                }
                int nextSeq = nextOut - seqOff;
                if (nextSeq < 0) {
                    return -1;
                }
                int seqEnd = nextOut + seqLen + 1;
                if (seqEnd > outEnd) {
                    return -1;
                }
                bufOff = (seqEnd + 1 & 1) + 6;
                do {
                    out[nextOut++] = out[nextSeq++];
                } while (nextOut < seqEnd);
            }
            lastChar = LZR.u8(out[nextOut - 1]);
        }
    }

    private static class BoolObject {
        private boolean value;

        private BoolObject() {
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }
    }

    private static class IntObject {
        private static final IntObject Null = new IntObject(0);
        private int value;

        public IntObject(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int incr() {
            return this.value++;
        }

        public void sub(int sub) {
            this.value -= sub;
        }

        public String toString() {
            return String.format("0x%08X", this.value);
        }
    }
}

