/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.object;

import java.awt.image.BufferedImage;
import jpcsp.format.rco.ObjectField;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.object.ImageObject;
import jpcsp.format.rco.type.EventType;
import jpcsp.format.rco.type.ImageType;
import jpcsp.format.rco.type.IntType;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;

public class UButtonObject
extends BasePositionObject {
    @ObjectField(order=201)
    public ImageType image;
    @ObjectField(order=202)
    public EventType onPush;
    @ObjectField(order=203)
    public EventType onFocusIn;
    @ObjectField(order=204)
    public EventType onFocusOut;
    @ObjectField(order=205)
    public EventType onLeft;
    @ObjectField(order=206)
    public EventType onRight;
    @ObjectField(order=207)
    public EventType onUp;
    @ObjectField(order=208)
    public EventType onDown;
    @ObjectField(order=209)
    public IntType unknownInt32;
    private ImageObject texture;

    @Override
    public BufferedImage getImage() {
        if (this.texture != null) {
            return this.texture.getImage();
        }
        return this.image.getImage();
    }

    @Override
    public void onUp() {
        this.trigger(this.onUp);
    }

    @Override
    public void onDown() {
        this.trigger(this.onDown);
    }

    @Override
    public void onLeft() {
        this.trigger(this.onLeft);
    }

    @Override
    public void onRight() {
        this.trigger(this.onRight);
    }

    @Override
    public void onPush() {
        this.trigger(this.onPush);
    }

    @Override
    public void setFocus() {
        this.trigger(this.onFocusIn);
        super.setFocus();
    }

    @Override
    public void focusOut() {
        this.trigger(this.onFocusOut);
        super.focusOut();
    }

    public void setTexture(BaseNativeObject texture) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("UButtonObject.setTexture %s", texture));
        }
        if (texture instanceof ImageObject) {
            this.texture = (ImageObject)texture;
        }
        this.onDisplayUpdated();
    }

    @Override
    protected void toString(StringBuilder s) {
        if (this.texture != null) {
            s.append(String.format(", texture=%s", this.texture));
        }
        super.toString(s);
    }
}

