/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.interpreter.VSMXUndefined;

public class VSMXObject
extends VSMXBaseObject {
    protected final Map<String, VSMXBaseObject> properties;
    private String className;
    private final List<String> sortedPropertyNames;

    public VSMXObject(VSMXInterpreter interpreter, String className) {
        super(interpreter);
        this.className = className;
        this.properties = new HashMap<String, VSMXBaseObject>();
        this.sortedPropertyNames = new LinkedList<String>();
    }

    private void addProperty(String name, VSMXBaseObject value) {
        this.properties.put(name, value);
        this.sortedPropertyNames.add(name);
    }

    protected static int getIndex(String name) {
        int index;
        try {
            index = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            index = -1;
        }
        return index;
    }

    @Override
    public VSMXBaseObject getPropertyValue(String name) {
        if ("length".equals(name)) {
            return new VSMXNumber(this.interpreter, this.properties.size());
        }
        if ("prototype".equals(name)) {
            VSMXObject prototype = this.getPrototype();
            if (prototype != null) {
                return prototype;
            }
            return VSMXUndefined.singleton;
        }
        VSMXBaseObject value = this.properties.get(name);
        if (value == null) {
            int index = VSMXObject.getIndex(name);
            if (index >= 0) {
                value = index < this.properties.size() ? this.properties.get(this.sortedPropertyNames.get(index)) : VSMXUndefined.singleton;
            } else {
                VSMXObject prototype = this.getPrototype();
                if (prototype != null && prototype.properties.containsKey(name)) {
                    value = prototype.getPropertyValue(name);
                } else {
                    value = VSMXUndefined.singleton;
                    this.addProperty(name, value);
                }
            }
        }
        return value;
    }

    @Override
    public List<String> getPropertyNames() {
        return this.sortedPropertyNames;
    }

    @Override
    public void setPropertyValue(String name, VSMXBaseObject value) {
        if (this.properties.containsKey(name)) {
            this.properties.put(name, value);
        } else {
            this.addProperty(name, value);
        }
    }

    @Override
    public void deletePropertyValue(String name) {
        this.properties.remove(name);
        this.sortedPropertyNames.remove(name);
    }

    @Override
    public boolean hasPropertyValue(String name) {
        if ("prototype".equals(name)) {
            return true;
        }
        if (this.properties.containsKey(name)) {
            return true;
        }
        VSMXObject prototype = this.getPrototype();
        if (prototype != null) {
            return prototype.hasPropertyValue(name);
        }
        return false;
    }

    @Override
    public boolean equals(VSMXBaseObject value) {
        if (value instanceof VSMXObject) {
            return this == value;
        }
        return false;
    }

    @Override
    public String typeOf() {
        return "object";
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getStringValue() {
        if (this.hasPropertyValue("toString")) {
            log.warn((Object)String.format("getStringValue on VSMXObject should be calling existing toString: %s", this.getPropertyValue("toString")));
        }
        return super.getStringValue();
    }

    protected void toString(StringBuilder s) {
        Object[] keys = this.properties.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            VSMXBaseObject value = this.properties.get(key);
            if (s.length() > 1) {
                s.append(",\n");
            }
            s.append(String.format("%s=%s", key, value));
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        this.toString(s);
        s.append("]");
        return s.toString();
    }
}

