/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.objects;

import java.util.HashMap;
import java.util.Map;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXArray;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import jpcsp.scheduler.Scheduler;
import org.apache.log4j.Logger;

public class Timer
extends BaseNativeObject {
    private static final Logger log = VSMX.log;
    private int currentTimerId = 0;
    private VSMXInterpreter interpreter;
    private Map<Integer, TimerAction> timers;

    public static VSMXNativeObject create(VSMXInterpreter interpreter) {
        Timer timer = new Timer(interpreter);
        VSMXNativeObject object = new VSMXNativeObject(interpreter, timer);
        timer.setObject(object);
        return object;
    }

    private Timer(VSMXInterpreter interpreter) {
        this.interpreter = interpreter;
        this.timers = new HashMap<Integer, TimerAction>();
    }

    private void onTimer(int id, VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject[] parameters) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Timer.onTimer id=%d, object=%s, function=%s, parameters=%s", id, object, function, parameters));
            for (int i = 0; i < parameters.length; ++i) {
                log.debug((Object)String.format("Timer.onTimer param%d=%s", i, parameters[i]));
            }
        }
        if (function instanceof VSMXFunction) {
            this.interpreter.interpretFunction((VSMXFunction)function, object, parameters);
        }
    }

    private VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject ... parameters) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Timer.setInterval function=%s, interval=%d, numberOfParameters=%d", function, interval.getIntValue(), parameters.length));
            for (int i = 0; i < parameters.length; ++i) {
                log.debug((Object)String.format("Timer.setInterval param%d=%s", i, parameters[i]));
            }
        }
        int id = this.currentTimerId++;
        long schedule = Scheduler.getNow() + (long)(interval.getIntValue() * 1000);
        TimerAction timerAction = new TimerAction(id, object, function, parameters);
        this.timers.put(id, timerAction);
        Scheduler.getInstance().addAction(schedule, timerAction);
        VSMXArray result = new VSMXArray(this.interpreter, 1);
        result.setPropertyValue(0, (VSMXBaseObject)new VSMXNumber(this.interpreter, id));
        return result;
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[0]);
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject param1) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[]{param1});
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject param1, VSMXBaseObject param2) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[]{param1, param2});
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject param1, VSMXBaseObject param2, VSMXBaseObject param3) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[]{param1, param2, param3});
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject param1, VSMXBaseObject param2, VSMXBaseObject param3, VSMXBaseObject param4) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[]{param1, param2, param3, param4});
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject param1, VSMXBaseObject param2, VSMXBaseObject param3, VSMXBaseObject param4, VSMXBaseObject param5) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[]{param1, param2, param3, param4, param5});
    }

    public VSMXBaseObject setInterval(VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject interval, VSMXBaseObject param1, VSMXBaseObject param2, VSMXBaseObject param3, VSMXBaseObject param4, VSMXBaseObject param5, VSMXBaseObject param6) {
        return this.setInterval(object, function, interval, new VSMXBaseObject[]{param1, param2, param3, param4, param5, param6});
    }

    public void clearInterval(VSMXBaseObject object, VSMXBaseObject id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Timer.clearInterval %d", id.getPropertyValue(0).getIntValue()));
        }
    }

    private class TimerAction
    implements IAction {
        private int id;
        private VSMXBaseObject object;
        private VSMXBaseObject function;
        private VSMXBaseObject[] parameters;

        public TimerAction(int id, VSMXBaseObject object, VSMXBaseObject function, VSMXBaseObject[] parameters) {
            this.id = id;
            this.object = object;
            this.function = function;
            this.parameters = parameters;
        }

        @Override
        public void execute() {
            Timer.this.onTimer(this.id, this.object, this.function, this.parameters);
        }
    }
}

