/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import jpcsp.graphics.FrameBufferSettings;

public class DisplayScreen {
    private float[] values;

    public DisplayScreen() {
        this.update(1.0f, 1.0f);
    }

    public void update(float texS, float texT) {
        int[] indices = this.getIndices();
        if (indices == null) {
            return;
        }
        float[] baseValues = new float[]{0.0f, 0.0f, texS, 0.0f, 0.0f, texT, texS, texT};
        this.values = new float[baseValues.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = baseValues[indices[i]];
        }
    }

    protected int[] getIndices() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    public boolean isSwappedXY() {
        return false;
    }

    protected int getWidth(int width, int height) {
        return this.isSwappedXY() ? height : width;
    }

    protected int getHeight(int width, int height) {
        return this.isSwappedXY() ? width : height;
    }

    public int getWidth() {
        return this.getWidth(480, 272);
    }

    public int getHeight() {
        return this.getHeight(480, 272);
    }

    public int getWidth(FrameBufferSettings fb) {
        return this.getWidth(fb.getWidth(), fb.getHeight());
    }

    public int getHeight(FrameBufferSettings fb) {
        return this.getHeight(fb.getWidth(), fb.getHeight());
    }

    public float getTextureUpperLeftS() {
        return this.values[0];
    }

    public float getTextureUpperLeftT() {
        return this.values[1];
    }

    public float getTextureUpperRightS() {
        return this.values[2];
    }

    public float getTextureUpperRightT() {
        return this.values[3];
    }

    public float getTextureLowerLeftS() {
        return this.values[4];
    }

    public float getTextureLowerLeftT() {
        return this.values[5];
    }

    public float getTextureLowerRightS() {
        return this.values[6];
    }

    public float getTextureLowerRightT() {
        return this.values[7];
    }

    public String toString() {
        return String.format("DisplayScreen [%f, %f, %f, %f, %f, %f, %f, %f, %b]", Float.valueOf(this.values[0]), Float.valueOf(this.values[1]), Float.valueOf(this.values[2]), Float.valueOf(this.values[3]), Float.valueOf(this.values[4]), Float.valueOf(this.values[5]), Float.valueOf(this.values[6]), Float.valueOf(this.values[7]), this.isSwappedXY());
    }

    public static class DisplayScreenMirrorY
    extends DisplayScreen {
        private DisplayScreen displayScreen;

        public DisplayScreenMirrorY(DisplayScreen displayScreen) {
            this.displayScreen = displayScreen;
        }

        @Override
        protected int[] getIndices() {
            int[] i = this.displayScreen.getIndices();
            return new int[]{i[4], i[5], i[6], i[7], i[0], i[1], i[2], i[3]};
        }

        @Override
        public boolean isSwappedXY() {
            return this.displayScreen.isSwappedXY();
        }
    }

    public static class DisplayScreenMirrorX
    extends DisplayScreen {
        private DisplayScreen displayScreen;

        public DisplayScreenMirrorX(DisplayScreen displayScreen) {
            this.displayScreen = displayScreen;
            this.update(1.0f, 1.0f);
        }

        @Override
        protected int[] getIndices() {
            if (this.displayScreen == null) {
                return null;
            }
            int[] i = this.displayScreen.getIndices();
            return new int[]{i[2], i[3], i[0], i[1], i[6], i[7], i[4], i[5]};
        }

        @Override
        public boolean isSwappedXY() {
            return this.displayScreen.isSwappedXY();
        }
    }

    public static class DisplayScreenRotation270
    extends DisplayScreen {
        @Override
        protected int[] getIndices() {
            return new int[]{2, 3, 6, 7, 0, 1, 4, 5};
        }

        @Override
        public boolean isSwappedXY() {
            return true;
        }
    }

    public static class DisplayScreenRotation180
    extends DisplayScreen {
        @Override
        protected int[] getIndices() {
            return new int[]{6, 7, 4, 5, 2, 3, 0, 1};
        }
    }

    public static class DisplayScreenRotation90
    extends DisplayScreen {
        @Override
        protected int[] getIndices() {
            return new int[]{4, 5, 0, 1, 6, 7, 2, 3};
        }

        @Override
        public boolean isSwappedXY() {
            return true;
        }
    }
}

