/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.BaseRenderingEngineProxy;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.VideoEngineUtilities;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class BaseRenderingEngineFunction
extends BaseRenderingEngineProxy {
    protected static final boolean useWorkaroundForMultiDrawArrays = true;
    protected boolean useVertexArray;
    ClearModeContext clearModeContext = new ClearModeContext();
    protected boolean directMode;
    protected boolean directModeSetOrthoMatrix;
    protected static final boolean[] flagsValidInClearMode = new boolean[]{false, false, true, false, false, false, true, false, true, false, true, true, true, true, true, true, true, false, false, true, true, true, true, true, true};
    protected boolean viewMatrixLoaded = false;
    protected boolean modelMatrixLoaded = false;
    protected boolean bboxVisible;
    protected int activeTextureUnit = 0;
    private boolean[] colorMask = new boolean[4];
    private static ByteBuffer emptyBuffer;
    protected int logicOp = -1;

    public BaseRenderingEngineFunction(IRenderingEngine proxy) {
        super(proxy);
        this.init();
    }

    protected void init() {
        boolean bl = this.useVertexArray = Settings.getInstance().readBool("emu.enablevao") && super.isVertexArrayAvailable();
        if (this.useVertexArray) {
            log.info((Object)"Using VAO (Vertex Array Object)");
        }
    }

    private static ByteBuffer getEmptyBuffer(int capacity) {
        if (emptyBuffer == null || emptyBuffer.capacity() < capacity) {
            emptyBuffer = ByteBuffer.allocateDirect(capacity);
        }
        emptyBuffer.clear();
        return emptyBuffer;
    }

    protected void setFlag(GeContext.EnableDisableFlag flag) {
        if (flag.isEnabled()) {
            this.re.enableFlag(flag.getReFlag());
        } else {
            this.re.disableFlag(flag.getReFlag());
        }
    }

    protected void setClearModeSettings(boolean color, boolean stencil, boolean depth) {
        for (int i = 0; i < flagsValidInClearMode.length; ++i) {
            if (flagsValidInClearMode[i]) continue;
            this.re.disableFlag(i);
        }
        if (stencil) {
            this.re.enableFlag(3);
            this.re.setStencilFunc(1, 0, 0);
            this.re.setStencilOp(0, 0, 1);
        }
        if (depth) {
            this.re.enableFlag(1);
            this.context.depthFunc = 1;
            this.re.setDepthFunc(this.context.depthFunc);
        }
        this.re.setDepthMask(depth);
        this.re.setColorMask(color, color, color, stencil);
        this.re.setTextureFunc(3, true, false);
        this.re.setBones(0, null);
    }

    @Override
    public void startClearMode(boolean color, boolean stencil, boolean depth) {
        this.clearModeContext.color = color;
        this.clearModeContext.stencil = stencil;
        this.clearModeContext.depth = depth;
        this.clearModeContext.depthFunc = this.context.depthFunc;
        this.clearModeContext.textureFunc = this.context.textureFunc;
        this.clearModeContext.textureAlphaUsed = this.context.textureAlphaUsed;
        this.clearModeContext.textureColorDoubled = this.context.textureColorDoubled;
        this.clearModeContext.stencilFunc = this.context.stencilFunc;
        this.clearModeContext.stencilRef = this.context.stencilRef;
        this.clearModeContext.stencilMask = this.context.stencilMask;
        this.clearModeContext.stencilOpFail = this.context.stencilOpFail;
        this.clearModeContext.stencilOpZFail = this.context.stencilOpZFail;
        this.clearModeContext.stencilOpZPass = this.context.stencilOpZPass;
        this.setClearModeSettings(color, stencil, depth);
        super.startClearMode(color, stencil, depth);
    }

    @Override
    public void endClearMode() {
        for (GeContext.EnableDisableFlag flag : this.context.flags) {
            if (flagsValidInClearMode[flag.getReFlag()]) continue;
            this.setFlag(flag);
        }
        this.context.depthFunc = this.clearModeContext.depthFunc;
        this.re.setDepthFunc(this.context.depthFunc);
        this.context.textureFunc = this.clearModeContext.textureFunc;
        this.context.textureAlphaUsed = this.clearModeContext.textureAlphaUsed;
        this.context.textureColorDoubled = this.clearModeContext.textureColorDoubled;
        this.re.setTextureFunc(this.context.textureFunc, this.context.textureAlphaUsed, this.context.textureColorDoubled);
        this.context.stencilFunc = this.clearModeContext.stencilFunc;
        this.context.stencilRef = this.clearModeContext.stencilRef;
        this.context.stencilMask = this.clearModeContext.stencilMask;
        this.re.setStencilFunc(this.context.stencilFunc, this.context.stencilRef, this.context.stencilRef);
        this.context.stencilOpFail = this.clearModeContext.stencilOpFail;
        this.context.stencilOpZFail = this.clearModeContext.stencilOpZFail;
        this.context.stencilOpZPass = this.clearModeContext.stencilOpZPass;
        this.re.setStencilOp(this.context.stencilOpFail, this.context.stencilOpZFail, this.context.stencilOpZPass);
        this.re.setDepthMask(this.context.depthMask);
        this.re.setColorMask(true, true, true, this.context.stencilTestFlag.isEnabled());
        this.re.setColorMask(this.context.colorMask[0], this.context.colorMask[1], this.context.colorMask[2], this.context.colorMask[3]);
        super.endClearMode();
    }

    protected boolean isClearMode() {
        return this.context.clearMode;
    }

    protected boolean canUpdateFlag(int flag) {
        return !this.context.clearMode || this.directMode || flagsValidInClearMode[flag];
    }

    protected boolean canUpdate() {
        return !this.context.clearMode || this.directMode;
    }

    protected boolean getBooleanColorMask(String name, int bitMask) {
        if (bitMask == 255) {
            return false;
        }
        if (bitMask == 0) {
            return true;
        }
        if (bitMask >= 240 && VideoEngineUtilities.getPixelFormatBytes(this.context.psm) == 2) {
            return false;
        }
        if (bitMask <= 15 && VideoEngineUtilities.getPixelFormatBytes(this.context.psm) == 2) {
            return true;
        }
        if (log.isEnabledFor((Priority)Level.WARN)) {
            log.warn((Object)String.format("Unimplemented %s 0x%02X", name, bitMask));
        }
        return true;
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        this.colorMask[0] = redWriteEnabled;
        this.colorMask[1] = greenWriteEnabled;
        this.colorMask[2] = blueWriteEnabled;
        this.colorMask[3] = alphaWriteEnabled;
        super.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        boolean redWriteEnabled = this.getBooleanColorMask("Red color mask", redMask);
        boolean greenWriteEnabled = this.getBooleanColorMask("Green color mask", greenMask);
        boolean blueWriteEnabled = this.getBooleanColorMask("Blue color mask", blueMask);
        this.re.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, this.colorMask[3]);
        super.setColorMask(redMask, greenMask, blueMask, alphaMask);
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        if (this.canUpdate()) {
            super.setDepthMask(depthWriteEnabled);
        }
    }

    @Override
    public void setViewMatrix(float[] values) {
        super.setViewMatrix(values);
        if (this.modelMatrixLoaded) {
            this.re.setModelMatrix(this.context.model_uploaded_matrix);
        }
        this.viewMatrixLoaded = true;
    }

    @Override
    public void setModelMatrix(float[] values) {
        if (!this.viewMatrixLoaded) {
            this.re.setViewMatrix(this.context.view_uploaded_matrix);
        }
        super.setModelMatrix(values);
        this.modelMatrixLoaded = true;
    }

    @Override
    public void endModelViewMatrixUpdate() {
        if (!this.viewMatrixLoaded) {
            this.re.setViewMatrix(this.context.view_uploaded_matrix);
        }
        if (!this.modelMatrixLoaded) {
            this.re.setModelMatrix(this.context.model_uploaded_matrix);
        }
        super.endModelViewMatrixUpdate();
        this.viewMatrixLoaded = false;
        this.modelMatrixLoaded = false;
    }

    @Override
    public void startDirectRendering(boolean textureEnabled, boolean depthWriteEnabled, boolean colorWriteEnabled, boolean setOrthoMatrix, boolean orthoInverted, int width, int height) {
        this.directMode = true;
        this.re.disableFlag(1);
        this.re.disableFlag(4);
        this.re.disableFlag(0);
        this.re.disableFlag(7);
        this.re.disableFlag(10);
        this.re.disableFlag(18);
        this.re.disableFlag(3);
        this.re.disableFlag(5);
        this.re.disableFlag(2);
        if (textureEnabled) {
            this.re.enableFlag(9);
        } else {
            this.re.disableFlag(9);
        }
        this.re.setTextureMipmapMinFilter(0);
        this.re.setTextureMipmapMagFilter(0);
        this.re.setTextureMipmapMinLevel(0);
        this.re.setTextureMipmapMaxLevel(0);
        this.re.setTextureWrapMode(1, 1);
        int colorMask = colorWriteEnabled ? 0 : 255;
        this.re.setColorMask(colorMask, colorMask, colorMask, colorMask);
        this.re.setColorMask(colorWriteEnabled, colorWriteEnabled, colorWriteEnabled, colorWriteEnabled);
        this.re.setDepthMask(depthWriteEnabled);
        this.re.setTextureFunc(3, true, false);
        this.re.setTextureMapMode(0, 1);
        this.re.setFrontFace(true);
        this.re.setBones(0, null);
        this.directModeSetOrthoMatrix = setOrthoMatrix;
        if (setOrthoMatrix) {
            float[] orthoMatrix = orthoInverted ? VideoEngine.getOrthoMatrix(0.0f, width, 0.0f, height, -1.0f, 1.0f) : VideoEngine.getOrthoMatrix(0.0f, width, height, 0.0f, -1.0f, 1.0f);
            this.re.setProjectionMatrix(orthoMatrix);
            this.re.setModelViewMatrix(null);
            this.re.setTextureMatrix(null);
        }
        super.startDirectRendering(textureEnabled, depthWriteEnabled, colorWriteEnabled, setOrthoMatrix, orthoInverted, width, height);
    }

    @Override
    public void endDirectRendering() {
        this.re.setColorMask(this.context.colorMask[0], this.context.colorMask[1], this.context.colorMask[2], this.context.colorMask[3]);
        if (this.context.clearMode) {
            this.setClearModeSettings(this.clearModeContext.color, this.clearModeContext.stencil, this.clearModeContext.depth);
        } else {
            this.context.depthTestFlag.updateEnabled(this.re);
            this.context.blendFlag.updateEnabled(this.re);
            this.context.alphaTestFlag.updateEnabled(this.re);
            this.context.fogFlag.updateEnabled(this.re);
            this.context.colorLogicOpFlag.updateEnabled(this.re);
            this.context.stencilTestFlag.updateEnabled(this.re);
            this.context.cullFaceFlag.updateEnabled(this.re);
            this.context.textureFlag.update(this.re);
            this.re.setDepthMask(this.context.depthMask);
            this.re.setTextureFunc(this.context.textureFunc, this.context.textureAlphaUsed, this.context.textureColorDoubled);
        }
        this.re.setTextureMapMode(this.context.tex_map_mode, this.context.tex_proj_map_mode);
        this.context.scissorTestFlag.updateEnabled(this.re);
        this.context.lightingFlag.updateEnabled(this.re);
        this.re.setTextureMipmapMagFilter(this.context.tex_mag_filter);
        this.re.setTextureMipmapMinFilter(this.context.tex_min_filter);
        this.re.setTextureWrapMode(this.context.tex_wrap_s, this.context.tex_wrap_t);
        this.re.setFrontFace(this.context.frontFaceCw);
        if (this.directModeSetOrthoMatrix) {
            VideoEngine videoEngine = VideoEngine.getInstance();
            videoEngine.projectionMatrixUpload.setChanged(true);
            videoEngine.viewMatrixUpload.setChanged(true);
            videoEngine.modelMatrixUpload.setChanged(true);
            videoEngine.textureMatrixUpload.setChanged(true);
        }
        super.endDirectRendering();
        this.directMode = false;
    }

    @Override
    public void beginBoundingBox(int numberOfVertexBoundingBox) {
        this.bboxVisible = true;
        super.beginBoundingBox(numberOfVertexBoundingBox);
    }

    @Override
    public void drawBoundingBox(float[][] values) {
        if (this.bboxVisible) {
            float[] modelViewMatrix = new float[16];
            float[] modelViewProjectionMatrix = new float[16];
            Utilities.matrixMult(modelViewMatrix, this.context.view_uploaded_matrix, this.context.model_uploaded_matrix);
            Utilities.matrixMult(modelViewProjectionMatrix, this.context.proj_uploaded_matrix, modelViewMatrix);
            float viewportX = this.context.viewport_cx - this.context.offset_x;
            float viewportY = this.context.viewport_cy - this.context.offset_y;
            float viewportWidth = this.context.viewport_width;
            float viewportHeight = this.context.viewport_height;
            float[] mvpVertex = new float[4];
            float minX = 0.0f;
            float minY = 0.0f;
            float maxX = 0.0f;
            float maxY = 0.0f;
            float minW = 0.0f;
            float maxW = 0.0f;
            for (int i = 0; i < values.length; ++i) {
                BaseRenderingEngineFunction.multMatrix44(mvpVertex, modelViewProjectionMatrix, values[i]);
                float w = mvpVertex[3];
                float x = minX;
                float y = minY;
                if (w != 0.0f) {
                    x = mvpVertex[0] / w * viewportWidth + viewportX;
                    y = mvpVertex[1] / w * viewportHeight + viewportY;
                }
                if (i == 0) {
                    minX = maxX = x;
                    minY = maxY = y;
                    minW = maxW = w;
                } else {
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    minW = Math.min(minW, w);
                    maxW = Math.max(maxW, w);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("drawBoundingBox vertex#%d x=%f, y=%f, w=%f", i, Float.valueOf(x), Float.valueOf(y), Float.valueOf(w)));
            }
            if ((maxX < (float)this.context.region_x1 || maxY < (float)this.context.region_y1 || minX > (float)this.context.region_x2 || minY > (float)this.context.region_y2) && (minW >= 0.0f || maxW <= 0.0f)) {
                this.bboxVisible = false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("drawBoundingBox visible=%b", this.bboxVisible));
        }
        super.drawBoundingBox(values);
    }

    @Override
    public boolean isBoundingBoxVisible() {
        if (!this.bboxVisible) {
            return false;
        }
        return super.isBoundingBoxVisible();
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
        this.re.setTexEnv(2, colorDoubled ? 2.0f : 1.0f);
        this.re.setTexEnv(16, func);
        super.setTextureFunc(func, alphaUsed, colorDoubled);
    }

    protected static void multMatrix44(float[] result4, float[] matrix44, float[] vector4) {
        float x = vector4[0];
        float y = vector4[1];
        float z = vector4[2];
        float w = vector4.length < 4 ? 1.0f : vector4[3];
        result4[0] = matrix44[0] * x + matrix44[4] * y + matrix44[8] * z + matrix44[12] * w;
        result4[1] = matrix44[1] * x + matrix44[5] * y + matrix44[9] * z + matrix44[13] * w;
        result4[2] = matrix44[2] * x + matrix44[6] * y + matrix44[10] * z + matrix44[14] * w;
        result4[3] = matrix44[3] * x + matrix44[7] * y + matrix44[11] * z + matrix44[15] * w;
    }

    @Override
    public void startDisplay() {
        for (int light = 0; light < this.context.lightFlags.length; ++light) {
            this.context.lightFlags[light].update(this.re);
        }
        super.startDisplay();
    }

    @Override
    public boolean isVertexArrayAvailable() {
        return this.useVertexArray;
    }

    @Override
    public void multiDrawArrays(int primitive, IntBuffer first, IntBuffer count) {
        int primitiveCount = first.remaining();
        int positionFirst = first.position();
        int positionCount = count.position();
        if (primitive == 0 || primitive == 1 || primitive == 3 || primitive == 7) {
            int firstIndex;
            boolean sequential = true;
            int currentIndex = firstIndex = first.get(positionFirst);
            for (int i = 1; i < primitiveCount; ++i) {
                if ((currentIndex += count.get(positionCount + i - 1)) == first.get(positionFirst + i)) continue;
                sequential = false;
                break;
            }
            if (sequential) {
                this.re.drawArrays(primitive, firstIndex, currentIndex - firstIndex + count.get(positionCount + primitiveCount - 1));
                return;
            }
        }
        this.re.drawArrays(primitive, first.get(positionFirst), count.get(positionCount));
        for (int i = 1; i < primitiveCount; ++i) {
            this.re.drawArraysBurstMode(primitive, first.get(positionFirst + i), count.get(positionCount + i));
        }
    }

    @Override
    public void bindActiveTexture(int index, int texture) {
        int previousActiveTextureUnit = this.activeTextureUnit;
        this.re.setActiveTexture(index);
        this.re.bindTexture(texture);
        this.re.setActiveTexture(previousActiveTextureUnit);
    }

    @Override
    public void setActiveTexture(int index) {
        this.activeTextureUnit = index;
        super.setActiveTexture(index);
    }

    protected void setAlphaMask(boolean alphaWriteEnabled) {
        if (this.colorMask[3] != alphaWriteEnabled) {
            this.colorMask[3] = alphaWriteEnabled;
            this.re.setColorMask(this.colorMask[0], this.colorMask[1], this.colorMask[2], this.colorMask[3]);
        }
    }

    @Override
    public void disableFlag(int flag) {
        if (flag == 3) {
            this.setAlphaMask(false);
        }
        super.disableFlag(flag);
    }

    @Override
    public void enableFlag(int flag) {
        if (flag == 3) {
            this.setAlphaMask(true);
        }
        if (flag == 18 && this.logicOp == 3) {
            this.disableFlag(flag);
        } else {
            super.enableFlag(flag);
        }
    }

    private int getBlendFix(int fixColor) {
        if (fixColor == 0) {
            return 12;
        }
        if (fixColor == 0xFFFFFF) {
            return 13;
        }
        return 10;
    }

    private int colorDistance(int color1, int color2) {
        int blueDistance = Math.abs(PixelColor.getBlue(color1) - PixelColor.getBlue(color2));
        int greenDistance = Math.abs(PixelColor.getGreen(color1) - PixelColor.getGreen(color2));
        int redDistance = Math.abs(PixelColor.getRed(color1) - PixelColor.getRed(color2));
        return redDistance + greenDistance + blueDistance;
    }

    private int oneMinusColor(int color) {
        int b = 255 - PixelColor.getBlue(color);
        int g = 255 - PixelColor.getGreen(color);
        int r = 255 - PixelColor.getRed(color);
        return PixelColor.getColorBGR(b, g, r);
    }

    private int getBestColorDistance(int blendColor, int color) {
        int bestDistance = this.colorDistance(color, blendColor);
        bestDistance = Math.min(bestDistance, this.colorDistance(color, this.oneMinusColor(blendColor)));
        bestDistance = Math.min(bestDistance, this.colorDistance(color, 0));
        bestDistance = Math.min(bestDistance, this.colorDistance(color, 0xFFFFFF));
        return bestDistance;
    }

    private int getBestBlend(int blendColor, int oneMinusBlendColor, int color) {
        if (blendColor == 0) {
            return 12;
        }
        if (blendColor == 0xFFFFFF) {
            return 13;
        }
        if (blendColor == color) {
            return 10;
        }
        if (blendColor == oneMinusBlendColor) {
            return 11;
        }
        int bestDistance = this.colorDistance(color, blendColor);
        int bestBlend = 10;
        int distance = this.colorDistance(color, oneMinusBlendColor);
        if (distance < bestDistance) {
            bestDistance = distance;
            bestBlend = 11;
        }
        if ((distance = this.colorDistance(color, 0)) < bestDistance) {
            bestDistance = distance;
            bestBlend = 12;
        }
        if ((distance = this.colorDistance(color, 0xFFFFFF)) < bestDistance) {
            bestDistance = distance;
            bestBlend = 13;
        }
        return bestBlend;
    }

    private int getColorFromBlend(int blend, int blendColor, int oneMinusBlendColor) {
        switch (blend) {
            case 12: {
                return 0;
            }
            case 13: {
                return 0xFFFFFF;
            }
            case 10: {
                return blendColor;
            }
            case 11: {
                return oneMinusBlendColor;
            }
        }
        return -1;
    }

    @Override
    public void setBlendFunc(int src, int dst) {
        if (src == 10) {
            src = this.getBlendFix(this.context.sfix);
        }
        if (dst == 10) {
            dst = src == 10 && this.context.sfix + this.context.dfix == 0xFFFFFF ? 11 : this.getBlendFix(this.context.dfix);
        }
        float[] blend_color = null;
        if (src == 10) {
            blend_color = this.context.sfix_color;
            if (dst == 10 && this.context.sfix != this.context.dfix) {
                int blendColor;
                if (this.getBestColorDistance(this.context.sfix, this.context.dfix) <= this.getBestColorDistance(this.context.dfix, this.context.sfix)) {
                    blendColor = this.context.sfix;
                    blend_color = this.context.sfix_color;
                } else {
                    blendColor = this.context.dfix;
                    blend_color = this.context.dfix_color;
                }
                int oneMinusBlendColor = this.oneMinusColor(blendColor);
                src = this.getBestBlend(blendColor, oneMinusBlendColor, this.context.sfix);
                dst = this.getBestBlend(blendColor, oneMinusBlendColor, this.context.dfix);
                if (log.isEnabledFor((Priority)Level.WARN)) {
                    log.warn((Object)String.format("UNSUPPORTED: Both different SFIX (0x%06X) and DFIX (0x%06X) are not supported (blend equation=%d), approximating with 0x%06X/0x%06X", this.context.sfix, this.context.dfix, this.context.blendEquation, this.getColorFromBlend(src, blendColor, oneMinusBlendColor), this.getColorFromBlend(dst, blendColor, oneMinusBlendColor)));
                }
            }
        } else if (dst == 10) {
            blend_color = this.context.dfix_color;
        }
        if (blend_color != null) {
            this.re.setBlendColor(blend_color);
        }
        super.setBlendFunc(src, dst);
    }

    @Override
    public void setBlendDFix(int sfix, float[] color) {
        this.setBlendFunc(this.context.blend_src, this.context.blend_dst);
        super.setBlendDFix(sfix, color);
    }

    @Override
    public void setBlendSFix(int dfix, float[] color) {
        this.setBlendFunc(this.context.blend_src, this.context.blend_dst);
        super.setBlendSFix(dfix, color);
    }

    @Override
    public void multiDrawElements(int primitive, IntBuffer first, IntBuffer count, int indexType, long indicesOffset) {
        int primitiveCount = first.remaining();
        int positionFirst = first.position();
        int positionCount = count.position();
        if (primitive == 0 || primitive == 1 || primitive == 3 || primitive == 7) {
            int firstIndex;
            boolean sequential = true;
            int currentIndex = firstIndex = first.get(positionFirst);
            if (firstIndex != 0) {
                sequential = false;
            } else {
                for (int i = 1; i < primitiveCount; ++i) {
                    if ((currentIndex += count.get(positionCount + i - 1)) == first.get(positionFirst + i)) continue;
                    sequential = false;
                    break;
                }
            }
            if (sequential) {
                this.re.drawElements(primitive, currentIndex - firstIndex + count.get(positionCount + primitiveCount - 1), indexType, indicesOffset);
                return;
            }
        }
        int bytesPerIndex = sizeOfType[indexType];
        this.re.drawElements(primitive, count.get(positionCount), indexType, indicesOffset + (long)(first.get(positionFirst) * bytesPerIndex));
        for (int i = 1; i < primitiveCount; ++i) {
            this.re.drawElementsBurstMode(primitive, count.get(positionCount + i), indexType, indicesOffset + (long)(first.get(positionFirst + i) * bytesPerIndex));
        }
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        if (buffer == null) {
            textureSize = width * height * sizeOfTextureType[format];
            buffer = BaseRenderingEngineFunction.getEmptyBuffer(textureSize * 2);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setTexImage using an empty buffer of size 0x%X", textureSize));
            }
        }
        super.setTexImage(level, internalFormat, width, height, format, type, textureSize, buffer);
    }

    @Override
    public void setLogicOp(int logicOp) {
        if (this.logicOp != logicOp) {
            if (logicOp == 3) {
                this.disableFlag(18);
            } else {
                super.setLogicOp(logicOp);
            }
            this.logicOp = logicOp;
        }
    }

    protected static class ClearModeContext {
        public boolean color;
        public boolean stencil;
        public boolean depth;
        public int alphaFunc;
        public int depthFunc;
        public int textureFunc;
        public boolean textureAlphaUsed;
        public boolean textureColorDoubled;
        public int stencilFunc;
        public int stencilRef;
        public int stencilMask;
        public int stencilOpFail;
        public int stencilOpZFail;
        public int stencilOpZPass;

        protected ClearModeContext() {
        }
    }
}

