/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.Utilities;

public class DirectBufferUtilities {
    private int directBufferSize = 100;
    private ByteBuffer directBuffer = ByteBuffer.allocateDirect(this.directBufferSize).order(ByteOrder.nativeOrder());
    private FloatBuffer directFloatBuffer = ByteBuffer.allocateDirect(128 * VideoEngine.SIZEOF_FLOAT).order(ByteOrder.nativeOrder()).asFloatBuffer();

    public FloatBuffer getDirectBuffer(float[] values) {
        return this.getDirectBuffer(values, values.length);
    }

    public FloatBuffer getDirectBuffer(float[] values, int length) {
        this.directFloatBuffer.clear();
        this.directFloatBuffer.limit(length);
        this.directFloatBuffer.put(values, 0, length);
        this.directFloatBuffer.rewind();
        return this.directFloatBuffer;
    }

    public IntBuffer getDirectBuffer(int size, IntBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        size = Utilities.round4(size);
        if (buffer.isDirect()) {
            buffer.limit((size >> 2) + buffer.position());
            return buffer;
        }
        IntBuffer directBuffer = this.allocateDirectBuffer(size).asIntBuffer();
        directBuffer.put((IntBuffer)buffer.slice().limit(size >> 2));
        directBuffer.rewind();
        return directBuffer;
    }

    public FloatBuffer getDirectBuffer(int size, FloatBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        size = Utilities.round4(size);
        if (buffer.isDirect()) {
            buffer.limit((size >> 2) + buffer.position());
            return buffer;
        }
        FloatBuffer directBuffer = this.allocateDirectBuffer(size).asFloatBuffer();
        directBuffer.put((FloatBuffer)buffer.slice().limit(size >> 2));
        directBuffer.rewind();
        return directBuffer;
    }

    public ShortBuffer getDirectBuffer(int size, ShortBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        size = Utilities.round2(size);
        if (buffer.isDirect()) {
            buffer.limit((size >> 1) + buffer.position());
            return buffer;
        }
        ShortBuffer directBuffer = this.allocateDirectBuffer(size).asShortBuffer();
        directBuffer.put((ShortBuffer)buffer.slice().limit(size >> 1));
        directBuffer.rewind();
        return directBuffer;
    }

    public ByteBuffer getDirectBuffer(int size, ByteBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        if (buffer.isDirect()) {
            buffer.limit(size + buffer.position());
            return buffer;
        }
        ByteBuffer directBuffer = this.allocateDirectBuffer(size);
        directBuffer.put((ByteBuffer)buffer.slice().limit(size));
        directBuffer.rewind();
        return directBuffer;
    }

    private ByteBuffer getByteBuffer(int size, Buffer buffer, int bufferOffset) {
        if (buffer instanceof ByteBuffer) {
            buffer.limit(size);
            buffer.position(bufferOffset);
            return (ByteBuffer)buffer;
        }
        if (buffer instanceof IntBuffer) {
            size = Utilities.round4(size);
            ByteBuffer directBuffer = this.allocateDirectBuffer(size);
            directBuffer.asIntBuffer().put((IntBuffer)((IntBuffer)buffer).slice().limit(size >> 2));
            directBuffer.position(bufferOffset);
            return directBuffer;
        }
        if (buffer instanceof ShortBuffer) {
            size = Utilities.round2(size);
            ByteBuffer directBuffer = this.allocateDirectBuffer(size);
            directBuffer.asShortBuffer().put((ShortBuffer)((ShortBuffer)buffer).slice().limit(size >> 1));
            directBuffer.position(bufferOffset);
            return directBuffer;
        }
        if (buffer instanceof FloatBuffer) {
            size = Utilities.round4(size);
            ByteBuffer directBuffer = this.allocateDirectBuffer(size);
            directBuffer.asFloatBuffer().put((FloatBuffer)((FloatBuffer)buffer).slice().limit(size >> 2));
            directBuffer.position(bufferOffset);
            return directBuffer;
        }
        throw new IllegalArgumentException();
    }

    public ByteBuffer getDirectByteBuffer(int size, Buffer buffer, int bufferOffset) {
        return this.getDirectBuffer(size, this.getByteBuffer(size, buffer, bufferOffset));
    }

    public FloatBuffer getDirectFloatBuffer(int size, Buffer buffer, int bufferOffset) {
        return this.getDirectBuffer(size, this.getByteBuffer(size, buffer, bufferOffset).asFloatBuffer());
    }

    public IntBuffer getDirectIntBuffer(int size, Buffer buffer, int bufferOffset) {
        return this.getDirectBuffer(size, this.getByteBuffer(size, buffer, bufferOffset).asIntBuffer());
    }

    public ShortBuffer getDirectShortBuffer(int size, Buffer buffer, int bufferOffset) {
        return this.getDirectBuffer(size, this.getByteBuffer(size, buffer, bufferOffset).asShortBuffer());
    }

    public ByteBuffer allocateDirectBuffer(int size) {
        if (size > this.directBufferSize) {
            this.directBufferSize = size;
            this.directBuffer = ByteBuffer.allocateDirect(this.directBufferSize).order(ByteOrder.nativeOrder());
        }
        this.directBuffer.clear();
        this.directBuffer.limit(size);
        return this.directBuffer;
    }

    public ByteBuffer allocateDirectBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return this.allocateDirectBuffer(buffer.remaining());
    }

    public IntBuffer allocateDirectBuffer(IntBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return this.allocateDirectBuffer(buffer.remaining() << 2).asIntBuffer();
    }

    public ShortBuffer allocateDirectBuffer(ShortBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return this.allocateDirectBuffer(buffer.remaining() << 1).asShortBuffer();
    }

    public FloatBuffer allocateDirectBuffer(FloatBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return this.allocateDirectBuffer(buffer.remaining() << 2).asFloatBuffer();
    }

    public void copyBuffer(ByteBuffer dstBuffer, ByteBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }

    public void copyBuffer(IntBuffer dstBuffer, IntBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }

    public void copyBuffer(ShortBuffer dstBuffer, ShortBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }

    public void copyBuffer(FloatBuffer dstBuffer, FloatBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }
}

