/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VideoEngine;
import org.apache.log4j.Logger;

public abstract class BaseBufferManager
implements IREBufferManager {
    protected static final Logger log = VideoEngine.log;
    protected Hashtable<Integer, BufferInfo> buffers;
    protected static final int[] sizeOfType = new int[]{1, 1, 2, 2, 4, 4, 4, 8};

    public BaseBufferManager() {
        this.init();
    }

    protected void init() {
        this.buffers = new Hashtable();
    }

    protected ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    @Override
    public void deleteBuffer(IRenderingEngine re, int buffer) {
        this.buffers.remove(buffer);
    }

    @Override
    public ByteBuffer getBuffer(int buffer) {
        BufferInfo bufferInfo = this.buffers.get(buffer);
        if (bufferInfo == null) {
            return null;
        }
        return bufferInfo.byteBuffer;
    }

    protected static class BufferInfo {
        public int buffer;
        public ByteBuffer byteBuffer;
        public Buffer typedBuffer;
        public int type;
        public int size;
        public int usage;
        public int elementSize;
        public int totalSize;

        public BufferInfo(int buffer, ByteBuffer byteBuffer, int type, int size) {
            this.buffer = buffer;
            this.byteBuffer = byteBuffer;
            this.type = type;
            this.size = size;
            this.elementSize = sizeOfType[type];
            this.totalSize = size * this.elementSize;
            this.typedBuffer = byteBuffer;
            switch (type) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.typedBuffer = byteBuffer.asShortBuffer();
                    break;
                }
                case 4: 
                case 5: {
                    this.typedBuffer = byteBuffer.asIntBuffer();
                    break;
                }
                case 6: {
                    this.typedBuffer = byteBuffer.asFloatBuffer();
                    break;
                }
                case 7: {
                    this.typedBuffer = byteBuffer.asDoubleBuffer();
                }
            }
        }

        public Buffer getBufferPosition(int offset) {
            return this.typedBuffer.position(offset / this.elementSize);
        }

        public int getBufferSize() {
            return this.totalSize;
        }
    }
}

