/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.BaseBufferManager;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class BufferManagerVBO
extends BaseBufferManager {
    private int[] bufferDataSize;

    public static boolean useVBO(IRenderingEngine re) {
        return !Settings.getInstance().readBool("emu.disablevbo") && re.isExtensionAvailable("GL_ARB_vertex_buffer_object");
    }

    @Override
    protected void init() {
        this.bufferDataSize = new int[100];
        super.init();
        log.info((Object)"Using VBO");
    }

    @Override
    public boolean useVBO() {
        return true;
    }

    @Override
    public int genBuffer(IRenderingEngine re, int target, int type, int size, int usage) {
        int totalSize = size * sizeOfType[type];
        ByteBuffer byteBuffer = this.createByteBuffer(totalSize);
        int buffer = re.genBuffer();
        if (buffer >= this.bufferDataSize.length) {
            this.bufferDataSize = Utilities.extendArray(this.bufferDataSize, buffer - this.bufferDataSize.length + 1);
        }
        this.setBufferData(re, target, buffer, totalSize, byteBuffer, usage);
        this.buffers.put(buffer, new BaseBufferManager.BufferInfo(buffer, byteBuffer, type, size));
        return buffer;
    }

    @Override
    public void bindBuffer(IRenderingEngine re, int target, int buffer) {
        re.bindBuffer(target, buffer);
    }

    @Override
    public void deleteBuffer(IRenderingEngine re, int buffer) {
        re.deleteBuffer(buffer);
        super.deleteBuffer(re, buffer);
    }

    @Override
    public void setColorPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(re, 0, buffer);
        re.setColorPointer(size, type, stride, offset);
    }

    @Override
    public void setNormalPointer(IRenderingEngine re, int buffer, int type, int stride, int offset) {
        this.bindBuffer(re, 0, buffer);
        re.setNormalPointer(type, stride, offset);
    }

    @Override
    public void setTexCoordPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(re, 0, buffer);
        re.setTexCoordPointer(size, type, stride, offset);
    }

    @Override
    public void setVertexAttribPointer(IRenderingEngine re, int buffer, int id, int size, int type, boolean normalized, int stride, int offset) {
        this.bindBuffer(re, 0, buffer);
        re.setVertexAttribPointer(id, size, type, normalized, stride, offset);
    }

    @Override
    public void setVertexPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(re, 0, buffer);
        re.setVertexPointer(size, type, stride, offset);
    }

    @Override
    public void setWeightPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(re, 0, buffer);
        re.setWeightPointer(size, type, stride, offset);
    }

    @Override
    public void setBufferData(IRenderingEngine re, int target, int buffer, int size, Buffer data, int usage) {
        this.bindBuffer(re, target, buffer);
        re.setBufferData(target, size, data, usage);
        this.bufferDataSize[buffer] = size;
    }

    @Override
    public void setBufferSubData(IRenderingEngine re, int target, int buffer, int offset, int size, Buffer data, int usage) {
        this.bindBuffer(re, target, buffer);
        int requiredBufferDataSize = Utilities.round4(offset) + Utilities.round4(size);
        if (requiredBufferDataSize > this.bufferDataSize[buffer]) {
            this.setBufferData(re, target, buffer, requiredBufferDataSize, null, usage);
        }
        re.setBufferSubData(target, offset, size, data);
    }
}

